/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.xml;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.xml.XmlAttlistDecl;
import com.intellij.psi.xml.XmlAttributeDecl;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementDecl;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.xml.impl.dtd.XmlElementDescriptorImpl;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class DtdFileTreeElement
extends PsiTreeElementBase<XmlFile> {
    public DtdFileTreeElement(XmlFile file) {
        super((PsiElement)file);
    }

    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        List<StructureViewTreeElement> list = DtdFileTreeElement.collectElements(((XmlFile)this.getElement()).getDocument());
        if (list == null) {
            DtdFileTreeElement.$$$reportNull$$$0(0);
        }
        return list;
    }

    static List<StructureViewTreeElement> collectElements(XmlElement element) {
        final ArrayList<StructureViewTreeElement> elements = new ArrayList<StructureViewTreeElement>();
        XmlUtil.processXmlElements(element, (PsiElementProcessor<? super PsiElement>)new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof XmlElementDecl || element instanceof XmlEntityDecl) {
                    elements.add(new DtdTreeElement((PsiNamedElement)element));
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/structureView/impl/xml/DtdFileTreeElement$1", "execute"));
            }
        }, false);
        return elements;
    }

    public String getPresentableText() {
        return ((XmlFile)this.getElement()).getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/xml/DtdFileTreeElement", "getChildrenBase"));
    }

    private static final class DtdTreeElement
    extends PsiTreeElementBase<PsiNamedElement> {
        @NonNls
        private static final String IMPLIED = "implied";
        @NonNls
        private static final String REQUIRED = "required";
        @NonNls
        private static final String FIXED = "fixed";
        @NonNls
        private static final String ID = "id";
        @NonNls
        private static final String IDREF = "idref";
        @NonNls
        private static final String ENUM = "enum";

        DtdTreeElement(PsiNamedElement element) {
            super((PsiElement)element);
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            List<StructureViewTreeElement> list = Collections.emptyList();
            if (list == null) {
                DtdTreeElement.$$$reportNull$$$0(0);
            }
            return list;
        }

        public String getPresentableText() {
            PsiNamedElement namedElement = (PsiNamedElement)this.getElement();
            return namedElement != null ? namedElement.getName() : "";
        }

        public Icon getIcon(boolean open2) {
            return IconManager.getInstance().getPlatformIcon(PlatformIcons.Tag);
        }

        public String getLocationString() {
            XmlAttlistDecl[] attLists;
            XmlElement owner = (XmlElement)this.getElement();
            XmlAttlistDecl[] xmlAttlistDeclArray = attLists = owner instanceof XmlElementDecl ? XmlElementDescriptorImpl.getCachedAttributeDeclarations(owner) : XmlAttlistDecl.EMPTY_ARRAY;
            if (attLists.length > 0) {
                LinkedHashMap<String, XmlAttributeDecl> attrMap = null;
                String name = ((PsiNamedElement)this.getElement()).getName();
                for (XmlAttlistDecl a : attLists) {
                    String aname = a.getName();
                    if (!Objects.equals(aname, name)) continue;
                    if (attrMap == null) {
                        attrMap = new LinkedHashMap<String, XmlAttributeDecl>();
                    }
                    for (XmlAttributeDecl d : a.getAttributeDecls()) {
                        attrMap.put(d.getName(), d);
                    }
                }
                StringBuilder b = null;
                if (attrMap != null) {
                    for (Map.Entry e : attrMap.entrySet()) {
                        XmlAttributeValue value2;
                        if (b == null) {
                            b = new StringBuilder();
                        } else {
                            b.append(", ");
                        }
                        b.append((String)e.getKey());
                        XmlAttributeDecl attributeDecl = (XmlAttributeDecl)e.getValue();
                        Object type2 = null;
                        if (attributeDecl.isIdAttribute()) {
                            type2 = ID;
                        } else if (attributeDecl.isIdRefAttribute()) {
                            type2 = IDREF;
                        } else if (attributeDecl.isEnumerated()) {
                            type2 = ENUM;
                        }
                        if (attributeDecl.isAttributeFixed()) {
                            type2 = type2 == null ? FIXED : (String)type2 + " fixed";
                        } else if (attributeDecl.isAttributeRequired()) {
                            type2 = type2 == null ? REQUIRED : (String)type2 + " required";
                        } else if (attributeDecl.isAttributeImplied()) {
                            type2 = type2 == null ? IMPLIED : (String)type2 + " implied";
                        }
                        if (type2 != null) {
                            b.append(':').append((String)type2);
                        }
                        if ((value2 = attributeDecl.getDefaultValue()) == null) continue;
                        b.append("=").append(value2);
                    }
                }
                if (b != null) {
                    return b.toString();
                }
            }
            return super.getLocationString();
        }

        public String toString() {
            String s = this.getLocationString();
            String name = ((PsiNamedElement)this.getElement()).getName();
            if (s == null || s.length() == 0) {
                return name;
            }
            return name + " (" + s + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/xml/DtdFileTreeElement$DtdTreeElement", "getChildrenBase"));
        }
    }
}

