/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsConsoleLine {
    @NotNull
    private final List<? extends Pair<String, ConsoleViewContentType>> myChunks;

    private VcsConsoleLine(@NotNull List<? extends Pair<String, ConsoleViewContentType>> chunks) {
        if (chunks == null) {
            VcsConsoleLine.$$$reportNull$$$0(0);
        }
        this.myChunks = chunks;
    }

    public void print(@NotNull ConsoleView console) {
        if (console == null) {
            VcsConsoleLine.$$$reportNull$$$0(1);
        }
        ConsoleViewContentType lastType = ConsoleViewContentType.NORMAL_OUTPUT;
        for (Pair<String, ConsoleViewContentType> pair : this.myChunks) {
            console.print((String)pair.first, (ConsoleViewContentType)pair.second);
            lastType = (ConsoleViewContentType)pair.second;
        }
        console.print("\n", lastType);
    }

    @Nullable
    public static VcsConsoleLine create(@Nls @Nullable String message2, @NotNull ConsoleViewContentType contentType) {
        if (contentType == null) {
            VcsConsoleLine.$$$reportNull$$$0(2);
        }
        return VcsConsoleLine.create(Collections.singletonList(Pair.create((Object)message2, (Object)contentType)));
    }

    @Nullable
    public static VcsConsoleLine create(@NotNull List<? extends Pair<@Nls String, ConsoleViewContentType>> lineChunks) {
        List chunks;
        if (lineChunks == null) {
            VcsConsoleLine.$$$reportNull$$$0(3);
        }
        if ((chunks = ContainerUtil.filter(lineChunks, it -> !StringUtil.isEmptyOrSpaces((String)((String)it.first)))).isEmpty()) {
            return null;
        }
        return new VcsConsoleLine(chunks);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineChunks";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/VcsConsoleLine";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "print";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

