/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import org.jetbrains.annotations.NotNull;

public final class FilePathsHelper {
    private FilePathsHelper() {
    }

    @NlsSafe
    public static String convertPath(FilePath fp) {
        return FilePathsHelper.convertPath(fp.getPath());
    }

    @NlsSafe
    public static String convertWithLastSeparator(FilePath fp) {
        return FilePathsHelper.convertWithLastSeparatorImpl(fp.getPath(), fp.isDirectory());
    }

    @NlsSafe
    private static String convertWithLastSeparatorImpl(String initPath, boolean isDir) {
        String path2 = isDir ? (initPath.endsWith("/") || initPath.endsWith("\\") ? initPath : initPath + "/") : initPath;
        return FilePathsHelper.convertPath(path2);
    }

    @NlsSafe
    public static String convertPath(String parent, String subpath) {
        String convParent = FileUtil.toSystemIndependentName((String)parent);
        String convPath = FileUtil.toSystemIndependentName((String)subpath);
        String withSlash = StringUtil.trimEnd((String)convParent, (String)"/") + "/" + StringUtil.trimStart((String)convPath, (String)"/");
        return SystemInfo.isFileSystemCaseSensitive ? withSlash : StringUtil.toUpperCase((String)withSlash);
    }

    @NotNull
    @NlsSafe
    public static String convertPath(@NotNull String s) {
        if (s == null) {
            FilePathsHelper.$$$reportNull$$$0(0);
        }
        String result2 = FileUtil.toSystemIndependentName((String)s);
        String string2 = SystemInfo.isFileSystemCaseSensitive ? result2 : StringUtil.toUpperCase((String)result2);
        if (string2 == null) {
            FilePathsHelper.$$$reportNull$$$0(1);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/FilePathsHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/FilePathsHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "convertPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertPath";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }
}

