/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/ShelveSilentlyActionBase;", "Lcom/intellij/openapi/project/DumbAwareAction;", "rollbackChanges", "", "(Z)V", "getRollbackChanges", "()Z", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.platform.vcs.impl"})
public abstract class ShelveSilentlyActionBase
extends DumbAwareAction {
    private final boolean rollbackChanges;

    public ShelveSilentlyActionBase(boolean rollbackChanges) {
        this.rollbackChanges = rollbackChanges;
    }

    public final boolean getRollbackChanges() {
        return this.rollbackChanges;
    }

    public void update(@NotNull AnActionEvent e) {
        Change[] changeArray;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        e.getPresentation().setEnabled(project2 != null && !((changeArray = changes) == null || changeArray.length == 0) && ChangeListManager.getInstance(project2).areChangeListsEnabled());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        Intrinsics.checkNotNull((Object)project2);
        Project project3 = project2;
        Object object = e.getData(VcsDataKeys.CHANGES);
        Intrinsics.checkNotNull((Object)object);
        Object[] changes = (Change[])object;
        FileDocumentManager.getInstance().saveAllDocuments();
        ShelveChangesManager.getInstance(project3).shelveSilentlyUnderProgress(ArraysKt.toList((Object[])changes), this.rollbackChanges);
    }
}

