/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch.tool;

import com.intellij.diff.DiffContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.PrevNextDifferenceIterableBase;
import com.intellij.diff.tools.util.SimpleDiffPanel;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LineNumberConverter;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.LineNumberConverterAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.patch.tool.PatchChangeBuilder;
import com.intellij.openapi.vcs.changes.patch.tool.PatchDiffRequest;
import com.intellij.ui.components.panels.Wrapper;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PatchDiffTool
implements FrameDiffTool {
    PatchDiffTool() {
    }

    @NotNull
    public String getName() {
        String string2 = VcsBundle.message("patch.content.viewer.name", new Object[0]);
        if (string2 == null) {
            PatchDiffTool.$$$reportNull$$$0(0);
        }
        return string2;
    }

    public boolean canShow(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            PatchDiffTool.$$$reportNull$$$0(1);
        }
        if (request == null) {
            PatchDiffTool.$$$reportNull$$$0(2);
        }
        return request instanceof PatchDiffRequest;
    }

    @NotNull
    public FrameDiffTool.DiffViewer createComponent(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            PatchDiffTool.$$$reportNull$$$0(3);
        }
        if (request == null) {
            PatchDiffTool.$$$reportNull$$$0(4);
        }
        return new MyPatchViewer(context, (PatchDiffRequest)request);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/tool/PatchDiffTool";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/tool/PatchDiffTool";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canShow";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createComponent";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string2);
        };
    }

    private static class MyPatchViewer
    implements FrameDiffTool.DiffViewer,
    DataProvider {
        private final Project myProject;
        private final SimpleDiffPanel myPanel;
        private final EditorEx myEditor;
        private final DiffContext myContext;
        private final PatchDiffRequest myRequest;
        private final MyPrevNextDifferenceIterable myPrevNextDifferenceIterable;
        private final List<PatchChangeBuilder.Hunk> myHunks = new ArrayList<PatchChangeBuilder.Hunk>();

        MyPatchViewer(DiffContext context, PatchDiffRequest request) {
            this.myProject = context.getProject();
            this.myContext = context;
            this.myRequest = request;
            Document document2 = EditorFactory.getInstance().createDocument((CharSequence)"");
            this.myEditor = DiffUtil.createEditor((Document)document2, (Project)this.myProject, (boolean)true, (boolean)true);
            this.myPrevNextDifferenceIterable = new MyPrevNextDifferenceIterable();
            Wrapper editorPanel = new Wrapper((LayoutManager)new BorderLayout(0, DiffUtil.TITLE_GAP.get()), this.myEditor.getComponent());
            String panelTitle = request.getPanelTitle();
            if (panelTitle != null) {
                editorPanel.add((Component)DiffUtil.createTitle((String)panelTitle), (Object)"North");
            }
            this.myPanel = new SimpleDiffPanel((JComponent)editorPanel, (DataProvider)this, context);
        }

        @NotNull
        public JComponent getComponent() {
            SimpleDiffPanel simpleDiffPanel = this.myPanel;
            if (simpleDiffPanel == null) {
                MyPatchViewer.$$$reportNull$$$0(0);
            }
            return simpleDiffPanel;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myEditor.getContentComponent();
        }

        @NotNull
        public FrameDiffTool.ToolbarComponents init() {
            this.myPanel.setPersistentNotifications(DiffUtil.createCustomNotifications((FrameDiffTool.DiffViewer)this, (UserDataHolder)this.myContext, (UserDataHolder)this.myRequest));
            this.onInit();
            return new FrameDiffTool.ToolbarComponents();
        }

        public void dispose() {
            EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
        }

        private void onInit() {
            PatchChangeBuilder builder2 = new PatchChangeBuilder();
            builder2.exec(this.myRequest.getPatch().getHunks());
            this.myHunks.addAll(builder2.getHunks());
            DocumentEx patchDocument = this.myEditor.getDocument();
            WriteAction.run(() -> MyPatchViewer.lambda$onInit$0((Document)patchDocument, builder2));
            this.myEditor.getGutter().setLineNumberConverter((LineNumberConverter)new LineNumberConverterAdapter(builder2.getLineConvertor1().createConvertor()), (LineNumberConverter)new LineNumberConverterAdapter(builder2.getLineConvertor2().createConvertor()));
            IntListIterator iterator = builder2.getSeparatorLines().iterator();
            while (iterator.hasNext()) {
                int offset = patchDocument.getLineStartOffset(iterator.nextInt());
                DiffDrawUtil.createLineSeparatorHighlighter((Editor)this.myEditor, (int)offset, (int)offset);
            }
            for (PatchChangeBuilder.Hunk hunk : this.myHunks) {
                List<DiffFragment> innerFragments = PatchChangeBuilder.computeInnerDifferences((Document)patchDocument, hunk);
                DiffDrawUtil.createUnifiedChunkHighlighters((Editor)this.myEditor, (LineRange)hunk.getPatchDeletionRange(), (LineRange)hunk.getPatchInsertionRange(), innerFragments);
            }
            this.myEditor.getGutterComponentEx().revalidateMarkup();
        }

        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                MyPatchViewer.$$$reportNull$$$0(1);
            }
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return this.myProject;
            }
            if (DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.is(dataId)) {
                return this.myPrevNextDifferenceIterable;
            }
            if (DiffDataKeys.CURRENT_EDITOR.is(dataId)) {
                return this.myEditor;
            }
            if (DiffDataKeys.CURRENT_CHANGE_RANGE.is(dataId)) {
                return this.myPrevNextDifferenceIterable.getHunkRangeByLine(this.myEditor.getCaretModel().getLogicalPosition().line);
            }
            return null;
        }

        private static /* synthetic */ void lambda$onInit$0(Document patchDocument, PatchChangeBuilder builder2) throws RuntimeException {
            patchDocument.setText((CharSequence)builder2.getPatchContent().toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/tool/PatchDiffTool$MyPatchViewer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/tool/PatchDiffTool$MyPatchViewer";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 1 -> new IllegalArgumentException(string2);
            };
        }

        private class MyPrevNextDifferenceIterable
        extends PrevNextDifferenceIterableBase<PatchChangeBuilder.Hunk> {
            private MyPrevNextDifferenceIterable() {
            }

            @NotNull
            protected List<PatchChangeBuilder.Hunk> getChanges() {
                List<PatchChangeBuilder.Hunk> list = MyPatchViewer.this.myHunks;
                if (list == null) {
                    MyPrevNextDifferenceIterable.$$$reportNull$$$0(0);
                }
                return list;
            }

            @NotNull
            protected EditorEx getEditor() {
                EditorEx editorEx = MyPatchViewer.this.myEditor;
                if (editorEx == null) {
                    MyPrevNextDifferenceIterable.$$$reportNull$$$0(1);
                }
                return editorEx;
            }

            protected int getStartLine(@NotNull PatchChangeBuilder.Hunk change) {
                if (change == null) {
                    MyPrevNextDifferenceIterable.$$$reportNull$$$0(2);
                }
                return change.getPatchDeletionRange().start;
            }

            protected int getEndLine(@NotNull PatchChangeBuilder.Hunk change) {
                if (change == null) {
                    MyPrevNextDifferenceIterable.$$$reportNull$$$0(3);
                }
                return change.getPatchInsertionRange().end;
            }

            @Nullable
            LineRange getHunkRangeByLine(int line) {
                for (PatchChangeBuilder.Hunk hunk : this.getChanges()) {
                    int start2 = hunk.getPatchDeletionRange().start;
                    int end = hunk.getPatchInsertionRange().end;
                    if (start2 <= line && end > line) {
                        return new LineRange(start2, end);
                    }
                    if (start2 <= line) continue;
                    return null;
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 2, 3 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/tool/PatchDiffTool$MyPatchViewer$MyPrevNextDifferenceIterable";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "change";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getChanges";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getEditor";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/tool/PatchDiffTool$MyPatchViewer$MyPrevNextDifferenceIterable";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getStartLine";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getEndLine";
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string2);
                    case 2, 3 -> new IllegalArgumentException(string2);
                };
            }
        }
    }
}

