/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.diff.util.Range;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.ex.ChangelistsLocalLineStatusTracker;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@State(name="LineStatusTrackerManager", storages={@Storage(value="$WORKSPACE_FILE$")})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\u0002H\u0016J\u0012\u0010\r\u001a\f\u0012\b\u0012\u00060\bj\u0002`\t0\u0007H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\f\u0012\b\u0012\u00060\bj\u0002`\t0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/vcs/impl/PartialLineStatusTrackerManagerState;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "storedFileStates", "", "Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$State;", "Lcom/intellij/openapi/vcs/impl/TrackerState;", "wasLoaded", "", "getState", "getStatesAndClear", "loadState", "", "element", "Companion", "intellij.platform.vcs.impl"})
@NonNls
public final class PartialLineStatusTrackerManagerState
implements PersistentStateComponent<Element> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private List<? extends ChangelistsLocalLineStatusTracker.State> storedFileStates;
    private boolean wasLoaded;
    private static final int DISABLED_FILES_THRESHOLD = 20;
    @NotNull
    private static final String NODE_PARTIAL_FILE = "file";
    @NotNull
    private static final String ATT_PATH = "path";
    @NotNull
    private static final String NODE_VCS = "vcs";
    @NotNull
    private static final String NODE_CURRENT = "current";
    @NotNull
    private static final String ATT_CONTENT = "content";
    @NotNull
    private static final String NODE_RANGES = "ranges";
    @NotNull
    private static final String NODE_RANGE = "range";
    @NotNull
    private static final String ATT_START_1 = "start1";
    @NotNull
    private static final String ATT_END_1 = "end1";
    @NotNull
    private static final String ATT_START_2 = "start2";
    @NotNull
    private static final String ATT_END_2 = "end2";
    @NotNull
    private static final String ATT_CHANGELIST_ID = "changelist";

    public PartialLineStatusTrackerManagerState(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.storedFileStates = CollectionsKt.emptyList();
    }

    @NotNull
    public Element getState() {
        Element element = new Element("state");
        boolean areChangeListsEnabled = ChangeListManager.getInstance(this.project).areChangeListsEnabled();
        List<? extends ChangelistsLocalLineStatusTracker.State> fileStates = areChangeListsEnabled ? LineStatusTrackerManager.Companion.getInstanceImpl(this.project).collectPartiallyChangedFilesStates$intellij_platform_vcs_impl() : (this.storedFileStates.size() < 20 ? this.storedFileStates : CollectionsKt.emptyList());
        for (ChangelistsLocalLineStatusTracker.State state : fileStates) {
            element.addContent(PartialLineStatusTrackerManagerState.Companion.writePartialFileState(state));
        }
        return element;
    }

    public void loadState(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (this.wasLoaded) {
            return;
        }
        this.storedFileStates = PartialLineStatusTrackerManagerState.Companion.parseStates(element);
    }

    private final List<ChangelistsLocalLineStatusTracker.State> getStatesAndClear() {
        List<ChangelistsLocalLineStatusTracker.State> result2 = this.storedFileStates;
        this.storedFileStates = CollectionsKt.emptyList();
        this.wasLoaded = true;
        return result2;
    }

    @JvmStatic
    public static final void restoreState$intellij_platform_vcs_impl(@NotNull Project project2) {
        Companion.restoreState$intellij_platform_vcs_impl(project2);
    }

    @JvmStatic
    public static final void saveCurrentState$intellij_platform_vcs_impl(@NotNull Project project2, @NotNull List<? extends ChangelistsLocalLineStatusTracker.State> fileStates) {
        Companion.saveCurrentState$intellij_platform_vcs_impl(project2, fileStates);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0012\u001a\f\u0012\b\u0012\u00060\u0014j\u0002`\u00150\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\n\u0018\u00010\u0014j\u0004\u0018\u0001`\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0017H\u0002J\u0015\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0001\u00a2\u0006\u0002\b J'\u0010!\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0010\u0010\"\u001a\f\u0012\b\u0012\u00060\u0014j\u0002`\u00150\u0013H\u0001\u00a2\u0006\u0002\b#J\u0014\u0010$\u001a\u00020\u00172\n\u0010%\u001a\u00060\u0014j\u0002`\u0015H\u0002J\u0010\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u001aH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/openapi/vcs/impl/PartialLineStatusTrackerManagerState$Companion;", "", "()V", "ATT_CHANGELIST_ID", "", "ATT_CONTENT", "ATT_END_1", "ATT_END_2", "ATT_PATH", "ATT_START_1", "ATT_START_2", "DISABLED_FILES_THRESHOLD", "", "NODE_CURRENT", "NODE_PARTIAL_FILE", "NODE_RANGE", "NODE_RANGES", "NODE_VCS", "parseStates", "", "Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$State;", "Lcom/intellij/openapi/vcs/impl/TrackerState;", "element", "Lorg/jdom/Element;", "readPartialFileState", "readRangeState", "Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$RangeState;", "node", "restoreState", "", "project", "Lcom/intellij/openapi/project/Project;", "restoreState$intellij_platform_vcs_impl", "saveCurrentState", "fileStates", "saveCurrentState$intellij_platform_vcs_impl", "writePartialFileState", "state", "writeRangeState", "range", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nPartialLineStatusTrackerManagerState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PartialLineStatusTrackerManagerState.kt\ncom/intellij/openapi/vcs/impl/PartialLineStatusTrackerManagerState$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,161:1\n29#2,3:162\n29#2,3:165\n*S KotlinDebug\n*F\n+ 1 PartialLineStatusTrackerManagerState.kt\ncom/intellij/openapi/vcs/impl/PartialLineStatusTrackerManagerState$Companion\n*L\n76#1:162,3\n86#1:165,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void restoreState$intellij_platform_vcs_impl(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            if (!ChangeListManager.getInstance(project2).areChangeListsEnabled()) {
                return;
            }
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<PartialLineStatusTrackerManagerState> serviceClass$iv = PartialLineStatusTrackerManagerState.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            List fileStates = ((PartialLineStatusTrackerManagerState)object).getStatesAndClear();
            if (fileStates.isEmpty()) {
                return;
            }
            ChangeListManager.getInstance(project2).invokeAfterUpdate(true, () -> Companion.restoreState$lambda$0(project2, fileStates));
        }

        @JvmStatic
        public final void saveCurrentState$intellij_platform_vcs_impl(@NotNull Project project2, @NotNull List<? extends ChangelistsLocalLineStatusTracker.State> fileStates) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(fileStates, (String)"fileStates");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<PartialLineStatusTrackerManagerState> serviceClass$iv = PartialLineStatusTrackerManagerState.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            PartialLineStatusTrackerManagerState stateService = (PartialLineStatusTrackerManagerState)object;
            stateService.storedFileStates = fileStates;
        }

        private final List<ChangelistsLocalLineStatusTracker.State> parseStates(Element element) {
            List fileStates = new ArrayList();
            for (Element node : element.getChildren(PartialLineStatusTrackerManagerState.NODE_PARTIAL_FILE)) {
                Intrinsics.checkNotNullExpressionValue((Object)node, (String)"node");
                ChangelistsLocalLineStatusTracker.State state = this.readPartialFileState(node);
                if (state == null) continue;
                fileStates.add(state);
            }
            return fileStates;
        }

        private final Element writePartialFileState(ChangelistsLocalLineStatusTracker.State state) {
            Element element = new Element(PartialLineStatusTrackerManagerState.NODE_PARTIAL_FILE);
            element.setAttribute(PartialLineStatusTrackerManagerState.ATT_PATH, state.getVirtualFile().getPath());
            if (state instanceof ChangelistsLocalLineStatusTracker.FullState && Registry.is((String)"vcs.enable.partial.changelists.persist.file.contents")) {
                element.addContent(new Element(PartialLineStatusTrackerManagerState.NODE_VCS).setAttribute(PartialLineStatusTrackerManagerState.ATT_CONTENT, XmlStringUtil.escapeIllegalXmlChars((String)((ChangelistsLocalLineStatusTracker.FullState)state).getVcsContent())));
                element.addContent(new Element(PartialLineStatusTrackerManagerState.NODE_CURRENT).setAttribute(PartialLineStatusTrackerManagerState.ATT_CONTENT, XmlStringUtil.escapeIllegalXmlChars((String)((ChangelistsLocalLineStatusTracker.FullState)state).getCurrentContent())));
            }
            Element rangesNode = new Element(PartialLineStatusTrackerManagerState.NODE_RANGES);
            for (ChangelistsLocalLineStatusTracker.RangeState it : state.getRanges()) {
                rangesNode.addContent(this.writeRangeState(it));
            }
            element.addContent(rangesNode);
            return element;
        }

        private final ChangelistsLocalLineStatusTracker.State readPartialFileState(Element element) {
            String string2 = element.getAttributeValue(PartialLineStatusTrackerManagerState.ATT_PATH);
            if (string2 == null) {
                return null;
            }
            String path2 = string2;
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path2);
            if (virtualFile == null) {
                return null;
            }
            VirtualFile virtualFile2 = virtualFile;
            Element element2 = element.getChild(PartialLineStatusTrackerManagerState.NODE_VCS);
            String vcsContent = element2 != null ? element2.getAttributeValue(PartialLineStatusTrackerManagerState.ATT_CONTENT) : null;
            Element element3 = element.getChild(PartialLineStatusTrackerManagerState.NODE_CURRENT);
            String currentContent = element3 != null ? element3.getAttributeValue(PartialLineStatusTrackerManagerState.ATT_CONTENT) : null;
            List rangeStates = new ArrayList();
            Element element4 = element.getChild(PartialLineStatusTrackerManagerState.NODE_RANGES);
            if (element4 == null) {
                return null;
            }
            Element rangesNode = element4;
            for (Element node : rangesNode.getChildren(PartialLineStatusTrackerManagerState.NODE_RANGE)) {
                ChangelistsLocalLineStatusTracker.RangeState rangeState;
                Intrinsics.checkNotNullExpressionValue((Object)node, (String)"node");
                if (this.readRangeState(node) == null) {
                    return null;
                }
                rangeStates.add(rangeState);
            }
            if (vcsContent != null && currentContent != null) {
                String string3 = XmlStringUtil.unescapeIllegalXmlChars((String)vcsContent);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"unescapeIllegalXmlChars(vcsContent)");
                String string4 = XmlStringUtil.unescapeIllegalXmlChars((String)currentContent);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"unescapeIllegalXmlChars(currentContent)");
                return new ChangelistsLocalLineStatusTracker.FullState(virtualFile2, rangeStates, string3, string4);
            }
            return new ChangelistsLocalLineStatusTracker.State(virtualFile2, rangeStates);
        }

        private final Element writeRangeState(ChangelistsLocalLineStatusTracker.RangeState range) {
            Element element = new Element(PartialLineStatusTrackerManagerState.NODE_RANGE).setAttribute(PartialLineStatusTrackerManagerState.ATT_START_1, String.valueOf(range.getRange().start1)).setAttribute(PartialLineStatusTrackerManagerState.ATT_END_1, String.valueOf(range.getRange().end1)).setAttribute(PartialLineStatusTrackerManagerState.ATT_START_2, String.valueOf(range.getRange().start2)).setAttribute(PartialLineStatusTrackerManagerState.ATT_END_2, String.valueOf(range.getRange().end2)).setAttribute(PartialLineStatusTrackerManagerState.ATT_CHANGELIST_ID, range.getChangelistId());
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"Element(NODE_RANGE)\n    \u2026T_ID, range.changelistId)");
            return element;
        }

        private final ChangelistsLocalLineStatusTracker.RangeState readRangeState(Element node) {
            Object object = node.getAttributeValue(PartialLineStatusTrackerManagerState.ATT_START_1);
            if (object == null || (object = StringsKt.toIntOrNull((String)object)) == null) {
                return null;
            }
            int start1 = (Integer)object;
            Object object2 = node.getAttributeValue(PartialLineStatusTrackerManagerState.ATT_END_1);
            if (object2 == null || (object2 = StringsKt.toIntOrNull((String)object2)) == null) {
                return null;
            }
            int end1 = (Integer)object2;
            Object object3 = node.getAttributeValue(PartialLineStatusTrackerManagerState.ATT_START_2);
            if (object3 == null || (object3 = StringsKt.toIntOrNull((String)object3)) == null) {
                return null;
            }
            int start2 = (Integer)object3;
            Object object4 = node.getAttributeValue(PartialLineStatusTrackerManagerState.ATT_END_2);
            if (object4 == null || (object4 = StringsKt.toIntOrNull((String)object4)) == null) {
                return null;
            }
            int end2 = (Integer)object4;
            String string2 = node.getAttributeValue(PartialLineStatusTrackerManagerState.ATT_CHANGELIST_ID);
            if (string2 == null) {
                return null;
            }
            String changelistId = string2;
            return new ChangelistsLocalLineStatusTracker.RangeState(new Range(start1, end1, start2, end2), changelistId, null, 4, null);
        }

        private static final void restoreState$lambda$0(Project $project, List $fileStates) {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)$fileStates, (String)"$fileStates");
            LineStatusTrackerManager.Companion.getInstanceImpl($project).restoreTrackersForPartiallyChangedFiles$intellij_platform_vcs_impl($fileStates);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

