/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.BasicAttributeValueReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileBasedUserDataCache;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.ImplicitIdRefProvider;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.util.XmlDeclareIdInCommentAction;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdRefReference
extends BasicAttributeValueReference {
    private final boolean myIdAttrsOnly;
    private static final FileBasedUserDataCache<List<PsiElement>> ourCachedIdsCache = new FileBasedUserDataCache<List<PsiElement>>(){
        private final Key<CachedValue<List<PsiElement>>> ourCachedIdsValueKey = Key.create((String)"my.ids.cached.value");

        @Override
        protected List<PsiElement> doCompute(PsiFile file) {
            final ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
            file.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(true){

                @Override
                public void visitXmlTag(@NotNull XmlTag tag) {
                    if (tag == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (IdRefReference.isAcceptableTagType(tag)) {
                        result2.add(tag);
                    }
                    super.visitXmlTag(tag);
                }

                public void visitComment(@NotNull PsiComment comment) {
                    if (comment == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (IdRefReference.isDeclarationComment(comment)) {
                        result2.add(comment);
                    }
                    super.visitComment(comment);
                }

                @Override
                public void visitXmlComment(@NotNull XmlComment comment) {
                    if (comment == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (IdRefReference.isDeclarationComment(comment)) {
                        result2.add(comment);
                    }
                    super.visitComment((PsiComment)comment);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "tag";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "comment";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/IdRefReference$1$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitXmlTag";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitComment";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitXmlComment";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            return result2;
        }

        @Override
        protected Key<CachedValue<List<PsiElement>>> getKey() {
            return this.ourCachedIdsValueKey;
        }
    };

    public IdRefReference(PsiElement element, int offset, boolean idAttrsOnly) {
        super(element, offset);
        this.myIdAttrsOnly = idAttrsOnly;
    }

    public IdRefReference(PsiElement element) {
        super(element);
        this.myIdAttrsOnly = false;
    }

    @Nullable
    protected PsiElement getIdValueElement(PsiElement element) {
        if (element instanceof XmlTag) {
            XmlTag tag = (XmlTag)element;
            XmlAttribute attribute = tag.getAttribute("id", null);
            if (!this.myIdAttrsOnly) {
                if (attribute == null) {
                    attribute = tag.getAttribute("name", null);
                }
                if (attribute == null) {
                    attribute = tag.getAttribute("styleId", null);
                }
            }
            return attribute != null ? attribute.getValueElement() : IdRefReference.getImplicitIdRefValueElement(tag);
        }
        return element;
    }

    @Nullable
    protected String getIdValue(PsiElement element) {
        if (element instanceof XmlTag) {
            XmlTag tag = (XmlTag)element;
            String s = tag.getAttributeValue("id");
            if (!this.myIdAttrsOnly) {
                if (s == null) {
                    s = tag.getAttributeValue("name");
                }
                if (s == null) {
                    s = tag.getAttributeValue("styleId");
                }
            }
            return s != null ? s : IdRefReference.getImplicitIdRefValue(tag);
        }
        if (element instanceof PsiComment) {
            return IdRefReference.getImplicitIdValue((PsiComment)element);
        }
        return null;
    }

    @Nullable
    public static XmlAttribute getImplicitIdRefAttr(@NotNull XmlTag tag) {
        if (tag == null) {
            IdRefReference.$$$reportNull$$$0(0);
        }
        for (ImplicitIdRefProvider idRefProvider : ImplicitIdRefProvider.EXTENSION_POINT_NAME.getExtensionList()) {
            XmlAttribute value2 = idRefProvider.getIdRefAttribute(tag);
            if (value2 == null) continue;
            return value2;
        }
        return null;
    }

    @Nullable
    public static XmlAttributeValue getImplicitIdRefValueElement(@NotNull XmlTag tag) {
        if (tag == null) {
            IdRefReference.$$$reportNull$$$0(1);
        }
        for (ImplicitIdRefProvider idRefProvider : ImplicitIdRefProvider.EXTENSION_POINT_NAME.getExtensionList()) {
            XmlAttribute value2 = idRefProvider.getIdRefAttribute(tag);
            if (value2 == null) continue;
            return value2.getValueElement();
        }
        return null;
    }

    @Nullable
    public static String getImplicitIdRefValue(@NotNull XmlTag tag) {
        XmlAttributeValue attribute;
        if (tag == null) {
            IdRefReference.$$$reportNull$$$0(2);
        }
        return (attribute = IdRefReference.getImplicitIdRefValueElement(tag)) != null ? attribute.getValue() : null;
    }

    protected static boolean isAcceptableTagType(XmlTag subTag) {
        return subTag.getAttributeValue("id") != null || subTag.getAttributeValue("for") != null || IdRefReference.getImplicitIdRefValue(subTag) != null || subTag.getAttributeValue("name") != null && !subTag.getName().contains(".directive");
    }

    private static boolean isDeclarationComment(@NotNull PsiComment comment) {
        if (comment == null) {
            IdRefReference.$$$reportNull$$$0(3);
        }
        return comment.getText().contains("@declare id=");
    }

    @Nullable
    private static String getImplicitIdValue(@NotNull PsiComment comment) {
        if (comment == null) {
            IdRefReference.$$$reportNull$$$0(4);
        }
        return XmlDeclareIdInCommentAction.getImplicitlyDeclaredId(comment);
    }

    private void process(PsiElementProcessor<? super PsiElement> processor2) {
        PsiFile psiFile2 = this.getElement().getContainingFile();
        IdRefReference.process(processor2, psiFile2);
    }

    public static void process(PsiElementProcessor<? super PsiElement> processor2, PsiFile file) {
        for (PsiElement e : ourCachedIdsCache.compute(file)) {
            if (processor2.execute(e)) continue;
            return;
        }
    }

    @Nullable
    public PsiElement resolve() {
        final PsiElement[] result2 = new PsiElement[1];
        this.process((PsiElementProcessor<? super PsiElement>)new PsiElementProcessor<PsiElement>(){
            final String canonicalText;
            {
                this.canonicalText = IdRefReference.this.getCanonicalText();
            }

            public boolean execute(@NotNull PsiElement element) {
                String idValue;
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((idValue = IdRefReference.this.getIdValue(element)) != null && idValue.equals(this.canonicalText)) {
                    result2[0] = IdRefReference.this.getIdValueElement(element);
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/IdRefReference$2", "execute"));
            }
        });
        return result2[0];
    }

    public Object @NotNull [] getVariants() {
        final LinkedList result2 = new LinkedList();
        this.process((PsiElementProcessor<? super PsiElement>)new PsiElementProcessor<PsiElement>(){

            public boolean execute(@NotNull PsiElement element) {
                String value2;
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((value2 = IdRefReference.this.getIdValue(element)) != null) {
                    result2.add(value2);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/IdRefReference$3", "execute"));
            }
        });
        Object[] objectArray = ArrayUtil.toObjectArray(result2);
        if (objectArray == null) {
            IdRefReference.$$$reportNull$$$0(5);
        }
        return objectArray;
    }

    public boolean isSoft() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/IdRefReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/IdRefReference";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitIdRefAttr";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitIdRefValueElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitIdRefValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isDeclarationComment";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitIdValue";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5 -> new IllegalStateException(string2);
        };
    }
}

