/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DocumentBasedReplaceHandler
extends StructuralReplaceHandler {
    private final Project myProject;
    private final Map<ReplacementInfo, RangeMarker> myRangeMarkers = new HashMap<ReplacementInfo, RangeMarker>();

    public DocumentBasedReplaceHandler(Project project2) {
        this.myProject = project2;
    }

    @Override
    public void replace(@NotNull ReplacementInfo info, @NotNull ReplaceOptions options) {
        if (info == null) {
            DocumentBasedReplaceHandler.$$$reportNull$$$0(0);
        }
        if (options == null) {
            DocumentBasedReplaceHandler.$$$reportNull$$$0(1);
        }
        RangeMarker rangeMarker = this.myRangeMarkers.get(info);
        Document document2 = rangeMarker.getDocument();
        document2.replaceString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), (CharSequence)info.getReplacement());
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document2);
    }

    @Override
    public void prepare(@NotNull ReplacementInfo info) {
        PsiElement firstElement;
        if (info == null) {
            DocumentBasedReplaceHandler.$$$reportNull$$$0(2);
        }
        if ((firstElement = StructuralSearchUtil.getPresentableElement(info.getMatch(0))) == null) {
            return;
        }
        PsiFile file = firstElement.getContainingFile();
        FileViewProvider fileViewProvider = file.getViewProvider();
        Document document2 = fileViewProvider.getDocument();
        assert (document2 != null);
        TextRange range = firstElement.getTextRange();
        int startOffset = range.getStartOffset();
        int endOffset = range.getEndOffset();
        int count = info.getMatchesCount();
        for (int i = 1; i < count; ++i) {
            PsiElement match2 = info.getMatch(i);
            if (match2 == null) continue;
            TextRange range1 = match2.getTextRange();
            startOffset = Math.min(startOffset, range1.getStartOffset());
            endOffset = Math.max(endOffset, range1.getEndOffset());
        }
        RangeMarker rangeMarker = document2.createRangeMarker(startOffset, endOffset);
        rangeMarker.setGreedyToLeft(true);
        rangeMarker.setGreedyToRight(true);
        this.myRangeMarkers.put(info, rangeMarker);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        objectArray2[1] = "com/intellij/structuralsearch/DocumentBasedReplaceHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "replace";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "prepare";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

