/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.dupLocator.AbstractMatchingVisitor;
import com.intellij.dupLocator.equivalence.EquivalenceDescriptor;
import com.intellij.dupLocator.equivalence.EquivalenceDescriptorProvider;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.util.DuplocatorUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.structuralsearch.DocumentBasedReplaceHandler;
import com.intellij.structuralsearch.MatchUtil;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.handlers.DelegatingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.LightTopLevelMatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SkippingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.TopLevelMatchingHandler;
import com.intellij.structuralsearch.impl.matcher.iterators.SsrFilteringNodeIterator;
import com.intellij.structuralsearch.impl.matcher.strategies.MatchingStrategy;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StructuralSearchProfileBase
extends StructuralSearchProfile {
    private static final String DELIMITER_CHARS = ",;.[]{}():";

    @Override
    public void compile(PsiElement @NotNull [] elements, final @NotNull GlobalCompilingVisitor globalVisitor) {
        if (globalVisitor == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(1);
        }
        PsiElement topElement = elements[0].getParent();
        PsiElement element = elements.length > 1 ? topElement : elements[0];
        element.accept((PsiElementVisitor)new MyCompilingVisitor(globalVisitor, topElement));
        element.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                MatchingHandler delegate;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitElement(element);
                if (DuplocatorUtil.isIgnoredNode(element)) {
                    return;
                }
                CompiledPattern pattern2 = globalVisitor.getContext().getPattern();
                MatchingHandler handler2 = pattern2.getHandler(element);
                if (!(handler2 instanceof SubstitutionHandler || handler2 instanceof TopLevelMatchingHandler || handler2 instanceof LightTopLevelMatchingHandler)) {
                    pattern2.setHandler(element, new SkippingHandler(handler2));
                }
                if (handler2 instanceof LightTopLevelMatchingHandler && !((delegate = ((LightTopLevelMatchingHandler)handler2).getDelegate()) instanceof SubstitutionHandler)) {
                    pattern2.setHandler(element, new LightTopLevelMatchingHandler(new SkippingHandler(delegate)));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/StructuralSearchProfileBase$1", "visitElement"));
            }
        });
        final Language baseLanguage = element.getContainingFile().getLanguage();
        globalVisitor.getContext().getPattern().setStrategy(new MatchingStrategy(){

            @Override
            public boolean continueMatching(PsiElement start2) {
                Language fileLanguage;
                Language language = start2.getLanguage();
                PsiFile file = start2.getContainingFile();
                if (file != null && (fileLanguage = file.getLanguage()).isKindOf(language)) {
                    language = fileLanguage;
                }
                return language == baseLanguage;
            }

            @Override
            public boolean shouldSkip(PsiElement element, PsiElement elementToMatchWith) {
                return DuplocatorUtil.shouldSkip(element, elementToMatchWith);
            }
        });
    }

    @Override
    @NotNull
    public PsiElementVisitor createMatchingVisitor(@NotNull GlobalMatchingVisitor globalVisitor) {
        if (globalVisitor == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(2);
        }
        return new MyMatchingVisitor(globalVisitor);
    }

    @Override
    public boolean isMatchNode(PsiElement element) {
        return !DuplocatorUtil.isIgnoredNode(element);
    }

    private static boolean containsOnlyDelimiters(String s) {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            if (DELIMITER_CHARS.indexOf(s.charAt(i)) >= 0) continue;
            return false;
        }
        return true;
    }

    protected abstract String @NotNull [] getVarPrefixes();

    @Override
    @NotNull
    public CompiledPattern createCompiledPattern() {
        return new CompiledPattern(){

            @Override
            @NotNull
            protected SubstitutionHandler doCreateSubstitutionHandler(@NotNull String name, boolean target, int minOccurs, int maxOccurs, boolean greedy) {
                if (name == null) {
                    3.$$$reportNull$$$0(0);
                }
                return new MySubstitutionHandler(name, target, minOccurs, maxOccurs, greedy);
            }

            @Override
            public String @NotNull [] getTypedVarPrefixes() {
                String[] stringArray = StructuralSearchProfileBase.this.getVarPrefixes();
                if (stringArray == null) {
                    3.$$$reportNull$$$0(1);
                }
                return stringArray;
            }

            @Override
            public boolean isTypedVar(@NotNull String str) {
                if (str == null) {
                    3.$$$reportNull$$$0(2);
                }
                for (String prefix : StructuralSearchProfileBase.this.getVarPrefixes()) {
                    if (!str.startsWith(prefix)) continue;
                    return true;
                }
                return false;
            }

            @Override
            @NotNull
            public String getTypedVarString(@NotNull PsiElement element) {
                if (element == null) {
                    3.$$$reportNull$$$0(3);
                }
                PsiElement initialElement = element;
                PsiElement child = SkippingHandler.getOnlyNonWhitespaceChild(element);
                while (child != element && child != null && !(child instanceof LeafElement)) {
                    element = child;
                    child = SkippingHandler.getOnlyNonWhitespaceChild(element);
                }
                String string2 = child instanceof LeafElement ? element.getText() : initialElement.getText();
                if (string2 == null) {
                    3.$$$reportNull$$$0(4);
                }
                return string2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/structuralsearch/StructuralSearchProfileBase$3";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "str";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/structuralsearch/StructuralSearchProfileBase$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTypedVarPrefixes";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTypedVarString";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "doCreateSubstitutionHandler";
                        break;
                    }
                    case 1: 
                    case 4: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "isTypedVar";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getTypedVarString";
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 1, 4 -> new IllegalStateException(string2);
                };
            }
        };
    }

    @Override
    public void checkReplacementPattern(@NotNull Project project2, @NotNull ReplaceOptions options) {
        if (project2 == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(3);
        }
        if (options == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(4);
        }
    }

    @Override
    public StructuralReplaceHandler getReplaceHandler(@NotNull Project project2, @NotNull ReplaceOptions replaceOptions) {
        if (project2 == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(5);
        }
        if (replaceOptions == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(6);
        }
        return new DocumentBasedReplaceHandler(project2);
    }

    private static boolean canBePatternVariable(@NotNull PsiElement element) {
        if (element == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(7);
        }
        if (element instanceof LeafElement) {
            return true;
        }
        while (!(element instanceof LeafElement) && element != null) {
            element = SkippingHandler.getOnlyNonWhitespaceChild(element);
        }
        return element != null;
    }

    protected boolean isStringLiteral(PsiElement element) {
        if (element == null) {
            return false;
        }
        ASTNode astNode = element.getNode();
        if (astNode == null) {
            return false;
        }
        IElementType elementType = astNode.getElementType();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(element.getLanguage());
        if (parserDefinition != null) {
            TokenSet literals = parserDefinition.getStringLiteralElements();
            return literals.contains(elementType);
        }
        return false;
    }

    private static boolean canBePatternVariableValue(@NotNull PsiElement element) {
        if (element == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(8);
        }
        return !StructuralSearchProfileBase.containsOnlyDelimiters(element.getText());
    }

    @Override
    public boolean canBeVarDelimiter(@NotNull PsiElement element) {
        ASTNode node;
        if (element == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(9);
        }
        return (node = element.getNode()) != null && this.getVariableDelimiters().contains(node.getElementType());
    }

    protected TokenSet getVariableDelimiters() {
        return TokenSet.EMPTY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalVisitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceOptions";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/structuralsearch/StructuralSearchProfileBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "compile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createMatchingVisitor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkReplacementPattern";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getReplaceHandler";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "canBePatternVariable";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "canBePatternVariableValue";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeVarDelimiter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyCompilingVisitor
    extends PsiRecursiveElementVisitor {
        private final GlobalCompilingVisitor myGlobalVisitor;
        private final PsiElement myTopElement;
        private Pattern[] mySubstitutionPatterns;

        MyCompilingVisitor(GlobalCompilingVisitor globalVisitor, PsiElement topElement) {
            this.myGlobalVisitor = globalVisitor;
            this.myTopElement = topElement;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                MyCompilingVisitor.$$$reportNull$$$0(0);
            }
            this.doVisitElement(element);
            if (StructuralSearchProfileBase.this.isStringLiteral(element)) {
                this.visitLiteral(element);
            }
        }

        private void doVisitElement(@NotNull PsiElement element) {
            String text2;
            ParserDefinition parserDefinition;
            if (element == null) {
                MyCompilingVisitor.$$$reportNull$$$0(1);
            }
            CompiledPattern pattern2 = this.myGlobalVisitor.getContext().getPattern();
            if (this.myGlobalVisitor.getCodeBlockLevel() == 0) {
                this.initTopLevelElement(element);
                return;
            }
            if (StructuralSearchProfileBase.canBePatternVariable(element) && pattern2.isRealTypedVar(element)) {
                this.myGlobalVisitor.handle(element);
                MatchingHandler handler2 = pattern2.getHandler(element);
                handler2.setFilter(other -> StructuralSearchProfileBase.canBePatternVariableValue(other));
                super.visitElement(element);
                return;
            }
            super.visitElement(element);
            if (this.myGlobalVisitor.getContext().getSearchHelper().doOptimizing() && element instanceof LeafElement && (parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(element.getLanguage())) != null && StringUtil.isJavaIdentifier((String)(text2 = element.getText()))) {
                this.myGlobalVisitor.processTokenizedName(text2, GlobalCompilingVisitor.OccurenceKind.CODE);
            }
        }

        private void visitLiteral(PsiElement literal) {
            String value2 = literal.getText();
            if (StringUtil.isQuotedString((String)value2)) {
                if (this.mySubstitutionPatterns == null) {
                    String[] prefixes = this.myGlobalVisitor.getContext().getPattern().getTypedVarPrefixes();
                    this.mySubstitutionPatterns = MatchUtil.createPatterns(prefixes);
                }
                for (Pattern substitutionPattern : this.mySubstitutionPatterns) {
                    @Nullable MatchingHandler handler2 = this.myGlobalVisitor.processPatternStringWithFragments(value2, GlobalCompilingVisitor.OccurenceKind.LITERAL, substitutionPattern);
                    if (handler2 == null) continue;
                    literal.putUserData(CompiledPattern.HANDLER_KEY, (Object)handler2);
                    break;
                }
            }
        }

        private void initTopLevelElement(PsiElement element) {
            CompiledPattern pattern2 = this.myGlobalVisitor.getContext().getPattern();
            PsiElement newElement = SkippingHandler.skipNodeIfNecessary(element);
            if (element != newElement) {
                newElement.accept((PsiElementVisitor)this);
                pattern2.setHandler(element, new LightTopLevelMatchingHandler(pattern2.getHandler(element)));
            } else {
                this.myGlobalVisitor.setCodeBlockLevel(this.myGlobalVisitor.getCodeBlockLevel() + 1);
                for (PsiElement el = element.getFirstChild(); el != null; el = el.getNextSibling()) {
                    if (GlobalCompilingVisitor.getFilter().accepts(el)) {
                        if (!(el instanceof PsiWhiteSpace)) continue;
                        this.myGlobalVisitor.addLexicalNode(el);
                        continue;
                    }
                    el.accept((PsiElementVisitor)this);
                    MatchingHandler matchingHandler = pattern2.getHandler(el);
                    pattern2.setHandler(el, element == this.myTopElement ? new TopLevelMatchingHandler(matchingHandler) : new LightTopLevelMatchingHandler(matchingHandler));
                }
                this.myGlobalVisitor.setCodeBlockLevel(this.myGlobalVisitor.getCodeBlockLevel() - 1);
                pattern2.setHandler(element, new TopLevelMatchingHandler(pattern2.getHandler(element)));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "element";
            objectArray2[1] = "com/intellij/structuralsearch/StructuralSearchProfileBase$MyCompilingVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doVisitElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyMatchingVisitor
    extends PsiElementVisitor {
        private final GlobalMatchingVisitor myGlobalVisitor;

        MyMatchingVisitor(GlobalMatchingVisitor globalVisitor) {
            this.myGlobalVisitor = globalVisitor;
        }

        private boolean shouldIgnoreVarNode(PsiElement element) {
            MatchingHandler handler2 = this.myGlobalVisitor.getMatchContext().getPattern().getHandlerSimple(element);
            if (handler2 instanceof DelegatingHandler) {
                handler2 = ((DelegatingHandler)((Object)handler2)).getDelegate();
            }
            return handler2 instanceof MySubstitutionHandler && ((MySubstitutionHandler)handler2).myExceptedNodes.contains(element);
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                MyMatchingVisitor.$$$reportNull$$$0(0);
            }
            super.visitElement(element);
            EquivalenceDescriptorProvider descriptorProvider = EquivalenceDescriptorProvider.getInstance(element);
            if (descriptorProvider != null) {
                EquivalenceDescriptor descriptor1 = descriptorProvider.buildDescriptor(element);
                EquivalenceDescriptor descriptor2 = descriptorProvider.buildDescriptor(this.myGlobalVisitor.getElement());
                if (descriptor1 != null && descriptor2 != null) {
                    boolean result2 = DuplocatorUtil.match(descriptor1, descriptor2, (AbstractMatchingVisitor)this.myGlobalVisitor, Collections.emptySet(), null);
                    this.myGlobalVisitor.setResult(result2);
                    return;
                }
            }
            if (StructuralSearchProfileBase.this.isStringLiteral(element)) {
                this.visitLiteral(element);
                return;
            }
            if (StructuralSearchProfileBase.canBePatternVariable(element) && this.myGlobalVisitor.getMatchContext().getPattern().isRealTypedVar(element) && !this.shouldIgnoreVarNode(element)) {
                PsiElement matchedElement = this.myGlobalVisitor.getElement();
                PsiElement newElement = SkippingHandler.skipNodeIfNecessary(matchedElement);
                while (newElement != matchedElement) {
                    matchedElement = newElement;
                    newElement = SkippingHandler.skipNodeIfNecessary(matchedElement);
                }
                this.myGlobalVisitor.setResult(this.myGlobalVisitor.handleTypedElement(element, matchedElement));
            } else if (element instanceof LeafElement) {
                this.myGlobalVisitor.setResult(element.getText().equals(this.myGlobalVisitor.getElement().getText()));
            } else if (element.getFirstChild() == null && element.getTextLength() == 0) {
                this.myGlobalVisitor.setResult(true);
            } else {
                PsiElement patternChild = element.getFirstChild();
                PsiElement matchedChild = this.myGlobalVisitor.getElement().getFirstChild();
                NodeIterator patternIterator = SsrFilteringNodeIterator.create(patternChild);
                NodeIterator matchedIterator = SsrFilteringNodeIterator.create(matchedChild);
                boolean matched = this.myGlobalVisitor.matchSequentially(patternIterator, matchedIterator);
                this.myGlobalVisitor.setResult(matched);
            }
        }

        private void visitLiteral(PsiElement literal) {
            PsiElement l2 = this.myGlobalVisitor.getElement();
            MatchingHandler handler2 = (MatchingHandler)literal.getUserData(CompiledPattern.HANDLER_KEY);
            if (handler2 instanceof SubstitutionHandler) {
                char c;
                int offset = 0;
                int length = l2.getTextLength();
                String text2 = l2.getText();
                if (length > 2 && ((c = text2.charAt(0)) == '\"' || c == '\'') && text2.charAt(length - 1) == c) {
                    boolean looseMatching = this.myGlobalVisitor.getMatchContext().getOptions().isLooseMatching();
                    if (!looseMatching && c != literal.getText().charAt(0)) {
                        this.myGlobalVisitor.setResult(false);
                        return;
                    }
                    --length;
                    ++offset;
                }
                this.myGlobalVisitor.setResult(((SubstitutionHandler)handler2).handle(l2, offset, length, this.myGlobalVisitor.getMatchContext()));
            } else if (handler2 != null) {
                this.myGlobalVisitor.setResult(handler2.match(literal, l2, this.myGlobalVisitor.getMatchContext()));
            } else {
                this.myGlobalVisitor.setResult(literal.textMatches(l2));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/StructuralSearchProfileBase$MyMatchingVisitor", "visitElement"));
        }
    }

    private static class MySubstitutionHandler
    extends SubstitutionHandler {
        final Set<PsiElement> myExceptedNodes;

        MySubstitutionHandler(@NotNull String name, boolean target, int minOccurs, int maxOccurs, boolean greedy) {
            if (name == null) {
                MySubstitutionHandler.$$$reportNull$$$0(0);
            }
            super(name, target, minOccurs, maxOccurs, greedy);
            this.myExceptedNodes = new HashSet<PsiElement>();
        }

        @Override
        public boolean matchSequentially(@NotNull NodeIterator patternNodes, @NotNull NodeIterator matchNodes, @NotNull MatchContext context) {
            if (patternNodes == null) {
                MySubstitutionHandler.$$$reportNull$$$0(1);
            }
            if (matchNodes == null) {
                MySubstitutionHandler.$$$reportNull$$$0(2);
            }
            if (context == null) {
                MySubstitutionHandler.$$$reportNull$$$0(3);
            }
            if (this.doMatchSequentially(patternNodes, matchNodes, context)) {
                return true;
            }
            PsiElement current = patternNodes.current();
            if (current != null) {
                this.myExceptedNodes.add(current);
            }
            boolean result2 = this.doMatchSequentiallyBySimpleHandler(patternNodes, matchNodes, context);
            this.myExceptedNodes.remove(current);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patternNodes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matchNodes";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/structuralsearch/StructuralSearchProfileBase$MySubstitutionHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matchSequentially";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

