/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.SmartList;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LinkComboBox
extends ActionLink {
    private final List<String> myItems = new SmartList();
    private String mySelectedItem;
    private @NlsContexts.Label String myDefaultItem;
    @Nullable
    private Consumer<? super String> myConsumer;

    LinkComboBox(@NlsContexts.Label String defaultItem) {
        this.setAutoHideOnDisable(false);
        this.setDefaultItem(defaultItem);
        this.setDropDownLinkIcon();
        this.addActionListener(e -> this.showPopup());
    }

    public void setItemConsumer(@Nullable Consumer<? super String> consumer) {
        this.myConsumer = consumer;
    }

    public void setItems(@NotNull Collection<String> items2) {
        if (items2 == null) {
            LinkComboBox.$$$reportNull$$$0(0);
        }
        if (items2.isEmpty()) {
            throw new IllegalArgumentException("items needs to contain at least one item");
        }
        this.myItems.clear();
        this.myItems.addAll(items2);
        if (!this.myItems.contains(this.mySelectedItem)) {
            this.setSelectedItem(this.myDefaultItem != null ? this.myDefaultItem : this.myItems.get(0));
        }
    }

    public void setLabel(@NotNull JLabel label) {
        if (label == null) {
            LinkComboBox.$$$reportNull$$$0(1);
        }
        label.setLabelFor((Component)((Object)this));
        label.getActionMap().put("release", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                LinkComboBox.this.doClick();
            }
        });
    }

    public String getSelectedItem() {
        return this.mySelectedItem;
    }

    public void setSelectedItem(@NlsContexts.Label String selectedItem2) {
        if (!this.myItems.contains(selectedItem2)) {
            throw new IllegalArgumentException("selected item is not contained in items");
        }
        this.mySelectedItem = selectedItem2;
        this.setText(selectedItem2);
    }

    public void setDefaultItem(@NlsContexts.Label String defaultItem) {
        this.myDefaultItem = defaultItem;
        this.setText(defaultItem);
    }

    void showPopup() {
        if (!this.isEnabled()) {
            return;
        }
        BaseListPopupStep<String> list = new BaseListPopupStep<String>(null, this.myItems){

            public PopupStep<?> onChosen(@NlsContexts.Label String selectedValue, boolean finalChoice) {
                LinkComboBox.this.setSelectedItem(selectedValue);
                if (LinkComboBox.this.myConsumer != null) {
                    LinkComboBox.this.myConsumer.accept(selectedValue);
                }
                return super.onChosen((Object)selectedValue, finalChoice);
            }

            public int getDefaultOptionIndex() {
                return LinkComboBox.this.myItems.indexOf(LinkComboBox.this.mySelectedItem);
            }
        };
        ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)list);
        popup2.show(new RelativePoint((Component)((Object)this), new Point(JBUIScale.scale((int)-2), this.getHeight() + JBUIScale.scale((int)2))));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
        }
        objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/LinkComboBox";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setItems";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setLabel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

