/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui.filters;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.ui.filters.FilterAction;
import com.intellij.structuralsearch.plugin.ui.filters.FilterEditor;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.awt.Container;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;

public class ContextFilter
extends FilterAction {
    public ContextFilter() {
        super(SSRBundle.messagePointer("context.filter.name", new Object[0]));
    }

    @Override
    public boolean hasFilter() {
        MatchVariableConstraint variable = this.myTable.getMatchVariable();
        return variable != null && !StringUtil.isEmpty((String)variable.getContextConstraint());
    }

    @Override
    public void clearFilter() {
        MatchVariableConstraint constraint = this.myTable.getMatchVariable();
        if (constraint == null) {
            return;
        }
        constraint.setContextConstraint("");
    }

    @Override
    public boolean isApplicable(List<? extends PsiElement> nodes, boolean completePattern, boolean target) {
        return this.myTable.getVariable() instanceof MatchVariableConstraint && completePattern && this.isApplicableConstraint("CONTEXT", nodes, true, target);
    }

    @Override
    protected void setLabel(SimpleColoredComponent component2) {
        MatchVariableConstraint variable = this.myTable.getMatchVariable();
        if (variable == null) {
            return;
        }
        component2.append(SSRBundle.message("context.0.label", StringUtil.unquoteString((String)variable.getContextConstraint())));
    }

    public FilterEditor<MatchVariableConstraint> getEditor() {
        return new FilterEditor<MatchVariableConstraint>(this.myTable.getMatchVariable(), this.myTable.getConstraintChangedCallback()){
            private final JLabel myLabel;
            private final TextFieldWithAutoCompletion<String> textField;
            private final String shortcut;
            private final ContextHelpLabel myHelpLabel;
            {
                this.myLabel = new JLabel(SSRBundle.message("context.label", new Object[0]));
                this.textField = TextFieldWithAutoCompletion.create((Project)ContextFilter.this.myTable.getProject(), Collections.emptyList(), (boolean)false, (String)"");
                this.shortcut = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("CodeCompletion"));
                this.myHelpLabel = ContextHelpLabel.create((String)SSRBundle.message("tooltip.preconfigured.search.patterns", this.shortcut));
            }

            @Override
            protected void layoutComponents() {
                ConfigurationManager configManager = ConfigurationManager.getInstance(ContextFilter.this.myTable.getProject());
                StructuralSearchProfile profile = ContextFilter.this.myTable.getProfile();
                assert (profile != null);
                List configurationNames = JBIterable.from(configManager.getAllConfigurationNames()).filter(name -> {
                    Configuration config = configManager.findConfigurationByName((String)name);
                    return config != null && profile.isApplicableContextConfiguration(config);
                }).toList();
                this.textField.setVariants((Collection)configurationNames);
                GroupLayout layout = new GroupLayout((Container)((Object)this));
                this.setLayout(layout);
                layout.setAutoCreateContainerGaps(true);
                layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.myLabel).addComponent((Component)this.textField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 1, 1).addComponent((Component)this.myHelpLabel));
                layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.myLabel).addComponent((Component)this.textField).addComponent((Component)this.myHelpLabel));
            }

            @Override
            protected void loadValues() {
                this.textField.setText(((MatchVariableConstraint)this.myConstraint).getContextConstraint());
            }

            @Override
            protected void saveValues() {
                ((MatchVariableConstraint)this.myConstraint).setContextConstraint(this.textField.getText());
            }

            public JComponent getPreferredFocusedComponent() {
                return this.textField;
            }

            public JComponent[] getFocusableComponents() {
                return new JComponent[]{this.textField};
            }
        };
    }
}

