/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.util.xml.NamedEnumUtil;
import com.intellij.util.xml.ui.BaseModifiableControl;
import com.intellij.util.xml.ui.DomWrapper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;

public class BooleanEnumControl
extends BaseModifiableControl<JCheckBox, String> {
    private boolean myUndefined;
    private final String mySelectedValue;
    private final String myUnselectedValue;

    public BooleanEnumControl(DomWrapper<String> domWrapper, String selectedValue, String unselectedValue) {
        super(domWrapper);
        this.mySelectedValue = selectedValue;
        this.myUnselectedValue = unselectedValue;
    }

    public BooleanEnumControl(DomWrapper<String> domWrapper, Class<? extends Enum> enumClass, boolean invertedOrder) {
        this(domWrapper, NamedEnumUtil.getEnumValueByElement(enumClass.getEnumConstants()[invertedOrder ? 0 : 1]), NamedEnumUtil.getEnumValueByElement(enumClass.getEnumConstants()[invertedOrder ? 1 : 0]));
        assert (enumClass.getEnumConstants().length == 2) : enumClass;
    }

    @Override
    protected JCheckBox createMainComponent(JCheckBox boundComponent) {
        JCheckBox checkBox2 = boundComponent == null ? new JCheckBox() : boundComponent;
        checkBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BooleanEnumControl.this.myUndefined = false;
                BooleanEnumControl.this.setModified();
                BooleanEnumControl.this.commit();
                BooleanEnumControl.this.reset();
            }
        });
        return checkBox2;
    }

    @Override
    protected String getValue() {
        return this.myUndefined ? null : (((JCheckBox)this.getComponent()).isSelected() ? this.mySelectedValue : this.myUnselectedValue);
    }

    @Override
    protected void setValue(String value2) {
        this.myUndefined = value2 == null;
        ((JCheckBox)this.getComponent()).setSelected(this.mySelectedValue.equals(value2));
    }
}

