/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.changes;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.vcs.changes.ChangeListScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ChangeListsScopesProvider
extends CustomScopesProviderEx {
    @NotNull
    private final Project myProject;

    public static ChangeListsScopesProvider getInstance(Project project2) {
        return (ChangeListsScopesProvider)((Object)CUSTOM_SCOPES_PROVIDER.findExtension(ChangeListsScopesProvider.class, (AreaInstance)project2));
    }

    public ChangeListsScopesProvider(@NotNull Project project2) {
        if (project2 == null) {
            ChangeListsScopesProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
    }

    @NotNull
    public List<NamedScope> getCustomScopes() {
        if (this.myProject.isDefault() || !ProjectLevelVcsManager.getInstance(this.myProject).hasActiveVcss()) {
            List<NamedScope> list = Collections.emptyList();
            if (list == null) {
                ChangeListsScopesProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance(this.myProject);
        ArrayList<NamedScope> result2 = new ArrayList<NamedScope>();
        result2.add((NamedScope)new ChangeListScope(changeListManager));
        if (ChangesUtil.hasMeaningfulChangelists(this.myProject)) {
            boolean skipSingleDefaultCL;
            List<LocalChangeList> changeLists = changeListManager.getChangeLists();
            boolean bl = skipSingleDefaultCL = Registry.is((String)"vcs.skip.single.default.changelist") && changeLists.size() == 1 && changeLists.get(0).isBlank();
            if (!skipSingleDefaultCL) {
                for (ChangeList changeList : changeLists) {
                    result2.add((NamedScope)new ChangeListScope(changeListManager, changeList.getName()));
                }
            }
        }
        ArrayList<NamedScope> arrayList = result2;
        if (arrayList == null) {
            ChangeListsScopesProvider.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public NamedScope getCustomScope(@NotNull String name) {
        LocalChangeList changeList;
        if (name == null) {
            ChangeListsScopesProvider.$$$reportNull$$$0(3);
        }
        if (this.myProject.isDefault()) {
            return null;
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance(this.myProject);
        if ("All Changed Files".equals(name)) {
            return new ChangeListScope(changeListManager);
        }
        if (ChangesUtil.hasMeaningfulChangelists(this.myProject) && (changeList = changeListManager.findChangeList(name)) != null) {
            return new ChangeListScope(changeListManager, changeList.getName());
        }
        return null;
    }

    public boolean isVetoed(NamedScope scope2, CustomScopesProviderEx.ScopePlace place) {
        if (place == CustomScopesProviderEx.ScopePlace.SETTING) {
            if (this.myProject.isDefault()) {
                return false;
            }
            ChangeListManager changeListManager = ChangeListManager.getInstance(this.myProject);
            return changeListManager.findChangeList(scope2.getScopeId()) != null;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/changes/ChangeListsScopesProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/changes/ChangeListsScopesProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomScopes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCustomScope";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2 -> new IllegalStateException(string2);
        };
    }
}

