/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit.message;

import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.vcs.commit.message.BaseCommitMessageInspection;
import com.intellij.vcs.commit.message.CommitMessageInspectionProfile;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class ReformatCommitMessageAction
extends DumbAwareAction {
    public ReformatCommitMessageAction() {
        super(VcsBundle.messagePointer("commit.message.intention.family.name.reformat.commit.message", new Object[0]));
        this.setEnabledInModalContext(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ReformatCommitMessageAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ReformatCommitMessageAction.$$$reportNull$$$0(1);
        }
        Project project2 = e.getProject();
        Document document2 = (Document)e.getData(VcsDataKeys.COMMIT_MESSAGE_DOCUMENT);
        e.getPresentation().setEnabled(project2 != null && document2 != null && ReformatCommitMessageAction.getEnabledInspections(project2).anyMatch(inspection -> inspection.canReformat(project2, document2)));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ReformatCommitMessageAction.$$$reportNull$$$0(2);
        }
        Project project2 = Objects.requireNonNull(e.getProject());
        Document document2 = (Document)e.getRequiredData(VcsDataKeys.COMMIT_MESSAGE_DOCUMENT);
        CommandProcessor.getInstance().executeCommand(project2, () -> WriteAction.run(() -> ReformatCommitMessageAction.reformat(project2, document2)), VcsBundle.message("commit.message.intention.family.name.reformat.commit.message", new Object[0]), null);
    }

    @RequiresWriteLock
    public static void reformat(@NotNull Project project2, @NotNull Document document2) {
        if (project2 == null) {
            ReformatCommitMessageAction.$$$reportNull$$$0(3);
        }
        if (document2 == null) {
            ReformatCommitMessageAction.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        List<BaseCommitMessageInspection> inspections = ReformatCommitMessageAction.getEnabledInspections(project2).toList();
        inspections.forEach(inspection -> inspection.reformat(project2, document2));
    }

    @NotNull
    private static Stream<BaseCommitMessageInspection> getEnabledInspections(@NotNull Project project2) {
        if (project2 == null) {
            ReformatCommitMessageAction.$$$reportNull$$$0(5);
        }
        Stream<BaseCommitMessageInspection> stream = CommitMessageInspectionProfile.getInstance(project2).getAllEnabledInspectionTools(project2).stream().map(Tools::getTool).map(InspectionToolWrapper::getTool).filter(BaseCommitMessageInspection.class::isInstance).map(BaseCommitMessageInspection.class::cast);
        if (stream == null) {
            ReformatCommitMessageAction.$$$reportNull$$$0(6);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/commit/message/ReformatCommitMessageAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/commit/message/ReformatCommitMessageAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledInspections";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "reformat";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getEnabledInspections";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string2);
        };
    }
}

