/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.FixedHashMap;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.RefsModel;
import java.util.Comparator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class HeadCommitsComparator
implements Comparator<Integer> {
    private static final Logger LOG = Logger.getInstance(HeadCommitsComparator.class);
    @NotNull
    private final RefsModel myRefsModel;
    @NotNull
    private final Map<VirtualFile, VcsLogRefManager> myRefManagers;
    @NotNull
    private final Function<? super Integer, ? extends Hash> myHashGetter;
    @NotNull
    private final Map<Integer, Integer> myErrorWasReported;

    public HeadCommitsComparator(@NotNull RefsModel refsModel, @NotNull Map<VirtualFile, VcsLogRefManager> refManagers, @NotNull Function<? super Integer, ? extends Hash> hashGetter) {
        if (refsModel == null) {
            HeadCommitsComparator.$$$reportNull$$$0(0);
        }
        if (refManagers == null) {
            HeadCommitsComparator.$$$reportNull$$$0(1);
        }
        if (hashGetter == null) {
            HeadCommitsComparator.$$$reportNull$$$0(2);
        }
        this.myErrorWasReported = new FixedHashMap(100);
        this.myRefsModel = refsModel;
        this.myRefManagers = refManagers;
        this.myHashGetter = hashGetter;
    }

    public void reportNoRefs(int head) {
        if (!this.myErrorWasReported.containsKey(head)) {
            this.myErrorWasReported.put(head, head);
            LOG.debug("No references found at head " + head + " which corresponds to hash " + this.myHashGetter.fun((Object)head));
        }
    }

    @Override
    public int compare(Integer head1, Integer head2) {
        VcsLogRefManager refManager2;
        if (head1.equals(head2)) {
            return 0;
        }
        VcsRef ref1 = this.myRefsModel.bestRefToHead(head1);
        VcsRef ref2 = this.myRefsModel.bestRefToHead(head2);
        if (ref1 == null) {
            this.reportNoRefs(head1);
            if (ref2 == null) {
                this.reportNoRefs(head2);
                return head1 - head2;
            }
            return 1;
        }
        if (ref2 == null) {
            this.reportNoRefs(head2);
            return -1;
        }
        if (ref1.equals(ref2)) {
            LOG.warn("Different heads " + this.myHashGetter.fun((Object)head1) + " and " + this.myHashGetter.fun((Object)head2) + " contain the same reference " + ref1);
        }
        VirtualFile root1 = ref1.getRoot();
        VirtualFile root2 = ref2.getRoot();
        VcsLogRefManager refManager1 = this.myRefManagers.get(root1);
        if (!refManager1.equals(refManager2 = this.myRefManagers.get(root2))) {
            return refManager1.toString().compareTo(refManager2.toString());
        }
        return refManager1.getBranchLayoutComparator().compare(ref1, ref2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "refsModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "refManagers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "hashGetter";
                break;
            }
        }
        objectArray[1] = "com/intellij/vcs/log/graph/HeadCommitsComparator";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

