/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.tools.external.ExternalDiffTool;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.ChainBackedDiffPreviewProvider;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.EditorTabPreviewBase;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogCommitSelection;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.history.FileHistoryDiffProcessor;
import com.intellij.vcs.log.history.FileHistoryPanel;
import com.intellij.vcs.log.ui.actions.history.CompareRevisionsFromFileHistoryActionProvider;
import com.intellij.vcs.log.ui.frame.EditorDiffPreview;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0017\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryEditorDiffPreview;", "Lcom/intellij/vcs/log/ui/frame/EditorDiffPreview;", "Lcom/intellij/openapi/vcs/changes/ChainBackedDiffPreviewProvider;", "project", "Lcom/intellij/openapi/project/Project;", "fileHistoryPanel", "Lcom/intellij/vcs/log/history/FileHistoryPanel;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/history/FileHistoryPanel;)V", "addSelectionListener", "", "listener", "Lkotlin/Function0;", "createDiffRequestChain", "Lcom/intellij/diff/chains/DiffRequestChain;", "createDiffRequestProcessor", "Lcom/intellij/diff/impl/DiffRequestProcessor;", "getEditorTabName", "", "Lorg/jetbrains/annotations/Nls;", "processor", "getOwnerComponent", "Ljavax/swing/JComponent;", "performDiffAction", "", "updateDiffAction", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nFileHistoryDiffPreview.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileHistoryDiffPreview.kt\ncom/intellij/vcs/log/history/FileHistoryEditorDiffPreview\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1#2:80\n*E\n"})
public final class FileHistoryEditorDiffPreview
extends EditorDiffPreview
implements ChainBackedDiffPreviewProvider {
    @NotNull
    private final FileHistoryPanel fileHistoryPanel;

    public FileHistoryEditorDiffPreview(@NotNull Project project2, @NotNull FileHistoryPanel fileHistoryPanel) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileHistoryPanel, (String)"fileHistoryPanel");
        super(project2, fileHistoryPanel);
        this.fileHistoryPanel = fileHistoryPanel;
        this.init();
    }

    @Override
    @NotNull
    public JComponent getOwnerComponent() {
        VcsLogGraphTable vcsLogGraphTable = this.fileHistoryPanel.getGraphTable();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)vcsLogGraphTable), (String)"fileHistoryPanel.graphTable");
        return (JComponent)((Object)vcsLogGraphTable);
    }

    @Override
    @NotNull
    public String getEditorTabName(@Nullable DiffRequestProcessor processor2) {
        Object[] objectArray = new Object[]{this.fileHistoryPanel.getFilePath().getName()};
        String string2 = VcsLogBundle.message("file.history.diff.preview.editor.tab.name", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"file.history.di\u2026storyPanel.filePath.name)");
        return string2;
    }

    @Override
    public void addSelectionListener(@NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        ListSelectionListener selectionListener = arg_0 -> FileHistoryEditorDiffPreview.addSelectionListener$lambda$0(this, listener2, arg_0);
        this.fileHistoryPanel.getGraphTable().getSelectionModel().addListSelectionListener(selectionListener);
        Disposer.register((Disposable)this.getOwner(), () -> FileHistoryEditorDiffPreview.addSelectionListener$lambda$1(this, selectionListener));
    }

    @Override
    @NotNull
    public DiffRequestProcessor createDiffRequestProcessor() {
        FileHistoryDiffProcessor fileHistoryDiffProcessor = this.fileHistoryPanel.createDiffPreview(true);
        Intrinsics.checkNotNullExpressionValue((Object)fileHistoryDiffProcessor, (String)"fileHistoryPanel.createDiffPreview(true)");
        FileHistoryDiffProcessor preview = fileHistoryDiffProcessor;
        preview.updatePreview(true);
        return (DiffRequestProcessor)preview;
    }

    @Override
    @Nullable
    public DiffRequestChain createDiffRequestChain() {
        Change change = this.fileHistoryPanel.getSelectedChange();
        if (change == null) {
            return null;
        }
        Change change2 = change;
        ChangeDiffRequestProducer changeDiffRequestProducer = ChangeDiffRequestProducer.create(this.getProject(), change2);
        if (changeDiffRequestProducer == null) {
            return null;
        }
        ChangeDiffRequestProducer producer = changeDiffRequestProducer;
        return (DiffRequestChain)SimpleDiffRequestChain.fromProducer((DiffRequestProducer)producer);
    }

    @Override
    public void updateDiffAction(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VcsLogCommitSelection vcsLogCommitSelection = (VcsLogCommitSelection)event.getData(VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION);
        if (vcsLogCommitSelection == null) {
            return;
        }
        VcsLogCommitSelection selection = vcsLogCommitSelection;
        CompareRevisionsFromFileHistoryActionProvider.setTextAndDescription(event, selection);
    }

    @Override
    public boolean performDiffAction() {
        Change change;
        if (ExternalDiffTool.isEnabled() && (change = this.fileHistoryPanel.getSelectedChange()) != null) {
            ListSelection diffProducers;
            ChangeDiffRequestProducer changeDiffRequestProducer = ChangeDiffRequestProducer.create(this.getProject(), change);
            if (changeDiffRequestProducer != null) {
                ChangeDiffRequestProducer it = changeDiffRequestProducer;
                boolean bl = false;
                v0 = ListSelection.createSingleton((Object)it);
            } else {
                v0 = diffProducers = null;
            }
            if (EditorTabPreviewBase.Companion.showExternalToolIfNeeded(this.getProject(), (ListSelection<? extends DiffRequestProducer>)diffProducers)) {
                return true;
            }
        }
        return super.performDiffAction();
    }

    private static final void addSelectionListener$lambda$0(FileHistoryEditorDiffPreview this$0, Function0 $listener, ListSelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        if (!this$0.fileHistoryPanel.getGraphTable().getSelectionModel().isSelectionEmpty()) {
            $listener.invoke();
        }
    }

    private static final void addSelectionListener$lambda$1(FileHistoryEditorDiffPreview this$0, ListSelectionListener $selectionListener) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$selectionListener, (String)"$selectionListener");
        this$0.fileHistoryPanel.getGraphTable().getSelectionModel().removeListSelectionListener($selectionListener);
    }
}

