/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogFileHistoryProvider;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.history.VcsLogFileHistoryProviderImplKt;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogTabLocation;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import com.intellij.vcs.log.visible.filters.VcsLogFiltersKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J \u0010\f\u001a\u00020\r2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/vcs/log/history/VcsLogDirectoryHistoryProvider;", "Lcom/intellij/vcs/log/VcsLogFileHistoryProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "canShowFileHistory", "", "paths", "", "Lcom/intellij/openapi/vcs/FilePath;", "revisionNumber", "", "showFileHistory", "", "Companion", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogFileHistoryProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogFileHistoryProviderImpl.kt\ncom/intellij/vcs/log/history/VcsLogDirectoryHistoryProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,184:1\n1#2:185\n*E\n"})
final class VcsLogDirectoryHistoryProvider
implements VcsLogFileHistoryProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public VcsLogDirectoryHistoryProvider(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    public boolean canShowFileHistory(@NotNull Collection<? extends FilePath> paths, @Nullable String revisionNumber) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        if (!Registry.is((String)"vcs.history.show.directory.history.in.log")) {
            return false;
        }
        VcsLogData vcsLogData = VcsProjectLog.Companion.getInstance(this.project).getDataManager();
        if (vcsLogData == null) {
            return false;
        }
        VcsLogData dataManager = vcsLogData;
        return VcsLogDirectoryHistoryProvider.Companion.createPathsFilter(this.project, dataManager, paths) != null;
    }

    public void showFileHistory(@NotNull Collection<? extends FilePath> paths, @Nullable String revisionNumber) {
        boolean firstTime;
        Hash hash2;
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        String string2 = revisionNumber;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            hash2 = HashImpl.build(it);
        } else {
            hash2 = null;
        }
        Hash hash3 = hash2;
        VirtualFile virtualFile = VcsLogUtil.getActualRoot(this.project, (FilePath)CollectionsKt.first((Iterable)paths));
        Intrinsics.checkNotNull((Object)virtualFile);
        VirtualFile root = virtualFile;
        VcsLogFileHistoryProviderImplKt.access$triggerFileHistoryUsage(this.project, paths, hash3);
        VcsLogManager vcsLogManager = VcsProjectLog.Companion.getInstance(this.project).getLogManager();
        Intrinsics.checkNotNull((Object)vcsLogManager);
        VcsLogManager logManager2 = vcsLogManager;
        VcsLogData vcsLogData = logManager2.getDataManager();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogData, (String)"logManager.dataManager");
        VcsLogFilter vcsLogFilter = VcsLogDirectoryHistoryProvider.Companion.createPathsFilter(this.project, vcsLogData, paths);
        Intrinsics.checkNotNull((Object)vcsLogFilter);
        VcsLogFilter pathsFilter = vcsLogFilter;
        VcsLogFilter hashFilter = VcsLogDirectoryHistoryProvider.Companion.createHashFilter(hash3, root);
        MainVcsLogUi ui2 = VcsLogTabLocation.Companion.findLogUi(logManager2, VcsLogTabLocation.TOOL_WINDOW, MainVcsLogUi.class, true, (Function1)new Function1<MainVcsLogUi, Boolean>(pathsFilter, hashFilter){
            final /* synthetic */ VcsLogFilter $pathsFilter;
            final /* synthetic */ VcsLogFilter $hashFilter;
            {
                this.$pathsFilter = $pathsFilter;
                this.$hashFilter = $hashFilter;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull MainVcsLogUi logUi2) {
                Intrinsics.checkNotNullParameter((Object)logUi2, (String)"logUi");
                VcsLogFilterCollection vcsLogFilterCollection = logUi2.getFilterUi().getFilters();
                Intrinsics.checkNotNullExpressionValue((Object)vcsLogFilterCollection, (String)"logUi.filterUi.filters");
                return com.intellij.vcs.log.history.VcsLogDirectoryHistoryProvider$Companion.access$matches(VcsLogDirectoryHistoryProvider.Companion, vcsLogFilterCollection, this.$pathsFilter, this.$hashFilter);
            }
        });
        boolean bl = firstTime = ui2 == null;
        if (firstTime) {
            VcsLogFilter[] vcsLogFilterArray = new VcsLogFilter[]{pathsFilter, hashFilter};
            VcsLogFilterCollection filters = VcsLogFilterObject.collection(vcsLogFilterArray);
            MainVcsLogUi mainVcsLogUi = VcsProjectLog.Companion.getInstance(this.project).openLogTab(filters);
            if (mainVcsLogUi == null) {
                return;
            }
            ui2 = mainVcsLogUi;
            ui2.getProperties().set(MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES, true);
        }
        MainVcsLogUi mainVcsLogUi = ui2;
        Intrinsics.checkNotNull((Object)mainVcsLogUi);
        VcsLogFileHistoryProviderImplKt.access$selectRowWhenOpen(logManager2, hash3, root, mainVcsLogUi, firstTime);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/vcs/log/history/VcsLogDirectoryHistoryProvider$Companion;", "", "()V", "createHashFilter", "Lcom/intellij/vcs/log/VcsLogFilter;", "hash", "Lcom/intellij/vcs/log/Hash;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "createPathsFilter", "project", "Lcom/intellij/openapi/project/Project;", "dataManager", "Lcom/intellij/vcs/log/data/VcsLogData;", "paths", "", "Lcom/intellij/openapi/vcs/FilePath;", "matches", "", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "pathsFilter", "hashFilter", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final VcsLogFilter createPathsFilter(Project project2, VcsLogData dataManager, Collection<? extends FilePath> paths) {
            Set forRootFilter = new LinkedHashSet();
            List forPathsFilter = new ArrayList();
            for (FilePath filePath : paths) {
                VirtualFile root = VcsLogUtil.getActualRoot(project2, filePath);
                if (root == null) {
                    return null;
                }
                if (!dataManager.getRoots().contains(root) || !VcsLogProperties.SUPPORTS_LOG_DIRECTORY_HISTORY.getOrDefault(dataManager.getLogProvider(root)).booleanValue()) {
                    return null;
                }
                FilePath correctedPath = VcsLogFileHistoryProviderImplKt.access$getCorrectedPath(project2, filePath, false);
                if (!correctedPath.isDirectory()) {
                    return null;
                }
                if (Intrinsics.areEqual((Object)filePath.getVirtualFile(), (Object)root)) {
                    forRootFilter.add(root);
                } else {
                    forPathsFilter.add(correctedPath);
                }
                if (!(!((Collection)forPathsFilter).isEmpty()) || !(!((Collection)forRootFilter).isEmpty())) continue;
                return null;
            }
            if (!((Collection)forPathsFilter).isEmpty()) {
                return VcsLogFilterObject.fromPaths(forPathsFilter);
            }
            return VcsLogFilterObject.fromRoots(forRootFilter);
        }

        private final VcsLogFilter createHashFilter(Hash hash2, VirtualFile root) {
            if (hash2 == null) {
                return VcsLogFilterObject.fromBranch("HEAD");
            }
            return VcsLogFilterObject.fromCommit(new CommitId(hash2, root));
        }

        private final boolean matches(VcsLogFilterCollection filters, VcsLogFilter pathsFilter, VcsLogFilter hashFilter) {
            VcsLogFilterCollection.FilterKey[] filterKeyArray = new VcsLogFilterCollection.FilterKey[2];
            Intrinsics.checkNotNullExpressionValue(hashFilter.getKey(), (String)"hashFilter.key");
            Intrinsics.checkNotNullExpressionValue(pathsFilter.getKey(), (String)"pathsFilter.key");
            if (!VcsLogFiltersKt.matches(filters, filterKeyArray)) {
                return false;
            }
            return Intrinsics.areEqual(filters.get(pathsFilter.getKey()), (Object)pathsFilter) && Intrinsics.areEqual(filters.get(hashFilter.getKey()), (Object)hashFilter);
        }

        public static final /* synthetic */ boolean access$matches(Companion $this, VcsLogFilterCollection filters, VcsLogFilter pathsFilter, VcsLogFilter hashFilter) {
            return $this.matches(filters, pathsFilter, hashFilter);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

