/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.ide.HelpTooltip;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.actionSystem.impl.FieldInplaceActionButtonLook;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.SearchFieldWithExtension;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHashFilter;
import com.intellij.vcs.log.VcsLogRangeFilter;
import com.intellij.vcs.log.VcsLogRevisionFilter;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.filter.BranchFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.BranchFilters;
import com.intellij.vcs.log.ui.filter.DateFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.FilterPair;
import com.intellij.vcs.log.ui.filter.StructureFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.UserFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.VcsLogFilterUiEx;
import com.intellij.vcs.log.ui.filter.VcsLogPopupComponent;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogClassicFilterUi
implements VcsLogFilterUiEx {
    private static final String VCS_LOG_TEXT_FILTER_HISTORY = "Vcs.Log.Text.Filter.History";
    private static final Logger LOG = Logger.getInstance(VcsLogClassicFilterUi.class);
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private final VcsLogColorManager myColorManager;
    @NotNull
    private final SearchFieldWithExtension mySearchComponent;
    @NotNull
    private VcsLogDataPack myDataPack;
    @NotNull
    protected final BranchFilterModel myBranchFilterModel;
    @NotNull
    protected final FilterModel.SingleFilterModel<VcsLogUserFilter> myUserFilterModel;
    @NotNull
    protected final FilterModel<VcsLogDateFilter> myDateFilterModel;
    @NotNull
    protected final FileFilterModel myStructureFilterModel;
    @NotNull
    protected final TextFilterModel myTextFilterModel;
    @NotNull
    private final EventDispatcher<VcsLogFilterUiEx.VcsLogFilterListener> myFilterListenerDispatcher;

    public VcsLogClassicFilterUi(@NotNull VcsLogData logData, @NotNull Consumer<VcsLogFilterCollection> filterConsumer, @NotNull MainVcsLogUiProperties uiProperties, @NotNull VcsLogColorManager colorManager, @Nullable VcsLogFilterCollection filters, @NotNull Disposable parentDisposable) {
        FilterModel[] models;
        if (logData == null) {
            VcsLogClassicFilterUi.$$$reportNull$$$0(0);
        }
        if (filterConsumer == null) {
            VcsLogClassicFilterUi.$$$reportNull$$$0(1);
        }
        if (uiProperties == null) {
            VcsLogClassicFilterUi.$$$reportNull$$$0(2);
        }
        if (colorManager == null) {
            VcsLogClassicFilterUi.$$$reportNull$$$0(3);
        }
        if (parentDisposable == null) {
            VcsLogClassicFilterUi.$$$reportNull$$$0(4);
        }
        this.myFilterListenerDispatcher = EventDispatcher.create(VcsLogFilterUiEx.VcsLogFilterListener.class);
        this.myLogData = logData;
        this.myUiProperties = uiProperties;
        this.myDataPack = VisiblePack.EMPTY;
        this.myColorManager = colorManager;
        Supplier<VcsLogDataPack> dataPackGetter = () -> this.myDataPack;
        this.myBranchFilterModel = new BranchFilterModel(dataPackGetter, this.myLogData.getStorage(), this.myLogData.getRoots(), this.myUiProperties, filters);
        this.myUserFilterModel = new UserFilterModel(this.myUiProperties, filters);
        this.myDateFilterModel = new DateFilterModel(this.myUiProperties, filters);
        this.myStructureFilterModel = new FileFilterModel(this.myLogData.getLogProviders().keySet(), this.myUiProperties, filters);
        this.myTextFilterModel = new TextFilterModel(this.myUiProperties, filters, parentDisposable);
        TextFilterField textFilterField = new TextFilterField(this.myTextFilterModel, parentDisposable);
        ActionToolbar toolbar2 = VcsLogClassicFilterUi.createTextActionsToolbar((JComponent)textFilterField.getTextEditor());
        this.mySearchComponent = new SearchFieldWithExtension(toolbar2.getComponent(), (SearchTextField)textFilterField);
        for (FilterModel model2 : models = new FilterModel[]{this.myBranchFilterModel, this.myUserFilterModel, this.myDateFilterModel, this.myStructureFilterModel, this.myTextFilterModel}) {
            model2.addSetFilterListener(() -> {
                filterConsumer.accept(this.getFilters());
                ((VcsLogFilterUiEx.VcsLogFilterListener)this.myFilterListenerDispatcher.getMulticaster()).onFiltersChanged();
                this.myBranchFilterModel.onStructureFilterChanged(this.myStructureFilterModel.getRootFilter(), this.myStructureFilterModel.getStructureFilter());
            });
        }
    }

    @NotNull
    private static ActionToolbar createTextActionsToolbar(@Nullable JComponent editor) {
        ActionManager actionManager = ActionManager.getInstance();
        @NotNull ActionGroup textActionGroup = (ActionGroup)actionManager.getAction("Vcs.Log.TextFilterSettings");
        ActionToolbarImpl toolbar2 = new ActionToolbarImpl("Vcs.Log.Toolbar", textActionGroup, true){

            @NotNull
            protected ActionButton createToolbarButton(@NotNull AnAction action2, ActionButtonLook look, @NotNull String place, @NotNull Presentation presentation2, Supplier<? extends @NotNull Dimension> minimumSize) {
                if (action2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (place == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (presentation2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                MyActionButton button = new MyActionButton(action2, presentation2);
                button.setFocusable(true);
                this.applyToolbarLook(look, presentation2, (JComponent)((Object)button));
                MyActionButton myActionButton = button;
                if (myActionButton == null) {
                    1.$$$reportNull$$$0(3);
                }
                return myActionButton;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "action";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "place";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "presentation";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createToolbarButton";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createToolbarButton";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 3 -> new IllegalStateException(string2);
                };
            }
        };
        toolbar2.setCustomButtonLook((ActionButtonLook)new FieldInplaceActionButtonLook());
        toolbar2.setReservePlaceAutoPopupIcon(false);
        toolbar2.setTargetComponent(editor);
        toolbar2.updateActionsImmediately();
        ActionToolbarImpl actionToolbarImpl = toolbar2;
        if (actionToolbarImpl == null) {
            VcsLogClassicFilterUi.$$$reportNull$$$0(5);
        }
        return actionToolbarImpl;
    }

    @Override
    public void updateDataPack(@NotNull VcsLogDataPack newDataPack) {
        if (newDataPack == null) {
            VcsLogClassicFilterUi.$$$reportNull$$$0(6);
        }
        this.myDataPack = newDataPack;
    }

    @Override
    @NotNull
    public SearchFieldWithExtension getTextFilterComponent() {
        SearchFieldWithExtension searchFieldWithExtension = this.mySearchComponent;
        if (searchFieldWithExtension == null) {
            VcsLogClassicFilterUi.$$$reportNull$$$0(7);
        }
        return searchFieldWithExtension;
    }

    @Override
    @NotNull
    public ActionGroup createActionGroup() {
        FilterActionComponent structureFilterComponent;
        FilterActionComponent dateComponent;
        FilterActionComponent userComponent;
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        FilterActionComponent branchComponent2 = this.createBranchComponent();
        if (branchComponent2 != null) {
            actionGroup.add((AnAction)branchComponent2);
        }
        if ((userComponent = this.createUserComponent()) != null) {
            actionGroup.add((AnAction)userComponent);
        }
        if ((dateComponent = this.createDateComponent()) != null) {
            actionGroup.add((AnAction)dateComponent);
        }
        if ((structureFilterComponent = this.createStructureFilterComponent()) != null) {
            actionGroup.add((AnAction)structureFilterComponent);
        }
        DefaultActionGroup defaultActionGroup = actionGroup;
        if (defaultActionGroup == null) {
            VcsLogClassicFilterUi.$$$reportNull$$$0(8);
        }
        return defaultActionGroup;
    }

    @Override
    @NotNull
    public VcsLogFilterCollection getFilters() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        VcsLogFilterCollection vcsLogFilterCollection = VcsLogFilterObject.collection(new VcsLogFilter[]{this.myBranchFilterModel.getBranchFilter(), this.myBranchFilterModel.getRevisionFilter(), this.myBranchFilterModel.getRangeFilter(), this.myTextFilterModel.getFilter1(), this.myTextFilterModel.getFilter2(), this.myStructureFilterModel.getFilter1(), this.myStructureFilterModel.getFilter2(), this.myDateFilterModel.getFilter(), (VcsLogFilter)this.myUserFilterModel.getFilter()});
        if (vcsLogFilterCollection == null) {
            VcsLogClassicFilterUi.$$$reportNull$$$0(9);
        }
        return vcsLogFilterCollection;
    }

    @Override
    public void setFilters(@NotNull VcsLogFilterCollection collection) {
        if (collection == null) {
            VcsLogClassicFilterUi.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myBranchFilterModel.setFilter(new BranchFilters(collection.get(VcsLogFilterCollection.BRANCH_FILTER), collection.get(VcsLogFilterCollection.REVISION_FILTER), collection.get(VcsLogFilterCollection.RANGE_FILTER)));
        this.myStructureFilterModel.setFilter(new FilterPair<VcsLogStructureFilter, VcsLogRootFilter>(collection.get(VcsLogFilterCollection.STRUCTURE_FILTER), collection.get(VcsLogFilterCollection.ROOT_FILTER)));
        this.myDateFilterModel.setFilter(collection.get(VcsLogFilterCollection.DATE_FILTER));
        this.myTextFilterModel.setFilter(new FilterPair<VcsLogTextFilter, VcsLogHashFilter>(collection.get(VcsLogFilterCollection.TEXT_FILTER), collection.get(VcsLogFilterCollection.HASH_FILTER)));
        this.myUserFilterModel.setFilter(collection.get(VcsLogFilterCollection.USER_FILTER));
    }

    @Nullable
    protected FilterActionComponent createBranchComponent() {
        return new FilterActionComponent(VcsLogBundle.messagePointer("vcs.log.branch.filter.action.text", new Object[0]), () -> new BranchFilterPopupComponent(this.myUiProperties, this.myBranchFilterModel).initUi());
    }

    @Nullable
    protected FilterActionComponent createUserComponent() {
        return new FilterActionComponent(VcsLogBundle.messagePointer("vcs.log.user.filter.action.text", new Object[0]), () -> new UserFilterPopupComponent(this.myUiProperties, this.myLogData, this.myUserFilterModel).initUi());
    }

    @Nullable
    protected FilterActionComponent createDateComponent() {
        return new FilterActionComponent(VcsLogBundle.messagePointer("vcs.log.date.filter.action.text", new Object[0]), () -> new DateFilterPopupComponent(this.myDateFilterModel).initUi());
    }

    @Nullable
    protected FilterActionComponent createStructureFilterComponent() {
        return new FilterActionComponent(VcsLogBundle.messagePointer("vcs.log.path.filter.action.text", new Object[0]), () -> new StructureFilterPopupComponent(this.myUiProperties, this.myStructureFilterModel, this.myColorManager).initUi());
    }

    @Override
    public void addFilterListener(@NotNull VcsLogFilterUiEx.VcsLogFilterListener listener2) {
        if (listener2 == null) {
            VcsLogClassicFilterUi.$$$reportNull$$$0(11);
        }
        this.myFilterListenerDispatcher.addListener((EventListener)listener2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterConsumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDataPack";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextActionsToolbar";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextFilterComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionGroup";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateDataPack";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setFilters";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addFilterListener";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 7, 8, 9 -> new IllegalStateException(string2);
        };
    }

    public static class BranchFilterModel
    extends FilterModel<BranchFilters> {
        @NotNull
        private final VcsLogStorage myStorage;
        @NotNull
        private final Collection<VirtualFile> myRoots;
        @Nullable
        private Collection<VirtualFile> myVisibleRoots;
        @NotNull
        private final Supplier<? extends VcsLogDataPack> myDataPackProvider;

        BranchFilterModel(@NotNull Supplier<? extends VcsLogDataPack> dataPackProvider, @NotNull VcsLogStorage storage, @NotNull Collection<VirtualFile> roots, @NotNull MainVcsLogUiProperties properties2, @Nullable VcsLogFilterCollection filters) {
            if (dataPackProvider == null) {
                BranchFilterModel.$$$reportNull$$$0(0);
            }
            if (storage == null) {
                BranchFilterModel.$$$reportNull$$$0(1);
            }
            if (roots == null) {
                BranchFilterModel.$$$reportNull$$$0(2);
            }
            if (properties2 == null) {
                BranchFilterModel.$$$reportNull$$$0(3);
            }
            super(properties2);
            this.myStorage = storage;
            this.myRoots = roots;
            this.myDataPackProvider = dataPackProvider;
            if (filters != null) {
                this.saveFilterToProperties(new BranchFilters(filters.get(VcsLogFilterCollection.BRANCH_FILTER), filters.get(VcsLogFilterCollection.REVISION_FILTER), filters.get(VcsLogFilterCollection.RANGE_FILTER)));
            }
        }

        @Override
        public void setFilter(@Nullable BranchFilters filters) {
            if (filters != null && filters.isEmpty()) {
                filters = null;
            }
            boolean anyFilterDiffers = false;
            if (BranchFilterModel.filterDiffers(filters, BranchFilters::getBranchFilter, (BranchFilters)this.myFilter)) {
                BranchFilterModel.triggerFilterSet(filters, BranchFilters::getBranchFilter, VcsLogFilterCollection.BRANCH_FILTER.getName());
                anyFilterDiffers = true;
            }
            if (BranchFilterModel.filterDiffers(filters, BranchFilters::getRevisionFilter, (BranchFilters)this.myFilter)) {
                BranchFilterModel.triggerFilterSet(filters, BranchFilters::getRevisionFilter, VcsLogFilterCollection.REVISION_FILTER.getName());
                anyFilterDiffers = true;
            }
            if (BranchFilterModel.filterDiffers(filters, BranchFilters::getRangeFilter, (BranchFilters)this.myFilter)) {
                BranchFilterModel.triggerFilterSet(filters, BranchFilters::getRangeFilter, VcsLogFilterCollection.RANGE_FILTER.getName());
                anyFilterDiffers = true;
            }
            if (anyFilterDiffers) {
                super.setFilter(filters);
            }
        }

        @Override
        protected void saveFilterToProperties(@Nullable BranchFilters filters) {
            if (filters == null || filters.getBranchFilter() == null) {
                this.myUiProperties.saveFilterValues(VcsLogFilterCollection.BRANCH_FILTER.getName(), null);
            } else {
                this.myUiProperties.saveFilterValues(VcsLogFilterCollection.BRANCH_FILTER.getName(), BranchFilterModel.getBranchFilterValues(filters.getBranchFilter()));
            }
            if (filters == null || filters.getRevisionFilter() == null) {
                this.myUiProperties.saveFilterValues(VcsLogFilterCollection.REVISION_FILTER.getName(), null);
            } else {
                this.myUiProperties.saveFilterValues(VcsLogFilterCollection.REVISION_FILTER.getName(), BranchFilterModel.getRevisionFilterValues(filters.getRevisionFilter()));
            }
            if (filters == null || filters.getRangeFilter() == null) {
                this.myUiProperties.saveFilterValues(VcsLogFilterCollection.RANGE_FILTER.getName(), null);
            } else {
                this.myUiProperties.saveFilterValues(VcsLogFilterCollection.RANGE_FILTER.getName(), BranchFilterModel.getRangeFilterValues(filters.getRangeFilter()));
            }
        }

        @Override
        @Nullable
        protected BranchFilters getFilterFromProperties() {
            List<String> branchFilterValues = this.myUiProperties.getFilterValues(VcsLogFilterCollection.BRANCH_FILTER.getName());
            VcsLogBranchFilter branchFilter = null;
            if (branchFilterValues != null) {
                branchFilter = this.createBranchFilter(branchFilterValues);
            }
            List<String> revisionFilterValues = this.myUiProperties.getFilterValues(VcsLogFilterCollection.REVISION_FILTER.getName());
            VcsLogRevisionFilter revisionFilter = null;
            if (revisionFilterValues != null) {
                revisionFilter = this.createRevisionFilter(revisionFilterValues);
            }
            List<String> rangeFilterValues = this.myUiProperties.getFilterValues(VcsLogFilterCollection.RANGE_FILTER.getName());
            VcsLogRangeFilter rangeFilter = null;
            if (rangeFilterValues != null) {
                rangeFilter = BranchFilterModel.createRangeFilter(rangeFilterValues);
            }
            if (branchFilter == null && revisionFilter == null && rangeFilter == null) {
                return null;
            }
            return new BranchFilters(branchFilter, revisionFilter, rangeFilter);
        }

        public void onStructureFilterChanged(@Nullable VcsLogRootFilter rootFilter, @Nullable VcsLogStructureFilter structureFilter) {
            this.myVisibleRoots = rootFilter == null && structureFilter == null ? null : VcsLogUtil.getAllVisibleRoots(this.myRoots, rootFilter, structureFilter);
        }

        @Nullable
        public Collection<VirtualFile> getVisibleRoots() {
            return this.myVisibleRoots;
        }

        @NotNull
        VcsLogDataPack getDataPack() {
            VcsLogDataPack vcsLogDataPack = this.myDataPackProvider.get();
            if (vcsLogDataPack == null) {
                BranchFilterModel.$$$reportNull$$$0(4);
            }
            return vcsLogDataPack;
        }

        @Nullable
        protected VcsLogBranchFilter createBranchFilter(@NotNull List<String> values2) {
            if (values2 == null) {
                BranchFilterModel.$$$reportNull$$$0(5);
            }
            return VcsLogFilterObject.fromBranchPatterns(values2, ContainerUtil.map2Set(this.getDataPack().getRefs().getBranches(), VcsRef::getName));
        }

        @Nullable
        protected VcsLogRevisionFilter createRevisionFilter(@NotNull List<String> values2) {
            if (values2 == null) {
                BranchFilterModel.$$$reportNull$$$0(6);
            }
            Pattern pattern2 = Pattern.compile("\\[(.*)\\](" + VcsLogUtil.HASH_REGEX.pattern() + ")");
            return VcsLogFilterObject.fromCommits(ContainerUtil.mapNotNull(values2, s -> {
                Matcher matcher = pattern2.matcher((CharSequence)s);
                if (!matcher.matches()) {
                    CommitId commitId2;
                    if (VcsLogUtil.isFullHash(s) && (commitId2 = this.findCommitId(HashImpl.build(s))) != null) {
                        return commitId2;
                    }
                    LOG.warn("Could not parse '" + s + "' while creating revision filter");
                    return null;
                }
                MatchResult result2 = matcher.toMatchResult();
                VirtualFile root = LocalFileSystem.getInstance().findFileByPath(result2.group(1));
                if (root == null) {
                    LOG.warn("Root '" + result2.group(1) + "' does not exist");
                    return null;
                }
                if (!this.myRoots.contains(root)) {
                    LOG.warn("Root '" + result2.group(1) + "' is not registered");
                    return null;
                }
                return new CommitId(HashImpl.build(result2.group(2)), root);
            }));
        }

        @Nullable
        private static VcsLogRangeFilter createRangeFilter(@NotNull List<String> values2) {
            List ranges;
            if (values2 == null) {
                BranchFilterModel.$$$reportNull$$$0(7);
            }
            if ((ranges = ContainerUtil.mapNotNull(values2, value2 -> {
                String TWO_DOTS = "..";
                int twoDots = value2.indexOf(TWO_DOTS);
                if (twoDots <= 0) {
                    LOG.error("Incorrect range filter value: " + values2);
                    return null;
                }
                return new VcsLogRangeFilter.RefRange(value2.substring(0, twoDots), value2.substring(twoDots + TWO_DOTS.length()));
            })).isEmpty()) {
                return null;
            }
            return VcsLogFilterObject.fromRange(ranges);
        }

        @Nullable
        private CommitId findCommitId(@NotNull Hash hash2) {
            if (hash2 == null) {
                BranchFilterModel.$$$reportNull$$$0(8);
            }
            for (VirtualFile root : this.myRoots) {
                CommitId commitId2 = new CommitId(hash2, root);
                if (!this.myStorage.containsCommit(commitId2)) continue;
                return commitId2;
            }
            return null;
        }

        @NotNull
        private static List<String> getBranchFilterValues(@NotNull VcsLogBranchFilter filter2) {
            if (filter2 == null) {
                BranchFilterModel.$$$reportNull$$$0(9);
            }
            return new ArrayList<String>(ContainerUtil.sorted(filter2.getTextPresentation()));
        }

        @NotNull
        private static List<String> getRevisionFilterValues(@NotNull VcsLogRevisionFilter filter2) {
            if (filter2 == null) {
                BranchFilterModel.$$$reportNull$$$0(10);
            }
            List list = ContainerUtil.map(filter2.getHeads(), id -> "[" + id.getRoot().getPath() + "]" + id.getHash().asString());
            if (list == null) {
                BranchFilterModel.$$$reportNull$$$0(11);
            }
            return list;
        }

        @NotNull
        private static List<String> getRangeFilterValues(@NotNull VcsLogRangeFilter rangeFilter) {
            if (rangeFilter == null) {
                BranchFilterModel.$$$reportNull$$$0(12);
            }
            return new ArrayList<String>(rangeFilter.getTextPresentation());
        }

        @NotNull
        private static List<String> getRevisionFilter2Presentation(@NotNull VcsLogRevisionFilter filter2) {
            if (filter2 == null) {
                BranchFilterModel.$$$reportNull$$$0(13);
            }
            List list = ContainerUtil.map(filter2.getHeads(), id -> id.getHash().asString());
            if (list == null) {
                BranchFilterModel.$$$reportNull$$$0(14);
            }
            return list;
        }

        void setBranchFilter(@NotNull VcsLogBranchFilter branchFilter) {
            if (branchFilter == null) {
                BranchFilterModel.$$$reportNull$$$0(15);
            }
            this.setFilter(new BranchFilters(branchFilter, null, null));
        }

        public void setRangeFilter(@NotNull VcsLogRangeFilter rangeFilter) {
            if (rangeFilter == null) {
                BranchFilterModel.$$$reportNull$$$0(16);
            }
            this.setFilter(new BranchFilters(null, null, rangeFilter));
        }

        @NotNull
        static List<String> getFilterPresentation(@NotNull BranchFilters filters) {
            if (filters == null) {
                BranchFilterModel.$$$reportNull$$$0(17);
            }
            List branchFilterValues = filters.getBranchFilter() == null ? Collections.emptyList() : BranchFilterModel.getBranchFilterValues(filters.getBranchFilter());
            List revisionFilterValues = filters.getRevisionFilter() == null ? Collections.emptyList() : BranchFilterModel.getRevisionFilter2Presentation(filters.getRevisionFilter());
            List rangeFilterValues = filters.getRangeFilter() == null ? Collections.emptyList() : BranchFilterModel.getRangeFilterValues(filters.getRangeFilter());
            List list = ContainerUtil.concat((List[])new List[]{branchFilterValues, revisionFilterValues, rangeFilterValues});
            if (list == null) {
                BranchFilterModel.$$$reportNull$$$0(18);
            }
            return list;
        }

        @Nullable
        BranchFilters createFilterFromPresentation(@NotNull List<String> values2) {
            if (values2 == null) {
                BranchFilterModel.$$$reportNull$$$0(19);
            }
            ArrayList<String> hashes2 = new ArrayList<String>();
            ArrayList<String> branches = new ArrayList<String>();
            ArrayList<String> ranges = new ArrayList<String>();
            for (String s : values2) {
                int twoDots = s.indexOf("..");
                if (twoDots > 0 && twoDots == s.lastIndexOf("..")) {
                    ranges.add(s);
                    continue;
                }
                if (VcsLogUtil.isFullHash(s)) {
                    hashes2.add(s);
                    continue;
                }
                branches.add(s);
            }
            VcsLogBranchFilter branchFilter = branches.isEmpty() ? null : this.createBranchFilter(branches);
            VcsLogRevisionFilter hashFilter = hashes2.isEmpty() ? null : this.createRevisionFilter(hashes2);
            VcsLogRangeFilter refDiffFilter = ranges.isEmpty() ? null : BranchFilterModel.createRangeFilter(ranges);
            return new BranchFilters(branchFilter, hashFilter, refDiffFilter);
        }

        @Nullable
        public VcsLogBranchFilter getBranchFilter() {
            BranchFilters filter2 = (BranchFilters)this.getFilter();
            if (filter2 == null) {
                return null;
            }
            return filter2.getBranchFilter();
        }

        @Nullable
        public VcsLogRevisionFilter getRevisionFilter() {
            BranchFilters filter2 = (BranchFilters)this.getFilter();
            if (filter2 == null) {
                return null;
            }
            return filter2.getRevisionFilter();
        }

        @Nullable
        public VcsLogRangeFilter getRangeFilter() {
            BranchFilters filter2 = (BranchFilters)this.getFilter();
            if (filter2 == null) {
                return null;
            }
            return filter2.getRangeFilter();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 11, 14, 18 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataPackProvider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storage";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 4: 
                case 11: 
                case 14: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$BranchFilterModel";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hash";
                    break;
                }
                case 9: 
                case 10: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 12: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeFilter";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchFilter";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$BranchFilterModel";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataPack";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevisionFilterValues";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevisionFilter2Presentation";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilterPresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 11: 
                case 14: 
                case 18: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createBranchFilter";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createRevisionFilter";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createRangeFilter";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "findCommitId";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getBranchFilterValues";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getRevisionFilterValues";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getRangeFilterValues";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "getRevisionFilter2Presentation";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "setBranchFilter";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "setRangeFilter";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilterPresentation";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "createFilterFromPresentation";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 4, 11, 14, 18 -> new IllegalStateException(string2);
            };
        }
    }

    private class UserFilterModel
    extends FilterModel.SingleFilterModel<VcsLogUserFilter> {
        UserFilterModel(@Nullable MainVcsLogUiProperties uiProperties, VcsLogFilterCollection filters) {
            if (uiProperties == null) {
                UserFilterModel.$$$reportNull$$$0(0);
            }
            super(VcsLogFilterCollection.USER_FILTER, uiProperties, filters);
        }

        @Override
        @NotNull
        protected VcsLogUserFilter createFilter(@NotNull List<String> values2) {
            if (values2 == null) {
                UserFilterModel.$$$reportNull$$$0(1);
            }
            VcsLogUserFilter vcsLogUserFilter = VcsLogFilterObject.fromUserNames(values2, VcsLogClassicFilterUi.this.myLogData);
            if (vcsLogUserFilter == null) {
                UserFilterModel.$$$reportNull$$$0(2);
            }
            return vcsLogUserFilter;
        }

        @Override
        @NotNull
        protected List<String> getFilterValues(@NotNull VcsLogUserFilter filter2) {
            if (filter2 == null) {
                UserFilterModel.$$$reportNull$$$0(3);
            }
            return new ArrayList<String>(filter2.getValuesAsText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uiProperties";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$UserFilterModel";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$UserFilterModel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createFilter";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilterValues";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }

    private static class DateFilterModel
    extends FilterModel.SingleFilterModel<VcsLogDateFilter> {
        DateFilterModel(@NotNull MainVcsLogUiProperties uiProperties, @Nullable VcsLogFilterCollection filters) {
            if (uiProperties == null) {
                DateFilterModel.$$$reportNull$$$0(0);
            }
            super(VcsLogFilterCollection.DATE_FILTER, uiProperties, filters);
        }

        @Override
        @Nullable
        protected VcsLogDateFilter createFilter(@NotNull List<String> values2) {
            if (values2 == null) {
                DateFilterModel.$$$reportNull$$$0(1);
            }
            if (values2.size() != 2) {
                LOG.warn("Can not create date filter from " + values2 + " before and after dates are required.");
                return null;
            }
            String after = values2.get(0);
            String before = values2.get(1);
            try {
                return VcsLogFilterObject.fromDates(after.isEmpty() ? 0L : Long.parseLong(after), before.isEmpty() ? 0L : Long.parseLong(before));
            }
            catch (NumberFormatException e) {
                LOG.warn("Can not create date filter from " + values2);
                return null;
            }
        }

        @Override
        @NotNull
        protected List<String> getFilterValues(@NotNull VcsLogDateFilter filter2) {
            if (filter2 == null) {
                DateFilterModel.$$$reportNull$$$0(2);
            }
            Date after = filter2.getAfter();
            Date before = filter2.getBefore();
            List<String> list = Arrays.asList(after == null ? "" : Long.toString(after.getTime()), before == null ? "" : Long.toString(before.getTime()));
            if (list == null) {
                DateFilterModel.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uiProperties";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$DateFilterModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$DateFilterModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilterValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createFilter";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilterValues";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3 -> new IllegalStateException(string2);
            };
        }
    }

    public static class FileFilterModel
    extends FilterModel.PairFilterModel<VcsLogStructureFilter, VcsLogRootFilter> {
        @NotNull
        @NonNls
        private static final String DIR = "dir:";
        @NotNull
        @NonNls
        private static final String FILE = "file:";
        @NotNull
        private final Set<VirtualFile> myRoots;

        public FileFilterModel(@NotNull Set<VirtualFile> roots, @NotNull MainVcsLogUiProperties uiProperties, @Nullable VcsLogFilterCollection filters) {
            if (roots == null) {
                FileFilterModel.$$$reportNull$$$0(0);
            }
            if (uiProperties == null) {
                FileFilterModel.$$$reportNull$$$0(1);
            }
            super(VcsLogFilterCollection.STRUCTURE_FILTER, VcsLogFilterCollection.ROOT_FILTER, uiProperties, filters);
            this.myRoots = roots;
        }

        @Override
        @NotNull
        protected List<String> getFilter1Values(@NotNull VcsLogStructureFilter filter2) {
            if (filter2 == null) {
                FileFilterModel.$$$reportNull$$$0(2);
            }
            return FileFilterModel.getFilterValues(filter2);
        }

        @Override
        @NotNull
        protected List<String> getFilter2Values(@NotNull VcsLogRootFilter filter2) {
            if (filter2 == null) {
                FileFilterModel.$$$reportNull$$$0(3);
            }
            return FileFilterModel.getRootFilterValues(filter2);
        }

        @NotNull
        public static List<String> getRootFilterValues(@NotNull VcsLogRootFilter filter2) {
            if (filter2 == null) {
                FileFilterModel.$$$reportNull$$$0(4);
            }
            List list = ContainerUtil.map(filter2.getRoots(), VirtualFile::getPath);
            if (list == null) {
                FileFilterModel.$$$reportNull$$$0(5);
            }
            return list;
        }

        @NotNull
        static List<String> getFilterValues(@NotNull VcsLogStructureFilter filter2) {
            if (filter2 == null) {
                FileFilterModel.$$$reportNull$$$0(6);
            }
            List list = ContainerUtil.map(filter2.getFiles(), path2 -> (path2.isDirectory() ? DIR : FILE) + path2.getPath());
            if (list == null) {
                FileFilterModel.$$$reportNull$$$0(7);
            }
            return list;
        }

        @Override
        @NotNull
        protected VcsLogStructureFilter createFilter1(@NotNull List<String> values2) {
            if (values2 == null) {
                FileFilterModel.$$$reportNull$$$0(8);
            }
            return FileFilterModel.createStructureFilter(values2);
        }

        @Override
        @Nullable
        protected VcsLogRootFilter createFilter2(@NotNull List<String> values2) {
            if (values2 == null) {
                FileFilterModel.$$$reportNull$$$0(9);
            }
            ArrayList<VirtualFile> selectedRoots = new ArrayList<VirtualFile>();
            for (String path2 : values2) {
                VirtualFile root = LocalFileSystem.getInstance().findFileByPath(path2);
                if (root != null) {
                    if (this.myRoots.contains(root)) {
                        selectedRoots.add(root);
                        continue;
                    }
                    LOG.warn("Can not find VCS root for filtering " + root);
                    continue;
                }
                LOG.warn("Can not filter by root that does not exist " + path2);
            }
            if (selectedRoots.isEmpty()) {
                return null;
            }
            return VcsLogFilterObject.fromRoots(selectedRoots);
        }

        @Nullable
        protected VcsLogRootFilter getRootFilter() {
            return (VcsLogRootFilter)this.getFilter2();
        }

        @Nullable
        public VcsLogStructureFilter getStructureFilter() {
            return (VcsLogStructureFilter)this.getFilter1();
        }

        @NotNull
        Set<VirtualFile> getRoots() {
            Set<VirtualFile> set = this.myRoots;
            if (set == null) {
                FileFilterModel.$$$reportNull$$$0(10);
            }
            return set;
        }

        protected void setStructureFilter(@NotNull VcsLogStructureFilter filter2) {
            if (filter2 == null) {
                FileFilterModel.$$$reportNull$$$0(11);
            }
            this.setFilter(new FilterPair<VcsLogStructureFilter, Object>(filter2, null));
        }

        @NotNull
        static VcsLogStructureFilter createStructureFilter(@NotNull List<String> values2) {
            if (values2 == null) {
                FileFilterModel.$$$reportNull$$$0(12);
            }
            VcsLogStructureFilter vcsLogStructureFilter = VcsLogFilterObject.fromPaths(ContainerUtil.map(values2, path2 -> {
                if (path2.startsWith(DIR)) {
                    return VcsUtil.getFilePath(path2.substring(DIR.length()), true);
                }
                if (path2.startsWith(FILE)) {
                    return VcsUtil.getFilePath(path2.substring(FILE.length()), false);
                }
                return VcsUtil.getFilePath(path2);
            }));
            if (vcsLogStructureFilter == null) {
                FileFilterModel.$$$reportNull$$$0(13);
            }
            return vcsLogStructureFilter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 7, 10, 13 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uiProperties";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 5: 
                case 7: 
                case 10: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$FileFilterModel";
                    break;
                }
                case 8: 
                case 9: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$FileFilterModel";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootFilterValues";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilterValues";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRoots";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createStructureFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilter1Values";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilter2Values";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getRootFilterValues";
                    break;
                }
                case 5: 
                case 7: 
                case 10: 
                case 13: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilterValues";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createFilter1";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "createFilter2";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "setStructureFilter";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "createStructureFilter";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 5, 7, 10, 13 -> new IllegalStateException(string2);
            };
        }
    }

    protected static class TextFilterModel
    extends FilterModel.PairFilterModel<VcsLogTextFilter, VcsLogHashFilter> {
        TextFilterModel(@NotNull MainVcsLogUiProperties properties2, @Nullable VcsLogFilterCollection filters, @NotNull Disposable parentDisposable) {
            VcsLogTextFilter textFilter;
            if (properties2 == null) {
                TextFilterModel.$$$reportNull$$$0(0);
            }
            if (parentDisposable == null) {
                TextFilterModel.$$$reportNull$$$0(1);
            }
            super(VcsLogFilterCollection.TEXT_FILTER, VcsLogFilterCollection.HASH_FILTER, properties2, filters);
            if (filters != null && (textFilter = filters.get(VcsLogFilterCollection.TEXT_FILTER)) != null) {
                this.myUiProperties.set(MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE, textFilter.matchesCase());
                this.myUiProperties.set(MainVcsLogUiProperties.TEXT_FILTER_REGEX, textFilter.isRegex());
            }
            VcsLogUiProperties.PropertiesChangeListener listener2 = new VcsLogUiProperties.PropertiesChangeListener(){

                @Override
                public <T> void onPropertyChanged(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property2) {
                    if (property2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((MainVcsLogUiProperties.TEXT_FILTER_REGEX.equals(property2) || MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE.equals(property2)) && this.getFilter1() != null) {
                        myFilter = this.getFilterFromProperties();
                        this.notifyFiltersChanged();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$TextFilterModel$1", "onPropertyChanged"));
                }
            };
            properties2.addChangeListener(listener2, parentDisposable);
        }

        @Override
        @Nullable
        protected FilterPair<VcsLogTextFilter, VcsLogHashFilter> getFilterFromProperties() {
            Object filterPair = super.getFilterFromProperties();
            if (filterPair == null) {
                return null;
            }
            VcsLogTextFilter textFilter = (VcsLogTextFilter)((FilterPair)filterPair).getFilter1();
            VcsLogHashFilter hashFilter = (VcsLogHashFilter)((FilterPair)filterPair).getFilter2();
            if (textFilter != null && StringUtil.isEmptyOrSpaces((String)textFilter.getText())) {
                LOG.warn("Saved text filter is empty. Removing.");
                textFilter = null;
            }
            if (textFilter != null) {
                VcsLogHashFilter hashFilterFromText = VcsLogFilterObject.fromHash(textFilter.getText());
                if (!Objects.equals(hashFilter, hashFilterFromText)) {
                    LOG.warn("Saved hash filter " + hashFilter + " is inconsistent with text filter. Replacing with " + hashFilterFromText);
                    hashFilter = hashFilterFromText;
                }
            } else if (hashFilter != null && !hashFilter.getHashes().isEmpty()) {
                textFilter = this.createTextFilter(StringUtil.join(hashFilter.getHashes(), (String)" "));
                LOG.warn("Saved hash filter " + hashFilter + " is inconsistent with empty text filter. Using text filter " + textFilter);
            }
            return new FilterPair<VcsLogTextFilter, VcsLogHashFilter>(textFilter, hashFilter);
        }

        @NotNull
        String getText() {
            if (this.getFilter1() != null) {
                String string2 = ((VcsLogTextFilter)this.getFilter1()).getText();
                if (string2 == null) {
                    TextFilterModel.$$$reportNull$$$0(2);
                }
                return string2;
            }
            return "";
        }

        @Override
        @NotNull
        protected List<String> getFilter1Values(@NotNull VcsLogTextFilter filter2) {
            if (filter2 == null) {
                TextFilterModel.$$$reportNull$$$0(3);
            }
            List<String> list = Collections.singletonList(filter2.getText());
            if (list == null) {
                TextFilterModel.$$$reportNull$$$0(4);
            }
            return list;
        }

        @Override
        @NotNull
        protected List<String> getFilter2Values(@NotNull VcsLogHashFilter filter2) {
            if (filter2 == null) {
                TextFilterModel.$$$reportNull$$$0(5);
            }
            return new ArrayList<String>(filter2.getHashes());
        }

        @Override
        @Nullable
        protected VcsLogTextFilter createFilter1(@NotNull List<String> values2) {
            if (values2 == null) {
                TextFilterModel.$$$reportNull$$$0(6);
            }
            return this.createTextFilter(Objects.requireNonNull((String)ContainerUtil.getFirstItem(values2)));
        }

        @Override
        @Nullable
        protected VcsLogHashFilter createFilter2(@NotNull List<String> values2) {
            if (values2 == null) {
                TextFilterModel.$$$reportNull$$$0(7);
            }
            return VcsLogFilterObject.fromHashes(values2);
        }

        @NotNull
        private VcsLogTextFilter createTextFilter(@NotNull String text2) {
            if (text2 == null) {
                TextFilterModel.$$$reportNull$$$0(8);
            }
            VcsLogTextFilter vcsLogTextFilter = VcsLogFilterObject.fromPattern(text2, this.myUiProperties.get(MainVcsLogUiProperties.TEXT_FILTER_REGEX), this.myUiProperties.get(MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE));
            if (vcsLogTextFilter == null) {
                TextFilterModel.$$$reportNull$$$0(9);
            }
            return vcsLogTextFilter;
        }

        public void setFilterText(@NotNull String text2) {
            if (text2 == null) {
                TextFilterModel.$$$reportNull$$$0(10);
            }
            if (StringUtil.isEmptyOrSpaces((String)text2)) {
                this.setFilter(null);
            } else {
                VcsLogTextFilter textFilter = this.createTextFilter(text2);
                VcsLogHashFilter hashFilter = VcsLogFilterObject.fromHash(text2);
                this.setFilter(new FilterPair<VcsLogTextFilter, VcsLogHashFilter>(textFilter, hashFilter));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
                case 2: 
                case 4: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$TextFilterModel";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$TextFilterModel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilter1Values";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTextFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: 
                case 9: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilter1Values";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilter2Values";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createFilter1";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createFilter2";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createTextFilter";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "setFilterText";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 4, 9 -> new IllegalStateException(string2);
            };
        }
    }

    private class TextFilterField
    extends SearchTextField
    implements DataProvider {
        @NotNull
        private final TextFilterModel myTextFilterModel;

        TextFilterField(@NotNull TextFilterModel model2, Disposable parentDisposable) {
            if (model2 == null) {
                TextFilterField.$$$reportNull$$$0(0);
            }
            if (parentDisposable == null) {
                TextFilterField.$$$reportNull$$$0(1);
            }
            super(VcsLogClassicFilterUi.VCS_LOG_TEXT_FILTER_HISTORY);
            this.myTextFilterModel = model2;
            this.setText(this.myTextFilterModel.getText());
            this.getTextEditor().addActionListener(e -> this.applyFilter(true));
            this.addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (TextFilterField.isFilterOnTheFlyEnabled()) {
                        TextFilterField.this.applyFilter(false);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$TextFilterField$1", "textChanged"));
                }
            });
            this.myTextFilterModel.addSetFilterListener(() -> {
                String modelText = this.myTextFilterModel.getText();
                if (!this.isSameFilterAs(modelText)) {
                    this.setText(modelText);
                }
            });
            this.getTextEditor().setToolTipText(TextFilterField.createTooltipText());
            Disposer.register((Disposable)parentDisposable, () -> this.hidePopup());
        }

        @NotNull
        @NlsContexts.Tooltip
        private static String createTooltipText() {
            String text2 = VcsLogBundle.message("vcs.log.filter.text.hash.tooltip", new Object[0]);
            String shortcut = HelpTooltip.getShortcutAsHtml((String)KeymapUtil.getFirstKeyboardShortcutText((String)"Vcs.Log.FocusTextFilter"));
            String string2 = XmlStringUtil.wrapInHtml((CharSequence)(text2 + shortcut));
            if (string2 == null) {
                TextFilterField.$$$reportNull$$$0(2);
            }
            return string2;
        }

        private void applyFilter(boolean addToHistory) {
            this.myTextFilterModel.setFilterText(this.getText());
            if (addToHistory) {
                this.addCurrentTextToHistory();
            }
        }

        protected void onFieldCleared() {
            this.myTextFilterModel.setFilter(null);
        }

        protected void onFocusLost() {
            if (!this.isSameFilterAs(this.myTextFilterModel.getText())) {
                this.applyFilter(TextFilterField.isFilterOnTheFlyEnabled());
            }
        }

        private boolean isSameFilterAs(@NotNull String otherText) {
            String thisText;
            if (otherText == null) {
                TextFilterField.$$$reportNull$$$0(3);
            }
            if (StringUtil.isEmptyOrSpaces((String)(thisText = this.getText()))) {
                return StringUtil.isEmptyOrSpaces((String)otherText);
            }
            return Objects.equals(thisText, otherText);
        }

        @Nullable
        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                TextFilterField.$$$reportNull$$$0(4);
            }
            if (VcsLogInternalDataKeys.LOG_UI_PROPERTIES.is(dataId)) {
                return VcsLogClassicFilterUi.this.myUiProperties;
            }
            return null;
        }

        private static boolean isFilterOnTheFlyEnabled() {
            return Registry.is((String)"vcs.log.filter.text.on.the.fly");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$TextFilterField";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "otherText";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$TextFilterField";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTooltipText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isSameFilterAs";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }

    protected static class FilterActionComponent
    extends DumbAwareAction
    implements CustomComponentAction {
        @NotNull
        private final Supplier<? extends JComponent> myComponentCreator;

        public FilterActionComponent(@NotNull Supplier<@Nls @NlsActions.ActionText String> dynamicText, @NotNull Supplier<? extends JComponent> componentCreator) {
            if (dynamicText == null) {
                FilterActionComponent.$$$reportNull$$$0(0);
            }
            if (componentCreator == null) {
                FilterActionComponent.$$$reportNull$$$0(1);
            }
            super(dynamicText);
            this.myComponentCreator = componentCreator;
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
            if (presentation2 == null) {
                FilterActionComponent.$$$reportNull$$$0(2);
            }
            if (place == null) {
                FilterActionComponent.$$$reportNull$$$0(3);
            }
            JComponent jComponent = this.myComponentCreator.get();
            if (jComponent == null) {
                FilterActionComponent.$$$reportNull$$$0(4);
            }
            return jComponent;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            MainVcsLogUi vcsLogUi;
            if (e == null) {
                FilterActionComponent.$$$reportNull$$$0(5);
            }
            if ((vcsLogUi = (MainVcsLogUi)e.getData(VcsLogInternalDataKeys.MAIN_UI)) == null) {
                return;
            }
            Component actionComponent = (Component)UIUtil.uiTraverser((Component)vcsLogUi.getToolbar()).traverse().find(component2 -> ClientProperty.get((Component)component2, (Key)ACTION_KEY) == this);
            if (actionComponent instanceof VcsLogPopupComponent) {
                ((VcsLogPopupComponent)((Object)actionComponent)).showPopupMenu();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dynamicText";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "componentCreator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$FilterActionComponent";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$FilterActionComponent";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCustomComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createCustomComponent";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 4 -> new IllegalStateException(string2);
            };
        }
    }

    private static final class MyActionButton
    extends ActionButton {
        MyActionButton(@NotNull AnAction action2, @NotNull Presentation presentation2) {
            if (action2 == null) {
                MyActionButton.$$$reportNull$$$0(0);
            }
            if (presentation2 == null) {
                MyActionButton.$$$reportNull$$$0(1);
            }
            super(action2, presentation2, "Vcs.Log.SearchTextField", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
            this.updateIcon();
        }

        public int getPopState() {
            return this.isSelected() ? 2 : super.getPopState();
        }

        public Icon getIcon() {
            Icon selectedIcon;
            if (this.isEnabled() && this.isSelected() && (selectedIcon = this.myPresentation.getSelectedIcon()) != null) {
                return selectedIcon;
            }
            return super.getIcon();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "action";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "presentation";
                    break;
                }
            }
            objectArray[1] = "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi$MyActionButton";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

