/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.EdgePrintElement;
import com.intellij.vcs.log.graph.NodePrintElement;
import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.graph.actions.GraphAction;
import com.intellij.vcs.log.graph.actions.GraphAnswer;
import com.intellij.vcs.log.paint.GraphCellPainter;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.frame.CommitPresentationUtil;
import com.intellij.vcs.log.ui.table.SelectionSnapshot;
import com.intellij.vcs.log.ui.table.VcsLogCellController;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.ui.table.column.Commit;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GraphCommitCellController
implements VcsLogCellController {
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogGraphTable myTable;
    @NotNull
    private final GraphCellPainter myGraphCellPainter;

    public GraphCommitCellController(@NotNull VcsLogData logData, @NotNull VcsLogGraphTable table, @NotNull GraphCellPainter painter) {
        if (logData == null) {
            GraphCommitCellController.$$$reportNull$$$0(0);
        }
        if (table == null) {
            GraphCommitCellController.$$$reportNull$$$0(1);
        }
        if (painter == null) {
            GraphCommitCellController.$$$reportNull$$$0(2);
        }
        this.myLogData = logData;
        this.myTable = table;
        this.myGraphCellPainter = painter;
    }

    protected abstract int getTooltipXCoordinate(int var1);

    @Nullable
    protected abstract JComponent getTooltip(@NotNull Object var1, @NotNull Point var2, int var3);

    @Override
    @Nullable
    public Cursor performMouseClick(int row2, @NotNull MouseEvent e) {
        PrintElement printElement;
        if (e == null) {
            GraphCommitCellController.$$$reportNull$$$0(3);
        }
        if ((printElement = this.findPrintElement(row2, this.myTable.getPointInCell(e.getPoint(), Commit.INSTANCE))) != null) {
            return this.performGraphAction(printElement, e, GraphAction.Type.MOUSE_CLICK);
        }
        return null;
    }

    @Override
    @Nullable
    public Cursor performMouseMove(int row2, @NotNull MouseEvent e) {
        if (e == null) {
            GraphCommitCellController.$$$reportNull$$$0(4);
        }
        Point pointInCell = this.myTable.getPointInCell(e.getPoint(), Commit.INSTANCE);
        PrintElement printElement = this.findPrintElement(row2, pointInCell);
        Cursor cursor = this.performGraphAction(printElement, e, GraphAction.Type.MOUSE_OVER);
        if (printElement == null && !this.showTooltip(row2, pointInCell, e.getPoint(), false) && IdeTooltipManager.getInstance().hasCurrent()) {
            IdeTooltipManager.getInstance().hideCurrent(e);
        }
        return cursor;
    }

    @Override
    public boolean shouldSelectCell(int row2, @NotNull MouseEvent e) {
        if (e == null) {
            GraphCommitCellController.$$$reportNull$$$0(5);
        }
        return this.findPrintElement(row2, this.myTable.getPointInCell(e.getPoint(), Commit.INSTANCE)) == null;
    }

    @Nullable
    private PrintElement findPrintElement(int row2, @NotNull Point pointInCell) {
        if (pointInCell == null) {
            GraphCommitCellController.$$$reportNull$$$0(6);
        }
        Collection<PrintElement> printElements = this.myTable.getVisibleGraph().getRowInfo(row2).getPrintElements();
        return this.myGraphCellPainter.getElementUnderCursor(printElements, pointInCell.x, pointInCell.y);
    }

    @Nullable
    private Cursor performGraphAction(@Nullable PrintElement printElement, @NotNull MouseEvent e, @NotNull GraphAction.Type actionType) {
        boolean isClickOnGraphElement;
        if (e == null) {
            GraphCommitCellController.$$$reportNull$$$0(7);
        }
        if (actionType == null) {
            GraphCommitCellController.$$$reportNull$$$0(8);
        }
        boolean bl = isClickOnGraphElement = actionType == GraphAction.Type.MOUSE_CLICK && printElement != null;
        if (isClickOnGraphElement) {
            GraphCommitCellController.triggerElementClick(printElement);
        }
        SelectionSnapshot previousSelection = this.myTable.getSelectionSnapshot();
        GraphAnswer<Integer> answer = this.myTable.getVisibleGraph().getActionController().performAction(new GraphAction.GraphActionImpl(printElement, actionType));
        return this.handleGraphAnswer(answer, isClickOnGraphElement, previousSelection, e);
    }

    @Nullable
    Cursor handleGraphAnswer(@Nullable GraphAnswer<Integer> answer, boolean dataCouldChange, @Nullable SelectionSnapshot previousSelection, @Nullable MouseEvent e) {
        if (dataCouldChange) {
            this.myTable.getModel().fireTableDataChanged();
            if (previousSelection != null) {
                previousSelection.restore(this.myTable.getVisibleGraph(), answer == null || answer.getCommitToJump() != null && answer.doJump(), false);
            }
        }
        if (answer == null) {
            return null;
        }
        if (answer.isRepaintRequired()) {
            this.myTable.repaint();
        }
        if (answer.getCommitToJump() != null) {
            Integer row2 = this.myTable.getModel().getVisiblePack().getVisibleGraph().getVisibleRowIndex(answer.getCommitToJump());
            if (row2 != null && row2 >= 0 && answer.doJump()) {
                this.myTable.jumpToRow(row2, true);
            } else if (e != null) {
                VcsLogUiUtil.showTooltip((JComponent)((Object)this.myTable), new Point(e.getX() + 5, e.getY()), Balloon.Position.atRight, this.getArrowTooltipText(answer.getCommitToJump(), row2));
            }
        }
        return answer.getCursorToSet();
    }

    @NotNull
    @Nls
    private String getArrowTooltipText(int commit2, @Nullable Integer row2) {
        VcsCommitMetadata details = row2 != null && row2 >= 0 ? this.myTable.getModel().getCommitMetadata(row2, true) : this.myLogData.getMiniDetailsGetter().getCommitData(commit2, Collections.singletonList(commit2));
        if (details instanceof LoadingDetails) {
            CommitId commitId2 = this.myLogData.getCommitId(commit2);
            if (commitId2 != null) {
                if (this.myLogData.getRoots().size() > 1) {
                    String string2 = VcsLogBundle.message("vcs.log.graph.arrow.tooltip.jump.to.hash.in.root", commitId2.getHash().toShortString(), commitId2.getRoot().getName());
                    if (string2 == null) {
                        GraphCommitCellController.$$$reportNull$$$0(9);
                    }
                    return string2;
                }
                String string3 = VcsLogBundle.message("vcs.log.graph.arrow.tooltip.jump.to.hash", commitId2.getHash().toShortString());
                if (string3 == null) {
                    GraphCommitCellController.$$$reportNull$$$0(10);
                }
                return string3;
            }
            return "";
        }
        long time = details.getAuthorTime();
        String shortenedSubject = StringUtil.shortenTextWithEllipsis((String)details.getSubject(), (int)50, (int)0, (String)"...");
        String commitMessage = HtmlChunk.text((String)("\"" + shortenedSubject + "\"")).bold().toString();
        String string4 = VcsLogBundle.message("vcs.log.graph.arrow.tooltip.jump.to.subject.author.date.time", commitMessage, CommitPresentationUtil.getAuthorPresentation(details), DateFormatUtil.formatDate((long)time), DateFormatUtil.formatTime((long)time));
        if (string4 == null) {
            GraphCommitCellController.$$$reportNull$$$0(11);
        }
        return string4;
    }

    private boolean showTooltip(int row2, @NotNull Point pointInCell, @NotNull Point point, boolean now) {
        JComponent tipComponent;
        if (pointInCell == null) {
            GraphCommitCellController.$$$reportNull$$$0(12);
        }
        if (point == null) {
            GraphCommitCellController.$$$reportNull$$$0(13);
        }
        if ((tipComponent = this.getTooltip(this.myTable.getValueAt(row2, this.myTable.getColumnViewIndex(Commit.INSTANCE)), pointInCell, row2)) != null) {
            this.myTable.getExpandableItemsHandler().setEnabled(false);
            IdeTooltip tooltip2 = new IdeTooltip((Component)((Object)this.myTable), point, (JComponent)new Wrapper(tipComponent), new Object[0]).setPreferredPosition(Balloon.Position.below);
            IdeTooltipManager.getInstance().show(tooltip2, now);
            return true;
        }
        return false;
    }

    void showTooltip(int row2) {
        Point topLeftCorner = new Point(this.myTable.getColumnDataRectLeftX(this.myTable.getColumnViewIndex(Commit.INSTANCE)), row2 * this.myTable.getRowHeight());
        Point pointInCell = new Point(this.getTooltipXCoordinate(row2), this.myTable.getRowHeight() / 2);
        this.showTooltip(row2, pointInCell, new Point(topLeftCorner.x + pointInCell.x, topLeftCorner.y + pointInCell.y), true);
    }

    private static void triggerElementClick(@NotNull PrintElement printElement) {
        if (printElement == null) {
            GraphCommitCellController.$$$reportNull$$$0(14);
        }
        if (printElement instanceof NodePrintElement) {
            VcsLogUsageTriggerCollector.triggerClick("node");
        } else if (printElement instanceof EdgePrintElement && ((EdgePrintElement)printElement).hasArrow()) {
            VcsLogUsageTriggerCollector.triggerClick("arrow");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "painter";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointInCell";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionType";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/table/GraphCommitCellController";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/table/GraphCommitCellController";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrowTooltipText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performMouseClick";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performMouseMove";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shouldSelectCell";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findPrintElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "performGraphAction";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showTooltip";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "triggerElementClick";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 9, 10, 11 -> new IllegalStateException(string2);
        };
    }
}

