/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.CommittedChangeListForRevision;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogListener;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsChangesLazilyParsedDetails;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsLogUtil {
    public static final int MAX_SELECTED_COMMITS = 1000;
    public static final int FULL_HASH_LENGTH = 40;
    public static final int SHORT_HASH_LENGTH = 8;
    public static final Pattern HASH_REGEX = Pattern.compile("[a-fA-F0-9]{7,40}");
    public static final Pattern HASH_PREFIX_REGEX = Pattern.compile("[a-fA-F0-9]{4,40}");
    @NlsSafe
    public static final String HEAD = "HEAD";

    @NotNull
    public static Map<VirtualFile, Set<VcsRef>> groupRefsByRoot(@NotNull Collection<? extends VcsRef> refs) {
        if (refs == null) {
            VcsLogUtil.$$$reportNull$$$0(0);
        }
        TreeMap<VirtualFile, Set<VcsRef>> map2 = new TreeMap<VirtualFile, Set<VcsRef>>(Comparator.comparing(VirtualFile::getPresentableUrl));
        for (VcsRef vcsRef : refs) {
            map2.computeIfAbsent(vcsRef.getRoot(), k -> new HashSet()).add(vcsRef);
        }
        TreeMap<VirtualFile, Set<VcsRef>> treeMap = map2;
        if (treeMap == null) {
            VcsLogUtil.$$$reportNull$$$0(1);
        }
        return treeMap;
    }

    public static int compareRoots(@NotNull VirtualFile root1, @NotNull VirtualFile root2) {
        if (root1 == null) {
            VcsLogUtil.$$$reportNull$$$0(2);
        }
        if (root2 == null) {
            VcsLogUtil.$$$reportNull$$$0(3);
        }
        return root1.getPresentableUrl().compareTo(root2.getPresentableUrl());
    }

    @NotNull
    private static Set<VirtualFile> collectRoots(@NotNull Collection<? extends FilePath> files2, @NotNull Set<? extends VirtualFile> roots) {
        if (files2 == null) {
            VcsLogUtil.$$$reportNull$$$0(4);
        }
        if (roots == null) {
            VcsLogUtil.$$$reportNull$$$0(5);
        }
        HashSet<VirtualFile> selectedRoots = new HashSet<VirtualFile>();
        List sortedRoots2 = ContainerUtil.sorted(roots, Comparator.comparing(VirtualFile::getPath));
        for (FilePath filePath : files2) {
            VirtualFile virtualFile = filePath.getVirtualFile();
            if (virtualFile != null && roots.contains(virtualFile)) {
                selectedRoots.add(virtualFile);
            } else {
                VirtualFile candidateAncestorRoot = null;
                for (VirtualFile root : sortedRoots2) {
                    if (!FileUtil.isAncestor((File)VfsUtilCore.virtualToIoFile((VirtualFile)root), (File)filePath.getIOFile(), (boolean)false)) continue;
                    candidateAncestorRoot = root;
                }
                if (candidateAncestorRoot != null) {
                    selectedRoots.add(candidateAncestorRoot);
                }
            }
            if (virtualFile == null) continue;
            for (VirtualFile virtualFile2 : roots) {
                if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)virtualFile2, (boolean)false)) continue;
                selectedRoots.add(virtualFile2);
            }
        }
        HashSet<VirtualFile> hashSet = selectedRoots;
        if (hashSet == null) {
            VcsLogUtil.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    @NotNull
    public static Set<VirtualFile> getVisibleRoots(@NotNull VcsLogUi logUi2) {
        if (logUi2 == null) {
            VcsLogUtil.$$$reportNull$$$0(7);
        }
        VcsLogFilterCollection filters = logUi2.getFilterUi().getFilters();
        Set<VirtualFile> roots = logUi2.getDataPack().getLogProviders().keySet();
        return VcsLogUtil.getAllVisibleRoots(roots, filters);
    }

    @NotNull
    public static Set<VirtualFile> getAllVisibleRoots(@NotNull Collection<VirtualFile> roots, @NotNull VcsLogFilterCollection filters) {
        if (roots == null) {
            VcsLogUtil.$$$reportNull$$$0(8);
        }
        if (filters == null) {
            VcsLogUtil.$$$reportNull$$$0(9);
        }
        return VcsLogUtil.getAllVisibleRoots(roots, filters.get(VcsLogFilterCollection.ROOT_FILTER), filters.get(VcsLogFilterCollection.STRUCTURE_FILTER));
    }

    @NotNull
    public static Set<VirtualFile> getAllVisibleRoots(@NotNull Collection<VirtualFile> roots, @Nullable VcsLogRootFilter rootFilter, @Nullable VcsLogStructureFilter structureFilter) {
        if (roots == null) {
            VcsLogUtil.$$$reportNull$$$0(10);
        }
        if (rootFilter == null && structureFilter == null) {
            return new HashSet<VirtualFile>(roots);
        }
        Collection<VirtualFile> fromRootFilter = rootFilter != null ? rootFilter.getRoots() : roots;
        Collection<VirtualFile> fromStructureFilter = structureFilter != null ? VcsLogUtil.collectRoots(structureFilter.getFiles(), new HashSet<VirtualFile>(roots)) : roots;
        return new HashSet<VirtualFile>(ContainerUtil.intersection(fromRootFilter, fromStructureFilter));
    }

    @NotNull
    public static Set<FilePath> getFilteredFilesForRoot(@NotNull VirtualFile root, @NotNull VcsLogFilterCollection filterCollection) {
        VcsLogStructureFilter structureFilter;
        if (root == null) {
            VcsLogUtil.$$$reportNull$$$0(11);
        }
        if (filterCollection == null) {
            VcsLogUtil.$$$reportNull$$$0(12);
        }
        if ((structureFilter = filterCollection.get(VcsLogFilterCollection.STRUCTURE_FILTER)) == null) {
            Set<FilePath> set = Collections.emptySet();
            if (set == null) {
                VcsLogUtil.$$$reportNull$$$0(13);
            }
            return set;
        }
        Collection<FilePath> files2 = structureFilter.getFiles();
        return new HashSet<FilePath>(ContainerUtil.filter(files2, filePath -> {
            VirtualFile virtualFile = filePath.getVirtualFile();
            return root.equals(virtualFile) || FileUtil.isAncestor((File)VfsUtilCore.virtualToIoFile((VirtualFile)root), (File)filePath.getIOFile(), (boolean)false);
        }));
    }

    @Nullable
    @NlsSafe
    public static String getSingleFilteredBranch(@NotNull VcsLogFilterCollection filters, @NotNull VcsLogRefs refs) {
        VcsLogBranchFilter filter2;
        if (filters == null) {
            VcsLogUtil.$$$reportNull$$$0(14);
        }
        if (refs == null) {
            VcsLogUtil.$$$reportNull$$$0(15);
        }
        if ((filter2 = filters.get(VcsLogFilterCollection.BRANCH_FILTER)) == null) {
            return null;
        }
        String branchName = null;
        HashSet<VirtualFile> checkedRoots = new HashSet<VirtualFile>();
        for (VcsRef branch : refs.getBranches()) {
            if (!filter2.matches(branch.getName())) continue;
            if (branchName == null) {
                branchName = branch.getName();
            } else if (!branch.getName().equals(branchName)) {
                return null;
            }
            if (checkedRoots.contains(branch.getRoot())) {
                return null;
            }
            checkedRoots.add(branch.getRoot());
        }
        return branchName;
    }

    public static boolean isRegexp(@NotNull String text2) {
        if (text2 == null) {
            VcsLogUtil.$$$reportNull$$$0(16);
        }
        return StringUtil.containsAnyChar((String)text2, (String)"()[]{}.*?+^$\\|");
    }

    @NotNull
    public static TextRevisionNumber convertToRevisionNumber(@NotNull Hash hash2) {
        if (hash2 == null) {
            VcsLogUtil.$$$reportNull$$$0(17);
        }
        return new TextRevisionNumber(hash2.asString(), hash2.toShortString());
    }

    @NotNull
    public static List<? extends VcsFullCommitDetails> getDetails(@NotNull VcsLogProvider logProvider, @NotNull VirtualFile root, @NotNull List<String> hashes2) throws VcsException {
        if (logProvider == null) {
            VcsLogUtil.$$$reportNull$$$0(18);
        }
        if (root == null) {
            VcsLogUtil.$$$reportNull$$$0(19);
        }
        if (hashes2 == null) {
            VcsLogUtil.$$$reportNull$$$0(20);
        }
        ArrayList result2 = new ArrayList();
        logProvider.readFullDetails(root, hashes2, (Consumer<? super VcsFullCommitDetails>)((Consumer)result2::add));
        ArrayList arrayList = result2;
        if (arrayList == null) {
            VcsLogUtil.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    @NotNull
    public static CommittedChangeListForRevision createCommittedChangeList(@NotNull VcsFullCommitDetails detail, boolean withChanges) {
        if (detail == null) {
            VcsLogUtil.$$$reportNull$$$0(22);
        }
        return new CommittedChangeListForRevision(detail.getSubject(), detail.getFullMessage(), VcsUserUtil.getShortPresentation(detail.getCommitter()), new Date(detail.getCommitTime()), withChanges ? detail.getChanges() : ContainerUtil.emptyList(), VcsLogUtil.convertToRevisionNumber((Hash)detail.getId()));
    }

    @NotNull
    public static CommittedChangeListForRevision createCommittedChangeList(@NotNull VcsFullCommitDetails detail) {
        if (detail == null) {
            VcsLogUtil.$$$reportNull$$$0(23);
        }
        return VcsLogUtil.createCommittedChangeList(detail, true);
    }

    @NotNull
    @NlsSafe
    public static String getShortHash(@NotNull String hashString) {
        if (hashString == null) {
            VcsLogUtil.$$$reportNull$$$0(24);
        }
        return VcsLogUtil.getShortHash(hashString, 8);
    }

    @NotNull
    @NlsSafe
    public static String getShortHash(@NotNull String hashString, int shortHashLength) {
        if (hashString == null) {
            VcsLogUtil.$$$reportNull$$$0(25);
        }
        String string2 = hashString.substring(0, Math.min(shortHashLength, hashString.length()));
        if (string2 == null) {
            VcsLogUtil.$$$reportNull$$$0(26);
        }
        return string2;
    }

    public static boolean isFullHash(@NotNull String s) {
        if (s == null) {
            VcsLogUtil.$$$reportNull$$$0(27);
        }
        return s.length() == 40 && HASH_REGEX.matcher(s).matches();
    }

    @Nullable
    public static VcsRef findBranch(@NotNull RefsModel refs, @NotNull VirtualFile root, @NotNull String branchName) {
        CompressedRefs compressedRefs;
        if (refs == null) {
            VcsLogUtil.$$$reportNull$$$0(28);
        }
        if (root == null) {
            VcsLogUtil.$$$reportNull$$$0(29);
        }
        if (branchName == null) {
            VcsLogUtil.$$$reportNull$$$0(30);
        }
        if ((compressedRefs = refs.getAllRefsByRoot().get(root)) == null) {
            return null;
        }
        Stream<VcsRef> branches = compressedRefs.streamBranches();
        return branches.filter(vcsRef -> vcsRef.getName().equals(branchName)).findFirst().orElse(null);
    }

    @NotNull
    public static List<Change> collectChanges(@NotNull List<? extends VcsFullCommitDetails> detailsList) {
        if (detailsList == null) {
            VcsLogUtil.$$$reportNull$$$0(31);
        }
        ArrayList<Change> changes = new ArrayList<Change>();
        List detailsListReversed = ContainerUtil.reverse(detailsList);
        for (VcsFullCommitDetails details : detailsListReversed) {
            changes.addAll(details.getChanges());
        }
        List<Change> list = CommittedChangesTreeBrowser.zipChanges(changes);
        if (list == null) {
            VcsLogUtil.$$$reportNull$$$0(32);
        }
        return list;
    }

    @Nullable
    public static VirtualFile getActualRoot(@NotNull Project project2, @NotNull FilePath path2) {
        VcsRoot rootObject;
        if (project2 == null) {
            VcsLogUtil.$$$reportNull$$$0(33);
        }
        if (path2 == null) {
            VcsLogUtil.$$$reportNull$$$0(34);
        }
        if ((rootObject = ProjectLevelVcsManager.getInstance(project2).getVcsRootObjectFor(path2)) == null) {
            return null;
        }
        Map<VirtualFile, VcsLogProvider> providers = VcsLogManager.findLogProviders(Collections.singletonList(rootObject), project2);
        if (providers.isEmpty()) {
            return null;
        }
        VcsLogProvider provider = Objects.requireNonNull((VcsLogProvider)ContainerUtil.getFirstItem(providers.values()));
        return provider.getVcsRoot(project2, rootObject.getPath(), path2);
    }

    @Nullable
    public static VirtualFile getActualRoot(@NotNull Project project2, @NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull FilePath path2) {
        List sortedRoots2;
        VirtualFile root;
        if (project2 == null) {
            VcsLogUtil.$$$reportNull$$$0(35);
        }
        if (providers == null) {
            VcsLogUtil.$$$reportNull$$$0(36);
        }
        if (path2 == null) {
            VcsLogUtil.$$$reportNull$$$0(37);
        }
        if ((root = (VirtualFile)ContainerUtil.find((Iterable)(sortedRoots2 = ContainerUtil.sorted(providers.keySet(), Comparator.comparing(VirtualFile::getPath).reversed())), r -> FileUtil.isAncestor((File)VfsUtilCore.virtualToIoFile((VirtualFile)r), (File)path2.getIOFile(), (boolean)false))) == null) {
            return null;
        }
        VcsLogProvider provider = providers.get(root);
        if (provider == null) {
            return null;
        }
        return provider.getVcsRoot(project2, root, path2);
    }

    @Nullable
    public static Collection<FilePath> getAffectedPaths(@NotNull VcsLogUi logUi2) {
        if (logUi2 == null) {
            VcsLogUtil.$$$reportNull$$$0(38);
        }
        return VcsLogUtil.getAffectedPaths(logUi2.getDataPack());
    }

    @Nullable
    public static Collection<FilePath> getAffectedPaths(@NotNull VcsLogDataPack dataPack) {
        VcsLogStructureFilter structureFilter;
        if (dataPack == null) {
            VcsLogUtil.$$$reportNull$$$0(39);
        }
        if ((structureFilter = dataPack.getFilters().get(VcsLogFilterCollection.STRUCTURE_FILTER)) != null) {
            return structureFilter.getFiles();
        }
        return null;
    }

    @Nullable
    public static Collection<FilePath> getAffectedPaths(@NotNull VirtualFile root, @NotNull AnActionEvent e) {
        VcsLogUiProperties properties2;
        if (root == null) {
            VcsLogUtil.$$$reportNull$$$0(40);
        }
        if (e == null) {
            VcsLogUtil.$$$reportNull$$$0(41);
        }
        if ((properties2 = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES)) != null && properties2.exists(MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES) && properties2.get(MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES).booleanValue()) {
            Collection<FilePath> affectedFilePaths;
            VcsLogUi logUi2 = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
            Project project2 = e.getProject();
            if (logUi2 != null && project2 != null && (affectedFilePaths = VcsLogUtil.getAffectedPaths(logUi2)) != null) {
                return ContainerUtil.filter(affectedFilePaths, path2 -> Objects.equals(VcsUtil.getVcsRootFor(project2, path2), root));
            }
        }
        return null;
    }

    public static int getMaxSize(@NotNull List<? extends VcsFullCommitDetails> detailsList) {
        if (detailsList == null) {
            VcsLogUtil.$$$reportNull$$$0(42);
        }
        int maxSize = 0;
        for (VcsFullCommitDetails vcsFullCommitDetails : detailsList) {
            maxSize = Math.max(VcsLogUtil.getSize(vcsFullCommitDetails), maxSize);
        }
        return maxSize;
    }

    public static int getSize(@NotNull VcsFullCommitDetails details) {
        if (details == null) {
            VcsLogUtil.$$$reportNull$$$0(43);
        }
        if (details instanceof VcsChangesLazilyParsedDetails) {
            return ((VcsChangesLazilyParsedDetails)details).size();
        }
        int size = 0;
        for (int i = 0; i < details.getParents().size(); ++i) {
            size += details.getChanges(i).size();
        }
        return size;
    }

    public static int getShownChangesLimit() {
        return Registry.intValue((String)"vcs.log.max.changes.shown");
    }

    @NotNull
    @NonNls
    public static String getSizeText(int maxSize) {
        if (maxSize < 1000) {
            String string2 = String.valueOf(maxSize);
            if (string2 == null) {
                VcsLogUtil.$$$reportNull$$$0(44);
            }
            return string2;
        }
        DecimalFormat format = new DecimalFormat("#.#");
        format.setRoundingMode(RoundingMode.FLOOR);
        if (maxSize < 10000) {
            String string3 = format.format((double)maxSize / 1000.0) + "K";
            if (string3 == null) {
                VcsLogUtil.$$$reportNull$$$0(45);
            }
            return string3;
        }
        if (maxSize < 1000000) {
            String string4 = maxSize / 1000 + "K";
            if (string4 == null) {
                VcsLogUtil.$$$reportNull$$$0(46);
            }
            return string4;
        }
        if (maxSize < 10000000) {
            String string5 = format.format((double)maxSize / 1000000.0) + "M";
            if (string5 == null) {
                VcsLogUtil.$$$reportNull$$$0(47);
            }
            return string5;
        }
        String string6 = maxSize / 1000000 + "M";
        if (string6 == null) {
            VcsLogUtil.$$$reportNull$$$0(48);
        }
        return string6;
    }

    @NotNull
    @NonNls
    public static String getProvidersMapText(@NotNull Map<VirtualFile, VcsLogProvider> providers) {
        if (providers == null) {
            VcsLogUtil.$$$reportNull$$$0(49);
        }
        String string2 = "[" + StringUtil.join(providers.keySet(), file -> file.getPresentableUrl(), (String)", ") + "]";
        if (string2 == null) {
            VcsLogUtil.$$$reportNull$$$0(50);
        }
        return string2;
    }

    @NotNull
    @Nls
    public static String getVcsDisplayName(@NotNull Project project2, @NotNull Collection<? extends VcsLogProvider> logProviders) {
        Set vcs;
        if (project2 == null) {
            VcsLogUtil.$$$reportNull$$$0(51);
        }
        if (logProviders == null) {
            VcsLogUtil.$$$reportNull$$$0(52);
        }
        if ((vcs = ContainerUtil.map2SetNotNull(logProviders, provider -> VcsUtil.findVcsByKey(project2, provider.getSupportedVcs()))).size() != 1) {
            String string2 = VcsLogBundle.message("vcs", new Object[0]);
            if (string2 == null) {
                VcsLogUtil.$$$reportNull$$$0(53);
            }
            return string2;
        }
        String string3 = Objects.requireNonNull((AbstractVcs)ContainerUtil.getFirstItem((Collection)vcs)).getDisplayName();
        if (string3 == null) {
            VcsLogUtil.$$$reportNull$$$0(54);
        }
        return string3;
    }

    @NotNull
    @Nls
    public static String getVcsDisplayName(@NotNull Project project2, @NotNull VcsLogManager logManager2) {
        if (project2 == null) {
            VcsLogUtil.$$$reportNull$$$0(55);
        }
        if (logManager2 == null) {
            VcsLogUtil.$$$reportNull$$$0(56);
        }
        return VcsLogUtil.getVcsDisplayName(project2, logManager2.getDataManager().getLogProviders().values());
    }

    public static void invokeOnChange(final @NotNull VcsLogUi ui2, final @NotNull Runnable runnable, final @NotNull Condition<? super VcsLogDataPack> condition) {
        if (ui2 == null) {
            VcsLogUtil.$$$reportNull$$$0(57);
        }
        if (runnable == null) {
            VcsLogUtil.$$$reportNull$$$0(58);
        }
        if (condition == null) {
            VcsLogUtil.$$$reportNull$$$0(59);
        }
        ui2.addLogListener(new VcsLogListener(){

            @Override
            public void onChange(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
                if (dataPack == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (condition.value((Object)dataPack)) {
                    runnable.run();
                    ui2.removeLogListener(this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/util/VcsLogUtil$1", "onChange"));
            }
        });
    }

    public static void runWhenVcsAndLogIsReady(@NotNull Project project2, @NotNull Consumer<? super VcsLogManager> action2) {
        VcsLogManager logManager2;
        if (project2 == null) {
            VcsLogUtil.$$$reportNull$$$0(60);
        }
        if (action2 == null) {
            VcsLogUtil.$$$reportNull$$$0(61);
        }
        if ((logManager2 = VcsProjectLog.getInstance(project2).getLogManager()) != null) {
            action2.consume((Object)logManager2);
            return;
        }
        ProjectLevelVcsManager.getInstance(project2).runAfterInitialization(() -> ApplicationManager.getApplication().invokeLater(() -> VcsProjectLog.Companion.runWhenLogIsReady(project2, (Function1<? super VcsLogManager, Unit>)((Function1)manager -> {
            action2.consume(manager);
            return Unit.INSTANCE;
        })), project2.getDisposed()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6, 13, 21, 26, 32, 44, 45, 46, 47, 48, 50, 53, 54 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 1: 
            case 6: 
            case 13: 
            case 21: 
            case 26: 
            case 32: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/util/VcsLogUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 7: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logUi";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 11: 
            case 19: 
            case 29: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterCollection";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logProvider";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashes";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detail";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashString";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 31: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailsList";
                break;
            }
            case 33: 
            case 35: 
            case 51: 
            case 55: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 36: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPack";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logProviders";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logManager";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/util/VcsLogUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "groupRefsByRoot";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRoots";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredFilesForRoot";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetails";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortHash";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "collectChanges";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getSizeText";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvidersMapText";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "groupRefsByRoot";
                break;
            }
            case 1: 
            case 6: 
            case 13: 
            case 21: 
            case 26: 
            case 32: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 53: 
            case 54: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "compareRoots";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectRoots";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleRoots";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAllVisibleRoots";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredFilesForRoot";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSingleFilteredBranch";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isRegexp";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "convertToRevisionNumber";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDetails";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createCommittedChangeList";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getShortHash";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isFullHash";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findBranch";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "collectChanges";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getActualRoot";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedPaths";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getMaxSize";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getSize";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getProvidersMapText";
                break;
            }
            case 51: 
            case 52: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getVcsDisplayName";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "invokeOnChange";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "runWhenVcsAndLogIsReady";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 6, 13, 21, 26, 32, 44, 45, 46, 47, 48, 50, 53, 54 -> new IllegalStateException(string2);
        };
    }
}

