/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.utils;

import com.intellij.markdown.utils.MarkdownToHtmlConverterKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HtmlMarkdownUtils {
    private static final Logger LOG = Logger.getInstance(HtmlMarkdownUtils.class);
    private static final Pattern TAG_START_OR_CLOSE_PATTERN = Pattern.compile("(<)/?(\\w+)[> ]");
    private static final Pattern SPLIT_BY_LINE_PATTERN = Pattern.compile("\n|\r|\r\n");
    private static final String HTML_CODE_START = "<code>";
    private static final String HTML_CODE_END = "</code>";
    private static final String FENCED_CODE_BLOCK = "```";
    private static final String INLINE_CODE_BLOCK = "``";
    private static final Map<String, String> HTML_DOC_SUBSTITUTIONS = new HashMap<String, String>();
    public static final String BR_TAG_AFTER_MARKDOWN_PROCESSING = "<br  />";
    public static final String BR_TAG_OPENING = "&lt;br&gt;";
    public static final String BR_TAG_CLOSING = "&lt;/br&gt;";
    private static final Set<String> ACCEPTABLE_TAGS;

    private HtmlMarkdownUtils() {
    }

    @Contract(pure=true)
    @Nullable
    public static String toHtml(@NotNull String markdownText) {
        if (markdownText == null) {
            HtmlMarkdownUtils.$$$reportNull$$$0(0);
        }
        return HtmlMarkdownUtils.toHtml(markdownText, true);
    }

    @NotNull
    private static String getBorder() {
        String string2 = "margin: 0; border: 1px solid; border-color: #" + ColorUtil.toHex((Color)UIUtil.getTooltipSeparatorColor()) + "; border-spacing: 0; border-collapse: collapse;vertical-align: baseline;";
        if (string2 == null) {
            HtmlMarkdownUtils.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @Contract(pure=true)
    @Nullable
    public static String toHtml(@NotNull String markdownText, boolean convertTagCodeBlocks) {
        if (markdownText == null) {
            HtmlMarkdownUtils.$$$reportNull$$$0(2);
        }
        String[] lines = SPLIT_BY_LINE_PATTERN.split(markdownText);
        ArrayList<Object> processedLines = new ArrayList<Object>(lines.length);
        boolean isInCode = false;
        boolean isInTable = false;
        List<String> tableFormats = null;
        for (int i = 0; i < lines.length; ++i) {
            int count;
            String line = lines[i];
            Object processedLine = StringUtil.trimTrailing((String)line);
            if (((String)processedLine).matches("\\s+```.*")) {
                processedLine = ((String)processedLine).trim();
            }
            if ((count = StringUtil.getOccurrenceCount((String)processedLine, (String)FENCED_CODE_BLOCK)) > 0) {
                isInCode = count % 2 == 0 ? isInCode : !isInCode;
            } else if (convertTagCodeBlocks) {
                if (isInCode) {
                    if (((String)processedLine).startsWith(HTML_CODE_END)) {
                        processedLines.add(FENCED_CODE_BLOCK);
                        processedLine = StringUtil.trimStart((String)processedLine, (String)HTML_CODE_END);
                        isInCode = false;
                    }
                } else {
                    boolean codeStart = false;
                    if (((String)processedLine).endsWith(HTML_CODE_START)) {
                        codeStart = true;
                        processedLine = StringUtil.trimEnd((String)processedLine, (String)HTML_CODE_START);
                    }
                    processedLine = ((String)processedLine).replace("<pre>", FENCED_CODE_BLOCK).replace("</pre>", FENCED_CODE_BLOCK).replace(HTML_CODE_START, INLINE_CODE_BLOCK).replace(HTML_CODE_END, INLINE_CODE_BLOCK);
                    if (codeStart) {
                        processedLines.add(processedLine);
                        processedLine = FENCED_CODE_BLOCK;
                        isInCode = true;
                    }
                }
            } else {
                int tableDelimiterIndex = ((String)processedLine).indexOf(124);
                if (tableDelimiterIndex != -1) {
                    if (!isInTable && i + 1 < lines.length) {
                        tableFormats = HtmlMarkdownUtils.parseTableFormats(HtmlMarkdownUtils.splitTableCols(lines[i + 1]));
                    }
                    if (!ContainerUtil.isEmpty(tableFormats)) {
                        List<String> parts = HtmlMarkdownUtils.splitTableCols((String)processedLine);
                        if (HtmlMarkdownUtils.isTableHeaderSeparator(parts)) continue;
                        processedLine = HtmlMarkdownUtils.getProcessedRow(isInTable, parts, tableFormats);
                        if (!isInTable) {
                            processedLine = "<table style=\"border: 0px;\" cellspacing=\"0\">" + (String)processedLine;
                        }
                        isInTable = true;
                    }
                } else {
                    if (isInTable) {
                        processedLine = (String)processedLine + "</table>";
                    }
                    isInTable = false;
                    tableFormats = null;
                }
                List<TextRange> ranges = HtmlMarkdownUtils.getInlineCodeBlocks((String)processedLine);
                processedLine = isInCode ? processedLine : HtmlMarkdownUtils.replaceProhibitedTags(StringUtil.trimLeading((String)processedLine), ranges);
            }
            processedLines.add(processedLine);
        }
        Object normalizedMarkdown = StringUtil.join(processedLines, (String)"\n");
        if (isInTable) {
            normalizedMarkdown = (String)normalizedMarkdown + "</table>";
        }
        String html = HtmlMarkdownUtils.convert((String)normalizedMarkdown);
        return HtmlMarkdownUtils.adjustHtml(html);
    }

    @Nullable
    private static List<String> parseTableFormats(@NotNull List<String> cols) {
        if (cols == null) {
            HtmlMarkdownUtils.$$$reportNull$$$0(3);
        }
        ArrayList<String> formats = new ArrayList<String>();
        for (String col : cols) {
            if (!HtmlMarkdownUtils.isHeaderSeparator(col)) {
                return null;
            }
            formats.add(HtmlMarkdownUtils.parseFormat(col.trim()));
        }
        return formats;
    }

    private static boolean isTableHeaderSeparator(@NotNull List<String> parts) {
        if (parts == null) {
            HtmlMarkdownUtils.$$$reportNull$$$0(4);
        }
        return parts.stream().allMatch(HtmlMarkdownUtils::isHeaderSeparator);
    }

    private static boolean isHeaderSeparator(@NotNull String s) {
        if (s == null) {
            HtmlMarkdownUtils.$$$reportNull$$$0(5);
        }
        return StringUtil.trimEnd((String)StringUtil.trimStart((String)s.trim(), (String)":"), (String)":").chars().allMatch(sx -> sx == 45);
    }

    @NotNull
    private static List<String> splitTableCols(@NotNull String processedLine) {
        ArrayList<String> parts;
        if (processedLine == null) {
            HtmlMarkdownUtils.$$$reportNull$$$0(6);
        }
        if ((parts = new ArrayList<String>(StringUtil.split((String)processedLine, (String)"|"))).isEmpty()) {
            ArrayList<String> arrayList = parts;
            if (arrayList == null) {
                HtmlMarkdownUtils.$$$reportNull$$$0(7);
            }
            return arrayList;
        }
        if (StringUtil.isEmptyOrSpaces((String)((String)parts.get(0)))) {
            parts.remove(0);
        }
        if (!parts.isEmpty() && StringUtil.isEmptyOrSpaces((String)((String)parts.get(parts.size() - 1)))) {
            parts.remove(parts.size() - 1);
        }
        ArrayList<String> arrayList = parts;
        if (arrayList == null) {
            HtmlMarkdownUtils.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    private static String getProcessedRow(boolean isInTable, @NotNull List<String> parts, @Nullable List<String> tableFormats) {
        if (parts == null) {
            HtmlMarkdownUtils.$$$reportNull$$$0(9);
        }
        String openingTagStart = isInTable ? "<td style=\"" + HtmlMarkdownUtils.getBorder() + "\" " : "<th style=\"" + HtmlMarkdownUtils.getBorder() + "\" ";
        String closingTag = isInTable ? "</td>" : "</th>";
        StringBuilder resultBuilder = new StringBuilder("<tr style=\"" + HtmlMarkdownUtils.getBorder() + "\">" + openingTagStart);
        resultBuilder.append("align=\"").append(HtmlMarkdownUtils.getAlign(0, tableFormats)).append("\">");
        for (int i = 0; i < parts.size(); ++i) {
            if (i > 0) {
                resultBuilder.append(closingTag).append(openingTagStart).append("align=\"").append(HtmlMarkdownUtils.getAlign(i, tableFormats)).append("\">");
            }
            resultBuilder.append(HtmlMarkdownUtils.convert(parts.get(i).trim()));
        }
        resultBuilder.append(closingTag).append("</tr>");
        String string2 = resultBuilder.toString();
        if (string2 == null) {
            HtmlMarkdownUtils.$$$reportNull$$$0(10);
        }
        return string2;
    }

    @NotNull
    private static String getAlign(int index, @Nullable List<String> formats) {
        String string2 = formats == null || index >= formats.size() ? "left" : formats.get(index);
        if (string2 == null) {
            HtmlMarkdownUtils.$$$reportNull$$$0(11);
        }
        return string2;
    }

    @NotNull
    private static String parseFormat(@NotNull String format) {
        if (format == null) {
            HtmlMarkdownUtils.$$$reportNull$$$0(12);
        }
        if (format.length() <= 1) {
            return "left";
        }
        char c0 = format.charAt(0);
        char cE = format.charAt(format.length() - 1);
        return c0 == ':' && cE == ':' ? "center" : (cE == ':' ? "right" : "left");
    }

    @NotNull
    private static List<TextRange> getInlineCodeBlocks(@NotNull String processingLine) {
        int startQuote;
        if (processingLine == null) {
            HtmlMarkdownUtils.$$$reportNull$$$0(13);
        }
        int next = 0;
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        int length = processingLine.length();
        while (next >= 0 && next < length && (startQuote = processingLine.indexOf(96, next)) >= 0 && length > startQuote + 1) {
            int endQuote;
            int offset;
            char nextChar = processingLine.charAt(startQuote + 1);
            int n = offset = nextChar == '`' ? 2 : 1;
            if (length <= startQuote + offset || (endQuote = processingLine.indexOf(96, startQuote + offset)) <= 0) break;
            ranges.add(new TextRange(startQuote, endQuote));
            next = endQuote + offset;
        }
        ArrayList<TextRange> arrayList = ranges;
        if (arrayList == null) {
            HtmlMarkdownUtils.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @Nullable
    @NlsSafe
    private static String convert(@NotNull @Nls String text2) {
        if (text2 == null) {
            HtmlMarkdownUtils.$$$reportNull$$$0(15);
        }
        try {
            return MarkdownToHtmlConverterKt.convertMarkdownToHtml(text2);
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @NotNull
    public static String replaceProhibitedTags(@NotNull String line) {
        if (line == null) {
            HtmlMarkdownUtils.$$$reportNull$$$0(16);
        }
        return HtmlMarkdownUtils.replaceProhibitedTags(line, ContainerUtil.emptyList());
    }

    @NotNull
    private static String replaceProhibitedTags(@NotNull String line, @NotNull List<TextRange> skipRanges) {
        if (line == null) {
            HtmlMarkdownUtils.$$$reportNull$$$0(17);
        }
        if (skipRanges == null) {
            HtmlMarkdownUtils.$$$reportNull$$$0(18);
        }
        Matcher matcher = TAG_START_OR_CLOSE_PATTERN.matcher(line);
        StringBuilder builder2 = new StringBuilder(line);
        int diff = 0;
        block0: while (matcher.find()) {
            String tagName = matcher.group(2);
            if (ACCEPTABLE_TAGS.contains(StringUtil.toLowerCase((String)tagName))) continue;
            int startOfTag = matcher.start(2);
            for (TextRange range : skipRanges) {
                if (!range.contains(startOfTag)) continue;
                continue block0;
            }
            int start2 = matcher.start(1) + diff;
            if (StringUtil.toLowerCase((String)tagName).equals("div")) {
                boolean isOpenTag = !matcher.group(0).contains("/");
                int end = start2 + (isOpenTag ? 5 : 6);
                String replacement = isOpenTag ? "<span>" : "</span>";
                builder2.replace(start2, end, replacement);
                ++diff;
                continue;
            }
            builder2.replace(start2, start2 + 1, "&lt;");
            diff += 3;
        }
        String string2 = builder2.toString();
        if (string2 == null) {
            HtmlMarkdownUtils.$$$reportNull$$$0(19);
        }
        return string2;
    }

    @Contract(pure=true)
    @Nullable
    public static String adjustHtml(@Nullable String html) {
        if (html == null) {
            return null;
        }
        String str = html;
        for (Map.Entry<String, String> entry2 : HTML_DOC_SUBSTITUTIONS.entrySet()) {
            str = str.replace(entry2.getKey(), entry2.getValue());
        }
        str = str.replace(BR_TAG_AFTER_MARKDOWN_PROCESSING, "");
        return str.trim();
    }

    static {
        HTML_DOC_SUBSTITUTIONS.put("<pre><code>", "<pre>");
        HTML_DOC_SUBSTITUTIONS.put("</code></pre>", "</pre>");
        HTML_DOC_SUBSTITUTIONS.put("<em>", "<i>");
        HTML_DOC_SUBSTITUTIONS.put("</em>", "</i>");
        HTML_DOC_SUBSTITUTIONS.put("<strong>", "<b>");
        HTML_DOC_SUBSTITUTIONS.put("</strong>", "</b>");
        HTML_DOC_SUBSTITUTIONS.put(": //", "://");
        ACCEPTABLE_TAGS = Set.of("span", "img", "p", "i", "code", "ul", "h1", "h2", "h3", "h4", "h5", "h6", "li", "blockquote", "ol", "b", "a", "tt", "pre", "tr", "th", "td", "table", "strong", "em", "u", "dl", "dd", "dt");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7, 8, 10, 11, 14, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markdownText";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webSymbols/utils/HtmlMarkdownUtils";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cols";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processedLine";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingLine";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webSymbols/utils/HtmlMarkdownUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBorder";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "splitTableCols";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessedRow";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlign";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlineCodeBlocks";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceProhibitedTags";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toHtml";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 19: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseTableFormats";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isTableHeaderSeparator";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isHeaderSeparator";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "splitTableCols";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getProcessedRow";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseFormat";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getInlineCodeBlocks";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "replaceProhibitedTags";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 7, 8, 10, 11, 14, 19 -> new IllegalStateException(string2);
        };
    }
}

