/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.extension;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import java.net.URL;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JsonSchemaProviderFactory {
    public static final ExtensionPointName<JsonSchemaProviderFactory> EP_NAME = ExtensionPointName.create((String)"JavaScript.JsonSchema.ProviderFactory");
    public static final Logger LOG = Logger.getInstance(JsonSchemaProviderFactory.class);

    @NotNull
    public List<JsonSchemaFileProvider> getProviders(@NotNull Project var1);

    @Nullable
    public static VirtualFile getResourceFile(@NotNull Class<?> baseClass, @NonNls @NotNull String resourcePath) {
        URL url;
        if (baseClass == null) {
            JsonSchemaProviderFactory.$$$reportNull$$$0(0);
        }
        if (resourcePath == null) {
            JsonSchemaProviderFactory.$$$reportNull$$$0(1);
        }
        if ((url = baseClass.getResource(resourcePath)) == null) {
            LOG.error("Cannot find resource " + resourcePath);
            return null;
        }
        VirtualFile file = VfsUtil.findFileByURL((URL)url);
        if (file != null) {
            return file;
        }
        LOG.info("File not found by " + url + ", performing refresh...");
        ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> {
            VirtualFile refreshed = (VirtualFile)WriteAction.compute(() -> VirtualFileManager.getInstance().refreshAndFindFileByUrl(VfsUtilCore.convertFromUrl((URL)url)));
            if (refreshed != null) {
                LOG.info("Refreshed " + url + " successfully");
                for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
                    JsonSchemaService service = (JsonSchemaService)project2.getService(JsonSchemaService.class);
                    service.reset();
                }
            } else {
                LOG.error("Cannot refresh and find file by " + resourcePath);
            }
        });
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "baseClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "resourcePath";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/jsonSchema/extension/JsonSchemaProviderFactory";
        objectArray[2] = "getResourceFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

