/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd;

import com.thaiopensource.datatype.xsd.BinaryDatatype;
import org.relaxng.datatype.ValidationContext;

class Base64BinaryDatatype
extends BinaryDatatype {
    private static final byte[] weightTable = Base64BinaryDatatype.makeWeightTable();
    private static final byte INVALID = -1;
    private static final byte WHITESPACE = -2;
    private static final byte PADDING = -3;

    Base64BinaryDatatype() {
    }

    boolean lexicallyAllows(String string2) {
        return Base64BinaryDatatype.byteCount(string2) >= 0;
    }

    private static int byteCount(String string2) {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        int n5 = string2.length();
        while (n4 < n5) {
            char c = string2.charAt(n4);
            if (c >= '\u0080') {
                return -1;
            }
            int n6 = weightTable[c];
            switch (n6) {
                case -2: {
                    break;
                }
                case -3: {
                    if (++n2 <= 2) break;
                    return -1;
                }
                case -1: {
                    return -1;
                }
                default: {
                    if (n2 > 0) {
                        return -1;
                    }
                    n3 = n6;
                    ++n;
                }
            }
            ++n4;
        }
        if ((n + n2 & 3) != 0) {
            return -1;
        }
        switch (n2) {
            case 1: {
                if ((n3 & 3) == 0) break;
                return -1;
            }
            case 2: {
                if ((n3 & 0xF) == 0) break;
                return -1;
            }
        }
        return (n + n2 >> 2) * 3 - n2;
    }

    Object getValue(String string2, ValidationContext validationContext) {
        int n = Base64BinaryDatatype.byteCount(string2);
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = string2.length();
        while (n5 < n6) {
            byte by = weightTable[string2.charAt(n5)];
            if (by != -2) {
                n4 <<= 6;
                if (by != -3) {
                    n4 |= by;
                }
                if (++n3 == 4) {
                    int n7 = 16;
                    while (n7 >= 0) {
                        if (n2 < n) {
                            byArray[n2++] = (byte)(n4 >> n7 & 0xFF);
                        }
                        n7 -= 8;
                    }
                    n3 = 0;
                    n4 = 0;
                }
            }
            ++n5;
        }
        return byArray;
    }

    private static byte[] makeWeightTable() {
        byte[] byArray = new byte[128];
        int n = -1;
        int n2 = 0;
        while (n2 < 128) {
            byArray[n2] = n;
            ++n2;
        }
        n = 0;
        int n3 = 65;
        while (n3 <= 90) {
            byArray[n3] = n;
            ++n3;
            n = (byte)(n + 1);
        }
        int n4 = 97;
        while (n4 <= 122) {
            byArray[n4] = n;
            ++n4;
            n = (byte)(n + 1);
        }
        int n5 = 48;
        while (n5 <= 57) {
            byArray[n5] = n;
            ++n5;
            n = (byte)(n + 1);
        }
        int n6 = n;
        n = (byte)(n + 1);
        byArray[43] = n6;
        int n7 = n;
        n = (byte)(n + 1);
        byArray[47] = n7;
        byArray[10] = -2;
        byArray[13] = -2;
        byArray[9] = -2;
        byArray[32] = -2;
        byArray[61] = -3;
        return byArray;
    }
}

