/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.common;

import com.thaiopensource.util.Utf16;
import com.thaiopensource.xml.out.CharRepertoire;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.Writer;
import java.util.Stack;

public class XmlWriter {
    private final String lineSep;
    private final String indentString;
    private final Writer w;
    private final CharRepertoire cr;
    private final Stack tagStack = new Stack();
    private boolean inStartTag = false;
    private boolean inText = false;
    private int level = 0;
    private final String[] topLevelAttributes;

    public XmlWriter(Writer writer, String string2, CharRepertoire charRepertoire, String string3, int n, String[] stringArray) {
        this.w = writer;
        this.lineSep = string3;
        this.cr = charRepertoire;
        this.topLevelAttributes = stringArray;
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = 32;
            ++n2;
        }
        this.indentString = new String(cArray);
        this.write("<?xml version=\"1.0\" encoding=\"");
        this.write(string2);
        this.write("\"?>");
        this.newline();
    }

    public void startElement(String string2) {
        if (this.inStartTag) {
            this.maybeWriteTopLevelAttributes();
            this.inStartTag = false;
            this.write(">");
            this.newline();
        }
        if (this.inText) {
            this.inText = false;
        } else {
            this.indent();
        }
        this.write('<');
        this.write(string2);
        this.tagStack.push(string2);
        this.inStartTag = true;
        ++this.level;
    }

    public void endElement() {
        if (this.inStartTag) {
            this.maybeWriteTopLevelAttributes();
            --this.level;
            this.inStartTag = false;
            this.tagStack.pop();
            this.write("/>");
        } else {
            --this.level;
            if (this.inText) {
                this.inText = false;
            } else {
                this.indent();
            }
            this.write("</");
            this.write((String)this.tagStack.pop());
            this.write(">");
        }
        this.newline();
    }

    public void attribute(String string2, String string3) {
        if (!this.inStartTag) {
            throw new IllegalStateException("attribute outside of start-tag");
        }
        this.write(' ');
        this.write(string2);
        this.write('=');
        this.write('\"');
        this.data(string3);
        this.write('\"');
    }

    public void text(String string2) {
        if (string2.length() == 0) {
            return;
        }
        if (this.inStartTag) {
            this.maybeWriteTopLevelAttributes();
            this.inStartTag = false;
            this.write(">");
        }
        this.data(string2);
        this.inText = true;
    }

    public void comment(String string2) {
        if (this.inStartTag) {
            this.maybeWriteTopLevelAttributes();
            this.inStartTag = false;
            this.write(">");
            this.newline();
        }
        if (!this.inText) {
            this.indent();
        }
        this.write("<!--");
        int n = 0;
        ++this.level;
        while (true) {
            int n2;
            if ((n2 = string2.indexOf(10, n)) < 0) {
                if (n > 0) {
                    this.newline();
                    this.indent();
                    this.write(string2.substring(n));
                    --this.level;
                    this.newline();
                    this.indent();
                    break;
                }
                --this.level;
                if (string2.length() == 0) break;
                this.write(' ');
                this.write(string2);
                if (string2.charAt(string2.length() - 1) == ' ') break;
                this.write(' ');
                break;
            }
            this.newline();
            this.indent();
            this.write(string2.substring(n, n2));
            n = n2 + 1;
        }
        this.write("-->");
        if (!this.inText) {
            this.newline();
        }
    }

    private void data(String string2) {
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            switch (c) {
                case '<': {
                    this.write("&lt;");
                    break;
                }
                case '>': {
                    this.write("&gt;");
                    break;
                }
                case '&': {
                    this.write("&amp;");
                    break;
                }
                case '\r': {
                    this.write("&#xD;");
                    break;
                }
                case '\n': {
                    this.write(this.lineSep);
                    break;
                }
                default: {
                    if (Utf16.isSurrogate(c)) {
                        char c2;
                        if (!Utf16.isSurrogate1(c) || n2 + 1 == n || !Utf16.isSurrogate2(string2.charAt(n2 + 1))) {
                            throw new WrappedException(new CharConversionException("surrogate pair integrity failure"));
                        }
                        if (this.cr.contains(c, c2 = string2.charAt(++n2))) {
                            this.write(c);
                            this.write(c2);
                            break;
                        }
                        this.charRef(Utf16.scalarValue(c, c2));
                        break;
                    }
                    if (!this.cr.contains(c)) {
                        this.charRef(c);
                        break;
                    }
                    this.write(c);
                }
            }
            ++n2;
        }
    }

    private void charRef(int n) {
        this.write("&#x");
        this.write(Integer.toHexString(n));
        this.write(';');
    }

    private void indent() {
        int n = 0;
        while (n < this.level) {
            this.write(this.indentString);
            ++n;
        }
    }

    private void newline() {
        this.write(this.lineSep);
    }

    private void maybeWriteTopLevelAttributes() {
        if (this.level != 1) {
            return;
        }
        int n = 0;
        while (n < this.topLevelAttributes.length) {
            this.attribute(this.topLevelAttributes[n], this.topLevelAttributes[n + 1]);
            n += 2;
        }
    }

    private void write(String string2) {
        try {
            this.w.write(string2);
        }
        catch (IOException iOException) {
            throw new WrappedException(iOException);
        }
    }

    private void write(char c) {
        try {
            this.w.write(c);
        }
        catch (IOException iOException) {
            throw new WrappedException(iOException);
        }
    }

    public void close() {
        try {
            this.w.close();
        }
        catch (IOException iOException) {
            throw new WrappedException(iOException);
        }
    }

    public static class WrappedException
    extends RuntimeException {
        private final IOException cause;

        public Throwable getCause() {
            return this.cause;
        }

        public IOException getIOException() {
            return this.cause;
        }

        private WrappedException(IOException iOException) {
            this.cause = iOException;
        }
    }
}

