/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.parse.compact;

import com.thaiopensource.relaxng.parse.BuildException;
import com.thaiopensource.relaxng.parse.IllegalSchemaException;
import com.thaiopensource.relaxng.parse.IncludedGrammar;
import com.thaiopensource.relaxng.parse.Parseable;
import com.thaiopensource.relaxng.parse.ParsedPattern;
import com.thaiopensource.relaxng.parse.SchemaBuilder;
import com.thaiopensource.relaxng.parse.Scope;
import com.thaiopensource.relaxng.parse.compact.CompactSyntax;
import com.thaiopensource.xml.util.EncodingMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.net.URL;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class CompactParseable
implements Parseable {
    private final InputSource in;
    private final ErrorHandler eh;
    private static final String UTF8 = EncodingMap.getJavaName("UTF-8");
    private static final String UTF16 = EncodingMap.getJavaName("UTF-16");

    public CompactParseable(InputSource inputSource, ErrorHandler errorHandler2) {
        this.in = inputSource;
        this.eh = errorHandler2;
    }

    public ParsedPattern parse(SchemaBuilder schemaBuilder, Scope scope2) throws BuildException, IllegalSchemaException {
        return new CompactSyntax(CompactParseable.makeReader(this.in), this.in.getSystemId(), schemaBuilder, this.eh).parse(scope2);
    }

    public ParsedPattern parseInclude(String string2, SchemaBuilder schemaBuilder, IncludedGrammar includedGrammar) throws BuildException, IllegalSchemaException {
        InputSource inputSource = new InputSource(string2);
        inputSource.setEncoding(this.in.getEncoding());
        return new CompactSyntax(CompactParseable.makeReader(inputSource), string2, schemaBuilder, this.eh).parseInclude(includedGrammar);
    }

    public ParsedPattern parseExternal(String string2, SchemaBuilder schemaBuilder, Scope scope2) throws BuildException, IllegalSchemaException {
        InputSource inputSource = new InputSource(string2);
        inputSource.setEncoding(this.in.getEncoding());
        return new CompactSyntax(CompactParseable.makeReader(inputSource), string2, schemaBuilder, this.eh).parse(scope2);
    }

    private static Reader makeReader(InputSource inputSource) throws BuildException {
        try {
            Reader reader = inputSource.getCharacterStream();
            if (reader == null) {
                String string2;
                InputStream inputStream = inputSource.getByteStream();
                if (inputStream == null) {
                    string2 = inputSource.getSystemId();
                    inputStream = new URL(string2).openStream();
                }
                if ((string2 = inputSource.getEncoding()) == null) {
                    PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 2);
                    string2 = CompactParseable.detectEncoding(pushbackInputStream);
                    inputStream = pushbackInputStream;
                }
                reader = new InputStreamReader(inputStream, string2);
            }
            return reader;
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
    }

    private static String detectEncoding(PushbackInputStream pushbackInputStream) throws IOException {
        String string2 = UTF8;
        int n = pushbackInputStream.read();
        if (n != -1) {
            int n2 = pushbackInputStream.read();
            if (n2 != -1) {
                pushbackInputStream.unread(n2);
                if (n == 255 && n2 == 254 || n == 254 && n2 == 255) {
                    string2 = UTF16;
                }
            }
            pushbackInputStream.unread(n);
        }
        return string2;
    }
}

