/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.lang.ASTNode;
import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.RegExpLanguageHosts;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpProperty;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public final class RegExpDocumentationProvider
extends AbstractDocumentationProvider {
    @Nullable
    @Nls
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        String description2;
        RegExpProperty prop;
        ASTNode node;
        if (element instanceof RegExpProperty && (node = (prop = (RegExpProperty)element).getCategoryNode()) != null && (description2 = RegExpLanguageHosts.getInstance().getPropertyDescription(node.getPsi(), node.getText())) != null) {
            if (prop.isNegated()) {
                return RegExpBundle.message("doc.property.block.stands.for.characters.not.matching.0", description2);
            }
            return RegExpBundle.message("doc.property.block.stands.for.0", description2);
        }
        return null;
    }

    @Nullable
    @Nls
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        if (element instanceof RegExpGroup) {
            RegExpGroup group2 = (RegExpGroup)element;
            return StringUtil.escapeXmlEntities((String)group2.getUnescapedText());
        }
        return null;
    }
}

