/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.inspection.RegExpReplacementUtil;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OctalEscapeInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            OctalEscapeInspection.$$$reportNull$$$0(0);
        }
        return new OctalEscapeVisitor(holder);
    }

    static String buildReplacementText(RegExpChar aChar) {
        int value2 = aChar.getValue();
        String hex = Integer.toHexString(value2);
        return (hex.length() == 1 ? "\\x0" : "\\x") + hex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/inspection/OctalEscapeInspection", "buildVisitor"));
    }

    private static class OctalEscapeVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        OctalEscapeVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpChar(RegExpChar ch) {
            if (ch.getType() != RegExpChar.Type.OCT) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)ch, RegExpBundle.message("inspection.warning.octal.escape.code.ref.code.in.regexp", new Object[0]), new LocalQuickFix[]{new ReplaceWithHexEscapeFix(OctalEscapeInspection.buildReplacementText(ch))});
        }
    }

    private static class ReplaceWithHexEscapeFix
    implements LocalQuickFix {
        private final String myHex;

        ReplaceWithHexEscapeFix(String hex) {
            this.myHex = hex;
        }

        @Nls
        @NotNull
        public String getName() {
            String string2 = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myHex});
            if (string2 == null) {
                ReplaceWithHexEscapeFix.$$$reportNull$$$0(0);
            }
            return string2;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string2 = RegExpBundle.message("inspection.quick.fix.replace.with.hexadecimal.escape", new Object[0]);
            if (string2 == null) {
                ReplaceWithHexEscapeFix.$$$reportNull$$$0(1);
            }
            return string2;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project2 == null) {
                ReplaceWithHexEscapeFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                ReplaceWithHexEscapeFix.$$$reportNull$$$0(3);
            }
            if (!((element = descriptor.getPsiElement()) instanceof RegExpChar)) {
                return;
            }
            RegExpReplacementUtil.replaceInContext(element, OctalEscapeInspection.buildReplacementText((RegExpChar)element));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/lang/regexp/inspection/OctalEscapeInspection$ReplaceWithHexEscapeFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/lang/regexp/inspection/OctalEscapeInspection$ReplaceWithHexEscapeFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 2, 3 -> new IllegalArgumentException(string2);
            };
        }
    }
}

