/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EmptyRunProfileState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.PortField;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipEmptySerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.xdebugger.XDebuggerBundle;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.DebuggableRunConfiguration;

public abstract class RemoteDebugConfiguration
extends LocatableConfigurationBase
implements RunConfigurationWithSuppressedDefaultRunAction,
DebuggableRunConfiguration {
    private final SerializationFilter serializationFilter;
    private String host;
    private int port;
    private final int defaultPort;

    public RemoteDebugConfiguration(Project project2, @NotNull ConfigurationFactory factory, String name, int defaultPort) {
        if (factory == null) {
            RemoteDebugConfiguration.$$$reportNull$$$0(0);
        }
        super(project2, factory, name);
        this.serializationFilter = new SkipEmptySerializationFilter(){

            protected ThreeState accepts(@NotNull String name, @NotNull Object beanValue) {
                if (name == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (beanValue == null) {
                    1.$$$reportNull$$$0(1);
                }
                return name.equals("port") ? ThreeState.fromBoolean((!beanValue.equals(RemoteDebugConfiguration.this.defaultPort) ? 1 : 0) != 0) : ThreeState.UNSURE;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "beanValue";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/debugger/RemoteDebugConfiguration$1";
                objectArray[2] = "accepts";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.port = defaultPort;
        this.defaultPort = defaultPort;
    }

    @Attribute
    @Nullable
    public String getHost() {
        return this.host;
    }

    public void setHost(@Nullable String value2) {
        this.host = StringUtil.isEmpty((String)value2) || value2.equals("localhost") || value2.equals("127.0.0.1") ? null : value2;
    }

    @Attribute
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new RemoteDebugConfigurationSettingsEditor();
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        if (executor == null) {
            RemoteDebugConfiguration.$$$reportNull$$$0(1);
        }
        if (env == null) {
            RemoteDebugConfiguration.$$$reportNull$$$0(2);
        }
        return EmptyRunProfileState.INSTANCE;
    }

    public RunConfiguration clone() {
        RemoteDebugConfiguration configuration = (RemoteDebugConfiguration)super.clone();
        configuration.host = this.host;
        configuration.port = this.port;
        return configuration;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            RemoteDebugConfiguration.$$$reportNull$$$0(3);
        }
        super.readExternal(element);
        XmlSerializer.deserializeInto((Object)this, (Element)element);
        if (this.port <= 0) {
            this.port = this.defaultPort;
        }
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            RemoteDebugConfiguration.$$$reportNull$$$0(4);
        }
        super.writeExternal(element);
        XmlSerializer.serializeInto((Object)this, (Element)element, (SerializationFilter)this.serializationFilter);
    }

    @Override
    @NotNull
    public InetSocketAddress computeDebugAddress(RunProfileState state) {
        if (this.host == null) {
            return new InetSocketAddress(InetAddress.getLoopbackAddress(), this.port);
        }
        return new InetSocketAddress(this.host, this.getPort());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/debugger/RemoteDebugConfiguration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class RemoteDebugConfigurationSettingsEditor
    extends SettingsEditor<RemoteDebugConfiguration> {
        private final JTextField hostField = GuiUtils.createUndoableTextField();
        private final PortField portField;

        RemoteDebugConfigurationSettingsEditor() {
            this.portField = new PortField(RemoteDebugConfiguration.this.defaultPort, 1024);
        }

        protected void resetEditorFrom(@NotNull RemoteDebugConfiguration configuration) {
            if (configuration == null) {
                RemoteDebugConfigurationSettingsEditor.$$$reportNull$$$0(0);
            }
            this.hostField.setText(StringUtil.notNullize((String)configuration.host, (String)"localhost"));
            this.portField.setNumber(configuration.port);
        }

        protected void applyEditorTo(@NotNull RemoteDebugConfiguration configuration) {
            if (configuration == null) {
                RemoteDebugConfigurationSettingsEditor.$$$reportNull$$$0(1);
            }
            configuration.setHost(this.hostField.getText());
            configuration.setPort(this.portField.getNumber());
        }

        @NotNull
        protected JComponent createEditor() {
            JPanel jPanel = FormBuilder.createFormBuilder().addLabeledComponent(XDebuggerBundle.message((String)"label.host", (Object[])new Object[0]), (JComponent)this.hostField).addLabeledComponent(XDebuggerBundle.message((String)"label.port", (Object[])new Object[0]), (JComponent)this.portField).getPanel();
            if (jPanel == null) {
                RemoteDebugConfigurationSettingsEditor.$$$reportNull$$$0(2);
            }
            return jPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/debugger/RemoteDebugConfiguration$RemoteDebugConfigurationSettingsEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/debugger/RemoteDebugConfiguration$RemoteDebugConfigurationSettingsEditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resetEditorFrom";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "applyEditorTo";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }
}

