/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.filter.Filter;
import com.android.tools.adtui.model.filter.FilterModel;
import com.android.tools.adtui.stdui.CommonToggleButton;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.SearchTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import java.util.concurrent.CountDownLatch;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class FilterComponent
extends JPanel {
    static final String OPEN_AND_FOCUS_ACTION = "OpenAndFocusSearchAction";
    static final String CLOSE_ACTION = "CloseSearchAction";
    static final KeyStroke FILTER_KEY_STROKE = KeyStroke.getKeyStroke(70, AdtUiUtils.getActionMask());
    static final JBColor NO_MATCHES_COLOR = new JBColor(new Color(-13108), new Color(-9160134));
    private static final String REGEX = "Regex";
    private static final String MATCH_CASE = "Match Case";
    private final FilterModel myModel;
    private JCheckBox myRegexCheckBox;
    private JCheckBox myMatchCaseCheckBox;
    private JLabel myCountLabel;
    private final SearchTextField mySearchField;
    private final Timer myTimer;
    private final Color mySearchFieldDefaultBackground;
    private CountDownLatch myTimerRunningLatch;

    public FilterComponent(@NotNull Filter filter, int textFieldWidth, int historySize, int delayMs) {
        if (filter == null) {
            FilterComponent.$$$reportNull$$$0(0);
        }
        super(new TabularLayout("4px," + textFieldWidth + "px,5px,Fit-,5px,Fit-,20px,Fit-", "Fit-"));
        this.myTimerRunningLatch = new CountDownLatch(0);
        this.myModel = new FilterModel();
        this.myModel.setFilter(filter);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                super.componentShown(e);
                FilterComponent.this.requestFocusInWindow();
            }
        });
        this.mySearchField = new SearchTextField(){

            protected Runnable createItemChosenCallback(JList list) {
                Runnable callback = super.createItemChosenCallback(list);
                return () -> {
                    callback.run();
                    FilterComponent.this.updateModel();
                };
            }

            protected Component getPopupLocationComponent() {
                return FilterComponent.this.mySearchField;
            }

            protected void onFocusLost() {
                this.addCurrentTextToHistory();
                super.onFocusLost();
            }
        };
        if (!filter.isEmpty()) {
            this.mySearchField.setText(filter.getFilterString());
        }
        this.mySearchField.getTextEditor().addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                e.consume();
                if (e.getKeyCode() == 10) {
                    FilterComponent.this.mySearchField.addCurrentTextToHistory();
                    FilterComponent.this.updateModel();
                }
            }
        });
        this.myTimer = new Timer(delayMs, e -> {
            this.updateModel();
            this.myTimerRunningLatch.countDown();
        });
        this.myTimer.setRepeats(false);
        this.mySearchField.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.onChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.onChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.onChanged();
            }

            private void onChanged() {
                FilterComponent.this.myTimerRunningLatch = new CountDownLatch(1);
                FilterComponent.this.myTimer.restart();
            }
        });
        this.mySearchField.setHistorySize(historySize);
        this.add((Component)this.mySearchField, new TabularLayout.Constraint(0, 1));
        this.mySearchFieldDefaultBackground = this.mySearchField.getTextEditor().getBackground();
        this.myMatchCaseCheckBox = new JCheckBox(MATCH_CASE, filter.isMatchCase());
        this.myMatchCaseCheckBox.setMnemonic(67);
        this.myMatchCaseCheckBox.setDisplayedMnemonicIndex(MATCH_CASE.indexOf(67));
        this.myMatchCaseCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FilterComponent.this.updateModel();
            }
        });
        this.add((Component)this.myMatchCaseCheckBox, new TabularLayout.Constraint(0, 3));
        this.myRegexCheckBox = new JCheckBox(REGEX, filter.isRegex());
        this.myRegexCheckBox.setMnemonic(71);
        this.myRegexCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FilterComponent.this.updateModel();
            }
        });
        this.add((Component)this.myRegexCheckBox, new TabularLayout.Constraint(0, 5));
        this.myCountLabel = new JLabel();
        this.myCountLabel.setFont(this.myCountLabel.getFont().deriveFont(1));
        this.add((Component)this.myCountLabel, new TabularLayout.Constraint(0, 7));
        this.myModel.addMatchResultListener(result -> {
            Color background = this.mySearchFieldDefaultBackground;
            Object text = "";
            if (result.isFilterEnabled()) {
                int count = result.getMatchCount();
                if (count == 0) {
                    text = "No matches";
                    background = NO_MATCHES_COLOR;
                } else {
                    text = count == 1 ? "One match" : new DecimalFormat("#,###").format(count) + " matches";
                }
            }
            this.mySearchField.getTextEditor().setBackground(background);
            this.myCountLabel.setText((String)text);
        });
    }

    public FilterComponent(int textFieldWidth, int historySize, int delayMs) {
        this(Filter.EMPTY_FILTER, textFieldWidth, historySize, delayMs);
    }

    public void setFilterText(String filterText) {
        this.mySearchField.setText(filterText);
    }

    @NotNull
    public FilterModel getModel() {
        FilterModel filterModel = this.myModel;
        if (filterModel == null) {
            FilterComponent.$$$reportNull$$$0(1);
        }
        return filterModel;
    }

    @NotNull
    public FilterComponent setMatchCountVisibility(boolean value) {
        this.myCountLabel.setVisible(value);
        FilterComponent filterComponent = this;
        if (filterComponent == null) {
            FilterComponent.$$$reportNull$$$0(2);
        }
        return filterComponent;
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.mySearchField.requestFocusInWindow();
    }

    @VisibleForTesting
    @NotNull
    public SearchTextField getSearchField() {
        SearchTextField searchTextField = this.mySearchField;
        if (searchTextField == null) {
            FilterComponent.$$$reportNull$$$0(3);
        }
        return searchTextField;
    }

    @VisibleForTesting
    @NotNull
    public JLabel getCountLabel() {
        JLabel jLabel = this.myCountLabel;
        if (jLabel == null) {
            FilterComponent.$$$reportNull$$$0(4);
        }
        return jLabel;
    }

    @TestOnly
    public void waitForFilterUpdated() throws InterruptedException {
        this.myTimerRunningLatch.await();
    }

    private void updateModel() {
        this.myModel.setFilter(new Filter(this.mySearchField.getText(), this.myMatchCaseCheckBox.isSelected(), this.myRegexCheckBox.isSelected()));
    }

    public static void configureKeyBindingAndFocusBehaviors(final @NotNull JComponent containerComponent, final @NotNull FilterComponent filterComponent, final @NotNull JToggleButton showHideButton) {
        if (containerComponent == null) {
            FilterComponent.$$$reportNull$$$0(5);
        }
        if (filterComponent == null) {
            FilterComponent.$$$reportNull$$$0(6);
        }
        if (showHideButton == null) {
            FilterComponent.$$$reportNull$$$0(7);
        }
        showHideButton.addActionListener(event -> {
            filterComponent.setVisible(showHideButton.isSelected());
            if (!showHideButton.isSelected()) {
                filterComponent.setFilterText("");
            } else {
                filterComponent.requestFocusInWindow();
            }
            containerComponent.revalidate();
        });
        InputMap inputMap = containerComponent.getInputMap(1);
        ActionMap actionMap = containerComponent.getActionMap();
        inputMap.put(FILTER_KEY_STROKE, OPEN_AND_FOCUS_ACTION);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), CLOSE_ACTION);
        actionMap.put(OPEN_AND_FOCUS_ACTION, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!showHideButton.isSelected()) {
                    showHideButton.doClick(0);
                } else {
                    filterComponent.requestFocusInWindow();
                }
            }
        });
        actionMap.put(CLOSE_ACTION, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!showHideButton.isSelected()) {
                    return;
                }
                showHideButton.doClick(0);
                containerComponent.requestFocusInWindow();
            }
        });
    }

    @NotNull
    public static CommonToggleButton createFilterToggleButton() {
        CommonToggleButton filterButton = new CommonToggleButton("", AllIcons.General.Filter);
        filterButton.setToolTipText(String.format("Filter (%s)", KeymapUtil.getKeystrokeText((KeyStroke)FILTER_KEY_STROKE)));
        CommonToggleButton commonToggleButton = filterButton;
        if (commonToggleButton == null) {
            FilterComponent.$$$reportNull$$$0(8);
        }
        return commonToggleButton;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/FilterComponent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerComponent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterComponent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "showHideButton";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/FilterComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "setMatchCountVisibility";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchField";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCountLabel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilterToggleButton";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "configureKeyBindingAndFocusBehaviors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 8 -> new IllegalStateException(string);
        };
    }
}

