/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.stdui.StandardColors;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ExpandedItemRendererComponentWrapper;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public final class HoverRowTable
extends JBTable {
    private int myHoveredRow;
    private final Color myHoverColor;

    public HoverRowTable(@NotNull TableModel model2) {
        if (model2 == null) {
            HoverRowTable.$$$reportNull$$$0(0);
        }
        super(model2);
        this.myHoveredRow = -1;
        this.myHoverColor = StandardColors.HOVER_COLOR;
        MouseAdapter mouseAdapter2 = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                HoverRowTable.this.hoveredRowChanged(HoverRowTable.this.rowAtPoint(e.getPoint()));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                HoverRowTable.this.hoveredRowChanged(-1);
            }
        };
        this.addMouseMotionListener(mouseAdapter2);
        this.addMouseListener(mouseAdapter2);
        this.getEmptyText().clear();
        this.setIntercellSpacing(new Dimension());
    }

    private void hoveredRowChanged(int row) {
        if (row == this.myHoveredRow) {
            return;
        }
        this.myHoveredRow = row;
        this.repaint();
    }

    @NotNull
    public Component prepareRenderer(@NotNull TableCellRenderer renderer, int row, int column) {
        Component comp;
        if (renderer == null) {
            HoverRowTable.$$$reportNull$$$0(1);
        }
        Component toChangeComp = comp = super.prepareRenderer(renderer, row, column);
        if (comp instanceof ExpandedItemRendererComponentWrapper) {
            toChangeComp = ((ExpandedItemRendererComponentWrapper)comp).getComponent(0);
        }
        if (this.getRowSelectionAllowed() && this.isRowSelected(row)) {
            toChangeComp.setForeground(this.getSelectionForeground());
            toChangeComp.setBackground(this.getSelectionBackground());
        } else if (row == this.myHoveredRow) {
            toChangeComp.setBackground(this.myHoverColor);
            toChangeComp.setForeground(this.getForeground());
        } else {
            toChangeComp.setBackground(this.getBackground());
            toChangeComp.setForeground(this.getForeground());
        }
        Component component = comp;
        if (component == null) {
            HoverRowTable.$$$reportNull$$$0(2);
        }
        return component;
    }

    public void paint(@NotNull Graphics g) {
        if (g == null) {
            HoverRowTable.$$$reportNull$$$0(3);
        }
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, UIUtil.getLcdContrastValue());
        }
        super.paint(g);
        if (this.isEmpty() && !StringUtil.isEmpty((String)this.getEmptyText().getText())) {
            return;
        }
        TableColumnModel columnModel = this.getColumnModel();
        ArrayList<Integer> columnX = new ArrayList<Integer>();
        int x2 = 0;
        for (int index = 0; index < columnModel.getColumnCount() - 1; ++index) {
            int column = this.getComponentOrientation().isLeftToRight() ? index : columnModel.getColumnCount() - 1 - index;
            columnX.add((x2 += columnModel.getColumn(column).getWidth()) - 1);
        }
        g.setColor(this.getGridColor());
        int lastRowBottom = this.getRowCount() * this.getRowHeight();
        columnX.forEach(x -> g.drawLine((int)x, lastRowBottom, (int)x, this.getHeight()));
        if (this.getSelectedRow() != -1 && this.getCellSelectionEnabled()) {
            g.setColor(AdtUiUtils.overlayColor(this.getSelectionBackground().getRGB(), this.getGridColor().getRGB(), 0.25f));
            Rectangle selectedRowRect = this.getCellRect(this.getSelectedRow(), 0, true);
            columnX.forEach(x -> g.drawLine((int)x, selectedRowRect.y, (int)x, selectedRowRect.y + selectedRowRect.height - 1));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/HoverRowTable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/HoverRowTable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenderer";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

