/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.annotations.concurrency.Slow;
import com.intellij.util.ui.ImageUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageUtils {
    public static final double EPSILON = 1.0E-5;
    public static final CropFilter TRANSPARENCY_FILTER = (bufferedImage, x, y) -> {
        int rgb = bufferedImage.getRGB(x, y);
        return (rgb & 0xFF000000) == 0;
    };

    @NotNull
    public static BufferedImage rotateByQuadrants(@NotNull BufferedImage source, int numQuadrants) {
        int shiftX;
        int rotatedH;
        int rotatedW;
        if (source == null) {
            ImageUtils.$$$reportNull$$$0(0);
        }
        if ((numQuadrants &= 3) == 0) {
            BufferedImage bufferedImage = source;
            if (bufferedImage == null) {
                ImageUtils.$$$reportNull$$$0(1);
            }
            return bufferedImage;
        }
        int w = source.getWidth();
        int h = source.getHeight();
        int shiftY = switch (numQuadrants) {
            default -> {
                rotatedW = w;
                rotatedH = h;
                shiftX = 0;
                yield 0;
            }
            case 1 -> {
                rotatedW = h;
                rotatedH = w;
                shiftX = 0;
                yield w;
            }
            case 2 -> {
                rotatedW = w;
                rotatedH = h;
                shiftX = w;
                yield h;
            }
            case 3 -> {
                rotatedW = h;
                rotatedH = w;
                shiftX = h;
                yield 0;
            }
        };
        BufferedImage result = new BufferedImage(rotatedW, rotatedH, source.getType());
        Graphics2D graphics = result.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        AffineTransform transform = new AffineTransform();
        transform.translate(shiftX, shiftY);
        transform.quadrantRotate(-numQuadrants);
        graphics.drawRenderedImage(source, transform);
        graphics.dispose();
        BufferedImage bufferedImage = result;
        if (bufferedImage == null) {
            ImageUtils.$$$reportNull$$$0(2);
        }
        return bufferedImage;
    }

    @NotNull
    public static BufferedImage rotateByQuadrantsAndScale(@NotNull BufferedImage source, int numQuadrants, int destinationWidth, int destinationHeight) {
        int shiftX;
        double rotatedH;
        double rotatedW;
        if (source == null) {
            ImageUtils.$$$reportNull$$$0(3);
        }
        if ((numQuadrants &= 3) == 0 && destinationWidth == source.getWidth() && destinationHeight == source.getHeight()) {
            BufferedImage bufferedImage = source;
            if (bufferedImage == null) {
                ImageUtils.$$$reportNull$$$0(4);
            }
            return bufferedImage;
        }
        int w = source.getWidth();
        int h = source.getHeight();
        int shiftY = switch (numQuadrants) {
            default -> {
                rotatedW = w;
                rotatedH = h;
                shiftX = 0;
                yield 0;
            }
            case 1 -> {
                rotatedW = h;
                rotatedH = w;
                shiftX = 0;
                yield destinationHeight;
            }
            case 2 -> {
                rotatedW = w;
                rotatedH = h;
                shiftX = destinationWidth;
                yield destinationHeight;
            }
            case 3 -> {
                rotatedW = h;
                rotatedH = w;
                shiftX = destinationWidth;
                yield 0;
            }
        };
        BufferedImage result = new BufferedImage(destinationWidth, destinationHeight, source.getType());
        AffineTransform transform = new AffineTransform();
        transform.translate(shiftX, shiftY);
        transform.scale((double)destinationWidth / rotatedW, (double)destinationHeight / rotatedH);
        transform.quadrantRotate(-numQuadrants);
        AffineTransformOp transformOp = new AffineTransformOp(transform, 2);
        BufferedImage bufferedImage = transformOp.filter(source, result);
        if (bufferedImage == null) {
            ImageUtils.$$$reportNull$$$0(5);
        }
        return bufferedImage;
    }

    public static BufferedImage createDipImage(int width, int height, int type) {
        return ImageUtil.createImage((int)width, (int)height, (int)type);
    }

    public static BufferedImage addMargin(BufferedImage source, int marginSize) {
        int destWidth = source.getWidth() + 2 * marginSize;
        int destHeight = source.getHeight() + 2 * marginSize;
        int type = source.getColorModel().hasAlpha() ? source.getType() : 2;
        BufferedImage expanded = new BufferedImage(destWidth, destHeight, type);
        Graphics2D g2 = expanded.createGraphics();
        g2.setColor(new Color(0, true));
        g2.fillRect(0, 0, destWidth, destHeight);
        g2.drawImage((Image)source, marginSize, marginSize, null);
        g2.dispose();
        return expanded;
    }

    @NotNull
    public static BufferedImage scale(BufferedImage source, double amount) {
        return ImageUtils.scale(source, amount, amount, 0, 0);
    }

    @NotNull
    public static BufferedImage scale(BufferedImage source, double xScale, double yScale) {
        return ImageUtils.scale(source, xScale, yScale, 0, 0);
    }

    @NotNull
    public static BufferedImage scale(BufferedImage source, double xScale, double yScale, @Nullable Shape clip) {
        return ImageUtils.scale(source, xScale, yScale, 0, 0, clip);
    }

    @NotNull
    public static BufferedImage scale(BufferedImage source, double xScale, double yScale, int rightMargin, int bottomMargin) {
        return ImageUtils.scale(source, xScale, yScale, rightMargin, bottomMargin, null);
    }

    @NotNull
    public static BufferedImage scale(BufferedImage source, double xScale, double yScale, int rightMargin, int bottomMargin, @Nullable Shape clip) {
        int sourceWidth = source.getWidth();
        int sourceHeight = source.getHeight();
        int destWidth = Math.max(1, (int)(xScale * (double)sourceWidth));
        int destHeight = Math.max(1, (int)(yScale * (double)sourceHeight));
        int imageType = source.getType();
        if (imageType == 0 || imageType == 13 || imageType == 12) {
            imageType = 2;
        }
        if (xScale > 0.5 && yScale > 0.5) {
            BufferedImage scaled = new BufferedImage(destWidth + rightMargin, destHeight + bottomMargin, imageType);
            Graphics2D g2 = scaled.createGraphics();
            g2.setComposite(AlphaComposite.Src);
            g2.setColor(new Color(0, true));
            g2.fillRect(0, 0, destWidth + rightMargin, destHeight + bottomMargin);
            if (clip != null) {
                g2.setClip(clip);
            }
            if (xScale == 1.0 && yScale == 1.0) {
                g2.drawImage((Image)source, 0, 0, null);
            } else {
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.drawImage(source, 0, 0, destWidth, destHeight, 0, 0, sourceWidth, sourceHeight, null);
            }
            g2.dispose();
            BufferedImage bufferedImage = scaled;
            if (bufferedImage == null) {
                ImageUtils.$$$reportNull$$$0(6);
            }
            return bufferedImage;
        }
        int iterations = 0;
        int nearestWidth = destWidth;
        int nearestHeight = destHeight;
        while (nearestWidth < sourceWidth / 2) {
            nearestWidth *= 2;
            nearestHeight *= 2;
            ++iterations;
        }
        if (iterations == 0) {
            nearestWidth += rightMargin;
            nearestHeight += bottomMargin;
        }
        BufferedImage scaled = new BufferedImage(nearestWidth, nearestHeight, imageType);
        Graphics2D g2 = scaled.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.drawImage(source, 0, 0, nearestWidth, nearestHeight, 0, 0, sourceWidth, sourceHeight, null);
        g2.dispose();
        sourceWidth = nearestWidth;
        sourceHeight = nearestHeight;
        source = scaled;
        for (int iteration = iterations - 1; iteration >= 0; --iteration) {
            int halfWidth = sourceWidth / 2;
            int halfHeight = sourceHeight / 2;
            if (iteration == 0) {
                scaled = new BufferedImage(halfWidth + rightMargin, halfHeight + bottomMargin, imageType);
                g2 = scaled.createGraphics();
                if (clip != null) {
                    g2.setClip(clip);
                }
            } else {
                scaled = new BufferedImage(halfWidth, halfHeight, imageType);
                g2 = scaled.createGraphics();
            }
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.drawImage(source, 0, 0, halfWidth, halfHeight, 0, 0, sourceWidth, sourceHeight, null);
            g2.dispose();
            sourceWidth = halfWidth;
            sourceHeight = halfHeight;
            source = scaled;
            --iterations;
        }
        BufferedImage bufferedImage = scaled;
        if (bufferedImage == null) {
            ImageUtils.$$$reportNull$$$0(7);
        }
        return bufferedImage;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static BufferedImage lowQualityFastScale(@NotNull BufferedImage source, double xScale, double d) {
        void yScale;
        if (source == null) {
            ImageUtils.$$$reportNull$$$0(8);
        }
        return ImageUtils.lowQualityFastScale(source, xScale, (double)yScale, 0, 0, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static BufferedImage lowQualityFastScale(@NotNull BufferedImage source, double xScale, double yScale, int rightMargin, int n, @Nullable Shape shape) {
        void clip;
        void bottomMargin;
        if (source == null) {
            ImageUtils.$$$reportNull$$$0(9);
        }
        int sourceWidth = source.getWidth();
        int sourceHeight = source.getHeight();
        int destWidth = Math.max(1, (int)(xScale * (double)sourceWidth));
        int destHeight = Math.max(1, (int)(yScale * (double)sourceHeight));
        int imageType = source.getType();
        if (imageType == 0) {
            imageType = 2;
        }
        BufferedImage scaled = new BufferedImage(destWidth + rightMargin, destHeight + bottomMargin, imageType);
        Graphics2D g2 = scaled.createGraphics();
        g2.setComposite(AlphaComposite.Src);
        g2.setColor(new Color(0, true));
        g2.fillRect(0, 0, destWidth + rightMargin, destHeight + bottomMargin);
        if (clip != null) {
            g2.setClip((Shape)clip);
        }
        if (xScale == 1.0 && yScale == 1.0) {
            g2.drawImage((Image)source, 0, 0, null);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.drawImage(source, 0, 0, destWidth, destHeight, 0, 0, sourceWidth, sourceHeight, null);
        }
        g2.dispose();
        BufferedImage bufferedImage = scaled;
        if (bufferedImage == null) {
            ImageUtils.$$$reportNull$$$0(10);
        }
        return bufferedImage;
    }

    @Slow
    @Nullable
    public static BufferedImage readImageAtScale(@NotNull InputStream inputStream, @NotNull Dimension dimension) throws IOException {
        double scale;
        ImageInputStream imageStream;
        Iterator<ImageReader> readerIterator;
        if (inputStream == null) {
            ImageUtils.$$$reportNull$$$0(11);
        }
        if (dimension == null) {
            ImageUtils.$$$reportNull$$$0(12);
        }
        if (!(readerIterator = ImageIO.getImageReaders(imageStream = ImageIO.createImageInputStream(inputStream))).hasNext()) {
            return null;
        }
        ImageReader reader = readerIterator.next();
        reader.setInput(imageStream);
        ImageReadParam readParams = reader.getDefaultReadParam();
        double srcW = reader.getWidth(0);
        double srcH = reader.getHeight(0);
        double d = scale = srcW > srcH ? (double)dimension.width / srcW : (double)dimension.height / srcH;
        if (scale < 0.5) {
            double xStep = Math.floor(1.0 / (scale *= 2.0));
            double yStep = Math.floor(1.0 / scale);
            readParams.setSourceSubsampling((int)xStep, (int)yStep, 0, 0);
        }
        BufferedImage intermediateImage = reader.read(0, readParams);
        imageStream.close();
        inputStream.close();
        scale = srcW > srcH ? (double)dimension.width / (double)intermediateImage.getWidth() : (double)dimension.height / (double)intermediateImage.getHeight();
        return ImageUtils.scale(intermediateImage, scale, scale);
    }

    @Nullable
    public static BufferedImage cropBlank(@NotNull BufferedImage image, @Nullable Rectangle initialCrop) {
        if (image == null) {
            ImageUtils.$$$reportNull$$$0(13);
        }
        return ImageUtils.cropBlank(image, initialCrop, image.getType());
    }

    @Nullable
    public static BufferedImage cropBlank(@Nullable BufferedImage image, @Nullable Rectangle initialCrop, int imageType) {
        return ImageUtils.crop(image, TRANSPARENCY_FILTER, initialCrop, imageType);
    }

    @Nullable
    public static Rectangle getCropBounds(@Nullable BufferedImage image, @NotNull CropFilter filter, @Nullable Rectangle initialCrop) {
        int y;
        int x;
        int y2;
        int x2;
        int y1;
        int x1;
        if (filter == null) {
            ImageUtils.$$$reportNull$$$0(14);
        }
        if (image == null) {
            return null;
        }
        if (initialCrop != null) {
            x1 = Math.max(initialCrop.x, 0);
            y1 = Math.max(initialCrop.y, 0);
            x2 = Math.min(initialCrop.x + initialCrop.width, image.getWidth());
            y2 = Math.min(initialCrop.y + initialCrop.height, image.getHeight());
        } else {
            x1 = 0;
            y1 = 0;
            x2 = image.getWidth();
            y2 = image.getHeight();
        }
        if (x1 == x2 || y1 == y2) {
            return null;
        }
        block0: while (y1 < y2) {
            for (x = x1; x < x2; ++x) {
                if (!filter.crop(image, x, y1)) break block0;
            }
            ++y1;
        }
        if (y1 == y2) {
            return null;
        }
        block2: while (x1 < x2) {
            for (y = y1; y < y2; ++y) {
                if (!filter.crop(image, x1, y)) break block2;
            }
            ++x1;
        }
        block4: while (--x2 >= x1) {
            for (y = y1; y < y2; ++y) {
                if (!filter.crop(image, x2, y)) break block4;
            }
        }
        ++x2;
        block6: while (--y2 >= y1) {
            for (x = x1; x < x2; ++x) {
                if (!filter.crop(image, x, y2)) break block6;
            }
        }
        if (x1 == x2 || y1 == ++y2) {
            return null;
        }
        int width = x2 - x1;
        int height = y2 - y1;
        return new Rectangle(x1, y1, width, height);
    }

    @Nullable
    public static BufferedImage crop(@Nullable BufferedImage image, @NotNull CropFilter filter, @Nullable Rectangle initialCrop, int imageType) {
        if (filter == null) {
            ImageUtils.$$$reportNull$$$0(15);
        }
        if (image == null) {
            return null;
        }
        Rectangle cropBounds = ImageUtils.getCropBounds(image, filter, initialCrop);
        if (cropBounds == null) {
            return null;
        }
        return ImageUtils.getCroppedImage(image, cropBounds, imageType);
    }

    @NotNull
    public static BufferedImage getCroppedImage(@NotNull BufferedImage image, @NotNull Rectangle cropBounds, int imageType) {
        if (image == null) {
            ImageUtils.$$$reportNull$$$0(16);
        }
        if (cropBounds == null) {
            ImageUtils.$$$reportNull$$$0(17);
        }
        int x1 = cropBounds.x;
        int y1 = cropBounds.y;
        int width = cropBounds.width;
        int height = cropBounds.height;
        int x2 = x1 + width;
        int y2 = y1 + height;
        if (imageType == -1) {
            imageType = image.getType();
        }
        if (imageType == 0) {
            imageType = 2;
        }
        BufferedImage cropped = new BufferedImage(width, height, imageType);
        Graphics g = cropped.getGraphics();
        g.drawImage(image, 0, 0, width, height, x1, y1, x2, y2, null);
        g.dispose();
        BufferedImage bufferedImage = cropped;
        if (bufferedImage == null) {
            ImageUtils.$$$reportNull$$$0(18);
        }
        return bufferedImage;
    }

    public static boolean isNonOpaque(@NotNull BufferedImage image) {
        if (image == null) {
            ImageUtils.$$$reportNull$$$0(19);
        }
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int rgb = image.getRGB(x, y);
                if ((rgb & 0xFF000000 ^ 0xFF000000) == 0) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static BufferedImage circularClip(@NotNull BufferedImage image, @Nullable Color backgroundColor) {
        if (image == null) {
            ImageUtils.$$$reportNull$$$0(20);
        }
        BufferedImage mask = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g2 = mask.createGraphics();
        ImageUtil.applyQualityRenderingHints((Graphics2D)g2);
        double diameter = Math.max(image.getWidth(), image.getHeight());
        g2.fill(new Area(new Ellipse2D.Double(0.0, 0.0, diameter, diameter)));
        g2.dispose();
        BufferedImage shapedImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        g2 = shapedImage.createGraphics();
        ImageUtil.applyQualityRenderingHints((Graphics2D)g2);
        g2.drawImage((Image)image, 0, 0, null);
        g2.setComposite(AlphaComposite.getInstance(6));
        g2.drawImage((Image)mask, 0, 0, null);
        if (backgroundColor != null) {
            g2.setColor(backgroundColor);
            g2.setComposite(AlphaComposite.getInstance(4));
            g2.fillRect(0, 0, image.getWidth(), image.getHeight());
        }
        g2.dispose();
        BufferedImage bufferedImage = shapedImage;
        if (bufferedImage == null) {
            ImageUtils.$$$reportNull$$$0(21);
        }
        return bufferedImage;
    }

    @NotNull
    public static BufferedImage ellipticalClip(@NotNull BufferedImage image, @Nullable Color backgroundColor) {
        if (image == null) {
            ImageUtils.$$$reportNull$$$0(22);
        }
        BufferedImage mask = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g2 = mask.createGraphics();
        ImageUtil.applyQualityRenderingHints((Graphics2D)g2);
        g2.fill(new Area(new Ellipse2D.Double(0.0, 0.0, image.getWidth(), image.getHeight())));
        g2.dispose();
        BufferedImage shapedImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        g2 = shapedImage.createGraphics();
        ImageUtil.applyQualityRenderingHints((Graphics2D)g2);
        g2.drawImage((Image)image, 0, 0, null);
        g2.setComposite(AlphaComposite.getInstance(6));
        g2.drawImage((Image)mask, 0, 0, null);
        if (backgroundColor != null) {
            g2.setColor(backgroundColor);
            g2.setComposite(AlphaComposite.getInstance(4));
            g2.fillRect(0, 0, image.getWidth(), image.getHeight());
        }
        g2.dispose();
        BufferedImage bufferedImage = shapedImage;
        if (bufferedImage == null) {
            ImageUtils.$$$reportNull$$$0(23);
        }
        return bufferedImage;
    }

    public static BufferedImage iconToImage(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ImageUtil.toBufferedImage((Image)((ImageIcon)icon).getImage());
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        BufferedImage image = ImageUtil.createImage((int)w, (int)h, (int)6);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5, 6, 7, 10, 18, 21, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 18: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/ImageUtils";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dimension";
                break;
            }
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cropBounds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/ImageUtils";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "rotateByQuadrants";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "rotateByQuadrantsAndScale";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "scale";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "lowQualityFastScale";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCroppedImage";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "circularClip";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "ellipticalClip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "rotateByQuadrants";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 18: 
            case 21: 
            case 23: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "rotateByQuadrantsAndScale";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lowQualityFastScale";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readImageAtScale";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "cropBlank";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCropBounds";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "crop";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCroppedImage";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isNonOpaque";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "circularClip";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "ellipticalClip";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5, 6, 7, 10, 18, 21, 23 -> new IllegalStateException(string);
        };
    }

    public static interface CropFilter {
        public boolean crop(BufferedImage var1, int var2, int var3);
    }
}

