/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.actions;

import com.intellij.icons.AllIcons;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public enum ZoomType {
    FIT("Zoom to Fit Screen", AllIcons.General.FitContent),
    ACTUAL("100%", "Zoom to Actual Size (100%)", AllIcons.General.ActualZoom),
    IN("Zoom In", AllIcons.General.Add),
    OUT("Zoom Out", AllIcons.General.Remove);

    private final String myLabel;
    private final String myDescription;
    private final Icon myIcon;
    private static final int[] ZOOM_POINTS;

    private ZoomType(@Nullable String label2, String description, Icon icon) {
        if (label2 == null) {
            ZoomType.$$$reportNull$$$0(0);
        }
        this.myLabel = label2;
        this.myDescription = description;
        this.myIcon = icon;
    }

    private ZoomType(String label2, Icon icon) {
        if (label2 == null) {
            ZoomType.$$$reportNull$$$0(1);
        }
        this(label2, null, icon);
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    public String getLabel() {
        return this.myLabel;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    public String toString() {
        return this.getLabel();
    }

    public static int zoomIn(int percentage) {
        return ZoomType.zoomIn(percentage, ZOOM_POINTS);
    }

    public static int zoomIn(int percentage, int[] zoomPoints) {
        int i2 = Arrays.binarySearch(zoomPoints, percentage);
        if (i2 < 0) {
            if ((i2 = -i2 - 1) == 0 && (double)percentage < (double)zoomPoints[0] * 0.75) {
                return Math.min((int)Math.ceil((double)percentage * 1.2), zoomPoints[0]);
            }
            if (i2 < zoomPoints.length) {
                return zoomPoints[i2];
            }
            return (percentage / 100 + 1) * 100;
        }
        if (i2 < zoomPoints.length - 1) {
            return zoomPoints[i2 + 1];
        }
        return percentage + 100;
    }

    public static int zoomOut(int percentage) {
        return ZoomType.zoomOut(percentage, ZOOM_POINTS);
    }

    public static int zoomOut(int percentage, int[] zoomPoints) {
        int i2 = Arrays.binarySearch(zoomPoints, percentage);
        if (i2 < 0) {
            if ((i2 = -i2 - 1) == 0) {
                return (int)Math.floor((double)percentage / 1.1);
            }
            if (i2 < zoomPoints.length) {
                return zoomPoints[i2 - 1];
            }
            return (percentage / 100 - 1) * 100;
        }
        if (i2 > 0) {
            return zoomPoints[i2 - 1];
        }
        return (int)Math.floor((double)percentage / 1.1);
    }

    static {
        ZOOM_POINTS = new int[]{25, 33, 50, 67, 75, 90, 100, 110, 125, 150, 200};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/android/tools/adtui/actions/ZoomType", "<init>"));
    }
}

