/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.hchart;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.chart.hchart.DefaultHTreeChartReducer;
import com.android.tools.adtui.chart.hchart.HRenderer;
import com.android.tools.adtui.chart.hchart.HTreeChartReducer;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.HNode;
import com.android.tools.adtui.model.Range;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.ui.UISettings;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\n\u0018\u0000 Q*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003:\u0003PQRB\u0015\b\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u00107\u001a\u00020\nH\u0002J\u0015\u00108\u001a\u00020\u00112\u0006\u0010/\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u00109J\u0018\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0014J\u0015\u0010@\u001a\u0004\u0018\u00018\u00002\u0006\u0010A\u001a\u00020B\u00a2\u0006\u0002\u0010CJ\u0015\u0010D\u001a\u00020\f2\u0006\u0010/\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010EJ\b\u0010F\u001a\u00020;H\u0002J\b\u0010G\u001a\u00020;H\u0002J\u0010\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020IH\u0002J\b\u0010K\u001a\u00020;H\u0002J\u0010\u0010L\u001a\u00020;2\u0006\u0010>\u001a\u00020?H\u0002J\b\u0010M\u001a\u00020;H\u0002J\u0015\u0010N\u001a\u00020;2\b\u0010-\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0017J\b\u0010O\u001a\u00020;H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u000ej\b\u0012\u0004\u0012\u00028\u0000`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u000ej\b\u0012\u0004\u0012\u00020\u0011`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0013\u001a\u0004\u0018\u00018\u00002\b\u0010\u0012\u001a\u0004\u0018\u00018\u0000@GX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001dR\u000e\u0010 \u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010#\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u000ej\b\u0012\u0004\u0012\u00028\u0000`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001e\u0010(\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u000ej\b\u0012\u0004\u0012\u00020\u0011`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010-\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u000e\u0010.\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u00100\u001a\u0004\u0018\u00018\u00002\b\u0010/\u001a\u0004\u0018\u00018\u00008G@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\b1\u0010\u0015\"\u0004\b2\u0010\u0017R\u000e\u00103\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00104\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106\u00a8\u0006S"}, d2={"Lcom/android/tools/adtui/chart/hchart/HTreeChart;", "N", "Lcom/android/tools/adtui/model/HNode;", "Lcom/android/tools/adtui/AnimatedComponent;", "builder", "Lcom/android/tools/adtui/chart/hchart/HTreeChart$Builder;", "(Lcom/android/tools/adtui/chart/hchart/HTreeChart$Builder;)V", "canvas", "Ljava/awt/Image;", "customNodeHeightPx", "", "dataUpdated", "", "drawnNodes", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "drawnRectangles", "Ljava/awt/geom/Rectangle2D$Float;", "<set-?>", "focusedNode", "getFocusedNode", "()Lcom/android/tools/adtui/model/HNode;", "setFocusedNode", "(Lcom/android/tools/adtui/model/HNode;)V", "Lcom/android/tools/adtui/model/HNode;", "globalXRange", "Lcom/android/tools/adtui/model/Range;", "maximumHeight", "getMaximumHeight", "()I", "nodeHeight", "getNodeHeight", "nodeSelectionEnabled", "nodeXPaddingPx", "nodeYPaddingPx", "nodes", "orientation", "Lcom/android/tools/adtui/chart/hchart/HTreeChart$Orientation;", "getOrientation", "()Lcom/android/tools/adtui/chart/hchart/HTreeChart$Orientation;", "rectangles", "reducer", "Lcom/android/tools/adtui/chart/hchart/HTreeChartReducer;", "renderer", "Lcom/android/tools/adtui/chart/hchart/HRenderer;", "root", "rootVisible", "node", "selectedNode", "getSelectedNode", "setSelectedNode", "xRange", "yRange", "getYRange", "()Lcom/android/tools/adtui/model/Range;", "calculateMaximumHeight", "createRectangle", "(Lcom/android/tools/adtui/model/HNode;)Ljava/awt/geom/Rectangle2D$Float;", "draw", "", "g", "Ljava/awt/Graphics2D;", "dim", "Ljava/awt/Dimension;", "getNodeAt", "point", "Ljava/awt/Point;", "(Ljava/awt/Point;)Lcom/android/tools/adtui/model/HNode;", "inRange", "(Lcom/android/tools/adtui/model/HNode;)Z", "initializeInputMap", "initializeMouseEvents", "positionToRange", "", "x", "rangeChanged", "redrawToCanvas", "rootChanged", "setHTree", "updateNodesAndClearCanvas", "Builder", "Companion", "Orientation", "intellij.android.adt.ui"})
@SourceDebugExtension(value={"SMAP\nHTreeChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HTreeChart.kt\ncom/android/tools/adtui/chart/hchart/HTreeChart\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,462:1\n1#2:463\n*E\n"})
public final class HTreeChart<N extends HNode<N>>
extends AnimatedComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Orientation orientation;
    @NotNull
    private final HRenderer<N> renderer;
    @Nullable
    private N root;
    @NotNull
    private final Range xRange;
    @NotNull
    private final Range globalXRange;
    @NotNull
    private final Range yRange;
    @NotNull
    private final ArrayList<Rectangle2D.Float> rectangles;
    @NotNull
    private final ArrayList<N> nodes;
    private final boolean rootVisible;
    @Nullable
    private N focusedNode;
    private final boolean nodeSelectionEnabled;
    @Nullable
    private N selectedNode;
    @NotNull
    private final ArrayList<Rectangle2D.Float> drawnRectangles;
    @NotNull
    private final ArrayList<N> drawnNodes;
    @NotNull
    private final HTreeChartReducer<N> reducer;
    @Nullable
    private Image canvas;
    private boolean dataUpdated;
    private int maximumHeight;
    private final int customNodeHeightPx;
    private final int nodeXPaddingPx;
    private final int nodeYPaddingPx;
    @NotNull
    private static final String NO_HTREE = "No data available.";
    @NotNull
    private static final String NO_RANGE = "X range width is zero: Please use a wider range.";
    private static final int ZOOM_FACTOR = 20;
    @NotNull
    private static final String ACTION_ZOOM_IN = "zoom in";
    @NotNull
    private static final String ACTION_ZOOM_OUT = "zoom out";
    @NotNull
    private static final String ACTION_MOVE_LEFT = "move left";
    @NotNull
    private static final String ACTION_MOVE_RIGHT = "move right";
    private static final int ACTION_MOVEMENT_FACTOR = 5;
    public static final int PADDING = 1;
    private static final int INITIAL_Y_POSITION = 0;
    public static final int HEIGHT_PADDING = 15;
    private static final int MOUSE_WHEEL_SCROLL_FACTOR = 8;

    private HTreeChart(Builder<N> builder) {
        this.orientation = builder.getOrientation$intellij_android_adt_ui();
        this.renderer = builder.getRenderer$intellij_android_adt_ui();
        this.root = builder.getRoot$intellij_android_adt_ui();
        this.xRange = builder.getXRange$intellij_android_adt_ui();
        this.globalXRange = builder.getGlobalXRange$intellij_android_adt_ui();
        this.yRange = new Range(0.0, 0.0);
        this.rectangles = new ArrayList();
        this.nodes = new ArrayList();
        this.rootVisible = builder.getRootVisible$intellij_android_adt_ui();
        this.nodeSelectionEnabled = builder.getNodeSelectionEnabled$intellij_android_adt_ui();
        this.drawnRectangles = new ArrayList();
        this.drawnNodes = new ArrayList();
        this.reducer = builder.getReducer$intellij_android_adt_ui();
        this.customNodeHeightPx = builder.getCustomNodeHeightPx$intellij_android_adt_ui();
        this.nodeXPaddingPx = builder.getNodeXPaddingPx$intellij_android_adt_ui();
        this.nodeYPaddingPx = builder.getNodeYPaddingPx$intellij_android_adt_ui();
        this.setFocusable(true);
        this.initializeInputMap();
        this.initializeMouseEvents();
        this.setFont((Font)AdtUiUtils.DEFAULT_FONT);
        this.xRange.addDependency(this.myAspectObserver).onChange((Enum)Range.Aspect.RANGE, this::rangeChanged);
        this.yRange.addDependency(this.myAspectObserver).onChange((Enum)Range.Aspect.RANGE, this::rangeChanged);
        this.rootChanged();
    }

    @NotNull
    public final Orientation getOrientation() {
        return this.orientation;
    }

    @NotNull
    public final Range getYRange() {
        return this.yRange;
    }

    @Nullable
    public final N getFocusedNode() {
        return this.focusedNode;
    }

    @VisibleForTesting
    public final void setFocusedNode(@Nullable N n) {
        this.focusedNode = n;
    }

    @VisibleForTesting
    @Nullable
    public final N getSelectedNode() {
        return this.selectedNode;
    }

    public final void setSelectedNode(@Nullable N node) {
        if (this.selectedNode != node) {
            this.dataUpdated = true;
            this.selectedNode = node;
        }
    }

    public final int getMaximumHeight() {
        return this.maximumHeight;
    }

    private final int getNodeHeight() {
        return this.customNodeHeightPx > 0 ? this.customNodeHeightPx : this.mDefaultFontMetrics.getHeight();
    }

    private final void rangeChanged() {
        this.dataUpdated = true;
        this.opaqueRepaint();
    }

    private final void rootChanged() {
        this.maximumHeight = this.calculateMaximumHeight();
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.maximumHeight));
        this.rangeChanged();
    }

    @Override
    protected void draw(@NotNull Graphics2D g, @NotNull Dimension dim) {
        long startTime;
        block11: {
            block10: {
                block9: {
                    block8: {
                        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                        Intrinsics.checkNotNullParameter((Object)dim, (String)"dim");
                        startTime = System.nanoTime();
                        if (this.dataUpdated) {
                            this.updateNodesAndClearCanvas();
                            this.dataUpdated = false;
                        }
                        g.setFont(this.getFont());
                        if (this.root == null) break block8;
                        N n = this.root;
                        Intrinsics.checkNotNull(n);
                        if (n.getChildCount() != 0) break block9;
                    }
                    g.drawString(NO_HTREE, dim.width / 2 - this.mDefaultFontMetrics.stringWidth(NO_HTREE), dim.height / 2);
                    return;
                }
                if (this.xRange.getLength() == 0.0) {
                    g.drawString(NO_RANGE, dim.width / 2 - this.mDefaultFontMetrics.stringWidth(NO_RANGE), dim.height / 2);
                    return;
                }
                if (this.canvas == null) break block10;
                Image image = this.canvas;
                Intrinsics.checkNotNull((Object)image);
                if (ImageUtil.getUserHeight((Image)image) != dim.height) break block10;
                Image image2 = this.canvas;
                Intrinsics.checkNotNull((Object)image2);
                if (ImageUtil.getUserWidth((Image)image2) == dim.width) break block11;
            }
            this.redrawToCanvas(dim);
        }
        Graphics graphics = g;
        Image image = this.canvas;
        Intrinsics.checkNotNull((Object)image);
        UIUtil.drawImage((Graphics)graphics, (Image)image, (int)0, (int)0, null);
        Object[] objectArray = new Object[]{(double)(System.nanoTime() - startTime) / 1000000.0};
        this.addDebugInfo("Draw time %.2fms", objectArray);
        objectArray = new Object[]{this.nodes.size()};
        this.addDebugInfo("# of nodes %d", objectArray);
        objectArray = new Object[]{this.drawnNodes.size()};
        this.addDebugInfo("# of reduced nodes %d", objectArray);
    }

    private final void redrawToCanvas(Dimension dim) {
        boolean bl;
        block8: {
            block7: {
                if (this.canvas == null) break block7;
                Image image = this.canvas;
                Intrinsics.checkNotNull((Object)image);
                if (ImageUtil.getUserWidth((Image)image) < dim.width) break block7;
                Image image2 = this.canvas;
                Intrinsics.checkNotNull((Object)image2);
                if (ImageUtil.getUserHeight((Image)image2) >= dim.height) break block8;
            }
            this.canvas = ImageUtil.createImage((int)dim.width, (int)dim.height, (int)2);
        }
        Image image = this.canvas;
        Intrinsics.checkNotNull((Object)image);
        Graphics graphics = image.getGraphics();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g = (Graphics2D)graphics;
        g.setColor(this.getBackground());
        g.setComposite(AlphaComposite.Clear);
        g.fillRect(0, 0, dim.width, dim.height);
        g.setComposite(AlphaComposite.Src);
        UISettings.Companion.setupAntialiasing((Graphics)g);
        g.setFont(this.getFont());
        this.drawnNodes.clear();
        this.drawnNodes.addAll((Collection)this.nodes);
        this.drawnRectangles.clear();
        for (Rectangle2D.Float rect : this.rectangles) {
            Rectangle2D.Float newRect = new Rectangle2D.Float();
            newRect.x = rect.x * (float)dim.getWidth();
            newRect.y = rect.y;
            newRect.width = Math.max(0.0f, rect.width * (float)dim.getWidth() - (float)this.nodeXPaddingPx);
            newRect.height = rect.height;
            if (this.orientation == Orientation.BOTTOM_UP) {
                newRect.y = (float)(dim.getHeight() - (double)newRect.y - newRect.getHeight());
            }
            this.drawnRectangles.add(newRect);
        }
        this.reducer.reduce((List<Rectangle2D.Float>)this.drawnRectangles, (List)this.drawnNodes);
        boolean bl2 = bl = this.drawnRectangles.size() == this.drawnNodes.size();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        int n = this.drawnNodes.size();
        for (int i2 = 0; i2 < n; ++i2) {
            Rectangle2D.Float drawingArea;
            N n2 = this.drawnNodes.get(i2);
            Intrinsics.checkNotNullExpressionValue(n2, (String)"drawnNodes[i]");
            HNode node = (HNode)n2;
            Intrinsics.checkNotNullExpressionValue((Object)this.drawnRectangles.get(i2), (String)"drawnRectangles[i]");
            Rectangle2D.Float clampedDrawingArea = new Rectangle2D.Float(Math.max(0.0f, drawingArea.x), drawingArea.y, Math.min(drawingArea.x + drawingArea.width, (float)(dim.width - this.nodeXPaddingPx)) - Math.max(0.0f, drawingArea.x), drawingArea.height);
            this.renderer.render(g, node, drawingArea, clampedDrawingArea, node == this.focusedNode, this.selectedNode != null && node != this.selectedNode);
        }
        g.dispose();
    }

    private final void updateNodesAndClearCanvas() {
        this.nodes.clear();
        this.rectangles.clear();
        this.canvas = null;
        if (this.root == null) {
            return;
        }
        N n = this.root;
        Intrinsics.checkNotNull(n);
        if (this.inRange(n)) {
            N n2 = this.root;
            Intrinsics.checkNotNull(n2);
            this.nodes.add(n2);
            N n3 = this.root;
            Intrinsics.checkNotNull(n3);
            this.rectangles.add(this.createRectangle(n3));
        }
        int head = 0;
        while (head < this.nodes.size()) {
            N n4 = this.nodes.get(head++);
            Intrinsics.checkNotNullExpressionValue(n4, (String)"nodes[head++]");
            HNode curNode = (HNode)n4;
            int n5 = curNode.getChildCount();
            for (int i2 = 0; i2 < n5; ++i2) {
                Object child;
                Intrinsics.checkNotNullExpressionValue(curNode.getChildAt(i2), (String)"curNode.getChildAt(i)");
                if (!this.inRange(child)) continue;
                this.nodes.add(child);
                this.rectangles.add(this.createRectangle(child));
            }
        }
        if (!this.rootVisible && !((Collection)this.nodes).isEmpty()) {
            this.nodes.remove(0);
            this.rectangles.remove(0);
        }
    }

    private final boolean inRange(N node) {
        return (double)node.getStart() <= this.xRange.getMax() && (double)node.getEnd() >= this.xRange.getMin();
    }

    private final Rectangle2D.Float createRectangle(N node) {
        Rectangle2D.Float float_;
        float left = (float)(((double)node.getStart() - this.xRange.getMin()) / this.xRange.getLength());
        float right = (float)(((double)node.getEnd() - this.xRange.getMin()) / this.xRange.getLength());
        Rectangle2D.Float $this$createRectangle_u24lambda_u240 = float_ = new Rectangle2D.Float();
        boolean bl = false;
        $this$createRectangle_u24lambda_u240.x = left;
        $this$createRectangle_u24lambda_u240.y = (float)((double)((this.getNodeHeight() + this.nodeYPaddingPx) * node.getDepth()) - this.yRange.getMin());
        $this$createRectangle_u24lambda_u240.width = right - left;
        $this$createRectangle_u24lambda_u240.height = this.getNodeHeight();
        return float_;
    }

    private final double positionToRange(double x) {
        return x / (double)this.getWidth() * this.xRange.getLength() + this.xRange.getMin();
    }

    public final void setHTree(@Nullable N root) {
        this.root = root;
        this.rootChanged();
    }

    @Nullable
    public final N getNodeAt(@NotNull Point point) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            Iterable iterable = CollectionsKt.zip((Iterable)this.drawnNodes, (Iterable)this.drawnRectangles);
            for (Object t : iterable) {
                Pair pair = (Pair)t;
                boolean bl = false;
                Rectangle2D.Float rect = (Rectangle2D.Float)pair.component2();
                if (!rect.contains(point)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Pair pair = v0;
        return (N)(pair != null ? (HNode)pair.getFirst() : null);
    }

    private final void initializeInputMap() {
        HTreeChart.initializeInputMap$bindKey(this, 38, ACTION_ZOOM_IN);
        HTreeChart.initializeInputMap$bindKey(this, 87, ACTION_ZOOM_IN);
        HTreeChart.initializeInputMap$bindKey(this, 40, ACTION_ZOOM_OUT);
        HTreeChart.initializeInputMap$bindKey(this, 83, ACTION_ZOOM_OUT);
        HTreeChart.initializeInputMap$bindKey(this, 37, ACTION_MOVE_LEFT);
        HTreeChart.initializeInputMap$bindKey(this, 65, ACTION_MOVE_LEFT);
        HTreeChart.initializeInputMap$bindKey(this, 39, ACTION_MOVE_RIGHT);
        HTreeChart.initializeInputMap$bindKey(this, 68, ACTION_MOVE_RIGHT);
        HTreeChart.initializeInputMap$bindMovementAction(this, ACTION_ZOOM_IN, (Function1<? super Double, Unit>)((Function1)new Function1<Double, Unit>(this){
            final /* synthetic */ HTreeChart<N> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(double delta) {
                HTreeChart.access$getXRange$p(this.this$0).set(HTreeChart.access$getXRange$p(this.this$0).getMin() + delta, HTreeChart.access$getXRange$p(this.this$0).getMax() - delta);
            }
        }));
        HTreeChart.initializeInputMap$bindMovementAction(this, ACTION_ZOOM_OUT, (Function1<? super Double, Unit>)((Function1)new Function1<Double, Unit>(this){
            final /* synthetic */ HTreeChart<N> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(double delta) {
                HTreeChart.access$getXRange$p(this.this$0).set(Math.max(HTreeChart.access$getGlobalXRange$p(this.this$0).getMin(), HTreeChart.access$getXRange$p(this.this$0).getMin() - delta), Math.min(HTreeChart.access$getGlobalXRange$p(this.this$0).getMax(), HTreeChart.access$getXRange$p(this.this$0).getMax() + delta));
            }
        }));
        HTreeChart.initializeInputMap$bindMovementAction(this, ACTION_MOVE_LEFT, (Function1<? super Double, Unit>)((Function1)new Function1<Double, Unit>(this){
            final /* synthetic */ HTreeChart<N> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(double delta) {
                HTreeChart.access$getXRange$p(this.this$0).shift(-Math.min(HTreeChart.access$getXRange$p(this.this$0).getMin() - HTreeChart.access$getGlobalXRange$p(this.this$0).getMin(), delta));
            }
        }));
        HTreeChart.initializeInputMap$bindMovementAction(this, ACTION_MOVE_RIGHT, (Function1<? super Double, Unit>)((Function1)new Function1<Double, Unit>(this){
            final /* synthetic */ HTreeChart<N> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(double delta) {
                HTreeChart.access$getXRange$p(this.this$0).shift(Math.min(HTreeChart.access$getGlobalXRange$p(this.this$0).getMax() - HTreeChart.access$getXRange$p(this.this$0).getMax(), delta));
            }
        }));
    }

    private final void initializeMouseEvents() {
        MouseAdapter adapter2 = new MouseAdapter(this){
            @Nullable
            private Point lastPoint;
            final /* synthetic */ HTreeChart<N> this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseMoved(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Point point = e.getPoint();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"e.point");
                N node = this.this$0.getNodeAt(point);
                if (node != this.this$0.getFocusedNode()) {
                    HTreeChart.access$setDataUpdated$p(this.this$0, true);
                    this.this$0.setFocusedNode(node);
                    HTreeChart.access$eventSourceRepaint(this.this$0, e);
                }
            }

            public void mouseClicked(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!this.this$0.hasFocus()) {
                    this.this$0.requestFocusInWindow();
                }
            }

            public void mousePressed(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.lastPoint = e.getPoint();
            }

            public void mouseDragged(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int n = e.getPoint().y;
                Point point = this.lastPoint;
                Intrinsics.checkNotNull((Object)point);
                double deltaY = n - point.y;
                this.shiftYRange(this.this$0.getOrientation() == Orientation.BOTTOM_UP ? deltaY : -deltaY);
                int n2 = e.getPoint().x;
                Point point2 = this.lastPoint;
                Intrinsics.checkNotNull((Object)point2);
                double deltaX = n2 - point2.x;
                double deltaXToShift = HTreeChart.access$getXRange$p(this.this$0).getLength() / (double)this.this$0.getWidth() * -deltaX;
                if (deltaXToShift > 0.0) {
                    deltaXToShift = Math.min(HTreeChart.access$getGlobalXRange$p(this.this$0).getMax() - HTreeChart.access$getXRange$p(this.this$0).getMax(), deltaXToShift);
                } else if (deltaXToShift < 0.0) {
                    deltaXToShift = Math.max(HTreeChart.access$getGlobalXRange$p(this.this$0).getMin() - HTreeChart.access$getXRange$p(this.this$0).getMin(), deltaXToShift);
                }
                HTreeChart.access$getXRange$p(this.this$0).shift(deltaXToShift);
                this.lastPoint = e.getPoint();
            }

            private final void shiftYRange(double deltaY) {
                double deltaY2 = deltaY;
                int contentHeight = this.this$0.getMaximumHeight();
                int viewHeight = this.this$0.getHeight();
                if (this.this$0.getYRange().getMin() + deltaY2 < 0.0) {
                    deltaY2 = 0.0 - this.this$0.getYRange().getMin();
                } else if (this.this$0.getYRange().getMin() + (double)viewHeight + deltaY2 > (double)contentHeight) {
                    deltaY2 = Math.max(0.0, (double)(contentHeight - viewHeight) - this.this$0.getYRange().getMin());
                }
                this.this$0.getYRange().shift(deltaY2);
            }

            public void mouseWheelMoved(@NotNull MouseWheelEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (AdtUiUtils.isActionKeyDown(e)) {
                    double cursorRange = HTreeChart.access$positionToRange(this.this$0, e.getX());
                    double leftDelta = (cursorRange - HTreeChart.access$getXRange$p(this.this$0).getMin()) / (double)20 * (double)e.getWheelRotation();
                    double rightDelta = (HTreeChart.access$getXRange$p(this.this$0).getMax() - cursorRange) / (double)20 * (double)e.getWheelRotation();
                    HTreeChart.access$getXRange$p(this.this$0).set(Math.max(HTreeChart.access$getGlobalXRange$p(this.this$0).getMin(), HTreeChart.access$getXRange$p(this.this$0).getMin() - leftDelta), Math.min(HTreeChart.access$getGlobalXRange$p(this.this$0).getMax(), HTreeChart.access$getXRange$p(this.this$0).getMax() + rightDelta));
                } else {
                    double deltaY = e.getPreciseWheelRotation() * (double)8;
                    this.shiftYRange(this.this$0.getOrientation() == Orientation.TOP_DOWN ? deltaY : -deltaY);
                }
            }
        };
        this.addMouseWheelListener(adapter2);
        this.addMouseListener(adapter2);
        this.addMouseMotionListener(adapter2);
    }

    private final int calculateMaximumHeight() {
        if (this.root == null) {
            return 0;
        }
        int maxDepth = -1;
        Queue queue = new LinkedList();
        queue.add(this.root);
        while (!queue.isEmpty()) {
            Object e = queue.poll();
            Intrinsics.checkNotNull(e);
            HNode n = (HNode)e;
            if (n.getDepth() > maxDepth) {
                maxDepth = n.getDepth();
            }
            int n2 = n.getChildCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                queue.add(n.getChildAt(i2));
            }
        }
        return (this.getNodeHeight() + this.nodeYPaddingPx) * ++maxDepth + 15;
    }

    private static final <N extends HNode<N>> void initializeInputMap$bindKey(HTreeChart<N> this$0, int key, String action) {
        this$0.getInputMap().put(KeyStroke.getKeyStroke(key, 0), action);
    }

    private static final <N extends HNode<N>> void initializeInputMap$bindMovementAction(HTreeChart<N> this$0, String action, Function1<? super Double, Unit> perform) {
        this$0.getActionMap().put(action, new AbstractAction(perform, this$0){
            final /* synthetic */ Function1<Double, Unit> $perform;
            final /* synthetic */ HTreeChart<N> this$0;
            {
                this.$perform = $perform;
                this.this$0 = $receiver;
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$perform.invoke((Object)(HTreeChart.access$getXRange$p(this.this$0).getLength() / (double)5));
            }
        });
    }

    public static final /* synthetic */ Range access$getXRange$p(HTreeChart $this) {
        return $this.xRange;
    }

    public static final /* synthetic */ Range access$getGlobalXRange$p(HTreeChart $this) {
        return $this.globalXRange;
    }

    public static final /* synthetic */ void access$setDataUpdated$p(HTreeChart $this, boolean bl) {
        $this.dataUpdated = bl;
    }

    public static final /* synthetic */ void access$eventSourceRepaint(HTreeChart $this, ComponentEvent event) {
        $this.eventSourceRepaint(event);
    }

    public static final /* synthetic */ double access$positionToRange(HTreeChart $this, double x) {
        return $this.positionToRange(x);
    }

    public /* synthetic */ HTreeChart(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000*\u000e\b\u0001\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B%\u0012\b\u0010\u0004\u001a\u0004\u0018\u00018\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\u0002\u0010\tJ\f\u00106\u001a\b\u0012\u0004\u0012\u00028\u000107J\u0014\u00108\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u00109\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u0010\u001a\u00020\u0006J\u0014\u0010:\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u0015\u001a\u00020\u0016J\u0014\u0010;\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u001b\u001a\u00020\u000bJ\u0014\u0010<\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u001e\u001a\u00020\u000bJ\u0014\u0010=\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010!\u001a\u00020\"J\u001c\u0010>\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\f\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00010(H\u0007J\u0014\u0010?\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010@\u001a\u00020\u0016R\u001a\u0010\n\u001a\u00020\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\r\"\u0004\b\u001d\u0010\u000fR\u001a\u0010\u001e\u001a\u00020\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\r\"\u0004\b \u0010\u000fR\u001a\u0010!\u001a\u00020\"X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R \u0010'\u001a\b\u0012\u0004\u0012\u00028\u00010(X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0018\u0010\u0004\u001a\u0004\u0018\u00018\u0001X\u0080\u0004\u00a2\u0006\n\n\u0002\u00101\u001a\u0004\b/\u00100R\u001a\u00102\u001a\u00020\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u0018\"\u0004\b4\u0010\u001aR\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u0012\u00a8\u0006A"}, d2={"Lcom/android/tools/adtui/chart/hchart/HTreeChart$Builder;", "N", "Lcom/android/tools/adtui/model/HNode;", "", "root", "xRange", "Lcom/android/tools/adtui/model/Range;", "renderer", "Lcom/android/tools/adtui/chart/hchart/HRenderer;", "(Lcom/android/tools/adtui/model/HNode;Lcom/android/tools/adtui/model/Range;Lcom/android/tools/adtui/chart/hchart/HRenderer;)V", "customNodeHeightPx", "", "getCustomNodeHeightPx$intellij_android_adt_ui", "()I", "setCustomNodeHeightPx$intellij_android_adt_ui", "(I)V", "globalXRange", "getGlobalXRange$intellij_android_adt_ui", "()Lcom/android/tools/adtui/model/Range;", "setGlobalXRange$intellij_android_adt_ui", "(Lcom/android/tools/adtui/model/Range;)V", "nodeSelectionEnabled", "", "getNodeSelectionEnabled$intellij_android_adt_ui", "()Z", "setNodeSelectionEnabled$intellij_android_adt_ui", "(Z)V", "nodeXPaddingPx", "getNodeXPaddingPx$intellij_android_adt_ui", "setNodeXPaddingPx$intellij_android_adt_ui", "nodeYPaddingPx", "getNodeYPaddingPx$intellij_android_adt_ui", "setNodeYPaddingPx$intellij_android_adt_ui", "orientation", "Lcom/android/tools/adtui/chart/hchart/HTreeChart$Orientation;", "getOrientation$intellij_android_adt_ui", "()Lcom/android/tools/adtui/chart/hchart/HTreeChart$Orientation;", "setOrientation$intellij_android_adt_ui", "(Lcom/android/tools/adtui/chart/hchart/HTreeChart$Orientation;)V", "reducer", "Lcom/android/tools/adtui/chart/hchart/HTreeChartReducer;", "getReducer$intellij_android_adt_ui", "()Lcom/android/tools/adtui/chart/hchart/HTreeChartReducer;", "setReducer$intellij_android_adt_ui", "(Lcom/android/tools/adtui/chart/hchart/HTreeChartReducer;)V", "getRenderer$intellij_android_adt_ui", "()Lcom/android/tools/adtui/chart/hchart/HRenderer;", "getRoot$intellij_android_adt_ui", "()Lcom/android/tools/adtui/model/HNode;", "Lcom/android/tools/adtui/model/HNode;", "rootVisible", "getRootVisible$intellij_android_adt_ui", "setRootVisible$intellij_android_adt_ui", "getXRange$intellij_android_adt_ui", "build", "Lcom/android/tools/adtui/chart/hchart/HTreeChart;", "setCustomNodeHeightPx", "setGlobalXRange", "setNodeSelectionEnabled", "setNodeXPaddingPx", "setNodeYPaddingPx", "setOrientation", "setReducer", "setRootVisible", "visible", "intellij.android.adt.ui"})
    public static final class Builder<N extends HNode<N>> {
        @Nullable
        private final N root;
        @NotNull
        private final Range xRange;
        @NotNull
        private final HRenderer<N> renderer;
        @NotNull
        private Orientation orientation;
        @NotNull
        private Range globalXRange;
        private boolean rootVisible;
        private boolean nodeSelectionEnabled;
        @NotNull
        private HTreeChartReducer<N> reducer;
        private int customNodeHeightPx;
        private int nodeXPaddingPx;
        private int nodeYPaddingPx;

        public Builder(@Nullable N root, @NotNull Range xRange, @NotNull HRenderer<N> renderer) {
            Intrinsics.checkNotNullParameter((Object)xRange, (String)"xRange");
            Intrinsics.checkNotNullParameter(renderer, (String)"renderer");
            this.root = root;
            this.xRange = xRange;
            this.renderer = renderer;
            this.orientation = Orientation.TOP_DOWN;
            this.globalXRange = new Range(-1.7976931348623157E308, Double.MAX_VALUE);
            this.rootVisible = true;
            this.reducer = new DefaultHTreeChartReducer();
            this.nodeXPaddingPx = 1;
            this.nodeYPaddingPx = 1;
        }

        @Nullable
        public final N getRoot$intellij_android_adt_ui() {
            return this.root;
        }

        @NotNull
        public final Range getXRange$intellij_android_adt_ui() {
            return this.xRange;
        }

        @NotNull
        public final HRenderer<N> getRenderer$intellij_android_adt_ui() {
            return this.renderer;
        }

        @NotNull
        public final Orientation getOrientation$intellij_android_adt_ui() {
            return this.orientation;
        }

        public final void setOrientation$intellij_android_adt_ui(@NotNull Orientation orientation) {
            Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"<set-?>");
            this.orientation = orientation;
        }

        @NotNull
        public final Range getGlobalXRange$intellij_android_adt_ui() {
            return this.globalXRange;
        }

        public final void setGlobalXRange$intellij_android_adt_ui(@NotNull Range range) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"<set-?>");
            this.globalXRange = range;
        }

        public final boolean getRootVisible$intellij_android_adt_ui() {
            return this.rootVisible;
        }

        public final void setRootVisible$intellij_android_adt_ui(boolean bl) {
            this.rootVisible = bl;
        }

        public final boolean getNodeSelectionEnabled$intellij_android_adt_ui() {
            return this.nodeSelectionEnabled;
        }

        public final void setNodeSelectionEnabled$intellij_android_adt_ui(boolean bl) {
            this.nodeSelectionEnabled = bl;
        }

        @NotNull
        public final HTreeChartReducer<N> getReducer$intellij_android_adt_ui() {
            return this.reducer;
        }

        public final void setReducer$intellij_android_adt_ui(@NotNull HTreeChartReducer<N> hTreeChartReducer) {
            Intrinsics.checkNotNullParameter(hTreeChartReducer, (String)"<set-?>");
            this.reducer = hTreeChartReducer;
        }

        public final int getCustomNodeHeightPx$intellij_android_adt_ui() {
            return this.customNodeHeightPx;
        }

        public final void setCustomNodeHeightPx$intellij_android_adt_ui(int n) {
            this.customNodeHeightPx = n;
        }

        public final int getNodeXPaddingPx$intellij_android_adt_ui() {
            return this.nodeXPaddingPx;
        }

        public final void setNodeXPaddingPx$intellij_android_adt_ui(int n) {
            this.nodeXPaddingPx = n;
        }

        public final int getNodeYPaddingPx$intellij_android_adt_ui() {
            return this.nodeYPaddingPx;
        }

        public final void setNodeYPaddingPx$intellij_android_adt_ui(int n) {
            this.nodeYPaddingPx = n;
        }

        @NotNull
        public final Builder<N> setOrientation(@NotNull Orientation orientation) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
            Builder it = builder = this;
            boolean bl = false;
            this.orientation = orientation;
            return builder;
        }

        @NotNull
        public final Builder<N> setRootVisible(boolean visible) {
            Builder builder;
            Builder it = builder = this;
            boolean bl = false;
            this.rootVisible = visible;
            return builder;
        }

        @NotNull
        public final Builder<N> setNodeSelectionEnabled(boolean nodeSelectionEnabled) {
            Builder builder;
            Builder it = builder = this;
            boolean bl = false;
            this.nodeSelectionEnabled = nodeSelectionEnabled;
            return builder;
        }

        @NotNull
        public final Builder<N> setGlobalXRange(@NotNull Range globalXRange) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)globalXRange, (String)"globalXRange");
            Builder it = builder = this;
            boolean bl = false;
            this.globalXRange = globalXRange;
            return builder;
        }

        @VisibleForTesting
        @NotNull
        public final Builder<N> setReducer(@NotNull HTreeChartReducer<N> reducer) {
            Builder builder;
            Intrinsics.checkNotNullParameter(reducer, (String)"reducer");
            Builder it = builder = this;
            boolean bl = false;
            this.reducer = reducer;
            return builder;
        }

        @NotNull
        public final Builder<N> setCustomNodeHeightPx(int customNodeHeightPx) {
            Builder builder;
            Builder it = builder = this;
            boolean bl = false;
            this.customNodeHeightPx = customNodeHeightPx;
            return builder;
        }

        @NotNull
        public final Builder<N> setNodeXPaddingPx(int nodeXPaddingPx) {
            Builder builder;
            Builder it = builder = this;
            boolean bl = false;
            this.nodeXPaddingPx = nodeXPaddingPx;
            return builder;
        }

        @NotNull
        public final Builder<N> setNodeYPaddingPx(int nodeYPaddingPx) {
            Builder builder;
            Builder it = builder = this;
            boolean bl = false;
            this.nodeYPaddingPx = nodeYPaddingPx;
            return builder;
        }

        @NotNull
        public final HTreeChart<N> build() {
            return new HTreeChart(this, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\u0002R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0011\u0010\u0002R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/adtui/chart/hchart/HTreeChart$Companion;", "", "()V", "ACTION_MOVEMENT_FACTOR", "", "ACTION_MOVE_LEFT", "", "ACTION_MOVE_RIGHT", "ACTION_ZOOM_IN", "ACTION_ZOOM_OUT", "HEIGHT_PADDING", "getHEIGHT_PADDING$annotations", "INITIAL_Y_POSITION", "MOUSE_WHEEL_SCROLL_FACTOR", "NO_HTREE", "NO_RANGE", "PADDING", "getPADDING$annotations", "ZOOM_FACTOR", "intellij.android.adt.ui"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getPADDING$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getHEIGHT_PADDING$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/adtui/chart/hchart/HTreeChart$Orientation;", "", "(Ljava/lang/String;I)V", "TOP_DOWN", "BOTTOM_UP", "intellij.android.adt.ui"})
    public static final class Orientation
    extends Enum<Orientation> {
        public static final /* enum */ Orientation TOP_DOWN = new Orientation();
        public static final /* enum */ Orientation BOTTOM_UP = new Orientation();
        private static final /* synthetic */ Orientation[] $VALUES;

        public static Orientation[] values() {
            return (Orientation[])$VALUES.clone();
        }

        public static Orientation valueOf(String value) {
            return Enum.valueOf(Orientation.class, value);
        }

        static {
            $VALUES = orientationArray = new Orientation[]{Orientation.TOP_DOWN, Orientation.BOTTOM_UP};
        }
    }
}

