/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.hchart;

import com.android.tools.adtui.RangeScrollBarUI;
import com.android.tools.adtui.chart.hchart.HTreeChart;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.HNode;
import com.android.tools.adtui.model.Range;
import com.intellij.ui.components.JBScrollBar;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.plaf.ScrollBarUI;
import org.jetbrains.annotations.NotNull;

public class HTreeChartVerticalScrollBar<N extends HNode<N>>
extends JBScrollBar {
    private boolean myUpdating;
    private final AspectObserver myObserver;
    @NotNull
    private final HTreeChart<N> myChart;

    public HTreeChartVerticalScrollBar(@NotNull HTreeChart<N> chart) {
        if (chart == null) {
            HTreeChartVerticalScrollBar.$$$reportNull$$$0(0);
        }
        super(1);
        this.myChart = chart;
        this.setPreferredSize(new Dimension(10, this.getPreferredSize().height));
        this.setUI((ScrollBarUI)((Object)new RangeScrollBarUI()));
        this.addAdjustmentListener(e -> this.updateYRange());
        this.myObserver = new AspectObserver();
        chart.getYRange().addDependency(this.myObserver).onChange(Range.Aspect.RANGE, this::updateValues);
        this.updateValues();
        chart.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                HTreeChartVerticalScrollBar.this.updateValues();
            }
        });
    }

    private void updateValues() {
        this.myUpdating = true;
        double value = this.myChart.getOrientation() == HTreeChart.Orientation.TOP_DOWN ? (double)((int)this.myChart.getYRange().getMin()) : (double)this.myChart.getMaximumHeight() - this.myChart.getYRange().getMin() - (double)this.myChart.getHeight();
        this.setValues((int)value, this.myChart.getHeight(), 0, this.myChart.getMaximumHeight());
        this.myUpdating = false;
    }

    private void updateYRange() {
        if (this.myUpdating) {
            return;
        }
        int offset = this.myChart.getOrientation() == HTreeChart.Orientation.BOTTOM_UP ? this.getMaximum() - (this.getValue() + this.getVisibleAmount()) : this.getValue();
        this.myChart.getYRange().set(offset, offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chart", "com/android/tools/adtui/chart/hchart/HTreeChartVerticalScrollBar", "<init>"));
    }
}

