/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.statechart;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.chart.statechart.DefaultStateChartReducer;
import com.android.tools.adtui.chart.statechart.StateChartColorProvider;
import com.android.tools.adtui.chart.statechart.StateChartConfig;
import com.android.tools.adtui.chart.statechart.StateChartKt;
import com.android.tools.adtui.chart.statechart.StateChartTextConverter;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.adtui.model.Stopwatch;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MouseEventHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import javax.swing.JList;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 P*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001PB3\b\u0017\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0002\u0010\nBA\b\u0017\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0002\u0010\rB)\b\u0017\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010\u0011B\u00a4\u0001\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u007f\u0010\u0012\u001a{\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u001b\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u001f0\u0013j\b\u0012\u0004\u0012\u00028\u0000` \u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0002\u0010!J\u0014\u0010<\u001a\u00020\u001f2\f\u0010=\u001a\b\u0012\u0004\u0012\u00028\u000000J\u000e\u0010>\u001a\u00020\u001f2\u0006\u0010?\u001a\u000206J\u0018\u0010@\u001a\u00020\u001f2\u0006\u0010A\u001a\u00020\u00142\u0006\u0010B\u001a\u00020CH\u0014J\u0012\u0010D\u001a\u0004\u0018\u00010\u00182\u0006\u0010E\u001a\u000208H\u0002J\u0017\u0010F\u001a\u0004\u0018\u00018\u00002\u0006\u00107\u001a\u000208H\u0007\u00a2\u0006\u0002\u0010GJ\b\u0010H\u001a\u00020\u001fH\u0002J\u001a\u0010I\u001a\u00020\u001f2\b\u0010J\u001a\u0004\u0018\u00010\u00022\u0006\u0010K\u001a\u000208H\u0002J\u001e\u0010L\u001a\u0010\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020*\u0018\u0001042\u0006\u00107\u001a\u000208H\u0007J\u0017\u0010M\u001a\u0004\u0018\u00010*2\u0006\u00107\u001a\u000208H\u0002\u00a2\u0006\u0002\u0010NJ\b\u0010O\u001a\u00020\u001fH\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010$\u001a\u00020#2\u0006\u0010\"\u001a\u00020#@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001e\u0010+\u001a\u00020*2\u0006\u0010)\u001a\u00020*@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u0000000/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u00102\u001a \u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001803\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u0000030403X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0087\u0001\u0010\u0012\u001a{\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u001b\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u001f0\u0013j\b\u0012\u0004\u0012\u00028\u0000` X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00105\u001a\b\u0012\u0004\u0012\u0002060/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u00109\u001a\u0004\u0018\u0001082\b\u00107\u001a\u0004\u0018\u000108@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b:\u0010;\u00a8\u0006Q"}, d2={"Lcom/android/tools/adtui/chart/statechart/StateChart;", "T", "", "Lcom/android/tools/adtui/AnimatedComponent;", "model", "Lcom/android/tools/adtui/model/StateChartModel;", "colorProvider", "Lcom/android/tools/adtui/chart/statechart/StateChartColorProvider;", "config", "Lcom/android/tools/adtui/chart/statechart/StateChartConfig;", "(Lcom/android/tools/adtui/model/StateChartModel;Lcom/android/tools/adtui/chart/statechart/StateChartColorProvider;Lcom/android/tools/adtui/chart/statechart/StateChartConfig;)V", "textConverter", "Lcom/android/tools/adtui/chart/statechart/StateChartTextConverter;", "(Lcom/android/tools/adtui/model/StateChartModel;Lcom/android/tools/adtui/chart/statechart/StateChartColorProvider;Lcom/android/tools/adtui/chart/statechart/StateChartTextConverter;Lcom/android/tools/adtui/chart/statechart/StateChartConfig;)V", "colors", "", "Ljava/awt/Color;", "(Lcom/android/tools/adtui/model/StateChartModel;Ljava/util/Map;)V", "render", "Lkotlin/Function5;", "Ljava/awt/Graphics2D;", "Lkotlin/ParameterName;", "name", "g", "Ljava/awt/geom/Rectangle2D$Float;", "boundary", "Ljava/awt/FontMetrics;", "defaultFontMetrics", "", "hoverred", "value", "", "Lcom/android/tools/adtui/chart/statechart/Renderer;", "(Lcom/android/tools/adtui/model/StateChartModel;Lkotlin/jvm/functions/Function5;Lcom/android/tools/adtui/chart/statechart/StateChartConfig;)V", "gap", "", "heightGap", "getHeightGap", "()F", "setHeightGap", "(F)V", "index", "", "hoveredSeriesIndex", "setHoveredSeriesIndex", "(I)V", "itemClickedListeners", "", "Ljava/util/function/Consumer;", "needsTransformToViewSpace", "rectangleCache", "", "Lkotlin/Pair;", "rowIndexChangeListeners", "Ljava/util/function/IntConsumer;", "point", "Ljava/awt/Point;", "rowPoint", "setRowPoint", "(Ljava/awt/Point;)V", "addItemClickedListener", "onClicked", "addRowIndexChangeListener", "onNewRowIndex", "draw", "g2d", "dim", "Ljava/awt/Dimension;", "getMouseRectanglesUnion", "mousePoint", "itemAtMouse", "(Ljava/awt/Point;)Ljava/lang/Object;", "registerMouseEvents", "renderUnion", "container", "containerOffset", "seriesIndexAtMouse", "seriesIndexAtPoint", "(Ljava/awt/Point;)Ljava/lang/Integer;", "transformToViewSpace", "Companion", "intellij.android.adt.ui"})
@SourceDebugExtension(value={"SMAP\nStateChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateChart.kt\ncom/android/tools/adtui/chart/statechart/StateChart\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,458:1\n1#2:459\n1855#3,2:460\n1559#3:462\n1590#3,4:463\n1864#3,2:467\n1620#3,3:469\n1620#3,3:472\n1855#3,2:475\n1866#3:477\n*S KotlinDebug\n*F\n+ 1 StateChart.kt\ncom/android/tools/adtui/chart/statechart/StateChart\n*L\n89#1:460,2\n148#1:462\n148#1:463,4\n208#1:467,2\n227#1:469,3\n228#1:472,3\n246#1:475,2\n208#1:477\n*E\n"})
public final class StateChart<T>
extends AnimatedComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StateChartModel<T> model;
    @NotNull
    private final Function5<Graphics2D, Rectangle2D.Float, FontMetrics, Boolean, T, Unit> render;
    @NotNull
    private final StateChartConfig<T> config;
    private float heightGap;
    private boolean needsTransformToViewSpace;
    @NotNull
    private List<? extends Pair<? extends List<? extends Rectangle2D.Float>, ? extends List<? extends T>>> rectangleCache;
    @Nullable
    private Point rowPoint;
    private int hoveredSeriesIndex;
    @NotNull
    private final List<Consumer<T>> itemClickedListeners;
    @NotNull
    private final List<IntConsumer> rowIndexChangeListeners;
    private static final int INVALID_INDEX = -1;
    private static final int TEXT_PADDING = 3;
    private static final int PREFERRED_ROW_HEIGHT = 27;

    public StateChart(@NotNull StateChartModel<T> model2, @NotNull Function5<? super Graphics2D, ? super Rectangle2D.Float, ? super FontMetrics, ? super Boolean, ? super T, Unit> render, @NotNull StateChartConfig<T> config) {
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        Intrinsics.checkNotNullParameter(render, (String)"render");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        this.model = model2;
        this.render = render;
        this.config = config;
        this.heightGap = this.config.getHeightGap();
        this.needsTransformToViewSpace = true;
        this.rectangleCache = CollectionsKt.emptyList();
        this.hoveredSeriesIndex = -1;
        this.itemClickedListeners = new ArrayList();
        this.rowIndexChangeListeners = new ArrayList();
        this.setFont((Font)AdtUiUtils.DEFAULT_FONT);
        this.model.addDependency(this.myAspectObserver).onChange((Enum)StateChartModel.Aspect.MODEL_CHANGED, () -> StateChart._init_$modelChanged(this));
        StateChart._init_$modelChanged(this);
        this.registerMouseEvents();
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, JBUI.scale((int)27) * this.model.getSeries().size()));
    }

    public /* synthetic */ StateChart(StateChartModel stateChartModel, Function5 function5, StateChartConfig stateChartConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            stateChartConfig = StateChart.Companion.defaultConfig();
        }
        this(stateChartModel, function5, stateChartConfig);
    }

    public final float getHeightGap() {
        return this.heightGap;
    }

    public final void setHeightGap(float gap) {
        this.heightGap = Math.max(Math.min(gap, 1.0f), 0.0f);
    }

    /*
     * Unable to fully structure code
     */
    private final void setRowPoint(Point point) {
        this.rowPoint = point;
        v0 = this;
        v1 = point;
        if (v1 == null) ** GOTO lbl-1000
        var2_2 = v1;
        var4_3 = v0;
        $i$a$-let-StateChart$rowPoint$1 = false;
        v2 = this.seriesIndexAtPoint((Point)p0);
        v0 = var4_3;
        v1 = v2;
        if (v2 != null) {
            v3 = v1.intValue();
        } else lbl-1000:
        // 2 sources

        {
            v3 = -1;
        }
        v0.setHoveredSeriesIndex(v3);
    }

    private final void setHoveredSeriesIndex(int index) {
        if (this.hoveredSeriesIndex != index) {
            this.hoveredSeriesIndex = index;
            Iterable $this$forEach$iv = this.rowIndexChangeListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IntConsumer it = (IntConsumer)element$iv;
                boolean bl = false;
                it.accept(index);
            }
        }
    }

    @JvmOverloads
    public StateChart(@NotNull StateChartModel<T> model2, @NotNull StateChartColorProvider<T> colorProvider, @NotNull StateChartConfig<T> config) {
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        Intrinsics.checkNotNullParameter(colorProvider, (String)"colorProvider");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        this(model2, StateChart.Companion.fillRectRenderer(colorProvider), config);
    }

    public /* synthetic */ StateChart(StateChartModel stateChartModel, StateChartColorProvider stateChartColorProvider, StateChartConfig stateChartConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            stateChartConfig = StateChart.Companion.defaultConfig();
        }
        this(stateChartModel, stateChartColorProvider, stateChartConfig);
    }

    @JvmOverloads
    public StateChart(@NotNull StateChartModel<T> model2, @NotNull StateChartColorProvider<T> colorProvider, @NotNull StateChartTextConverter<T> textConverter, @NotNull StateChartConfig<T> config) {
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        Intrinsics.checkNotNullParameter(colorProvider, (String)"colorProvider");
        Intrinsics.checkNotNullParameter(textConverter, (String)"textConverter");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        this(model2, StateChart.Companion.fillRectAndTextRenderer(colorProvider, textConverter), config);
    }

    public /* synthetic */ StateChart(StateChartModel stateChartModel, StateChartColorProvider stateChartColorProvider, StateChartTextConverter stateChartTextConverter, StateChartConfig stateChartConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            stateChartConfig = StateChart.Companion.defaultConfig();
        }
        this(stateChartModel, stateChartColorProvider, stateChartTextConverter, stateChartConfig);
    }

    @VisibleForTesting
    public StateChart(@NotNull StateChartModel<T> model2, final @NotNull Map<T, ? extends Color> colors) {
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        this(model2, new StateChartColorProvider<T>(){

            /*
             * WARNING - void declaration
             */
            @Override
            @NotNull
            public Color getColor(boolean isMouseOver, @NotNull T value) {
                void var3_3;
                Intrinsics.checkNotNullParameter(value, (String)"value");
                Color color = colors.get(value);
                Intrinsics.checkNotNull((Object)color);
                Color it = color;
                boolean bl = false;
                Object object = isMouseOver ? ColorUtil.brighter((Color)it, (int)2) : var3_3;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"colors[value]!!.let {\n  \u2026er(it, 2) else it\n      }");
                return object;
            }
        }, null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void transformToViewSpace() {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        if (!this.needsTransformToViewSpace) {
            return;
        }
        this.needsTransformToViewSpace = false;
        List<RangedSeries<T>> series = this.model.getSeries();
        int seriesSize = series.size();
        if (seriesSize == 0) {
            return;
        }
        float rectHeight = 1.0f / (float)seriesSize;
        float gap = rectHeight * this.heightGap;
        float barHeight = rectHeight - gap;
        Intrinsics.checkNotNullExpressionValue(series, (String)"series");
        Iterable iterable = series;
        StateChart stateChart = this;
        boolean $i$f$mapIndexed = false;
        void var8_9 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void seriesIndex;
            void data;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            RangedSeries rangedSeries = (RangedSeries)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            double min = data.getXRange().getMin();
            double max = data.getXRange().getMax();
            double invRange = 1.0 / (max - min);
            double startHeight = 1.0 - (double)(rectHeight * (float)(seriesIndex + true));
            double barY = startHeight + (double)(gap * 0.5f);
            List seriesDataList = data.getSeries();
            List rectangles = new ArrayList();
            List rectangleValues = new ArrayList();
            if (!((Collection)seriesDataList).isEmpty()) {
                double previousX = seriesDataList.get((int)0).x;
                Object previousValue = seriesDataList.get((int)0).value;
                for (SeriesData seriesData : seriesDataList.subList(1, seriesDataList.size())) {
                    long x = seriesData.component1();
                    Object value = seriesData.component2();
                    if (Intrinsics.areEqual(value, previousValue)) continue;
                    if ((double)x >= min) {
                        Object object = previousValue;
                        Intrinsics.checkNotNullExpressionValue(object, (String)"previousValue");
                        StateChart.transformToViewSpace$lambda$1$addRectangleDelta(rectangles, min, invRange, barY, barHeight, rectangleValues, object, previousX, x);
                    }
                    previousValue = value;
                    previousX = x;
                    if (!(previousX >= max)) continue;
                }
                if (previousX < max && previousValue != null) {
                    StateChart.transformToViewSpace$lambda$1$addRectangleDelta(rectangles, min, invRange, barY, barHeight, rectangleValues, previousValue, Math.max(min, previousX), max);
                }
            }
            collection.add(TuplesKt.to((Object)rectangles, (Object)rectangleValues));
        }
        stateChart.rectangleCache = (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void draw(@NotNull Graphics2D g2d, @NotNull Dimension dim) {
        Intrinsics.checkNotNullParameter((Object)g2d, (String)"g2d");
        Intrinsics.checkNotNullParameter((Object)dim, (String)"dim");
        Stopwatch stopwatch = new Stopwatch().start();
        Intrinsics.checkNotNullExpressionValue((Object)stopwatch, (String)"Stopwatch().start()");
        Stopwatch stopwatch2 = stopwatch;
        long scalingTime = 0L;
        long reducerTime = 0L;
        int transformedShapesCount = 0;
        this.transformToViewSpace();
        long transformTime = stopwatch2.getElapsedSinceLastDeltaNs();
        g2d.setFont(this.getFont());
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        float scaleX = this.getWidth();
        float scaleY = this.getHeight();
        Rectangle clipRect = g2d.getClipBounds();
        Iterable $this$forEachIndexed$iv = this.rectangleCache;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            String destination$iv;
            void $this$mapTo$iv;
            void var30_43;
            Iterable destination$iv2;
            Object item$iv22;
            void $this$mapTo$iv2;
            int n2;
            int n3;
            int n4;
            if ((n4 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pair pair = (Pair)item$iv;
            int seriesIndex = n4;
            boolean bl = false;
            List rectangles = (List)pair.component1();
            List rectangleValues = (List)pair.component2();
            if (clipRect != null && clipRect.x != 0) {
                int it = StateChart.draw$lambda$8$searchByX(rectangles, (float)clipRect.x / scaleX, 0.0f);
                boolean bl2 = false;
                n3 = it < 0 ? -(it + 1) : it;
            } else {
                n3 = 0;
            }
            int startIndexInclusive = n3;
            if (clipRect != null && clipRect.width != this.getWidth()) {
                int it = StateChart.draw$lambda$8$searchByX(rectangles, (float)(clipRect.x + clipRect.width) / scaleX, 0.0f);
                boolean bl3 = false;
                n2 = it < 0 ? -(it + 1) : it + 1;
            } else {
                n2 = rectangles.size();
            }
            int endIndexExclusive = n2;
            Iterable it = rectangleValues.subList(startIndexInclusive, endIndexExclusive);
            Collection bl3 = new ArrayList();
            boolean $i$f$mapTo22 = false;
            for (Object item$iv22 : $this$mapTo$iv2) {
                void it2;
                Object t = item$iv22;
                var30_43 = destination$iv2;
                boolean bl4 = false;
                var30_43.add(it2);
            }
            List transformedValues = (List)destination$iv2;
            destination$iv2 = rectangles.subList(startIndexInclusive, endIndexExclusive);
            Collection $i$f$mapTo22 = new ArrayList();
            boolean $i$f$mapTo = false;
            item$iv22 = $this$mapTo$iv.iterator();
            while (item$iv22.hasNext()) {
                void it3;
                Object item$iv3 = item$iv22.next();
                Rectangle2D.Float bl4 = (Rectangle2D.Float)item$iv3;
                var30_43 = destination$iv;
                boolean bl5 = false;
                var30_43.add(new Rectangle2D.Float(it3.x * scaleX, it3.y * scaleY, it3.width * scaleX, it3.height * scaleY));
            }
            List transformedShapes = (List)((Object)destination$iv);
            transformedShapesCount += transformedShapes.size();
            scalingTime += stopwatch2.getElapsedSinceLastDeltaNs();
            this.config.getReducer().reduce(transformedShapes, transformedValues);
            boolean bl6 = $this$mapTo$iv = transformedShapes.size() == transformedValues.size();
            if (_Assertions.ENABLED && !$this$mapTo$iv) {
                destination$iv = "Assertion failed";
                throw new AssertionError((Object)destination$iv);
            }
            reducerTime += stopwatch2.getElapsedSinceLastDeltaNs();
            if (seriesIndex != this.hoveredSeriesIndex || this.rowPoint == null) {
                n = -1;
            } else {
                Point point = this.rowPoint;
                Intrinsics.checkNotNull((Object)point);
                float it4 = point.x;
                boolean bl7 = false;
                n = StateChart.draw$lambda$8$searchByX(transformedShapes, it4, 1.0f);
            }
            int hoverIndex = n;
            Iterable $this$forEach$iv = (Iterable)CollectionsKt.getIndices((Collection)transformedShapes);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Shape shape;
                int element$iv;
                int it5 = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl8 = false;
                Rectangle2D.Float rect = (Rectangle2D.Float)transformedShapes.get(it5);
                if (0.0f <= rect.x && rect.x + rect.width <= (float)this.getWidth()) {
                    shape = rect;
                } else {
                    float x = Math.max(0.0f, rect.x);
                    float w = Math.min(scaleX - x, rect.width);
                    shape = new Rectangle2D.Float(x, rect.y, w, rect.height);
                }
                g2d.setClip(shape);
                FontMetrics fontMetrics = this.mDefaultFontMetrics;
                Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"mDefaultFontMetrics");
                this.render.invoke((Object)g2d, (Object)rect, (Object)fontMetrics, (Object)(it5 == hoverIndex ? 1 : 0), transformedValues.get(it5));
            }
        }
        long drawTime = stopwatch2.getElapsedSinceLastDeltaNs();
        Object[] objectArray = new Object[]{Float.valueOf((float)transformTime / 1000000.0f), Float.valueOf((float)scalingTime / 1000000.0f)};
        this.addDebugInfo("XS ms: %.2fms, %.2fms", objectArray);
        objectArray = new Object[]{Float.valueOf((float)reducerTime / 1000000.0f), Float.valueOf((float)drawTime / 1000000.0f), Float.valueOf((float)(scalingTime + reducerTime + drawTime) / 1000000.0f)};
        this.addDebugInfo("RDT ms: %.2f, %.2f, %.2f", objectArray);
        objectArray = new Object[]{transformedShapesCount};
        this.addDebugInfo("# of drawn rects: %d", objectArray);
    }

    public final void addItemClickedListener(@NotNull Consumer<T> onClicked) {
        Intrinsics.checkNotNullParameter(onClicked, (String)"onClicked");
        this.itemClickedListeners.add(onClicked);
    }

    public final void addRowIndexChangeListener(@NotNull IntConsumer onNewRowIndex) {
        Intrinsics.checkNotNullParameter((Object)onNewRowIndex, (String)"onNewRowIndex");
        this.rowIndexChangeListeners.add(onNewRowIndex);
    }

    private final void registerMouseEvents() {
        Ref.ObjectRef mouseEventSource = new Ref.ObjectRef();
        Ref.ObjectRef mousePoint = new Ref.ObjectRef();
        Ref.IntRef rowIndex = new Ref.IntRef();
        rowIndex.element = -1;
        MouseEventHandler handler2 = new MouseEventHandler(this, (Ref.ObjectRef<Point>)mousePoint, rowIndex, (Ref.ObjectRef<Object>)mouseEventSource){
            final /* synthetic */ StateChart<T> this$0;
            final /* synthetic */ Ref.ObjectRef<Point> $mousePoint;
            final /* synthetic */ Ref.IntRef $rowIndex;
            final /* synthetic */ Ref.ObjectRef<Object> $mouseEventSource;
            {
                this.this$0 = $receiver;
                this.$mousePoint = $mousePoint;
                this.$rowIndex = $rowIndex;
                this.$mouseEventSource = $mouseEventSource;
            }

            /*
             * WARNING - void declaration
             */
            protected void handle(@NotNull MouseEvent event) {
                Object it;
                Object object;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getID() == 500) {
                    Point point = event.getPoint();
                    Intrinsics.checkNotNullExpressionValue((Object)point, (String)"event.point");
                    T t = this.this$0.itemAtMouse(point);
                    if (t != null) {
                        T t2 = t;
                        StateChart<T> stateChart = this.this$0;
                        T it2 = t2;
                        boolean bl = false;
                        Iterable $this$forEach$iv = StateChart.access$getItemClickedListeners$p(stateChart);
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            Consumer handler2 = (Consumer)element$iv;
                            boolean bl2 = false;
                            handler2.accept(it2);
                        }
                    }
                    return;
                }
                if (Intrinsics.areEqual((Object)event.getPoint(), (Object)this.$mousePoint.element)) {
                    return;
                }
                Object src = event.getSource();
                if (this.$rowIndex.element != -1) {
                    Object oldRowOriginInEventSpace;
                    Object object2 = oldRowOriginInEventSpace = src instanceof JList ? ((JList)src).getUI().indexToLocation((JList)src, this.$rowIndex.element) : new Object(0, 0);
                    if (object2 != null) {
                        Object object3 = object2;
                        StateChart<T> stateChart = this.this$0;
                        object = this.$mouseEventSource;
                        it = object3;
                        boolean bl = false;
                        StateChart.access$renderUnion(stateChart, object.element, (Point)it);
                    }
                }
                if (event.getID() == 505) {
                    this.$mousePoint.element = null;
                    StateChart.access$setRowPoint(this.this$0, null);
                    this.$mouseEventSource.element = null;
                    this.$rowIndex.element = -1;
                } else {
                    Point rowOrigin = null;
                    rowOrigin = new Point(0, 0);
                    Point eventPoint = event.getPoint();
                    this.$mousePoint.element = eventPoint;
                    this.$mouseEventSource.element = src;
                    if (src instanceof JList) {
                        void $this$handle_u24lambda_u243;
                        this.$rowIndex.element = ((JList)src).getUI().locationToIndex((JList)src, eventPoint);
                        if (this.$rowIndex.element >= 0) {
                            Point point = ((JList)src).getUI().indexToLocation((JList)src, this.$rowIndex.element);
                            Intrinsics.checkNotNull((Object)point);
                            rowOrigin = point;
                        }
                        it = object = new Point(eventPoint);
                        StateChart<T> stateChart = this.this$0;
                        boolean bl = false;
                        $this$handle_u24lambda_u243.translate(-rowOrigin.x, -rowOrigin.y);
                        StateChart.access$setRowPoint(stateChart, object);
                    } else {
                        this.$rowIndex.element = 0;
                        StateChart.access$setRowPoint(this.this$0, eventPoint);
                    }
                    if (this.$rowIndex.element != -1) {
                        StateChart.access$renderUnion(this.this$0, this.$mouseEventSource.element, rowOrigin);
                    }
                }
            }
        };
        this.addMouseListener((MouseListener)handler2);
        this.addMouseMotionListener((MouseMotionListener)handler2);
    }

    @VisibleForTesting
    @Nullable
    public final T itemAtMouse(@NotNull Point point) {
        Object v2;
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Pair<Integer, Integer> pair = this.seriesIndexAtMouse(point);
        if (pair != null) {
            Pair<Integer, Integer> pair2 = pair;
            boolean bl = false;
            int seriesIndex = ((Number)pair2.component1()).intValue();
            int i2 = ((Number)pair2.component2()).intValue();
            SeriesData seriesData = (SeriesData)StateChartKt.access$getOrNull(this.model.getSeries().get(seriesIndex).getSeries(), i2);
            v2 = seriesData != null ? seriesData.value : null;
        } else {
            v2 = null;
        }
        return v2;
    }

    @VisibleForTesting
    @Nullable
    public final Pair<Integer, Integer> seriesIndexAtMouse(@NotNull Point point) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        List<RangedSeries<T>> series = this.model.getSeries();
        if (series.isEmpty()) {
            return null;
        }
        double scaleX = this.getWidth();
        Integer n = this.seriesIndexAtPoint(point);
        if (n != null) {
            int i2;
            int seriesIndex = ((Number)n).intValue();
            boolean bl = false;
            RangedSeries<T> seriesAtMouse = series.get(seriesIndex);
            List<SeriesData<T>> seriesData = seriesAtMouse.getSeries();
            double min = seriesAtMouse.getXRange().getMin();
            double max = seriesAtMouse.getXRange().getMax();
            double range = max - min;
            double modelMouseX = (double)point.x / scaleX * range + min;
            pair = seriesData.isEmpty() ? null : TuplesKt.to((Object)seriesIndex, (Object)((0 <= (i2 = CollectionsKt.binarySearch$default(seriesData, (int)0, (int)0, (Function1)new Function1<SeriesData<T>, Integer>(modelMouseX){
                final /* synthetic */ double $modelMouseX;
                {
                    this.$modelMouseX = $modelMouseX;
                    super(1);
                }

                @NotNull
                public final Integer invoke(@NotNull SeriesData<T> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return Double.compare(it.x, this.$modelMouseX);
                }
            }, (int)3, null)) ? i2 < seriesData.size() : false) ? i2 : -i2 - 1 - 1));
        } else {
            pair = null;
        }
        return pair;
    }

    private final Integer seriesIndexAtPoint(Point point) {
        Integer n;
        float normalizedY = 1.0f - (float)point.y / (float)this.getHeight();
        boolean bl = false;
        int n2 = this.model.getSeries().size();
        int i2 = (int)(normalizedY * (float)n2);
        int tolerancePixels = 2;
        boolean bl2 = 0 <= i2 ? i2 < n2 : false;
        if (bl2) {
            n = i2;
        } else {
            int n3 = this.getHeight();
            int n4 = this.getHeight() + tolerancePixels;
            int n5 = point.y;
            n = (n3 <= n5 ? n5 <= n4 : false) ? Integer.valueOf(0) : (((n3 = -tolerancePixels) <= (n4 = point.y) ? n4 < 1 : false) ? Integer.valueOf(n2 - 1) : null);
        }
        return n;
    }

    private final void renderUnion(Object container, Point containerOffset) {
        block1: {
            if (this.rowPoint == null || !(container instanceof Component)) break block1;
            Point point = this.rowPoint;
            Intrinsics.checkNotNull((Object)point);
            Rectangle2D.Float float_ = this.getMouseRectanglesUnion(point);
            if (float_ != null) {
                Rectangle2D.Float union = float_;
                boolean bl = false;
                ((Component)container).repaint((int)union.x + containerOffset.x, (int)union.y + containerOffset.y, (int)Math.ceil(union.width), (int)Math.ceil(union.height));
            }
        }
    }

    private final Rectangle2D.Float getMouseRectanglesUnion(Point mousePoint) {
        Rectangle2D.Float float_;
        Pair<Integer, Integer> pair = this.seriesIndexAtMouse(mousePoint);
        if (pair != null) {
            Pair<Integer, Integer> pair2 = pair;
            boolean bl = false;
            int seriesIndex = ((Number)pair2.component1()).intValue();
            int i2 = ((Number)pair2.component2()).intValue();
            RangedSeries<T> series = this.model.getSeries().get(seriesIndex);
            List<SeriesData<T>> seriesDataList = series.getSeries();
            double min = series.getXRange().getMin();
            double max = series.getXRange().getMax();
            double range = max - min;
            int seriesSize = this.model.getSeries().size();
            double scaleX = this.getWidth();
            double scaleY = this.getHeight();
            SeriesData seriesData = (SeriesData)StateChartKt.access$getOrNull(seriesDataList, i2);
            double modelXLeft = seriesData != null ? (double)seriesData.x : min;
            SeriesData seriesData2 = (SeriesData)StateChartKt.access$getOrNull(seriesDataList, i2 + 1);
            double modelXRight = seriesData2 != null ? (double)seriesData2.x : max;
            double screenXLeft = Math.floor((modelXLeft - min) * scaleX / range);
            double screenYTop = Math.floor(scaleY - (double)(seriesIndex + 1) * scaleY / (double)seriesSize);
            double screenXRight = Math.ceil((modelXRight - min) * scaleX / range);
            double screenYBottom = Math.ceil(scaleY - (double)seriesIndex * scaleY / (double)seriesSize);
            double screenWidth = screenXRight - screenXLeft;
            double screenHeight = screenYBottom - screenYTop;
            float_ = new Rectangle2D.Float((float)screenXLeft, (float)screenYTop, (float)screenWidth, (float)screenHeight);
        } else {
            float_ = null;
        }
        return float_;
    }

    @JvmOverloads
    public StateChart(@NotNull StateChartModel<T> model2, @NotNull StateChartColorProvider<T> colorProvider) {
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        Intrinsics.checkNotNullParameter(colorProvider, (String)"colorProvider");
        this(model2, colorProvider, null, 4, null);
    }

    @JvmOverloads
    public StateChart(@NotNull StateChartModel<T> model2, @NotNull StateChartColorProvider<T> colorProvider, @NotNull StateChartTextConverter<T> textConverter) {
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        Intrinsics.checkNotNullParameter(colorProvider, (String)"colorProvider");
        Intrinsics.checkNotNullParameter(textConverter, (String)"textConverter");
        this(model2, colorProvider, textConverter, null, 8, null);
    }

    private static final <T> void _init_$modelChanged(StateChart<T> this$0) {
        this$0.needsTransformToViewSpace = true;
        this$0.opaqueRepaint();
    }

    private static final <T> void transformToViewSpace$lambda$1$addRectangleDelta(List<Rectangle2D.Float> rectangles, double min, double invRange, double barY, float barHeight, List<T> rectangleValues, T value, double previousX, double currentX) {
        rectangles.add(new Rectangle2D.Float((float)((previousX - min) * invRange), (float)barY, (float)((currentX - previousX) * invRange), barHeight));
        rectangleValues.add(value);
    }

    private static final int draw$lambda$8$searchByX(List<? extends Rectangle2D.Float> $this$draw_u24lambda_u248_u24searchByX, float x, float w) {
        return CollectionsKt.binarySearch$default($this$draw_u24lambda_u248_u24searchByX, (int)0, (int)0, (Function1)((Function1)new Function1<Rectangle2D.Float, Integer>(x, w){
            final /* synthetic */ float $x;
            final /* synthetic */ float $w;
            {
                this.$x = $x;
                this.$w = $w;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull Rectangle2D.Float it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.x + it.width < this.$x ? -1 : (it.x > this.$x + this.$w ? 1 : 0);
            }
        }), (int)3, null);
    }

    @JvmStatic
    @NotNull
    public static final <T> StateChartTextConverter<T> defaultTextConverter() {
        return Companion.defaultTextConverter();
    }

    public static final /* synthetic */ void access$setRowPoint(StateChart $this, Point point) {
        $this.setRowPoint(point);
    }

    public static final /* synthetic */ void access$renderUnion(StateChart $this, Object container, Point containerOffset) {
        $this.renderUnion(container, containerOffset);
    }

    public static final /* synthetic */ List access$getItemClickedListeners$p(StateChart $this) {
        return $this.itemClickedListeners;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\t0\b\"\u0004\b\u0001\u0010\tH\u0002J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000b\"\u0004\b\u0001\u0010\tH\u0007J\u00a7\u0001\u0010\f\u001a{\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u0011H\t\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00190\rj\b\u0012\u0004\u0012\u0002H\t`\u001a\"\b\b\u0001\u0010\t*\u00020\u00012\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\t0\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\t0\u000bH\u0002J\u0099\u0001\u0010\u001e\u001a{\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u0011H\t\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00190\rj\b\u0012\u0004\u0012\u0002H\t`\u001a\"\b\b\u0001\u0010\t*\u00020\u00012\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\t0\u001cH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/adtui/chart/statechart/StateChart$Companion;", "", "()V", "INVALID_INDEX", "", "PREFERRED_ROW_HEIGHT", "TEXT_PADDING", "defaultConfig", "Lcom/android/tools/adtui/chart/statechart/StateChartConfig;", "T", "defaultTextConverter", "Lcom/android/tools/adtui/chart/statechart/StateChartTextConverter;", "fillRectAndTextRenderer", "Lkotlin/Function5;", "Ljava/awt/Graphics2D;", "Lkotlin/ParameterName;", "name", "g", "Ljava/awt/geom/Rectangle2D$Float;", "boundary", "Ljava/awt/FontMetrics;", "defaultFontMetrics", "", "hoverred", "value", "", "Lcom/android/tools/adtui/chart/statechart/Renderer;", "colorProvider", "Lcom/android/tools/adtui/chart/statechart/StateChartColorProvider;", "textConverter", "fillRectRenderer", "intellij.android.adt.ui"})
    @SourceDebugExtension(value={"SMAP\nStateChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateChart.kt\ncom/android/tools/adtui/chart/statechart/StateChart$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,458:1\n1#2:459\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final <T> StateChartConfig<T> defaultConfig() {
            return new StateChartConfig(new DefaultStateChartReducer());
        }

        @JvmStatic
        @NotNull
        public final <T> StateChartTextConverter<T> defaultTextConverter() {
            return object -> String.valueOf(object);
        }

        private final <T> Function5<Graphics2D, Rectangle2D.Float, FontMetrics, Boolean, T, Unit> fillRectRenderer(StateChartColorProvider<T> colorProvider) {
            return new Function5<Graphics2D, Rectangle2D.Float, FontMetrics, Boolean, T, Unit>(colorProvider){
                final /* synthetic */ StateChartColorProvider<T> $colorProvider;
                {
                    this.$colorProvider = $colorProvider;
                    super(5);
                }

                public final void invoke(@NotNull Graphics2D g, @NotNull Rectangle2D.Float rect, @NotNull FontMetrics fontMetrics, boolean hovered, @NotNull T value) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
                    Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"<anonymous parameter 2>");
                    Intrinsics.checkNotNullParameter(value, (String)"value");
                    g.setColor(this.$colorProvider.getColor(hovered, value));
                    g.fill(rect);
                }
            };
        }

        private final <T> Function5<Graphics2D, Rectangle2D.Float, FontMetrics, Boolean, T, Unit> fillRectAndTextRenderer(StateChartColorProvider<T> colorProvider, StateChartTextConverter<T> textConverter) {
            Function5<Graphics2D, Rectangle2D.Float, FontMetrics, Boolean, T, Unit> fillRect = this.fillRectRenderer(colorProvider);
            boolean bl = false;
            return new Function5<Graphics2D, Rectangle2D.Float, FontMetrics, Boolean, T, Unit>(fillRect, textConverter, colorProvider){
                final /* synthetic */ Function5<Graphics2D, Rectangle2D.Float, FontMetrics, Boolean, T, Unit> $fillRect;
                final /* synthetic */ StateChartTextConverter<T> $textConverter;
                final /* synthetic */ StateChartColorProvider<T> $colorProvider;
                {
                    this.$fillRect = $fillRect;
                    this.$textConverter = $textConverter;
                    this.$colorProvider = $colorProvider;
                    super(5);
                }

                public final void invoke(@NotNull Graphics2D g, @NotNull Rectangle2D.Float rect, @NotNull FontMetrics fontMetrics, boolean hovered, @NotNull T value) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
                    Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
                    Intrinsics.checkNotNullParameter(value, (String)"value");
                    this.$fillRect.invoke((Object)g, (Object)rect, (Object)fontMetrics, (Object)hovered, value);
                    String string = this.$textConverter.convertToString(value);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"textConverter.convertToString(value)");
                    String text = AdtUiUtils.shrinkToFit$default(string, fontMetrics, rect.width - (float)6, null, 8, null);
                    if (((CharSequence)text).length() > 0) {
                        g.setColor(this.$colorProvider.getFontColor(hovered, value));
                        float textOffset = rect.y + (rect.height - (float)fontMetrics.getHeight()) * 0.5f + (float)fontMetrics.getAscent();
                        g.drawString(text, rect.x + (float)3, textOffset);
                    }
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

