/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.common;

import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.adtui.common.ColoredIconGeneratorKt;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.IconUtil;
import java.awt.Color;
import java.awt.image.RGBImageFilter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0007J\n\u0010\n\u001a\u00020\u0007*\u00020\u0007\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/adtui/common/ColoredIconGenerator;", "", "()V", "generateColoredIcon", "Ljavax/swing/Icon;", "icon", "color", "Ljava/awt/Color;", "generateDeEmphasizedIcon", "generateWhiteIcon", "deEmphasize", "intellij.android.adt.ui"})
public final class ColoredIconGenerator {
    @NotNull
    public static final ColoredIconGenerator INSTANCE = new ColoredIconGenerator();

    private ColoredIconGenerator() {
    }

    @JvmStatic
    @NotNull
    public static final Icon generateWhiteIcon(@NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        return INSTANCE.generateColoredIcon(icon, (Color)ColoredIconGeneratorKt.getWHITE());
    }

    @NotNull
    public final Icon generateColoredIcon(@NotNull Icon icon, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        return IconLoader.createLazy((Supplier)new Supplier<Icon>(color, icon){
            @NotNull
            private final Map<Integer, Icon> cache;
            final /* synthetic */ Color $color;
            final /* synthetic */ Icon $icon;
            {
                this.$color = $color;
                this.$icon = $icon;
                this.cache = new LinkedHashMap<K, V>();
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public Icon get() {
                Object object;
                void key$iv;
                void $this$getOrPut$iv;
                Map<Integer, Icon> map2 = this.cache;
                Integer n = this.$color.getRGB();
                Icon icon = this.$icon;
                Color color = this.$color;
                boolean $i$f$getOrPut = false;
                V value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Icon answer$iv = IconUtil.filterIcon((Icon)icon, () -> generateColoredIcon.1.get$lambda$1$lambda$0(color), null);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                return (Icon)object;
            }

            private static final RGBImageFilter get$lambda$1$lambda$0(Color $color) {
                Intrinsics.checkNotNullParameter((Object)$color, (String)"$color");
                return new RGBImageFilter($color){
                    final /* synthetic */ Color $color;
                    {
                        this.$color = $color;
                    }

                    public int filterRGB(int x, int y, int rgb) {
                        return (rgb | 0xFFFFFF) & this.$color.getRGB();
                    }
                };
            }
        });
    }

    @NotNull
    public final Icon generateDeEmphasizedIcon(@NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        return IconLoader.createLazy(() -> ColoredIconGenerator.generateDeEmphasizedIcon$lambda$1(icon));
    }

    @NotNull
    public final Color deEmphasize(@NotNull Color $this$deEmphasize) {
        Intrinsics.checkNotNullParameter((Object)$this$deEmphasize, (String)"<this>");
        return new Color($this$deEmphasize.getRed(), $this$deEmphasize.getGreen(), $this$deEmphasize.getBlue(), ($this$deEmphasize.getAlpha() + 1) / 2);
    }

    private static final RGBImageFilter generateDeEmphasizedIcon$lambda$1$lambda$0() {
        return new RGBImageFilter(){

            public int filterRGB(int x, int y, int rgb) {
                Color color = new Color(rgb, true);
                return ColoredIconGenerator.INSTANCE.deEmphasize(color).getRGB();
            }
        };
    }

    private static final Icon generateDeEmphasizedIcon$lambda$1(Icon $icon) {
        Intrinsics.checkNotNullParameter((Object)$icon, (String)"$icon");
        return IconUtil.filterIcon((Icon)$icon, ColoredIconGenerator::generateDeEmphasizedIcon$lambda$1$lambda$0, null);
    }
}

