/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.common;

import com.android.tools.adtui.RangeScrollBarUI;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.StudioColorsKt;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.AbstractExpandableItemsHandler;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.TableCell;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.tree.ui.DefaultTreeUI;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.RowSorter;
import javax.swing.Scrollable;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class ColumnTreeBuilder {
    @NotNull
    private final JTree myTree;
    @NotNull
    private ColumnTreeCellRenderer myCellRenderer;
    @NotNull
    private final JTable myTable;
    @NotNull
    private final DefaultTableModel myTableModel;
    private TreeSorter myTreeSorter;
    @NotNull
    private List<ColumnBuilder> myColumnBuilders;
    private Border myBorder;
    private Color myBackground;
    private Color myHoverColor;
    private boolean myShowHeaderTooltips;
    @NotNull
    private final ColumnTreeScrollPanel myHScrollBarPanel;
    private TreeCellRenderer myHeaderRowCellRenderer;
    private ColumnTreeExpandableItemsHandler myExpandableItemsHandler;
    private boolean myShouldAlwaysPaintExpandControl;
    private static final String LAST_TREE_PREFERRED_WIDTH = "last.tree.width";
    private static final String PREFERRED_TREE_WIDTH = "tree.width";
    private static final String TREE_OFFSET = "tree.offset";

    public ColumnTreeBuilder(@NotNull JTree tree) {
        if (tree == null) {
            ColumnTreeBuilder.$$$reportNull$$$0(0);
        }
        this(tree, null);
    }

    public ColumnTreeBuilder(@NotNull JTree tree, TableColumnModel tableColumnModel) {
        if (tree == null) {
            ColumnTreeBuilder.$$$reportNull$$$0(1);
        }
        this.myHeaderRowCellRenderer = null;
        this.myTree = tree;
        this.myTableModel = new DefaultTableModel();
        this.myTable = new JBTable((TableModel)this.myTableModel, tableColumnModel);
        this.myHScrollBarPanel = new ColumnTreeScrollPanel(this.myTree, this.myTable);
        this.myTable.setAutoCreateColumnsFromModel(true);
        this.myTable.setShowVerticalLines(false);
        this.myTable.setFocusable(false);
        this.myColumnBuilders = new LinkedList<ColumnBuilder>();
    }

    public ColumnTreeBuilder setTreeSorter(@NotNull TreeSorter<?> sorter) {
        if (sorter == null) {
            ColumnTreeBuilder.$$$reportNull$$$0(2);
        }
        this.myTreeSorter = sorter;
        return this;
    }

    public ColumnTreeBuilder setBorder(@NotNull Border border) {
        if (border == null) {
            ColumnTreeBuilder.$$$reportNull$$$0(3);
        }
        this.myBorder = border;
        return this;
    }

    public ColumnTreeBuilder setBackground(@NotNull Color background) {
        if (background == null) {
            ColumnTreeBuilder.$$$reportNull$$$0(4);
        }
        this.myBackground = background;
        return this;
    }

    public ColumnTreeBuilder setHoverColor(@NotNull Color hoverColor) {
        if (hoverColor == null) {
            ColumnTreeBuilder.$$$reportNull$$$0(5);
        }
        this.myHoverColor = hoverColor;
        return this;
    }

    public ColumnTreeBuilder setShowVerticalLines(boolean showVerticalLines) {
        this.myTable.setShowVerticalLines(showVerticalLines);
        return this;
    }

    public ColumnTreeBuilder setTableFocusable(boolean focusable) {
        this.myTable.setFocusable(focusable);
        return this;
    }

    @NotNull
    public ColumnTreeBuilder setTableIntercellSpacing(Dimension spacing) {
        this.myTable.setIntercellSpacing(spacing);
        ColumnTreeBuilder columnTreeBuilder = this;
        if (columnTreeBuilder == null) {
            ColumnTreeBuilder.$$$reportNull$$$0(6);
        }
        return columnTreeBuilder;
    }

    @NotNull
    public ColumnTreeBuilder setShowHeaderTooltips(boolean showing) {
        this.myShowHeaderTooltips = showing;
        ColumnTreeBuilder columnTreeBuilder = this;
        if (columnTreeBuilder == null) {
            ColumnTreeBuilder.$$$reportNull$$$0(7);
        }
        return columnTreeBuilder;
    }

    @NotNull
    public ColumnTreeBuilder setHeaderRowCellRenderer(@NotNull TreeCellRenderer renderer) {
        if (renderer == null) {
            ColumnTreeBuilder.$$$reportNull$$$0(8);
        }
        this.myHeaderRowCellRenderer = renderer;
        ColumnTreeBuilder columnTreeBuilder = this;
        if (columnTreeBuilder == null) {
            ColumnTreeBuilder.$$$reportNull$$$0(9);
        }
        return columnTreeBuilder;
    }

    @NotNull
    public ColumnTreeBuilder setShouldPaintExpandControl(boolean shouldAlwaysPaintExpandControl) {
        this.myShouldAlwaysPaintExpandControl = shouldAlwaysPaintExpandControl;
        ColumnTreeBuilder columnTreeBuilder = this;
        if (columnTreeBuilder == null) {
            ColumnTreeBuilder.$$$reportNull$$$0(10);
        }
        return columnTreeBuilder;
    }

    public JComponent build() {
        this.myCellRenderer = new ColumnTreeCellRenderer(this.myTree, this.myTable.getColumnModel(), this.myHeaderRowCellRenderer);
        boolean showsRootHandles = this.myTree.getShowsRootHandles();
        ColumnTreeHoverListener hoverListener = this.myHoverColor != null ? ColumnTreeHoverListener.create(this.myTree) : null;
        this.setTreeUi(hoverListener);
        if (this.myHeaderRowCellRenderer != null) {
            this.myTree.setSelectionModel(new DefaultTreeSelectionModel(){

                private boolean isLastComponentNotHeader(TreePath path) {
                    return path.getPathCount() != 2;
                }

                @Override
                public void addSelectionPath(TreePath path) {
                    if (this.isLastComponentNotHeader(path)) {
                        super.addSelectionPath(path);
                    }
                }

                @Override
                public void addSelectionPaths(TreePath[] paths) {
                    super.addSelectionPaths((TreePath[])Arrays.stream(paths).filter(this::isLastComponentNotHeader).toArray(TreePath[]::new));
                }

                @Override
                public void setSelectionPath(TreePath path) {
                    if (this.isLastComponentNotHeader(path)) {
                        super.setSelectionPath(path);
                    }
                }

                @Override
                public void setSelectionPaths(TreePath[] pPaths) {
                    super.setSelectionPaths((TreePath[])Arrays.stream(pPaths).filter(this::isLastComponentNotHeader).toArray(TreePath[]::new));
                }
            });
        }
        this.myTree.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("UI") && !(evt.getNewValue() instanceof ColumnTreeUI)) {
                this.setTreeUi(hoverListener);
            }
        });
        this.myTree.setShowsRootHandles(showsRootHandles);
        this.myTree.setCellRenderer(this.myCellRenderer);
        this.myTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent changeEvent) {
                ColumnTreeBuilder.this.myTree.revalidate();
                ColumnTreeBuilder.this.myTree.repaint();
                ColumnTreeBuilder.this.myHScrollBarPanel.updateScrollBar();
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }
        });
        ColumnTreeTableRowSorter rowSorter = new ColumnTreeTableRowSorter(this.myTable.getModel(), ContainerUtil.map(this.myColumnBuilders, cb -> cb.mySortOrderPreference));
        this.myTable.setRowSorter(rowSorter);
        rowSorter.addRowSorterListener(event -> {
            if (this.myTreeSorter != null && !rowSorter.getSortKeys().isEmpty()) {
                RowSorter.SortKey key = rowSorter.getSortKeys().get(0);
                Comparator<?> comparator = rowSorter.getComparator(key.getColumn());
                Enumeration<TreePath> expanded = this.myTree.getExpandedDescendants(new TreePath(this.myTree.getModel().getRoot()));
                comparator = key.getSortOrder() == SortOrder.ASCENDING ? comparator : Collections.reverseOrder(comparator);
                this.myTreeSorter.sort(comparator, key.getSortOrder());
                if (expanded != null) {
                    while (expanded.hasMoreElements()) {
                        this.myTree.expandPath(expanded.nextElement());
                    }
                }
            }
        });
        this.myTable.setAutoResizeMode(1);
        for (ColumnBuilder column : this.myColumnBuilders) {
            column.create(this.myTableModel);
        }
        this.myExpandableItemsHandler = new ColumnTreeExpandableItemsHandler(this.myTree, this.myTable);
        for (int i2 = 0; i2 < this.myColumnBuilders.size(); ++i2) {
            ColumnBuilder column;
            column = this.myColumnBuilders.get(i2);
            column.configure(i2, this.myTable, rowSorter, this.myCellRenderer, this.myShowHeaderTooltips);
        }
        TreeWrapperPanel panel2 = new TreeWrapperPanel(this.myTable, this.myTree);
        if (this.myBackground != null) {
            panel2.setBackground(this.myBackground);
        }
        JTableHeader header2 = this.myTable.getTableHeader();
        header2.setReorderingAllowed(false);
        JViewport viewport = new JViewport();
        viewport.setView(header2);
        JBScrollPane scrollPane = new JBScrollPane((Component)panel2);
        scrollPane.setColumnHeader(viewport);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setBorder((Border)JBUI.Borders.empty());
        JPanel outerPanel = new JPanel(new BorderLayout());
        outerPanel.add((Component)scrollPane, "Center");
        outerPanel.add((Component)this.myHScrollBarPanel, "South");
        if (this.myBorder != null) {
            scrollPane.setBorder(this.myBorder);
        }
        this.myHScrollBarPanel.setBorder(scrollPane.getBorder());
        return outerPanel;
    }

    private void setTreeUi(ColumnTreeHoverListener hoverListener) {
        if (this.myHeaderRowCellRenderer == null) {
            this.myTree.setUI((TreeUI)((Object)new ColumnTreeUI(this.myHoverColor, hoverListener, this.myTable, this.myHScrollBarPanel).setShouldAlwaysPaintExpandControl(this.myShouldAlwaysPaintExpandControl)));
        } else {
            this.myTree.setUI((TreeUI)((Object)new HeaderColumnTreeUI(this.myHoverColor, hoverListener, this.myTable, this.myHScrollBarPanel).setShouldAlwaysPaintExpandControl(this.myShouldAlwaysPaintExpandControl)));
        }
    }

    private static int getTreeColumnWidth(JTable table) {
        if (table == null || table.getColumnModel().getColumnCount() == 0) {
            return 0;
        }
        return table.getColumnModel().getColumn(0).getWidth();
    }

    private static int getPreferredTreeWidth(JTree tree) {
        Object value = tree.getClientProperty(PREFERRED_TREE_WIDTH);
        return value == null ? 0 : (Integer)value;
    }

    private static void setPreferredTreeWidth(JTree tree, int width) {
        tree.putClientProperty(PREFERRED_TREE_WIDTH, width);
    }

    private static int getTreeOffset(JTree tree) {
        Object value = tree.getClientProperty(TREE_OFFSET);
        return value == null ? 0 : (Integer)value;
    }

    private static void setTreeOffset(JTree tree, int offset) {
        tree.putClientProperty(TREE_OFFSET, offset);
    }

    @NotNull
    public ColumnTreeBuilder addColumn(@NotNull ColumnBuilder column) {
        if (column == null) {
            ColumnTreeBuilder.$$$reportNull$$$0(11);
        }
        this.myColumnBuilders.add(column);
        ColumnTreeBuilder columnTreeBuilder = this;
        if (columnTreeBuilder == null) {
            ColumnTreeBuilder.$$$reportNull$$$0(12);
        }
        return columnTreeBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 9, 10, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sorter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "border";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "background";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hoverColor";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/common/ColumnTreeBuilder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/common/ColumnTreeBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "setTableIntercellSpacing";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "setShowHeaderTooltips";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "setHeaderRowCellRenderer";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "setShouldPaintExpandControl";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "addColumn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setTreeSorter";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setBorder";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setBackground";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setHoverColor";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setHeaderRowCellRenderer";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addColumn";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 9, 10, 12 -> new IllegalStateException(string);
        };
    }

    private static class ColumnTreeScrollPanel
    extends JPanel {
        @NotNull
        private final ColumnTreeScrollBar myScrollbar;
        @NotNull
        private final JTree myTree;
        @NotNull
        private final JTable myTable;

        public ColumnTreeScrollPanel(@NotNull JTree tree, @NotNull JTable table) {
            if (tree == null) {
                ColumnTreeScrollPanel.$$$reportNull$$$0(0);
            }
            if (table == null) {
                ColumnTreeScrollPanel.$$$reportNull$$$0(1);
            }
            super(new TabularLayout("Fit-,*"));
            this.myTree = tree;
            this.myTable = table;
            this.myScrollbar = new ColumnTreeScrollBar(table);
            this.add((Component)((Object)this.myScrollbar), new TabularLayout.Constraint(0, 0));
            this.add((Component)new JPanel(), new TabularLayout.Constraint(0, 1));
        }

        public BoundedRangeModel getModel() {
            return this.myScrollbar.getModel();
        }

        public void updateScrollBar() {
            int extent;
            int max = ColumnTreeBuilder.getPreferredTreeWidth(this.myTree);
            int value = ColumnTreeBuilder.getTreeOffset(this.myTree);
            if (value + (extent = ColumnTreeBuilder.getTreeColumnWidth(this.myTable)) > max) {
                value = max - extent;
            }
            this.myScrollbar.getModel().setMaximum(max);
            this.myScrollbar.getModel().setValue(value);
            this.myScrollbar.getModel().setExtent(extent);
            this.myScrollbar.revalidate();
            this.setVisible(extent < max);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "table";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/adtui/common/ColumnTreeBuilder$ColumnTreeScrollPanel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface TreeSorter<T> {
        public void sort(Comparator<T> var1, SortOrder var2);
    }

    private static class ColumnTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        private final TreeCellRenderer myHeaderRowCellRenderer;

        public ColumnTreeCellRenderer(JTree tree, TableColumnModel columnModel, TreeCellRenderer headerRowCellRenderer) {
            super(new ColumnLayout(tree, columnModel));
            this.myHeaderRowCellRenderer = headerRowCellRenderer;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            TreeNode parent;
            if (this.myHeaderRowCellRenderer != null && value instanceof TreeNode && (parent = ((TreeNode)value).getParent()) != null && parent.getParent() == null) {
                return this.myHeaderRowCellRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            }
            this.setFont(tree.getFont());
            String toolTip = null;
            for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
                Component c;
                Component component = this.getComponent(i2);
                if (component instanceof ColoredTreeCellRenderer && (c = ((ColoredTreeCellRenderer)component).getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus)) instanceof JComponent && toolTip == null) {
                    toolTip = ((JComponent)c).getToolTipText();
                }
                if (i2 != 0) continue;
                tree.putClientProperty(ColumnTreeBuilder.LAST_TREE_PREFERRED_WIDTH, component.getPreferredSize().width);
            }
            this.setToolTipText(toolTip);
            return this;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = new Dimension();
            for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
                Dimension size = this.getComponent(i2).getPreferredSize();
                dimension.width += size.width;
                dimension.height = Math.max(dimension.height, size.height);
            }
            return dimension;
        }
    }

    private static class ColumnTreeHoverListener
    extends MouseAdapter {
        public static final ColumnTreeHoverListener EMPTY_LISTENER = new ColumnTreeHoverListener(){

            @Override
            public int getHoveredRow() {
                return -1;
            }
        };
        private int myHoveredRow = -1;

        private ColumnTreeHoverListener() {
        }

        public static ColumnTreeHoverListener create(@NotNull JTree tree) {
            if (tree == null) {
                ColumnTreeHoverListener.$$$reportNull$$$0(0);
            }
            ColumnTreeHoverListener config = new ColumnTreeHoverListener();
            tree.addMouseListener(config);
            tree.addMouseMotionListener(config);
            return config;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JTree tree = (JTree)e.getSource();
            int row = ColumnTreeHoverListener.getRowForLocation(tree, e.getX(), e.getY());
            if (row != this.myHoveredRow) {
                int oldHoveredRow = this.myHoveredRow;
                this.myHoveredRow = row;
                if (oldHoveredRow != -1 && oldHoveredRow < tree.getRowCount()) {
                    tree.repaint(ColumnTreeHoverListener.getHoverBounds(tree, oldHoveredRow));
                }
                if (this.myHoveredRow != -1) {
                    tree.repaint(ColumnTreeHoverListener.getHoverBounds(tree, this.myHoveredRow));
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.mouseMoved(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JTree tree = (JTree)e.getSource();
            if (this.myHoveredRow != -1) {
                int oldHoveredRow = this.myHoveredRow;
                this.myHoveredRow = -1;
                if (oldHoveredRow < tree.getRowCount()) {
                    tree.repaint(ColumnTreeHoverListener.getHoverBounds(tree, oldHoveredRow));
                }
            }
        }

        public int getHoveredRow() {
            return this.myHoveredRow;
        }

        private static Rectangle getHoverBounds(JTree tree, int row) {
            Rectangle bounds = tree.getRowBounds(row);
            return new Rectangle(0, bounds.y, bounds.width + bounds.x, bounds.height);
        }

        private static int getRowForLocation(JTree tree, int x, int y) {
            int row = tree.getClosestRowForLocation(x, y);
            if (row != -1 && ColumnTreeHoverListener.getHoverBounds(tree, row).contains(x, y)) {
                return row;
            }
            return -1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/adtui/common/ColumnTreeBuilder$ColumnTreeHoverListener", "create"));
        }
    }

    private static class ColumnTreeTableRowSorter
    extends TableRowSorter<TableModel> {
        @NotNull
        private final List<SortOrder> mySortOrderPreferences;

        private ColumnTreeTableRowSorter(@NotNull TableModel model2, @NotNull List<SortOrder> sortOrderPreferences) {
            if (model2 == null) {
                ColumnTreeTableRowSorter.$$$reportNull$$$0(0);
            }
            if (sortOrderPreferences == null) {
                ColumnTreeTableRowSorter.$$$reportNull$$$0(1);
            }
            super(model2);
            this.mySortOrderPreferences = sortOrderPreferences;
        }

        @Override
        public void toggleSortOrder(int column) {
            this.checkColumn(column);
            if (this.isSortable(column)) {
                int sortIndex;
                List<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>(this.getSortKeys());
                for (sortIndex = keys.size() - 1; sortIndex >= 0 && ((RowSorter.SortKey)keys.get(sortIndex)).getColumn() != column; --sortIndex) {
                }
                if (sortIndex == -1) {
                    RowSorter.SortKey sortKey = new RowSorter.SortKey(column, this.mySortOrderPreferences.get(column));
                    keys.add(0, sortKey);
                } else if (sortIndex == 0) {
                    keys.set(0, ColumnTreeTableRowSorter.toggle((RowSorter.SortKey)keys.get(0)));
                } else {
                    keys.remove(sortIndex);
                    keys.add(0, new RowSorter.SortKey(column, this.mySortOrderPreferences.get(column)));
                }
                if (keys.size() > this.getMaxSortKeys()) {
                    keys = keys.subList(0, this.getMaxSortKeys());
                }
                this.setSortKeys(keys);
            }
        }

        private void checkColumn(int column) {
            if (column < 0 || column >= this.getModelWrapper().getColumnCount()) {
                throw new IndexOutOfBoundsException("column beyond range of TableModel");
            }
        }

        private static RowSorter.SortKey toggle(RowSorter.SortKey key) {
            if (key.getSortOrder() == SortOrder.ASCENDING) {
                return new RowSorter.SortKey(key.getColumn(), SortOrder.DESCENDING);
            }
            return new RowSorter.SortKey(key.getColumn(), SortOrder.ASCENDING);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "model";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sortOrderPreferences";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/adtui/common/ColumnTreeBuilder$ColumnTreeTableRowSorter";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ColumnBuilder {
        private String myName;
        private int myWidth;
        private int myHeaderAlignment;
        private int myMinimumWidth;
        private int myMaximumWidth = Integer.MAX_VALUE;
        private Border myHeaderBorder;
        private Comparator<?> myComparator;
        private ColoredTreeCellRenderer myRenderer;
        private SortOrder myInitialOrder = SortOrder.UNSORTED;
        private SortOrder mySortOrderPreference = SortOrder.ASCENDING;

        @NotNull
        public ColumnBuilder setName(@NotNull String name) {
            if (name == null) {
                ColumnBuilder.$$$reportNull$$$0(0);
            }
            this.myName = name;
            ColumnBuilder columnBuilder = this;
            if (columnBuilder == null) {
                ColumnBuilder.$$$reportNull$$$0(1);
            }
            return columnBuilder;
        }

        @NotNull
        public ColumnBuilder setPreferredWidth(int width) {
            this.myWidth = width;
            ColumnBuilder columnBuilder = this;
            if (columnBuilder == null) {
                ColumnBuilder.$$$reportNull$$$0(2);
            }
            return columnBuilder;
        }

        @NotNull
        public ColumnBuilder setMinWidth(int width) {
            this.myMinimumWidth = width;
            ColumnBuilder columnBuilder = this;
            if (columnBuilder == null) {
                ColumnBuilder.$$$reportNull$$$0(3);
            }
            return columnBuilder;
        }

        @NotNull
        public ColumnBuilder setMaxWidth(int width) {
            this.myMaximumWidth = width;
            ColumnBuilder columnBuilder = this;
            if (columnBuilder == null) {
                ColumnBuilder.$$$reportNull$$$0(4);
            }
            return columnBuilder;
        }

        @NotNull
        public ColumnBuilder setHeaderAlignment(int alignment) {
            this.myHeaderAlignment = alignment;
            ColumnBuilder columnBuilder = this;
            if (columnBuilder == null) {
                ColumnBuilder.$$$reportNull$$$0(5);
            }
            return columnBuilder;
        }

        @NotNull
        public ColumnBuilder setHeaderBorder(Border border) {
            this.myHeaderBorder = border;
            ColumnBuilder columnBuilder = this;
            if (columnBuilder == null) {
                ColumnBuilder.$$$reportNull$$$0(6);
            }
            return columnBuilder;
        }

        @NotNull
        public ColumnBuilder setSortOrderPreference(@NotNull SortOrder sortOrderPreference) {
            if (sortOrderPreference == null) {
                ColumnBuilder.$$$reportNull$$$0(7);
            }
            assert (sortOrderPreference == SortOrder.ASCENDING || sortOrderPreference == SortOrder.DESCENDING);
            this.mySortOrderPreference = sortOrderPreference;
            ColumnBuilder columnBuilder = this;
            if (columnBuilder == null) {
                ColumnBuilder.$$$reportNull$$$0(8);
            }
            return columnBuilder;
        }

        public void create(DefaultTableModel model2) {
            model2.addColumn(this.myName);
        }

        private void configure(int index, JTable table, ColumnTreeTableRowSorter sorter, ColumnTreeCellRenderer renderer, final boolean showHeaderTooltips) {
            TableColumn column = table.getColumnModel().getColumn(index);
            column.setPreferredWidth(this.myWidth);
            column.setMinWidth(this.myMinimumWidth);
            column.setMaxWidth(this.myMaximumWidth);
            final TableCellRenderer tableCellRenderer = table.getTableHeader().getDefaultRenderer();
            column.setHeaderRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component component = tableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (component instanceof JLabel) {
                        ((JLabel)component).setHorizontalAlignment(myHeaderAlignment);
                    }
                    if (component instanceof JComponent) {
                        ((JComponent)component).setBorder(myHeaderBorder);
                        if (showHeaderTooltips) {
                            ((JComponent)component).setToolTipText(value.toString());
                        }
                    }
                    return component;
                }
            });
            if (this.myComparator != null) {
                sorter.setComparator(column.getModelIndex(), this.myComparator);
                if (this.myInitialOrder != SortOrder.UNSORTED) {
                    sorter.setSortKeys(Collections.singletonList(new RowSorter.SortKey(column.getModelIndex(), this.myInitialOrder)));
                }
            } else {
                sorter.setSortable(column.getModelIndex(), false);
            }
            assert (this.myRenderer != null);
            renderer.add((Component)this.myRenderer);
        }

        public ColumnBuilder setComparator(@NotNull Comparator<?> comparator) {
            if (comparator == null) {
                ColumnBuilder.$$$reportNull$$$0(9);
            }
            this.myComparator = comparator;
            return this;
        }

        public ColumnBuilder setRenderer(@NotNull ColoredTreeCellRenderer renderer) {
            if (renderer == null) {
                ColumnBuilder.$$$reportNull$$$0(10);
            }
            this.myRenderer = renderer;
            return this;
        }

        public ColumnBuilder setInitialOrder(@NotNull SortOrder initialOrder) {
            if (initialOrder == null) {
                ColumnBuilder.$$$reportNull$$$0(11);
            }
            this.myInitialOrder = initialOrder;
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 5, 6, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/adtui/common/ColumnTreeBuilder$ColumnBuilder";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sortOrderPreference";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comparator";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initialOrder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/adtui/common/ColumnTreeBuilder$ColumnBuilder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setPreferredWidth";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setMinWidth";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setMaxWidth";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setHeaderAlignment";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setHeaderBorder";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setSortOrderPreference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setSortOrderPreference";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "setComparator";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "setRenderer";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "setInitialOrder";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4, 5, 6, 8 -> new IllegalStateException(string);
            };
        }
    }

    private class ColumnTreeExpandableItemsHandler
    extends AbstractExpandableItemsHandler<TableCell, JTree> {
        @NotNull
        private final JTable myTable;

        protected ColumnTreeExpandableItemsHandler(@NotNull JTree tree, JTable table) {
            if (tree == null) {
                ColumnTreeExpandableItemsHandler.$$$reportNull$$$0(0);
            }
            if (table == null) {
                ColumnTreeExpandableItemsHandler.$$$reportNull$$$0(1);
            }
            super((JComponent)tree);
            this.myTable = table;
            TreeModelAdapter modelListener = new TreeModelAdapter(){

                protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (type == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (type == TreeModelAdapter.EventType.NodesChanged) {
                        ColumnTreeExpandableItemsHandler.this.updateCurrentSelection();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "type";
                            break;
                        }
                    }
                    objectArray[1] = "com/android/tools/adtui/common/ColumnTreeBuilder$ColumnTreeExpandableItemsHandler$1";
                    objectArray[2] = "process";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            if (tree.getModel() != null) {
                tree.getModel().addTreeModelListener((TreeModelListener)modelListener);
            }
            tree.addPropertyChangeListener("model", arg_0 -> this.lambda$new$0((TreeModelListener)modelListener, arg_0));
        }

        protected Pair<Component, Rectangle> getCellRendererAndBounds(TableCell key) {
            int rowIndex = key.row;
            TreePath path = ((JTree)this.myComponent).getPathForRow(rowIndex);
            if (path == null) {
                return null;
            }
            Rectangle treeCellRect = ((JTree)this.myComponent).getPathBounds(path);
            if (treeCellRect == null) {
                return null;
            }
            TreeCellRenderer treeCellRenderer = ((JTree)this.myComponent).getCellRenderer();
            if (treeCellRenderer == null) {
                return null;
            }
            if (key.row < 0 || key.row >= ((JTree)this.myComponent).getRowCount() || key.column < 0 || key.column >= this.myTable.getColumnCount() || this.hasDraggingOrResizingColumn()) {
                return null;
            }
            Object node = path.getLastPathComponent();
            Component treeCellComponent = treeCellRenderer.getTreeCellRendererComponent((JTree)this.myComponent, node, ((JTree)this.myComponent).isRowSelected(rowIndex), ((JTree)this.myComponent).isExpanded(rowIndex), ((JTree)this.myComponent).getModel().isLeaf(node), rowIndex, ((JTree)this.myComponent).hasFocus());
            if (!(treeCellComponent instanceof ColumnTreeCellRenderer)) {
                return null;
            }
            Component tableCellComponent = ((ColumnTreeCellRenderer)treeCellComponent).getComponent(key.column);
            Rectangle tableHeaderRect = this.myTable.getTableHeader().getHeaderRect(key.column);
            Rectangle tableCellRect = new Rectangle(Math.max(treeCellRect.x, tableHeaderRect.x), treeCellRect.y, tableCellComponent.getPreferredSize().width, treeCellRect.height);
            return Pair.create((Object)tableCellComponent, (Object)tableCellRect);
        }

        protected TableCell getCellKeyForPoint(Point point) {
            int rowIndex = ColumnTreeBuilder.this.myTree.getRowForLocation(point.x, point.y);
            if (rowIndex == -1) {
                return null;
            }
            int columnIndex = this.myTable.columnAtPoint(point);
            if (columnIndex == -1) {
                return null;
            }
            return new TableCell(rowIndex, columnIndex);
        }

        private boolean hasDraggingOrResizingColumn() {
            JTableHeader header2 = this.myTable.getTableHeader();
            return header2 != null && (header2.getResizingColumn() != null || header2.getDraggedColumn() != null);
        }

        public Rectangle getVisibleRect(TableCell key) {
            Rectangle columnVisibleRect = ((JTree)this.myComponent).getVisibleRect();
            Rectangle tableHeaderRect = this.myTable.getTableHeader().getHeaderRect(key.column);
            int visibleRight = Math.min(columnVisibleRect.x + columnVisibleRect.width, tableHeaderRect.x + tableHeaderRect.width);
            columnVisibleRect.x = Math.min(columnVisibleRect.x, tableHeaderRect.x);
            columnVisibleRect.width = Math.max(0, visibleRight - columnVisibleRect.x);
            return columnVisibleRect;
        }

        protected void doPaintTooltipImage(Component rComponent, Rectangle cellBounds, Graphics2D g, TableCell key) {
            DefaultTreeUI.setBackground((JTree)((JTree)this.myComponent), (Component)rComponent, (int)key.row);
            Container parent = rComponent.getParent();
            if (parent instanceof ColumnTreeCellRenderer) {
                ColumnTreeCellRenderer parentRenderer = (ColumnTreeCellRenderer)parent;
                int index = Arrays.asList(parentRenderer.getComponents()).indexOf(rComponent);
                if (index == -1) {
                    return;
                }
                parentRenderer.remove(rComponent);
                super.doPaintTooltipImage(rComponent, cellBounds, g, (Object)key);
                parentRenderer.add(rComponent, index);
            }
        }

        private /* synthetic */ void lambda$new$0(TreeModelListener modelListener, PropertyChangeEvent evt) {
            this.updateCurrentSelection();
            if (evt.getOldValue() != null) {
                ((TreeModel)evt.getOldValue()).removeTreeModelListener(modelListener);
            }
            if (evt.getNewValue() != null) {
                ((TreeModel)evt.getNewValue()).addTreeModelListener(modelListener);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "table";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/adtui/common/ColumnTreeBuilder$ColumnTreeExpandableItemsHandler";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TreeWrapperPanel
    extends JPanel
    implements Scrollable {
        @NotNull
        private final JTree myTree;

        public TreeWrapperPanel(JTable table, JTree tree) {
            super(new BorderLayout());
            this.myTree = tree;
            this.add((Component)table, "North");
            this.add((Component)this.myTree, "Center");
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.myTree.getPreferredScrollableViewportSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return this.myTree.getScrollableUnitIncrement(visibleRect, orientation, direction);
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return this.myTree.getScrollableUnitIncrement(visibleRect, orientation, direction);
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            Container parent = SwingUtilities.getUnwrappedParent(this);
            if (parent instanceof JViewport) {
                return parent.getWidth() > this.myTree.getPreferredSize().width;
            }
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            Container parent = SwingUtilities.getUnwrappedParent(this);
            if (parent instanceof JViewport) {
                return parent.getHeight() > this.myTree.getPreferredSize().height;
            }
            return false;
        }
    }

    private static class ColumnTreeUI
    extends WideSelectionTreeUI {
        private final ColumnTreeScrollPanel myHScrollBarPanel;
        private int myWidth = -1;
        private int myTreeColumnWidth = -1;
        private ArrayList<Integer> myTreeWidths = new ArrayList();
        @NotNull
        private final Color myHoverColor;
        @NotNull
        private final ColumnTreeHoverListener myHoverConfig;
        private final JTable myTable;
        private ChangeListener stateChangeListener;
        private boolean myShouldAlwaysPaintExpandControl = false;

        ColumnTreeUI() {
            this(null, null, null, null);
        }

        protected void uninstallListeners() {
            super.uninstallListeners();
            if (this.stateChangeListener != null) {
                this.myHScrollBarPanel.getModel().removeChangeListener(this.stateChangeListener);
                this.stateChangeListener = null;
            }
        }

        protected void installListeners() {
            super.installListeners();
            if (this.stateChangeListener == null) {
                this.stateChangeListener = new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        ColumnTreeBuilder.setTreeOffset(tree, myHScrollBarPanel.getModel().getValue());
                        treeState.invalidateSizes();
                        tree.repaint();
                    }
                };
                this.myHScrollBarPanel.getModel().addChangeListener(this.stateChangeListener);
            }
        }

        ColumnTreeUI(Color hoverColor, ColumnTreeHoverListener hoverConfig, JTable table, ColumnTreeScrollPanel hsb) {
            this.myHoverColor = hoverColor != null ? hoverColor : new JBColor(new Color(0, 0, 0, 0), new Color(0, 0, 0, 0));
            this.myHoverConfig = hoverConfig != null ? hoverConfig : ColumnTreeHoverListener.EMPTY_LISTENER;
            this.myTable = table;
            this.myHScrollBarPanel = hsb;
        }

        public void paint(Graphics g, JComponent c) {
            if (this.myWidth != c.getWidth() || this.myTreeColumnWidth != ColumnTreeBuilder.getTreeColumnWidth(this.myTable)) {
                this.treeState.invalidateSizes();
                this.myWidth = c.getWidth();
                this.myTreeColumnWidth = ColumnTreeBuilder.getTreeColumnWidth(this.myTable);
            }
            if (this.myTable != null && this.myTable.getShowVerticalLines()) {
                g.setColor(this.myTable.getGridColor());
                this.getColumnX().forEach(x -> g.drawLine((int)x, 0, (int)x, c.getHeight()));
            }
            super.paint(g, c);
        }

        protected boolean isLocationInExpandControl(TreePath path, int mouseX, int mouseY) {
            return super.isLocationInExpandControl(path, mouseX + ColumnTreeBuilder.getTreeOffset(this.tree), mouseY);
        }

        protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
            return new BasicTreeUI.NodeDimensionsHandler(){

                @Override
                public Rectangle getNodeDimensions(Object value, int row, int depth, boolean expanded, Rectangle size) {
                    int secondColumnStart;
                    tree.putClientProperty(ColumnTreeBuilder.LAST_TREE_PREFERRED_WIDTH, null);
                    Rectangle dimensions = super.getNodeDimensions(value, row, depth, expanded, size);
                    dimensions.width = tree.getWidth() - this.getRowX(row, depth);
                    if (row >= 0 && tree.getClientProperty(ColumnTreeBuilder.LAST_TREE_PREFERRED_WIDTH) != null) {
                        int realWidth = this.getRowX(row, depth) + (Integer)tree.getClientProperty(ColumnTreeBuilder.LAST_TREE_PREFERRED_WIDTH);
                        while (myTreeWidths.size() <= row) {
                            myTreeWidths.add(0);
                        }
                        myTreeWidths.set(row, realWidth);
                    }
                    if ((secondColumnStart = ColumnTreeBuilder.getTreeColumnWidth(myTable) - ((ColumnTreeUI)this).tree.getInsets().left) < dimensions.x) {
                        dimensions.width += dimensions.x - secondColumnStart;
                        dimensions.x = secondColumnStart;
                    }
                    int offset = ColumnTreeBuilder.getTreeOffset(tree);
                    dimensions.x -= offset;
                    dimensions.width += offset;
                    return dimensions;
                }
            };
        }

        protected void updateCachedPreferredSize() {
            super.updateCachedPreferredSize();
            int treePreferredWidth = 0;
            for (int r = 0; r < this.tree.getRowCount() && r < this.myTreeWidths.size(); ++r) {
                treePreferredWidth = Math.max(treePreferredWidth, this.myTreeWidths.get(r));
            }
            ColumnTreeBuilder.setPreferredTreeWidth(this.tree, treePreferredWidth);
            this.myHScrollBarPanel.updateScrollBar();
        }

        protected void onPaintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
            if (row == this.myHoverConfig.getHoveredRow() && !this.tree.isPathSelected(path)) {
                Color originalColor = g.getColor();
                g.setColor(this.myHoverColor);
                g.fillRect(0, bounds.y, this.tree.getWidth(), bounds.height);
                g.setColor(originalColor);
            }
        }

        protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
            this.onPaintRow(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
            super.paintRow(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
            if (this.myTable != null && this.myTable.getShowVerticalLines() && this.tree.isPathSelected(path)) {
                Color gridBackground = RenderingUtil.getSelectionBackground((JTree)this.tree);
                Color gridColor = gridBackground == null ? this.myTable.getGridColor() : AdtUiUtils.overlayColor(gridBackground.getRGB(), this.myTable.getGridColor().getRGB(), 0.25f);
                g.setColor(gridColor);
                this.getColumnX().forEach(x -> g.drawLine((int)x, bounds.y, (int)x, bounds.y + bounds.height - 1));
            }
        }

        protected void paintExpandControl(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
            if (bounds.x < ColumnTreeBuilder.getTreeColumnWidth(this.myTable) - 1) {
                if (!this.myShouldAlwaysPaintExpandControl) {
                    super.paintExpandControl(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    return;
                }
                boolean isPathSelected = this.tree.getSelectionModel().isPathSelected(path);
                if (!this.isLeaf(row)) {
                    this.setExpandedIcon(UIUtil.getTreeNodeIcon((boolean)true, (boolean)isPathSelected, (boolean)this.tree.hasFocus()));
                    this.setCollapsedIcon(UIUtil.getTreeNodeIcon((boolean)false, (boolean)isPathSelected, (boolean)this.tree.hasFocus()));
                }
                if (!isLeaf) {
                    boolean leftToRight = this.tree.getComponentOrientation().isLeftToRight();
                    int middleXOfKnob = leftToRight ? bounds.x - this.getRightChildIndent() + 1 : bounds.x + bounds.width + this.getRightChildIndent() - 1;
                    int middleYOfKnob = bounds.y + bounds.height / 2;
                    if (isExpanded) {
                        Icon expandedIcon = this.getExpandedIcon();
                        if (expandedIcon != null) {
                            this.drawCentered(this.tree, g, expandedIcon, middleXOfKnob, middleYOfKnob);
                        }
                    } else {
                        Icon collapsedIcon = this.getCollapsedIcon();
                        if (collapsedIcon != null) {
                            this.drawCentered(this.tree, g, collapsedIcon, middleXOfKnob, middleYOfKnob);
                        }
                    }
                }
            }
        }

        private List<Integer> getColumnX() {
            if (this.myTable == null) {
                return new ArrayList<Integer>();
            }
            ArrayList<Integer> columnX = new ArrayList<Integer>();
            int x = 0;
            for (int i2 = 0; i2 < this.myTable.getColumnModel().getColumnCount() - 1; ++i2) {
                columnX.add((x += this.myTable.getColumnModel().getColumn(i2).getWidth()) - 1);
            }
            return columnX;
        }

        @NotNull
        protected ColumnTreeUI setShouldAlwaysPaintExpandControl(boolean shouldAlwaysPaintExpandControl) {
            this.myShouldAlwaysPaintExpandControl = shouldAlwaysPaintExpandControl;
            ColumnTreeUI columnTreeUI = this;
            if (columnTreeUI == null) {
                ColumnTreeUI.$$$reportNull$$$0(0);
            }
            return columnTreeUI;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/common/ColumnTreeBuilder$ColumnTreeUI", "setShouldAlwaysPaintExpandControl"));
        }
    }

    private static class HeaderColumnTreeUI
    extends ColumnTreeUI {
        HeaderColumnTreeUI(Color hoverColor, ColumnTreeHoverListener hoverConfig, JTable table, ColumnTreeScrollPanel hsb) {
            super(hoverColor, hoverConfig, table, hsb);
        }

        @Override
        protected void onPaintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
            super.onPaintRow(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
            if (path.getPathCount() == 2) {
                int containerWidth = this.tree.getParent() instanceof JViewport ? this.tree.getParent().getWidth() : this.tree.getWidth();
                int xOffset = this.tree.getParent() instanceof JViewport ? ((JViewport)this.tree.getParent()).getViewPosition().x : 0;
                Color originalColor = g.getColor();
                g.setColor((Color)StudioColorsKt.getPrimaryPanelBackground());
                g.fillRect(xOffset, bounds.y, containerWidth, bounds.height);
                g.setColor((Color)StudioColorsKt.getBorder());
                g.drawLine(xOffset, bounds.y, xOffset + containerWidth, bounds.y);
                g.drawLine(xOffset, bounds.y + bounds.height, xOffset + containerWidth, bounds.y + bounds.height);
                g.setColor(originalColor);
            }
        }
    }

    private static class ColumnLayout
    implements LayoutManager {
        @NotNull
        private final TableColumnModel myColumnModel;
        @NotNull
        private final JTree myTree;

        public ColumnLayout(@NotNull JTree tree, @NotNull TableColumnModel columnModel) {
            if (tree == null) {
                ColumnLayout.$$$reportNull$$$0(0);
            }
            if (columnModel == null) {
                ColumnLayout.$$$reportNull$$$0(1);
            }
            this.myTree = tree;
            this.myColumnModel = columnModel;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return parent.getSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return parent.getSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            int size = parent.getComponentCount();
            int columns = this.myColumnModel.getColumnCount();
            Insets insets = this.myTree.getInsets();
            assert (size == columns);
            int padding = this.myTree.getWidth();
            for (int i2 = 0; i2 < size && i2 < columns; ++i2) {
                padding -= this.myColumnModel.getColumn(i2).getWidth();
            }
            int offset = parent.getWidth() - (insets.left + insets.right);
            for (int i3 = size - 1; i3 >= 0; --i3) {
                Component component = parent.getComponent(i3);
                int columnWidth = this.myColumnModel.getColumn(i3).getWidth();
                if (i3 == size - 1) {
                    columnWidth -= insets.right;
                }
                int width = i3 == 0 ? offset : Math.min(columnWidth + padding, offset);
                component.setBounds(offset - width, 0, width, parent.getHeight());
                offset -= width;
                padding = 0;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "columnModel";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/adtui/common/ColumnTreeBuilder$ColumnLayout";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ColumnTreeScrollBar
    extends JBScrollBar {
        @NotNull
        private final JTable myTable;

        public void updateUI() {
            this.setUI((ScrollBarUI)((Object)new RangeScrollBarUI()));
        }

        public ColumnTreeScrollBar(@NotNull JTable table) {
            if (table == null) {
                ColumnTreeScrollBar.$$$reportNull$$$0(0);
            }
            super(0);
            this.myTable = table;
        }

        public Dimension getMinimumSize() {
            Dimension dim = super.getMinimumSize();
            return new Dimension(ColumnTreeBuilder.getTreeColumnWidth(this.myTable), dim.height);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/android/tools/adtui/common/ColumnTreeBuilder$ColumnTreeScrollBar", "<init>"));
        }
    }
}

