/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.compose;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.compose.ComposeStatus;
import com.android.tools.adtui.compose.IssueNotificationAction;
import com.android.tools.adtui.compose.IssueNotificationActionKt;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.JToolTip;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\r\u0010 \u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011H\u0016J\b\u0010!\u001a\u00020\u0013H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\u0012\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010#H\u0016J\b\u0010%\u001a\u00020#H\u0014J\b\u0010&\u001a\u00020\u0015H\u0014J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u0019H\u0016J\b\u0010*\u001a\u00020\u0019H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006+"}, d2={"Lcom/android/tools/adtui/compose/IssueNotificationActionButton;", "Lcom/intellij/openapi/actionSystem/impl/ActionButtonWithText;", "action", "Lcom/android/tools/adtui/compose/IssueNotificationAction;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "(Lcom/android/tools/adtui/compose/IssueNotificationAction;Lcom/intellij/openapi/actionSystem/Presentation;Ljava/lang/String;)V", "getAction", "()Lcom/android/tools/adtui/compose/IssueNotificationAction;", "actionPresentation", "Lcom/android/tools/adtui/compose/ComposeStatus$Presentation;", "getActionPresentation", "()Lcom/android/tools/adtui/compose/ComposeStatus$Presentation;", "font", "Ljava/awt/Font;", "Lorg/jetbrains/annotations/NotNull;", "textColor", "Lcom/intellij/ui/JBColor;", "textPosition", "", "getTextPosition", "()I", "addNotify", "", "createToolTip", "Ljavax/swing/JToolTip;", "getBackground", "Ljava/awt/Color;", "getBorder", "Ljavax/swing/border/Border;", "getFont", "getForeground", "getInsets", "Ljava/awt/Insets;", "insets", "getMargins", "iconTextSpace", "isBackgroundSet", "", "removeNotify", "updateToolTipText", "intellij.android.adt.ui"})
public final class IssueNotificationActionButton
extends ActionButtonWithText {
    @NotNull
    private final IssueNotificationAction action;
    @NotNull
    private final Font font;
    @NotNull
    private final JBColor textColor;

    public IssueNotificationActionButton(@NotNull IssueNotificationAction action, @NotNull Presentation presentation, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        super((AnAction)action, presentation, place, (Dimension)JBUI.size((int)0, (int)20));
        this.action = action;
        Font font = UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL);
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getLabelFont(UIUtil.FontSize.SMALL)");
        this.font = font;
        this.textColor = AdtUiUtils.INSTANCE.getTITLE_COLOR();
        this.setHorizontalTextPosition(this.getTextPosition());
    }

    @NotNull
    public final IssueNotificationAction getAction() {
        return this.action;
    }

    protected int iconTextSpace() {
        return this.getIcon() == null || this.getIcon().getIconWidth() <= 0 ? 0 : 2;
    }

    private final ComposeStatus.Presentation getActionPresentation() {
        return (ComposeStatus.Presentation)((Object)this.myPresentation.getClientProperty(ComposeStatus.Companion.getPRESENTATION()));
    }

    public final int getTextPosition() {
        Integer n = (Integer)this.myPresentation.getClientProperty(ComposeStatus.Companion.getTEXT_POSITION());
        return n == null ? 10 : n;
    }

    public boolean isBackgroundSet() {
        return this.getActionPresentation() != null || super.isBackgroundSet();
    }

    @Nullable
    public Color getBackground() {
        ComposeStatus.Presentation presentation = this.getActionPresentation();
        return presentation != null && (presentation = presentation.getColor()) != null ? (Color)((Object)presentation) : super.getBackground();
    }

    @NotNull
    public Font getFont() {
        return this.font;
    }

    @NotNull
    public JBColor getForeground() {
        return this.textColor;
    }

    @NotNull
    public Border getBorder() {
        Object object;
        if (this.getPopState() == 1) {
            Color color = JBUI.CurrentTheme.ActionButton.hoverBorder();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"hoverBorder()");
            object = IssueNotificationActionKt.chipBorder(color);
        } else {
            object = this.getActionPresentation();
            if (object == null || (object = object.getBorder()) == null) {
                JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty();
                Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"empty()");
                object = (Border)jBEmptyBorder;
            }
        }
        return object;
    }

    @NotNull
    protected Insets getMargins() {
        return this.action.margins();
    }

    @NotNull
    public Insets getInsets() {
        return this.action.insets();
    }

    @NotNull
    public Insets getInsets(@Nullable Insets insets) {
        Insets i2 = this.getInsets();
        if (insets != null) {
            insets.set(i2.top, i2.left, i2.bottom, i2.right);
            return insets;
        }
        return i2;
    }

    public void addNotify() {
        super.addNotify();
        this.addMouseListener(this.action.getMouseListener());
        this.setHorizontalTextPosition(this.getTextPosition());
    }

    public void removeNotify() {
        this.removeMouseListener(this.action.getMouseListener());
        super.removeNotify();
    }

    @Nullable
    public JToolTip createToolTip() {
        return null;
    }

    protected void updateToolTipText() {
    }
}

