/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.font;

import com.google.common.collect.Sets;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.util.SystemInfo;
import java.awt.Font;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class FontUtil {
    @NotNull
    public static Font getFontAbleToDisplay(@NotNull String s, @NotNull Font defaultFont) {
        if (s == null) {
            FontUtil.$$$reportNull$$$0(0);
        }
        if (defaultFont == null) {
            FontUtil.$$$reportNull$$$0(1);
        }
        if (SystemInfo.isMac || FontUtil.isExtendedAscii(s)) {
            Font font = defaultFont;
            if (font == null) {
                FontUtil.$$$reportNull$$$0(2);
            }
            return font;
        }
        HashSet fonts = Sets.newHashSetWithExpectedSize((int)10);
        FontPreferences fontPreferences = EditorColorsManager.getInstance().getGlobalScheme().getFontPreferences();
        for (int i2 = 0; i2 < s.length(); ++i2) {
            if (s.charAt(i2) <= '\u00ff') continue;
            fonts.add(ComplementaryFontsRegistry.getFontAbleToDisplay((int)s.charAt(i2), (int)0, (FontPreferences)fontPreferences, null).getFont());
        }
        if (fonts.isEmpty()) {
            Font font = defaultFont;
            if (font == null) {
                FontUtil.$$$reportNull$$$0(3);
            }
            return font;
        }
        Font bestFont = defaultFont;
        int max = 0;
        for (Font f : fonts) {
            int supportedChars = 0;
            for (int i3 = 0; i3 < s.length(); ++i3) {
                if (!f.canDisplay(s.charAt(i3))) continue;
                ++supportedChars;
            }
            if (supportedChars <= max) continue;
            max = supportedChars;
            bestFont = f;
        }
        Font font = bestFont;
        if (font == null) {
            FontUtil.$$$reportNull$$$0(4);
        }
        return font;
    }

    private static boolean isExtendedAscii(@NotNull String s) {
        if (s == null) {
            FontUtil.$$$reportNull$$$0(5);
        }
        for (int i2 = 0; i2 < s.length(); ++i2) {
            if (s.charAt(i2) <= '\u00ff') continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultFont";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/font/FontUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/font/FontUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontAbleToDisplay";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFontAbleToDisplay";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isExtendedAscii";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

