/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.instructions;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.instructions.InstructionsRenderer;
import com.android.tools.adtui.instructions.RenderInstruction;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.EaseOutModel;
import com.android.tools.adtui.util.SwingUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstructionsPanel
extends JPanel {
    @Nullable
    private final EaseOutModel myEaseOutModel;
    @Nullable
    private AspectObserver myObserver;
    @Nullable
    private Consumer<InstructionsPanel> myEaseOutCompletionCallback;

    private InstructionsPanel(@NotNull Builder builder) {
        if (builder == null) {
            InstructionsPanel.$$$reportNull$$$0(0);
        }
        super(new TabularLayout("*,Fit-,*", "45*,Fit-,55*"));
        if (builder.myMode == Mode.FLOATING) {
            this.setOpaque(false);
        }
        this.setBackground(builder.myBackgroundColor);
        this.setForeground(builder.myForegroundColor);
        InstructionsComponent component = new InstructionsComponent(builder);
        this.add((Component)component, new TabularLayout.Constraint(1, 1));
        this.myEaseOutModel = builder.myEaseOutModel;
        this.myEaseOutCompletionCallback = builder.myEaseOutCompletionCallback;
        if (this.myEaseOutModel != null) {
            this.myObserver = new AspectObserver();
            this.myEaseOutModel.addDependency(this.myObserver).onChange(EaseOutModel.Aspect.EASING, this::modelChanged);
        }
    }

    private void modelChanged() {
        if (this.myEaseOutCompletionCallback == null) {
            return;
        }
        assert (this.myEaseOutModel != null);
        if (this.myEaseOutModel.getPercentageComplete() >= 1.0f) {
            this.myEaseOutCompletionCallback.accept(this);
            this.myEaseOutCompletionCallback = null;
        }
    }

    @VisibleForTesting
    @NotNull
    public List<RenderInstruction> getRenderInstructionsForComponent(int component) {
        assert (component >= 0 && component < this.getComponentCount());
        InstructionsComponent instructionsComponent = (InstructionsComponent)this.getComponent(component);
        List<RenderInstruction> list = instructionsComponent.getRenderInstructions();
        if (list == null) {
            InstructionsPanel.$$$reportNull$$$0(1);
        }
        return list;
    }

    @VisibleForTesting
    @NotNull
    public InstructionsRenderer getRenderer() {
        InstructionsRenderer renderer = null;
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            Component c = this.getComponent(i2);
            if (!(c instanceof InstructionsComponent)) continue;
            renderer = ((InstructionsComponent)c).myRenderer;
            break;
        }
        assert (renderer != null);
        InstructionsRenderer instructionsRenderer = renderer;
        if (instructionsRenderer == null) {
            InstructionsPanel.$$$reportNull$$$0(2);
        }
        return instructionsRenderer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/instructions/InstructionsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/instructions/InstructionsPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderInstructionsForComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    public static final class Builder {
        private Mode myMode;
        private static final Color INSTRUCTIONS_BACKGROUND = new JBColor(new Color(-666483130, true), new Color(-655956250, true));
        private static final Color INSTRUCTIONS_FOREGROUND = new JBColor(new Color(0xFFFFFF), new Color(0));
        public static final int DEFAULT_PADDING_PX = JBUIScale.scale((int)12);
        private int myArcWidth;
        private int myArcHeight;
        private int myHorizontalPadding;
        private int myVerticalPadding;
        @Nullable
        private Color myBackgroundColor;
        @NotNull
        private Color myForegroundColor;
        private InstructionsRenderer.HorizontalAlignment myAlignment;
        @Nullable
        private EaseOutModel myEaseOutModel;
        @Nullable
        private Consumer<InstructionsPanel> myEaseOutCompletionCallback;
        @NotNull
        private final List<RenderInstruction> myInstructions;
        @Nullable
        private BiFunction<Container, Cursor, Container> myCursorSetter;

        public Builder() {
            this.myMode = Mode.FLOATING;
            this.myHorizontalPadding = DEFAULT_PADDING_PX;
            this.myVerticalPadding = DEFAULT_PADDING_PX;
            this.myBackgroundColor = INSTRUCTIONS_BACKGROUND;
            this.myForegroundColor = INSTRUCTIONS_FOREGROUND;
            this.myAlignment = InstructionsRenderer.HorizontalAlignment.CENTER;
            this.myInstructions = new ArrayList<RenderInstruction>();
        }

        public Builder(RenderInstruction ... instructions) {
            if (instructions == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myMode = Mode.FLOATING;
            this.myHorizontalPadding = DEFAULT_PADDING_PX;
            this.myVerticalPadding = DEFAULT_PADDING_PX;
            this.myBackgroundColor = INSTRUCTIONS_BACKGROUND;
            this.myForegroundColor = INSTRUCTIONS_FOREGROUND;
            this.myAlignment = InstructionsRenderer.HorizontalAlignment.CENTER;
            this.myInstructions = new ArrayList<RenderInstruction>();
            this.myInstructions.addAll(Arrays.asList(instructions));
        }

        public Builder addInstruction(@NotNull RenderInstruction instruction) {
            if (instruction == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myInstructions.add(instruction);
            return this;
        }

        @NotNull
        public Builder setMode(Mode mode) {
            this.myMode = mode;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder;
        }

        @NotNull
        public Builder setColors(@NotNull Color foregroundColor, @Nullable Color backgroundColor) {
            if (foregroundColor == null) {
                Builder.$$$reportNull$$$0(3);
            }
            this.myForegroundColor = foregroundColor;
            this.myBackgroundColor = backgroundColor;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder;
        }

        @NotNull
        public Builder setAlignment(@NotNull InstructionsRenderer.HorizontalAlignment alignment) {
            if (alignment == null) {
                Builder.$$$reportNull$$$0(5);
            }
            this.myAlignment = alignment;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder;
        }

        @NotNull
        public Builder setPaddings(int horizontalPadding, int verticalPadding) {
            this.myHorizontalPadding = horizontalPadding;
            this.myVerticalPadding = verticalPadding;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder;
        }

        @NotNull
        public Builder setBackgroundCornerRadius(int arcWidth, int arcHeight) {
            this.myArcWidth = arcWidth;
            this.myArcHeight = arcHeight;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return builder;
        }

        @NotNull
        public Builder setEaseOut(@NotNull EaseOutModel easeOutModel, @Nullable Consumer<InstructionsPanel> easeOutCompletionCallback) {
            if (easeOutModel == null) {
                Builder.$$$reportNull$$$0(9);
            }
            this.myEaseOutModel = easeOutModel;
            this.myEaseOutCompletionCallback = easeOutCompletionCallback;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return builder;
        }

        @NotNull
        public Builder setCursorSetter(@NotNull BiFunction<Container, Cursor, Container> cursorSetter) {
            if (cursorSetter == null) {
                Builder.$$$reportNull$$$0(11);
            }
            this.myCursorSetter = cursorSetter;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(12);
            }
            return builder;
        }

        @NotNull
        public InstructionsPanel build() {
            return new InstructionsPanel(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4, 6, 7, 8, 10, 12 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instructions";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instruction";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/adtui/instructions/InstructionsPanel$Builder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "foregroundColor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "alignment";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "easeOutModel";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cursorSetter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/adtui/instructions/InstructionsPanel$Builder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setMode";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setColors";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setAlignment";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setPaddings";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setBackgroundCornerRadius";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setEaseOut";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setCursorSetter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addInstruction";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 12: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setColors";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setAlignment";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "setEaseOut";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "setCursorSetter";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4, 6, 7, 8, 10, 12 -> new IllegalStateException(string);
            };
        }
    }

    public static enum Mode {
        FLOATING,
        FILL_PANEL;

    }

    private static class InstructionsComponent
    extends AnimatedComponent {
        private final int myHorizontalPadding;
        private final int myVerticalPadding;
        private final int myArcWidth;
        private final int myArcHeight;
        private float myAlpha;
        @Nullable
        private EaseOutModel myEaseOutModel;
        @NotNull
        private final InstructionsRenderer myRenderer;
        @Nullable
        private final BiFunction<Container, Cursor, Container> myCursorSetter;
        @Nullable
        private Container myCachedCursorContainer;
        @Nullable
        private RenderInstruction myFocusInstruction;

        public InstructionsComponent(@NotNull Builder builder) {
            if (builder == null) {
                InstructionsComponent.$$$reportNull$$$0(0);
            }
            this.myCachedCursorContainer = null;
            this.setBackground(builder.myMode == Mode.FLOATING ? builder.myBackgroundColor : null);
            this.myEaseOutModel = builder.myEaseOutModel;
            this.myHorizontalPadding = builder.myHorizontalPadding;
            this.myVerticalPadding = builder.myVerticalPadding;
            this.myArcWidth = builder.myArcWidth;
            this.myArcHeight = builder.myArcHeight;
            this.myRenderer = new InstructionsRenderer(builder.myInstructions, builder.myAlignment);
            this.myAlpha = 1.0f;
            this.myCursorSetter = builder.myCursorSetter;
            if (this.myEaseOutModel != null) {
                this.myEaseOutModel.addDependency(this.myAspectObserver).onChange(EaseOutModel.Aspect.EASING, this::modelChanged);
            }
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    RenderInstruction instruction = this.delegateMouseEvent(e);
                    this.setCursor(instruction != null ? instruction.getCursorIcon() : null);
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    this.delegateMouseEvent(e);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.delegateMouseEvent(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.delegateMouseEvent(e);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (myFocusInstruction != null) {
                        this.handleMouseEvent(myFocusInstruction, e);
                        myFocusInstruction = null;
                        this.setCursor(null);
                    }
                }
            });
        }

        @Override
        public void setCursor(Cursor cursor) {
            if (this.myCachedCursorContainer != null) {
                this.myCachedCursorContainer.setCursor(cursor);
            } else if (this.myCursorSetter != null) {
                this.myCachedCursorContainer = this.myCursorSetter.apply(this, cursor);
            } else {
                super.setCursor(cursor);
            }
        }

        @VisibleForTesting
        @NotNull
        public List<RenderInstruction> getRenderInstructions() {
            List<RenderInstruction> list = this.myRenderer.getInstructions();
            if (list == null) {
                InstructionsComponent.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Nullable
        private RenderInstruction delegateMouseEvent(@NotNull MouseEvent event) {
            if (event == null) {
                InstructionsComponent.$$$reportNull$$$0(2);
            }
            event.translatePoint(-this.myHorizontalPadding, -this.myVerticalPadding);
            Point position = event.getPoint();
            Point cursor = new Point(this.myRenderer.getStartX(0), 0);
            RenderInstruction focusInstruction = null;
            for (RenderInstruction instruction : this.myRenderer.getInstructions()) {
                Rectangle bounds = instruction.getBounds(this.myRenderer, cursor);
                if (bounds.contains(position)) {
                    event.translatePoint(-bounds.x, -bounds.y);
                    focusInstruction = instruction;
                    break;
                }
                instruction.moveCursor(this.myRenderer, cursor);
            }
            if (this.myFocusInstruction != focusInstruction) {
                if (this.myFocusInstruction != null) {
                    this.handleMouseEvent(this.myFocusInstruction, SwingUtil.convertMouseEventID(event, 505));
                }
                this.myFocusInstruction = focusInstruction;
            }
            if (this.myFocusInstruction != null) {
                this.handleMouseEvent(this.myFocusInstruction, event);
            }
            return this.myFocusInstruction;
        }

        private void handleMouseEvent(@NotNull RenderInstruction instruction, @NotNull MouseEvent e) {
            if (instruction == null) {
                InstructionsComponent.$$$reportNull$$$0(3);
            }
            if (e == null) {
                InstructionsComponent.$$$reportNull$$$0(4);
            }
            instruction.handleMouseEvent(e);
            this.repaint();
        }

        private void modelChanged() {
            if (this.myAlpha <= 0.0f) {
                return;
            }
            assert (this.myEaseOutModel != null);
            this.myAlpha = 1.0f - this.myEaseOutModel.getPercentageComplete();
            this.opaqueRepaint();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension renderSize = this.myRenderer.getRenderSize();
            return new Dimension(renderSize.width + 2 * this.myHorizontalPadding, renderSize.height + 2 * this.myVerticalPadding);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        protected void draw(Graphics2D g2d, Dimension dim) {
            Color background;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setComposite(AlphaComposite.getInstance(3, this.myAlpha));
            Color color = background = this.isBackgroundSet() ? this.getBackground() : null;
            if (background != null) {
                g2d.setColor(background);
                Dimension size = this.getPreferredSize();
                g2d.fillRoundRect(0, 0, size.width, size.height, this.myArcWidth, this.myArcHeight);
            }
            g2d.translate(this.myHorizontalPadding, this.myVerticalPadding);
            this.myRenderer.draw(this, g2d);
            g2d.translate(-this.myHorizontalPadding, -this.myVerticalPadding);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/adtui/instructions/InstructionsPanel$InstructionsComponent";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instruction";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/adtui/instructions/InstructionsPanel$InstructionsComponent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRenderInstructions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "delegateMouseEvent";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "handleMouseEvent";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

