/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.instructions;

import com.android.tools.adtui.instructions.RenderInstruction;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.ui.UIUtilities;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class TextInstruction
extends RenderInstruction {
    @NotNull
    private final String myText;
    @NotNull
    private final Font myFont;
    @NotNull
    private final Dimension mySize;

    public TextInstruction(@NotNull FontMetrics metrics, @NotNull String text) {
        if (metrics == null) {
            TextInstruction.$$$reportNull$$$0(0);
        }
        if (text == null) {
            TextInstruction.$$$reportNull$$$0(1);
        }
        this.myFont = metrics.getFont();
        this.myText = text;
        Rectangle2D bounds = this.myFont.getStringBounds(this.myText, metrics.getFontRenderContext());
        int w = (int)bounds.getWidth();
        int h = (int)bounds.getHeight();
        this.mySize = new Dimension(w, h);
    }

    @Override
    @NotNull
    public Dimension getSize() {
        Dimension dimension = this.mySize;
        if (dimension == null) {
            TextInstruction.$$$reportNull$$$0(2);
        }
        return dimension;
    }

    @VisibleForTesting
    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            TextInstruction.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public void render(@NotNull JComponent c, @NotNull Graphics2D g2d, @NotNull Rectangle bounds) {
        if (c == null) {
            TextInstruction.$$$reportNull$$$0(4);
        }
        if (g2d == null) {
            TextInstruction.$$$reportNull$$$0(5);
        }
        if (bounds == null) {
            TextInstruction.$$$reportNull$$$0(6);
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        assert (this.mySize.height <= bounds.height);
        g2d.setColor(c.getForeground());
        g2d.setFont(this.myFont);
        FontMetrics metrics = UIUtilities.getFontMetrics((JComponent)c, (Font)this.myFont);
        Rectangle2D newBounds = this.myFont.getStringBounds(this.myText, metrics.getFontRenderContext());
        this.mySize.setSize((int)newBounds.getWidth(), (int)newBounds.getHeight());
        int textY = bounds.y + metrics.getAscent() + (bounds.height - this.mySize.height) / 2;
        g2d.drawString(this.myText, bounds.x, textY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metrics";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/instructions/TextInstruction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g2d";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/instructions/TextInstruction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSize";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

