/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B'\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f0\u000e2\u0006\u0010\u0017\u001a\u00020\u0004J\u0014\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f0\u000eH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/adtui/model/RangedSeries;", "E", "", "xRange", "Lcom/android/tools/adtui/model/Range;", "_series", "Lcom/android/tools/adtui/model/DataSeries;", "intersectRange", "(Lcom/android/tools/adtui/model/Range;Lcom/android/tools/adtui/model/DataSeries;Lcom/android/tools/adtui/model/Range;)V", "intersection", "getIntersection", "()Lcom/android/tools/adtui/model/Range;", "lastQueriedRange", "lastQueriedSeries", "", "Lcom/android/tools/adtui/model/SeriesData;", "maxEndPoints", "", "series", "getSeries", "()Ljava/util/List;", "getXRange", "getSeriesForRange", "range", "getValuesInRange", "intellij.android.adt.ui.model"})
public class RangedSeries<E> {
    @NotNull
    private final Range xRange;
    @NotNull
    private DataSeries<E> _series;
    @NotNull
    private final Range intersectRange;
    @NotNull
    private final List<Double> maxEndPoints;
    @NotNull
    private Range lastQueriedRange;
    @NotNull
    private List<SeriesData<E>> lastQueriedSeries;

    @JvmOverloads
    public RangedSeries(@NotNull Range xRange, @NotNull DataSeries<E> _series, @NotNull Range intersectRange) {
        Intrinsics.checkNotNullParameter((Object)xRange, (String)"xRange");
        Intrinsics.checkNotNullParameter(_series, (String)"_series");
        Intrinsics.checkNotNullParameter((Object)intersectRange, (String)"intersectRange");
        this.xRange = xRange;
        this._series = _series;
        this.intersectRange = intersectRange;
        Object[] objectArray = new Double[]{9.223372036854776E18, Double.MAX_VALUE};
        this.maxEndPoints = CollectionsKt.listOf((Object[])objectArray);
        this.lastQueriedRange = new Range();
        this.lastQueriedSeries = CollectionsKt.emptyList();
    }

    public /* synthetic */ RangedSeries(Range range, DataSeries dataSeries, Range range2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            range2 = new Range(-1.7976931348623157E308, Double.MAX_VALUE);
        }
        this(range, dataSeries, range2);
    }

    @NotNull
    public final Range getXRange() {
        return this.xRange;
    }

    @NotNull
    public final Range getIntersection() {
        Range range = this.xRange.getIntersection(this.intersectRange);
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"xRange.getIntersection(intersectRange)");
        return range;
    }

    @NotNull
    public final List<SeriesData<E>> getSeries() {
        return this.getValuesInRange();
    }

    private final List<SeriesData<E>> getValuesInRange() {
        Range queryRange = this.xRange.getIntersection(this.intersectRange);
        if (this.maxEndPoints.contains(queryRange.getMax())) {
            Intrinsics.checkNotNullExpressionValue((Object)queryRange, (String)"queryRange");
            return this._series.getDataForRange(queryRange);
        }
        if (!this.lastQueriedRange.isSameAs(queryRange)) {
            Intrinsics.checkNotNullExpressionValue((Object)queryRange, (String)"queryRange");
            List<SeriesData<E>> queriedSeries = this._series.getDataForRange(queryRange);
            this.lastQueriedRange = queryRange;
            this.lastQueriedSeries = CollectionsKt.toList((Iterable)queriedSeries);
        }
        return this.lastQueriedSeries;
    }

    @NotNull
    public final List<SeriesData<E>> getSeriesForRange(@NotNull Range range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return this._series.getDataForRange(range);
    }

    @JvmOverloads
    public RangedSeries(@NotNull Range xRange, @NotNull DataSeries<E> _series) {
        Intrinsics.checkNotNullParameter((Object)xRange, (String)"xRange");
        Intrinsics.checkNotNullParameter(_series, (String)"_series");
        this(xRange, _series, null, 4, null);
    }
}

