/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.filter;

import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Filter {
    public static final Filter EMPTY_FILTER = new Filter();
    @NotNull
    private final String myFilterString;
    private final boolean myIsMatchCase;
    private final boolean myIsRegex;
    @Nullable
    private final Pattern myPattern;

    public Filter() {
        this("");
    }

    public Filter(@NotNull String filterString) {
        if (filterString == null) {
            Filter.$$$reportNull$$$0(0);
        }
        this(filterString, false, false);
    }

    public Filter(@NotNull String filterString, boolean isMatchCase, boolean isRegex) {
        if (filterString == null) {
            Filter.$$$reportNull$$$0(1);
        }
        this.myFilterString = filterString;
        this.myIsMatchCase = isMatchCase;
        this.myIsRegex = isRegex;
        this.myPattern = this.createFilterPattern();
    }

    @NotNull
    public String getFilterString() {
        String string = this.myFilterString;
        if (string == null) {
            Filter.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isMatchCase() {
        return this.myIsMatchCase;
    }

    public boolean isRegex() {
        return this.myIsRegex;
    }

    public boolean isEmpty() {
        return this.myPattern == null;
    }

    public boolean matches(@NotNull String string) {
        if (string == null) {
            Filter.$$$reportNull$$$0(3);
        }
        return this.myPattern == null || this.myPattern.matcher(string).matches();
    }

    @Nullable
    private Pattern createFilterPattern() {
        int flags = this.myIsMatchCase ? 0 : 2;
        Pattern pattern = null;
        if (!this.myFilterString.isEmpty()) {
            block5: {
                if (this.myIsRegex) {
                    try {
                        pattern = Pattern.compile("^.*" + this.myFilterString + ".*$", flags);
                    }
                    catch (PatternSyntaxException e) {
                        if ($assertionsDisabled || e.getMessage() != null) break block5;
                        throw new AssertionError();
                    }
                }
            }
            if (pattern == null) {
                pattern = Pattern.compile("^.*" + Pattern.quote(this.myFilterString) + ".*$", flags);
            }
        }
        return pattern;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Filter) {
            Filter filter = (Filter)obj;
            if (this.myPattern == null) {
                return filter.myPattern == null;
            }
            return this.myPattern.pattern().equals(filter.myPattern) && this.myPattern.flags() == filter.myPattern.flags();
        }
        return false;
    }

    public int hashCode() {
        return this.myPattern == null ? 0 : Objects.hash(this.myPattern.pattern(), this.myPattern.flags());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterString";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/model/filter/Filter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/model/filter/Filter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

