/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.formatter;

import java.text.Format;
import java.text.NumberFormat;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class NumberFormatter {
    private static final Format INTEGER_FORMAT = NumberFormat.getIntegerInstance();
    private static final String[] FILE_SIZE_UNITS = new String[]{"B", "KB", "MB", "GB", "TB", "PB", "EB"};
    private static final int FILE_SIZE_MULTIPLIER = 1024;
    private static final String[] FREQUENCY_UNITS = new String[]{"kHz", "MHz", "GHz"};
    private static final int FREQUENCY_MULTIPLIER = 1000;

    @NotNull
    public static String formatInteger(@NotNull Number number) {
        if (number == null) {
            NumberFormatter.$$$reportNull$$$0(0);
        }
        String string = INTEGER_FORMAT.format(number);
        if (string == null) {
            NumberFormatter.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String formatFileSize(long sizeInBytes) {
        String string = NumberFormatter.formatNumberWithUnit(sizeInBytes, 1024, FILE_SIZE_UNITS);
        if (string == null) {
            NumberFormatter.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String formatFrequency(long frequencyInKhz) {
        String string = NumberFormatter.formatNumberWithUnit(frequencyInKhz, 1000, FREQUENCY_UNITS);
        if (string == null) {
            NumberFormatter.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static String formatNumberWithUnit(long number, int multiplier, String[] units) {
        double result = number;
        String unit = units[0];
        for (int i2 = 1; i2 < units.length && !(result < (double)multiplier); result /= (double)multiplier, ++i2) {
            unit = units[i2];
        }
        String decimalFormat = result < 100.0 ? "%.1f" : "%.0f";
        return String.format(Locale.US, decimalFormat + " %s", result, unit);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/model/formatter/NumberFormatter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/model/formatter/NumberFormatter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "formatInteger";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "formatFileSize";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "formatFrequency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "formatInteger";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

