/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.HoverRowTable;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.axis.ResizingAxisComponentModel;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.adtui.stdui.StandardColors;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public final class TimelineTable {
    private static final int HEADER_HEIGHT = 20;
    private static final int TIMELINE_HEIGHT = 14;

    @NotNull
    public static JBTable create(@NotNull TableModel model2, @NotNull Timeline timeline, @NotNull String timelineColumnName, boolean showsAllWhenEmpty) {
        if (model2 == null) {
            TimelineTable.$$$reportNull$$$0(0);
        }
        if (timeline == null) {
            TimelineTable.$$$reportNull$$$0(1);
        }
        if (timelineColumnName == null) {
            TimelineTable.$$$reportNull$$$0(2);
        }
        HoverRowTable table = new HoverRowTable(model2);
        table.getTableHeader().setDefaultRenderer(new HeaderRenderer((JTable)((Object)table), timeline, timelineColumnName, showsAllWhenEmpty));
        AspectObserver timelineObserver = new AspectObserver();
        table.addHierarchyListener(e -> {
            if ((e.getChangeFlags() & 4L) != 0L) {
                if (table.isShowing()) {
                    timeline.getSelectionRange().addDependency(timelineObserver).onChange(Range.Aspect.RANGE, () -> {
                        table.repaint();
                        table.getTableHeader().revalidate();
                    });
                    if (showsAllWhenEmpty) {
                        timeline.getDataRange().addDependency(timelineObserver).onChange(Range.Aspect.RANGE, () -> {
                            if (timeline.getSelectionRange().isEmpty()) {
                                table.repaint();
                                table.getTableHeader().repaint();
                            }
                        });
                    }
                } else {
                    timeline.getSelectionRange().removeDependencies(timelineObserver);
                    timeline.getDataRange().removeDependencies(timelineObserver);
                }
            }
        });
        boolean[] lastIsEmpty = new boolean[]{true};
        table.getModel().addTableModelListener(e -> {
            boolean isEmpty;
            boolean bl = isEmpty = table.getRowCount() == 0;
            if (lastIsEmpty[0] != isEmpty) {
                lastIsEmpty[0] = isEmpty;
                table.getTableHeader().resizeAndRepaint();
            }
        });
        HoverRowTable hoverRowTable = table;
        if (hoverRowTable == null) {
            TimelineTable.$$$reportNull$$$0(3);
        }
        return hoverRowTable;
    }

    @NotNull
    private static AxisComponent createAxis(@NotNull Timeline timeline, boolean showsAllWhenEmpty) {
        Range range;
        if (timeline == null) {
            TimelineTable.$$$reportNull$$$0(4);
        }
        if ((range = timeline.getSelectionRange()).isEmpty() && showsAllWhenEmpty) {
            range = timeline.getDataRange();
        }
        ResizingAxisComponentModel model2 = new ResizingAxisComponentModel.Builder(range, new TimeAxisFormatter(1, 5, 1)).setGlobalRange(timeline.getDataRange()).build();
        AxisComponent axis = new AxisComponent(model2, AxisComponent.AxisOrientation.BOTTOM, true);
        axis.setShowAxisLine(false);
        axis.setMarkerColor(StandardColors.AXIS_MARKER_COLOR);
        AxisComponent axisComponent = axis;
        if (axisComponent == null) {
            TimelineTable.$$$reportNull$$$0(5);
        }
        return axisComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeline";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timelineColumnName";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/stdui/TimelineTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/stdui/TimelineTable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createAxis";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createAxis";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }

    private static final class HeaderRenderer
    implements TableCellRenderer {
        @NotNull
        private final TableCellRenderer myDelegateRenderer;
        @NotNull
        private final Timeline myTimeline;
        @NotNull
        private final String myTimelineColumnName;
        private final boolean myShowsAllWhenEmpty;

        private HeaderRenderer(@NotNull JTable table, @NotNull Timeline timeline, @NotNull String timelineColumnName, boolean showsAllWhenEmpty) {
            if (table == null) {
                HeaderRenderer.$$$reportNull$$$0(0);
            }
            if (timeline == null) {
                HeaderRenderer.$$$reportNull$$$0(1);
            }
            if (timelineColumnName == null) {
                HeaderRenderer.$$$reportNull$$$0(2);
            }
            this.myDelegateRenderer = table.getTableHeader().getDefaultRenderer();
            this.myTimeline = timeline;
            this.myShowsAllWhenEmpty = showsAllWhenEmpty;
            this.myTimelineColumnName = timelineColumnName;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent headerComponent = (JComponent)this.myDelegateRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (headerComponent instanceof JLabel) {
                headerComponent.setBorder((Border)JBUI.Borders.empty((int)3, (int)10, (int)3, (int)0));
                ((JLabel)headerComponent).setHorizontalAlignment(2);
            }
            if (table.getRowCount() == 0) {
                return headerComponent;
            }
            JPanel rendererPanel = new JPanel(new TabularLayout("*", String.format(Locale.getDefault(), "%dpx,%dpx", 20, 14)));
            rendererPanel.setOpaque(false);
            headerComponent.setOpaque(false);
            JPanel axisPanel = new JPanel(new BorderLayout());
            axisPanel.setBackground(StandardColors.DEFAULT_CONTENT_BACKGROUND_COLOR);
            if (this.myTimelineColumnName.equals(value)) {
                AxisComponent header2 = TimelineTable.createAxis(this.myTimeline, this.myShowsAllWhenEmpty);
                header2.setShowAxisLine(false);
                header2.setMarkerLengths(14, 0);
                axisPanel.add(header2);
            } else {
                JComponent separator = AdtUiUtils.createHorizontalSeparator();
                separator.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
                axisPanel.add(separator);
            }
            axisPanel.setBorder(new GridBorder(table));
            rendererPanel.add((Component)headerComponent, new TabularLayout.Constraint(0, 0));
            rendererPanel.add((Component)axisPanel, new TabularLayout.Constraint(1, 0));
            return rendererPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "table";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "timeline";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "timelineColumnName";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/adtui/stdui/TimelineTable$HeaderRenderer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class GridBorder
    implements Border {
        private final Color myColor;

        public GridBorder(@NotNull JTable table) {
            if (table == null) {
                GridBorder.$$$reportNull$$$0(0);
            }
            this.myColor = table.getGridColor();
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(this.myColor);
            int xRight = x + width - 1;
            g.drawLine(xRight, y, xRight, y + height);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return JBInsets.emptyInsets();
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/android/tools/adtui/stdui/TimelineTable$GridBorder", "<init>"));
        }
    }

    public static abstract class CellRenderer
    implements TableCellRenderer {
        private Timeline myTimeline;
        private final boolean myShowsAllWhenEmpty;

        public CellRenderer(@NotNull Timeline timeline) {
            if (timeline == null) {
                CellRenderer.$$$reportNull$$$0(0);
            }
            this(timeline, false);
        }

        public CellRenderer(@NotNull Timeline timeline, boolean showsAllWhenEmpty) {
            if (timeline == null) {
                CellRenderer.$$$reportNull$$$0(1);
            }
            this.myTimeline = timeline;
            this.myShowsAllWhenEmpty = showsAllWhenEmpty;
        }

        @Override
        public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JPanel panel2 = new JPanel(new TabularLayout("*", "*"));
            panel2.add(this.getTableCellRendererComponent(isSelected, row), new TabularLayout.Constraint(0, 0));
            AxisComponent axisTicks = TimelineTable.createAxis(this.myTimeline, this.myShowsAllWhenEmpty);
            axisTicks.setShowLabels(false);
            axisTicks.setMarkerLengths(table.getRowHeight(), 0);
            panel2.add((Component)axisTicks, new TabularLayout.Constraint(0, 0));
            return panel2;
        }

        @NotNull
        protected final Timeline getTimeline() {
            Timeline timeline = this.myTimeline;
            if (timeline == null) {
                CellRenderer.$$$reportNull$$$0(2);
            }
            return timeline;
        }

        @NotNull
        public final Range getActiveRange() {
            Range range = this.myTimeline.getSelectionRange().isEmpty() && this.myShowsAllWhenEmpty ? this.myTimeline.getDataRange() : this.myTimeline.getSelectionRange();
            if (range == null) {
                CellRenderer.$$$reportNull$$$0(3);
            }
            return range;
        }

        @NotNull
        protected abstract Component getTableCellRendererComponent(boolean var1, int var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "timeline";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/adtui/stdui/TimelineTable$CellRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/adtui/stdui/TimelineTable$CellRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTimeline";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActiveRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

