/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui.menu;

import com.android.tools.adtui.model.stdui.CommonAction;
import com.android.tools.adtui.stdui.CommonToggleButton;
import com.android.tools.adtui.stdui.menu.CommonDropDownButtonUI;
import com.android.tools.adtui.stdui.menu.CommonMenu;
import com.android.tools.adtui.stdui.menu.CommonMenuItem;
import com.android.tools.adtui.stdui.menu.CommonPopupMenu;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.ui.PopupMenuListenerAdapter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonDropDownButton
extends CommonToggleButton
implements PropertyChangeListener {
    @NotNull
    private final CommonPopupMenu myPopup;
    @NotNull
    private final CommonAction myAction;

    public CommonDropDownButton(@NotNull CommonAction action) {
        if (action == null) {
            CommonDropDownButton.$$$reportNull$$$0(0);
        }
        super(action.getText(), action.getIcon());
        this.myAction = action;
        this.myPopup = new CommonPopupMenu();
        this.myPopup.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeInvisible(@NotNull PopupMenuEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                CommonDropDownButton.this.setSelected(false);
            }

            public void popupMenuCanceled(@NotNull PopupMenuEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                CommonDropDownButton.this.setSelected(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/android/tools/adtui/stdui/menu/CommonDropDownButton$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "popupMenuWillBecomeInvisible";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "popupMenuCanceled";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent event) {
                CommonDropDownButton menu;
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((menu = CommonDropDownButton.this).isSelected()) {
                    CommonDropDownButton.this.myAction.actionPerformed(event);
                    CommonDropDownButton.this.populatePopup();
                    JBPopupMenu.showBelow((Component)menu, (JPopupMenu)CommonDropDownButton.this.myPopup);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/stdui/menu/CommonDropDownButton$2", "actionPerformed"));
            }
        });
        this.addPropertyChangeListenerRecursive(this.myAction);
    }

    @VisibleForTesting
    @NotNull
    JPopupMenu getPopup() {
        CommonPopupMenu commonPopupMenu = this.myPopup;
        if (commonPopupMenu == null) {
            CommonDropDownButton.$$$reportNull$$$0(1);
        }
        return commonPopupMenu;
    }

    @Override
    @NotNull
    public CommonAction getAction() {
        CommonAction commonAction = this.myAction;
        if (commonAction == null) {
            CommonDropDownButton.$$$reportNull$$$0(2);
        }
        return commonAction;
    }

    private void populatePopup() {
        this.myPopup.removeAll();
        List<CommonAction> actions2 = this.myAction.getChildrenActions();
        for (CommonAction action : actions2) {
            JMenuItem menu;
            if (action instanceof CommonAction.SeparatorAction) {
                this.myPopup.addSeparator();
                continue;
            }
            if (action.getChildrenActionCount() == 0) {
                menu = new CommonMenuItem(action);
            } else {
                menu = new CommonMenu(action);
                this.populateMenuRecursive((CommonMenu)menu, action.getChildrenActions());
            }
            menu.setFont(this.getFont());
            this.myPopup.add(menu);
        }
        this.myPopup.pack();
    }

    private void populateMenuRecursive(@NotNull JMenu parent, @NotNull List<CommonAction> actions2) {
        if (parent == null) {
            CommonDropDownButton.$$$reportNull$$$0(3);
        }
        if (actions2 == null) {
            CommonDropDownButton.$$$reportNull$$$0(4);
        }
        parent.removeAll();
        for (CommonAction action : actions2) {
            JMenuItem menu;
            if (action instanceof CommonAction.SeparatorAction) {
                parent.addSeparator();
                continue;
            }
            if (action.getChildrenActionCount() == 0) {
                menu = new CommonMenuItem(action);
            } else {
                menu = new CommonMenu(action);
                this.populateMenuRecursive((CommonMenu)menu, action.getChildrenActions());
            }
            menu.setFont(this.getFont());
            parent.add(menu);
        }
    }

    @Override
    public void updateUI() {
        this.setUI(new CommonDropDownButtonUI());
        this.revalidate();
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent event) {
        if (event == null) {
            CommonDropDownButton.$$$reportNull$$$0(5);
        }
        switch (event.getPropertyName()) {
            case "childrenActions": {
                List oldValues = (List)event.getOldValue();
                oldValues.forEach(action -> this.removePropertyChangeListenerRecursive((CommonAction)action));
                List newValues = (List)event.getNewValue();
                newValues.forEach(action -> this.addPropertyChangeListenerRecursive((CommonAction)action));
                if (!(event.getSource() instanceof CommonAction)) break;
                CommonAction sourceAction = (CommonAction)event.getSource();
                if (sourceAction == this.myAction) {
                    this.populatePopup();
                    break;
                }
                JMenuItem sourceMenuItem = this.findMenuRecursive(this.myPopup, sourceAction);
                if (!(sourceMenuItem instanceof JMenu)) break;
                JMenu sourceMenu = (JMenu)sourceMenuItem;
                this.populateMenuRecursive(sourceMenu, newValues);
                JPopupMenu sourcePopup = sourceMenu.getPopupMenu();
                if (!sourcePopup.isShowing()) break;
                sourcePopup.pack();
                break;
            }
            case "Name": 
            case "SmallIcon": 
            case "showExpandArrow": 
            case "isSelected": {
                break;
            }
        }
    }

    @VisibleForTesting
    @Nullable
    JMenuItem findMenuRecursive(@NotNull JPopupMenu popup, @NotNull CommonAction targetAction) {
        if (popup == null) {
            CommonDropDownButton.$$$reportNull$$$0(6);
        }
        if (targetAction == null) {
            CommonDropDownButton.$$$reportNull$$$0(7);
        }
        for (Component component : popup.getComponents()) {
            JMenuItem matchedChildMenuItem;
            if (!(component instanceof JMenuItem)) continue;
            JMenuItem jmenuItem = (JMenuItem)component;
            if (jmenuItem.getAction() == targetAction) {
                return jmenuItem;
            }
            if (!(jmenuItem instanceof JMenu) || (matchedChildMenuItem = this.findMenuRecursive(((JMenu)jmenuItem).getPopupMenu(), targetAction)) == null) continue;
            return matchedChildMenuItem;
        }
        return null;
    }

    private void addPropertyChangeListenerRecursive(@NotNull CommonAction action) {
        if (action == null) {
            CommonDropDownButton.$$$reportNull$$$0(8);
        }
        action.addPropertyChangeListener(this);
        action.getChildrenActions().forEach(child -> this.addPropertyChangeListenerRecursive((CommonAction)child));
    }

    private void removePropertyChangeListenerRecursive(@NotNull CommonAction action) {
        if (action == null) {
            CommonDropDownButton.$$$reportNull$$$0(9);
        }
        action.removePropertyChangeListener(this);
        action.getChildrenActions().forEach(child -> this.removePropertyChangeListenerRecursive((CommonAction)child));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/stdui/menu/CommonDropDownButton";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/stdui/menu/CommonDropDownButton";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPopup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "populateMenuRecursive";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "propertyChange";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findMenuRecursive";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListenerRecursive";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListenerRecursive";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

