/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.ui;

import java.awt.Font;
import javax.swing.JTextPane;
import javax.swing.SizeRequirements;
import javax.swing.UIManager;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.InlineView;
import javax.swing.text.html.ParagraphView;
import javax.swing.text.html.StyleSheet;

public class BreakWordWrapHtmlTextPane
extends JTextPane {
    public BreakWordWrapHtmlTextPane() {
        this.setContentType("text/html");
        this.setBackground(null);
        this.setBorder(null);
        this.setEditable(false);
        BreakWordWrapHTMLEditorKit editorKit = new BreakWordWrapHTMLEditorKit();
        StyleSheet styleSheet = editorKit.getStyleSheet();
        Font labelFont = UIManager.getFont("Label.font");
        String foregroundColor = String.format("#%06x", UIManager.getColor("Label.foreground").getRGB() & 0xFFFFFF);
        String backgroundColor = String.format("#%06x", UIManager.getColor("Label.background").getRGB() & 0xFFFFFF);
        styleSheet.addRule("body { font-family: " + labelFont.getFamily() + "; font-size: 13pt; }");
        styleSheet.addRule("body { color:" + foregroundColor + "; background-color:" + backgroundColor + "}");
        styleSheet.addRule("p { margin: 4 0 4 0; }");
        this.setEditorKit(editorKit);
    }

    public static final class BreakWordWrapHTMLEditorKit
    extends HTMLEditorKit {
        @Override
        public ViewFactory getViewFactory() {
            return new HTMLEditorKit.HTMLFactory(){

                @Override
                public View create(Element e) {
                    View v = super.create(e);
                    if (v instanceof InlineView) {
                        return new BreakWordInlineView(e);
                    }
                    if (v instanceof ParagraphView) {
                        return new BreakWordParagraphView(e);
                    }
                    return v;
                }
            };
        }
    }

    private static final class BreakWordParagraphView
    extends ParagraphView {
        public BreakWordParagraphView(Element e) {
            super(e);
        }

        @Override
        protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
            if (r == null) {
                r = new SizeRequirements();
            }
            float pref = this.layoutPool.getPreferredSpan(axis);
            float min = this.layoutPool.getMinimumSpan(axis);
            r.minimum = (int)min;
            r.preferred = Math.max(r.minimum, (int)pref);
            r.maximum = Integer.MAX_VALUE;
            r.alignment = 0.5f;
            return r;
        }
    }

    private static final class BreakWordInlineView
    extends InlineView {
        public BreakWordInlineView(Element e) {
            super(e);
        }

        @Override
        public int getBreakWeight(int axis, float pos, float len) {
            return 1000;
        }

        @Override
        public View breakView(int axis, int p0, float pos, float len) {
            if (axis == 0) {
                this.checkPainter();
                int p1 = this.getGlyphPainter().getBoundedPosition(this, p0, pos, len);
                if (p0 == this.getStartOffset() && p1 == this.getEndOffset()) {
                    return this;
                }
                return this.createFragment(p0, p1);
            }
            return this;
        }
    }
}

