/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.ui;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterators;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavigationComponent<T extends Item>
extends JEditorPane {
    private boolean myDisplaySingleRoot;
    private final ArrayList<ItemListener<T>> myItemListeners = new ArrayList();
    private final LinkedList<T> myItemStack = new LinkedList();
    private boolean hasRootItem = false;

    public NavigationComponent() {
        this.setEditable(false);
        this.setEditorKit(HTMLEditorKitBuilder.simple());
        this.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        ((HTMLDocument)this.getDocument()).getStyleSheet().addRule("a { text-decoration:none; }");
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                int idx = Integer.parseInt(e.getDescription());
                Item item = (Item)NavigationComponent.this.myItemStack.get(idx);
                for (ItemListener listener2 : NavigationComponent.this.myItemListeners) {
                    ApplicationManager.getApplication().invokeLater(() -> listener2.itemSelected(item));
                }
            }
        });
    }

    public void addItemListener(@NotNull ItemListener<T> itemListener) {
        if (itemListener == null) {
            NavigationComponent.$$$reportNull$$$0(0);
        }
        this.myItemListeners.add(itemListener);
    }

    public void removeItemListener(@NotNull ItemListener<T> itemListener) {
        if (itemListener == null) {
            NavigationComponent.$$$reportNull$$$0(1);
        }
        this.myItemListeners.remove(itemListener);
    }

    private void updateText() {
        if (this.myItemStack.isEmpty()) {
            this.setText("");
            return;
        }
        if (this.myItemStack.size() == 1 && this.hasRootItem && !this.myDisplaySingleRoot) {
            this.setText("");
            return;
        }
        final AtomicInteger id = new AtomicInteger(this.myItemStack.size() - 1);
        String text = Joiner.on((String)" &gt; ").join(Iterators.transform(this.myItemStack.descendingIterator(), (Function)new Function<T, String>(){

            public String apply(T input) {
                if (id.get() == 0) {
                    return ((Item)input).getDisplayText();
                }
                return String.format(Locale.US, "<a href=\"%d\">%s</a>", id.getAndDecrement(), ((Item)input).getDisplayText());
            }

            public boolean equals(Object object) {
                return false;
            }
        }));
        this.setText(text);
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        boolean hasContentToDisplay = this.myDisplaySingleRoot ? this.hasRootItem : this.myItemStack.size() > 1;
        return hasContentToDisplay ? new Dimension(0, this.getFontMetrics(this.getFont()).getHeight()) : super.getMinimumSize();
    }

    public void setDisplaySingleRoot(boolean displaySingleRoot) {
        this.myDisplaySingleRoot = displaySingleRoot;
    }

    public void setRootItem(@Nullable T item) {
        if (this.hasRootItem) {
            this.myItemStack.removeFirst();
        }
        this.hasRootItem = item != null;
        this.myItemStack.addFirst(item);
        this.updateText();
    }

    public void push(@NotNull T item) {
        if (item == null) {
            NavigationComponent.$$$reportNull$$$0(2);
        }
        if (item.equals(this.peek())) {
            return;
        }
        this.myItemStack.push(item);
        this.updateText();
    }

    @Nullable
    public T pop() {
        if (this.myItemStack.size() == 1 && this.hasRootItem) {
            return null;
        }
        Item removed = (Item)this.myItemStack.pop();
        this.updateText();
        return (T)removed;
    }

    @Nullable
    public T peek() {
        return (T)((Item)this.myItemStack.peek());
    }

    public void goTo(@NotNull T goToItem) {
        T item;
        if (goToItem == null) {
            NavigationComponent.$$$reportNull$$$0(3);
        }
        while ((item = this.peek()) != null) {
            if (goToItem.equals(item)) {
                return;
            }
            if (this.pop() != null) continue;
            return;
        }
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.isMaximumSizeSet()) {
            return super.getMaximumSize();
        }
        return new Dimension(Integer.MAX_VALUE, this.getFontMetrics(this.getFont()).getHeight());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemListener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goToItem";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/adtui/ui/NavigationComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addItemListener";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "removeItemListener";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "push";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "goTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class Item {
        @NotNull
        public abstract String getDisplayText();
    }

    public static interface ItemListener<T extends Item> {
        public void itemSelected(@NotNull T var1);
    }
}

