/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.ui;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.adtui.model.Stopwatch;
import com.android.tools.adtui.ui.ImagePanel;
import com.android.tools.adtui.ui.ImagePanelKt;
import com.android.tools.adtui.ui.ScaledImageProvider;
import com.android.tools.adtui.ui.ScalingImagePanel;
import com.android.tools.idea.concurrency.FutureCallbackExecutor;
import com.android.tools.idea.concurrency.FutureUtils;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000g\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004*\u0001\u001d\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010(\u001a\u00020\u001bH\u0016J\u0010\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020+H\u0014J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0013H\u0002J\b\u0010/\u001a\u00020\u001bH\u0002J\u0010\u00100\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0013H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0007\u001a\u0004\u0018\u00010\u0013@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001eR(\u0010 \u001a\u0004\u0018\u00010\u001f2\b\u0010\u0007\u001a\u0004\u0018\u00010\u001f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/android/tools/adtui/ui/ScalingImagePanel;", "Lcom/intellij/ui/components/JBPanel;", "Lcom/android/tools/adtui/ui/ImagePanel;", "Lcom/intellij/openapi/Disposable;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "value", "", "active", "getActive", "()Z", "setActive", "(Z)V", "boundedExecutor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "edtExecutor", "Lcom/android/tools/idea/concurrency/FutureCallbackExecutor;", "Ljava/awt/Image;", "image", "getImage", "()Ljava/awt/Image;", "setImage", "(Ljava/awt/Image;)V", "previousFuture", "Ljava/util/concurrent/Future;", "", "resizedListener", "com/android/tools/adtui/ui/ScalingImagePanel$resizedListener$1", "Lcom/android/tools/adtui/ui/ScalingImagePanel$resizedListener$1;", "Lcom/android/tools/adtui/ui/ScaledImageProvider;", "scaledImageProvider", "getScaledImageProvider", "()Lcom/android/tools/adtui/ui/ScaledImageProvider;", "setScaledImageProvider", "(Lcom/android/tools/adtui/ui/ScaledImageProvider;)V", "stopwatch", "Lcom/android/tools/adtui/model/Stopwatch;", "taskExecutor", "dispose", "paintComponent", "g", "Ljava/awt/Graphics;", "pixelWidth", "", "img", "repaintAsync", "userWidth", "intellij.android.adt.ui"})
@SourceDebugExtension(value={"SMAP\nScalingImagePanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScalingImagePanel.kt\ncom/android/tools/adtui/ui/ScalingImagePanel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,155:1\n10#2:156\n*S KotlinDebug\n*F\n+ 1 ScalingImagePanel.kt\ncom/android/tools/adtui/ui/ScalingImagePanel\n*L\n44#1:156\n*E\n"})
public class ScalingImagePanel
extends JBPanel<ImagePanel>
implements Disposable {
    @NotNull
    private final Logger LOG;
    @NotNull
    private final Stopwatch stopwatch;
    @NotNull
    private final FutureCallbackExecutor edtExecutor;
    @NotNull
    private final ExecutorService boundedExecutor;
    @NotNull
    private final FutureCallbackExecutor taskExecutor;
    @NotNull
    private final resizedListener.1 resizedListener;
    @Nullable
    private Future<Unit> previousFuture;
    @Nullable
    private Image image;
    private boolean active;
    @Nullable
    private ScaledImageProvider scaledImageProvider;

    public ScalingImagePanel() {
        super(true);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ScalingImagePanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        this.LOG = logger;
        this.stopwatch = new Stopwatch();
        this.edtExecutor = new FutureCallbackExecutor((Executor)EdtExecutorService.getInstance());
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"ScalingImagePanel", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplication\u2026r(\"ScalingImagePanel\", 1)");
        this.boundedExecutor = executorService;
        this.taskExecutor = new FutureCallbackExecutor((Executor)this.boundedExecutor);
        this.resizedListener = new ComponentAdapter(this){
            final /* synthetic */ ScalingImagePanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void componentResized(@Nullable ComponentEvent e) {
                super.componentResized(e);
                ScalingImagePanel.access$repaintAsync(this.this$0);
            }
        };
        this.active = true;
    }

    @Nullable
    public final Image getImage() {
        return this.image;
    }

    public final void setImage(@Nullable Image value) {
        this.image = value;
        this.repaint();
    }

    public final boolean getActive() {
        return this.active;
    }

    public final void setActive(boolean value) {
        this.active = value;
        this.repaint();
    }

    @Nullable
    public final ScaledImageProvider getScaledImageProvider() {
        return this.scaledImageProvider;
    }

    public final void setScaledImageProvider(@Nullable ScaledImageProvider value) {
        this.scaledImageProvider = value;
        if (value == null) {
            this.removeComponentListener(this.resizedListener);
            this.repaint();
        } else {
            this.addComponentListener(this.resizedListener);
            this.setImage(value.getInitialImage());
            this.repaintAsync();
        }
    }

    public void dispose() {
        this.removeComponentListener(this.resizedListener);
        Future<Unit> future = this.previousFuture;
        if (future != null) {
            future.cancel(false);
        }
        this.boundedExecutor.shutdownNow();
    }

    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintComponent(g);
        ImagePanelKt.paintPanelImage(this, g, this.image, this.active, false);
    }

    private final void repaintAsync() {
        block1: {
            ScaledImageProvider scaledImageProvider = this.scaledImageProvider;
            if (scaledImageProvider == null) break block1;
            ScaledImageProvider provider = scaledImageProvider;
            boolean bl = false;
            double width = this.getWidth();
            double height = this.getHeight();
            ScaleContext ctx = ScaleContext.Companion.create((Component)((Object)this));
            ListenableFuture listenableFuture = this.taskExecutor.executeAsync(ScalingImagePanel::repaintAsync$lambda$1$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"taskExecutor.executeAsyn\u2026 transform below)\n      }");
            ListenableFuture newFuture2 = FutureUtils.catching((ListenableFuture)FutureUtils.transform((ListenableFuture)FutureUtils.transform((ListenableFuture)listenableFuture, (Executor)((Executor)this.taskExecutor), (Function1)((Function1)new Function1<Unit, Image>(this, provider, ctx, width, height){
                final /* synthetic */ ScalingImagePanel this$0;
                final /* synthetic */ ScaledImageProvider $provider;
                final /* synthetic */ ScaleContext $ctx;
                final /* synthetic */ double $width;
                final /* synthetic */ double $height;
                {
                    this.this$0 = $receiver;
                    this.$provider = $provider;
                    this.$ctx = $ctx;
                    this.$width = $width;
                    this.$height = $height;
                    super(1);
                }

                @NotNull
                public final Image invoke(Unit it) {
                    ScalingImagePanel.access$getStopwatch$p(this.this$0).start();
                    Image result = this.$provider.createScaledImage(this.$ctx, this.$width, this.$height);
                    ScalingImagePanel.access$getStopwatch$p(this.this$0).stop();
                    ScalingImagePanel.access$getLOG$p(this.this$0).debug("createScaleImage(scaleContext=" + this.$ctx + ", w=" + this.$width + ", h=" + this.$height + ") is done in " + TimeUnit.NANOSECONDS.toMillis(ScalingImagePanel.access$getStopwatch$p(this.this$0).getTotalRunningTimeNs()) + " msec");
                    return result;
                }
            })), (Executor)((Executor)this.edtExecutor), (Function1)((Function1)new Function1<Image, Unit>(this, ctx, provider){
                final /* synthetic */ ScalingImagePanel this$0;
                final /* synthetic */ ScaleContext $ctx;
                final /* synthetic */ ScaledImageProvider $provider;
                {
                    this.this$0 = $receiver;
                    this.$ctx = $ctx;
                    this.$provider = $provider;
                    super(1);
                }

                public final void invoke(@NotNull Image newImage) {
                    Intrinsics.checkNotNullParameter((Object)newImage, (String)"newImage");
                    ScalingImagePanel.access$getLOG$p(this.this$0).debug("Updating panel image (scaleContext=" + this.$ctx + ", userWidth=" + ScalingImagePanel.access$userWidth(this.this$0, newImage) + ", pixelWidth=" + ScalingImagePanel.access$pixelWidth(this.this$0, newImage) + ")");
                    if (Intrinsics.areEqual((Object)this.$provider, (Object)this.this$0.getScaledImageProvider())) {
                        this.this$0.setImage(newImage);
                    }
                }
            })), (Executor)((Executor)this.edtExecutor), Exception.class, (Function1)((Function1)new Function1<Exception, Unit>(this){
                final /* synthetic */ ScalingImagePanel this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    ScalingImagePanel.access$getLOG$p(this.this$0).warn("Error loading scaled image", (Throwable)e);
                }
            }));
            Future<Unit> future = this.previousFuture;
            if (future != null) {
                future.cancel(false);
            }
            this.previousFuture = (Future)newFuture2;
        }
    }

    private final int userWidth(Image img) {
        if (img instanceof JBHiDPIScaledImage) {
            return ((JBHiDPIScaledImage)img).getUserWidth();
        }
        return img.getWidth(null);
    }

    private final int pixelWidth(Image img) {
        if (img instanceof JBHiDPIScaledImage) {
            return ((JBHiDPIScaledImage)img).getRealWidth();
        }
        return img.getWidth(null);
    }

    private static final Unit repaintAsync$lambda$1$lambda$0() {
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Stopwatch access$getStopwatch$p(ScalingImagePanel $this) {
        return $this.stopwatch;
    }

    public static final /* synthetic */ Logger access$getLOG$p(ScalingImagePanel $this) {
        return $this.LOG;
    }

    public static final /* synthetic */ int access$userWidth(ScalingImagePanel $this, Image img) {
        return $this.userWidth(img);
    }

    public static final /* synthetic */ int access$pixelWidth(ScalingImagePanel $this, Image img) {
        return $this.pixelWidth(img);
    }

    public static final /* synthetic */ void access$repaintAsync(ScalingImagePanel $this) {
        $this.repaintAsync();
    }
}

