/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.adtui.util.ActionToolbarUtil;
import com.android.tools.adtui.workbench.Layout;
import com.android.tools.adtui.workbench.SideModel;
import com.android.tools.adtui.workbench.ToolContent;
import com.android.tools.adtui.workbench.ToolWindowCallback;
import com.android.tools.adtui.workbench.ToolWindowDefinition;
import com.android.tools.adtui.workbench.WorkBench;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.impl.AnchoredButton;
import com.intellij.toolWindow.StripeButtonUi;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SideBorder;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ButtonUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AttachedToolWindow<T>
implements ToolWindowCallback,
Disposable {
    static final String TOOL_WINDOW_PROPERTY_PREFIX = "ATTACHED_TOOL_WINDOW.";
    static final String TOOL_WINDOW_TOOLBAR_PLACE = "TOOL_WINDOW_TOOLBAR";
    static final String LABEL_HEADER = "LABEL";
    static final String SEARCH_HEADER = "SEARCH";
    private final WorkBench<T> myWorkBench;
    private final ToolWindowDefinition<T> myDefinition;
    private final PropertiesComponent myPropertiesComponent;
    private final SideModel<T> myModel;
    private final JPanel myPanel;
    private final AbstractButton myMinimizedButton;
    private MySearchField mySearchField;
    private ButtonDragListener<T> myDragListener;
    private ActionToolbar myActionToolbar;
    private ActionButton mySearchActionButton;
    private boolean myShowSearchField;
    @Nullable
    private ToolContent<T> myContent;
    private boolean myAutoHideOpen;
    private int myToolOrder;

    AttachedToolWindow(@NotNull ToolWindowDefinition<T> definition, @NotNull ButtonDragListener<T> dragListener, @NotNull WorkBench<T> workBench, @NotNull SideModel<T> model2, boolean minimizedByDefault) {
        if (definition == null) {
            AttachedToolWindow.$$$reportNull$$$0(0);
        }
        if (dragListener == null) {
            AttachedToolWindow.$$$reportNull$$$0(1);
        }
        if (workBench == null) {
            AttachedToolWindow.$$$reportNull$$$0(2);
        }
        if (model2 == null) {
            AttachedToolWindow.$$$reportNull$$$0(3);
        }
        Disposer.register(workBench, (Disposable)this);
        this.myWorkBench = workBench;
        this.myDefinition = definition;
        this.myDragListener = dragListener;
        this.myPropertiesComponent = PropertiesComponent.getInstance();
        this.myModel = model2;
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this.myMinimizedButton = new MinimizedButton(definition.getTitle(), definition.getIcon(), this);
        this.setDefaultProperty(PropertyType.LEFT, definition.getSide().isLeft());
        this.setDefaultProperty(PropertyType.SPLIT, definition.getSplit().isBottom());
        this.setDefaultProperty(PropertyType.AUTO_HIDE, definition.getAutoHide().isAutoHide());
        this.setDefaultProperty(PropertyType.MINIMIZED, minimizedByDefault);
        this.updateContent();
        AnAction globalFindAction = ActionManager.getInstance().getAction("Find");
        if (globalFindAction != null) {
            new FindAction().registerCustomShortcutSet(globalFindAction.getShortcutSet(), this.myPanel, this);
        }
    }

    public void dispose() {
        if (this.myContent != null) {
            this.myContent = null;
            this.myDragListener = null;
            this.myPanel.removeAll();
        }
    }

    @NotNull
    public String getToolName() {
        String string = this.myDefinition.getName();
        if (string == null) {
            AttachedToolWindow.$$$reportNull$$$0(4);
        }
        return string;
    }

    public int getToolOrder() {
        return this.myToolOrder;
    }

    public void setToolOrder(int order) {
        this.myToolOrder = order;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            AttachedToolWindow.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    @NotNull
    public AbstractButton getMinimizedButton() {
        AbstractButton abstractButton = this.myMinimizedButton;
        if (abstractButton == null) {
            AttachedToolWindow.$$$reportNull$$$0(6);
        }
        return abstractButton;
    }

    @Nullable
    public T getContext() {
        return this.myModel.getContext();
    }

    public ToolWindowDefinition<T> getDefinition() {
        return this.myDefinition;
    }

    public boolean isMinimized() {
        return this.getProperty(PropertyType.MINIMIZED);
    }

    public void setMinimized(boolean value) {
        this.setProperty(PropertyType.MINIMIZED, value);
    }

    public boolean isLeft() {
        return this.getProperty(PropertyType.LEFT);
    }

    public void setLeft(boolean value) {
        this.setProperty(PropertyType.LEFT, value);
    }

    public boolean isSplit() {
        return this.getProperty(PropertyType.SPLIT);
    }

    public void setSplit(boolean value) {
        this.setProperty(PropertyType.SPLIT, value);
    }

    public boolean isAutoHide() {
        return this.getProperty(PropertyType.AUTO_HIDE);
    }

    public void setAutoHide(boolean value) {
        this.setProperty(PropertyType.AUTO_HIDE, value);
    }

    public boolean isFloating() {
        return this.getProperty(PropertyType.FLOATING);
    }

    public void setFloating(boolean value) {
        this.setProperty(PropertyType.FLOATING, value);
    }

    public boolean isDetached() {
        return this.getProperty(PropertyType.DETACHED);
    }

    public void setDetached(boolean value) {
        this.setProperty(PropertyType.DETACHED, value);
    }

    public boolean getProperty(@NotNull PropertyType property) {
        if (property == null) {
            AttachedToolWindow.$$$reportNull$$$0(7);
        }
        if (property == PropertyType.MINIMIZED && this.isAutoHide()) {
            return !this.myAutoHideOpen;
        }
        return this.getLayoutProperty(Layout.CURRENT, property);
    }

    public void setProperty(@NotNull PropertyType property, boolean value) {
        if (property == null) {
            AttachedToolWindow.$$$reportNull$$$0(8);
        }
        if (property == PropertyType.MINIMIZED && this.isAutoHide()) {
            this.myAutoHideOpen = !value;
        } else {
            this.setLayoutProperty(Layout.CURRENT, property, value);
        }
        if (this.myMinimizedButton != null) {
            this.myMinimizedButton.setSelected(!this.isMinimized());
        }
    }

    private boolean getLayoutProperty(@NotNull Layout layout, @NotNull PropertyType property) {
        if (layout == null) {
            AttachedToolWindow.$$$reportNull$$$0(9);
        }
        if (property == null) {
            AttachedToolWindow.$$$reportNull$$$0(10);
        }
        return this.myPropertiesComponent.getBoolean(this.getPropertyName(layout, property));
    }

    private void setLayoutProperty(@NotNull Layout layout, @NotNull PropertyType property, boolean value) {
        if (layout == null) {
            AttachedToolWindow.$$$reportNull$$$0(11);
        }
        if (property == null) {
            AttachedToolWindow.$$$reportNull$$$0(12);
        }
        this.myPropertiesComponent.setValue(this.getPropertyName(layout, property), value);
    }

    public void setDefaultProperty(@NotNull PropertyType property, boolean defaultValue) {
        if (property == null) {
            AttachedToolWindow.$$$reportNull$$$0(13);
        }
        if (!this.myPropertiesComponent.isValueSet(this.getPropertyName(Layout.DEFAULT, property))) {
            this.myPropertiesComponent.setValue(this.getPropertyName(Layout.DEFAULT, property), defaultValue, !defaultValue);
            this.setLayoutProperty(Layout.CURRENT, property, defaultValue);
        }
    }

    private String getPropertyName(@NotNull Layout layout, @NotNull PropertyType property) {
        if (layout == null) {
            AttachedToolWindow.$$$reportNull$$$0(14);
        }
        if (property == null) {
            AttachedToolWindow.$$$reportNull$$$0(15);
        }
        String context = this.myWorkBench.getContext();
        return String.format("%s%s%s.%s.%s%s%s", TOOL_WINDOW_PROPERTY_PREFIX, layout.getPrefix(), this.myWorkBench.getName(), this.myDefinition.getName(), context, StringUtil.isEmpty((String)context) ? "" : ".", property.name());
    }

    public void setPropertyAndUpdate(@NotNull PropertyType property, boolean value) {
        if (property == null) {
            AttachedToolWindow.$$$reportNull$$$0(16);
        }
        this.setProperty(property, value);
        if (property == PropertyType.FLOATING && value) {
            property = PropertyType.DETACHED;
            this.setProperty(property, true);
        }
        this.updateContent();
        this.myModel.update(this, property);
        if (property == PropertyType.MINIMIZED && !value && this.myContent != null) {
            this.myContent.getFocusedComponent().requestFocus();
        }
    }

    public void storeDefaultLayout() {
        for (PropertyType property : PropertyType.values()) {
            this.setLayoutProperty(Layout.DEFAULT, property, this.getLayoutProperty(Layout.CURRENT, property));
        }
    }

    public void restoreDefaultLayout() {
        for (PropertyType property : PropertyType.values()) {
            this.setProperty(property, this.getLayoutProperty(Layout.DEFAULT, property));
        }
        this.updateContent();
        this.myModel.update(this, PropertyType.DETACHED);
    }

    public void setContext(T context) {
        if (this.myContent != null) {
            this.myContent.setToolContext(context);
        }
    }

    @VisibleForTesting
    @Nullable
    public SearchTextField getSearchField() {
        return this.mySearchField;
    }

    @VisibleForTesting
    @Nullable
    ToolContent<T> getContent() {
        return this.myContent;
    }

    private void updateContent() {
        if (this.isDetached() && this.myContent != null) {
            this.myPanel.removeAll();
            this.myContent.setToolContext(null);
            Disposer.dispose(this.myContent);
            this.myContent = null;
            this.myActionToolbar = null;
            this.mySearchActionButton = null;
        } else if (!this.isDetached() && this.myContent == null) {
            this.myContent = this.myDefinition.getFactory().apply(this);
            assert (this.myContent != null);
            this.myContent.setToolContext(this.myModel.getContext());
            this.myContent.registerCallbacks(this);
            this.myPanel.add((Component)this.createHeader(this.myContent), "North");
            this.myPanel.add((Component)this.myContent.getComponent(), "Center");
        }
        this.myPanel.putClientProperty("com.android.tools.adtui.workbench.TOOL_CONTENT", this.myContent);
    }

    @Override
    public void restore() {
        if (!this.isDetached() && this.isMinimized()) {
            this.setPropertyAndUpdate(PropertyType.MINIMIZED, false);
        }
    }

    @Override
    public void autoHide() {
        if (!this.isDetached() && this.isAutoHide() && !this.isMinimized()) {
            this.setPropertyAndUpdate(PropertyType.MINIMIZED, true);
        }
    }

    @NotNull
    private JComponent createHeader(@NotNull ToolContent<T> content) {
        if (content == null) {
            AttachedToolWindow.$$$reportNull$$$0(17);
        }
        this.myActionToolbar = this.createToolbar(content);
        this.mySearchActionButton = this.findSearchActionButton(content, this.myActionToolbar);
        JPanel header2 = new JPanel(new BorderLayout());
        header2.add((Component)this.createTitlePanel(this.myDefinition.getTitle(), content.supportsFiltering()), "Center");
        header2.add((Component)this.myActionToolbar.getComponent(), "East");
        header2.setBorder((Border)new SideBorder(JBColor.border(), 8));
        JPanel jPanel = header2;
        if (jPanel == null) {
            AttachedToolWindow.$$$reportNull$$$0(18);
        }
        return jPanel;
    }

    @NotNull
    private JPanel createTitlePanel(@NotNull String title, boolean includeSearchField) {
        if (title == null) {
            AttachedToolWindow.$$$reportNull$$$0(19);
        }
        CardLayout layout = new CardLayout();
        JPanel titlePanel = new JPanel(layout);
        JBLabel titleLabel = new JBLabel(title){

            public void updateUI() {
                super.updateUI();
                this.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
            }
        };
        titleLabel.setBorder((Border)JBUI.Borders.empty((int)2, (int)5, (int)2, (int)10));
        titlePanel.add((Component)titleLabel, LABEL_HEADER);
        if (includeSearchField) {
            this.mySearchField = new MySearchField(TOOL_WINDOW_PROPERTY_PREFIX + this.myWorkBench.getName() + ".TEXT_SEARCH_HISTORY");
            this.mySearchField.setPreferredSize(new Dimension(this.mySearchField.getPreferredSize().width, titlePanel.getPreferredSize().height));
            titlePanel.add((Component)((Object)this.mySearchField), SEARCH_HEADER);
        }
        layout.show(titlePanel, LABEL_HEADER);
        JPanel jPanel = titlePanel;
        if (jPanel == null) {
            AttachedToolWindow.$$$reportNull$$$0(20);
        }
        return jPanel;
    }

    private void showSearchField(boolean show2) {
        if (this.myContent == null || this.mySearchField == null) {
            return;
        }
        Container parent = this.mySearchField.getParent();
        CardLayout layout = (CardLayout)parent.getLayout();
        this.myShowSearchField = show2;
        if (show2) {
            layout.show(parent, SEARCH_HEADER);
            this.mySearchField.requestFocus();
        } else {
            layout.show(parent, LABEL_HEADER);
        }
        this.updateActions();
    }

    @Override
    public void startFiltering(@NotNull String initialSearchString) {
        if (initialSearchString == null) {
            AttachedToolWindow.$$$reportNull$$$0(21);
        }
        if (this.myContent == null || this.mySearchField == null) {
            return;
        }
        this.mySearchField.setText(initialSearchString);
        this.showSearchField(true);
    }

    @Override
    public void stopFiltering() {
        if (this.myContent == null || this.mySearchField == null) {
            return;
        }
        this.mySearchField.setText("");
        this.showSearchField(false);
    }

    @NotNull
    private ActionToolbar createToolbar(@NotNull ToolContent<T> content) {
        if (content == null) {
            AttachedToolWindow.$$$reportNull$$$0(22);
        }
        DefaultActionGroup rightGroup = new DefaultActionGroup();
        if (content.supportsFiltering()) {
            rightGroup.add((AnAction)new SearchAction());
        }
        if (!content.getAdditionalActions().isEmpty()) {
            rightGroup.addAll(content.getAdditionalActions());
            rightGroup.add((AnAction)Separator.getInstance());
        }
        rightGroup.add((AnAction)new GearAction());
        rightGroup.add((AnAction)new HideAction());
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("AttachedToolWindow", (ActionGroup)rightGroup, true);
        ActionToolbarUtil.makeToolbarNavigable(actionToolbar);
        actionToolbar.setMinimumButtonSize(this.myDefinition.getButtonSize());
        actionToolbar.setTargetComponent((JComponent)this.myPanel);
        actionToolbar.setLayoutPolicy(0);
        actionToolbar.setReservePlaceAutoPopupIcon(false);
        Dimension buttonSize = this.myDefinition.getButtonSize();
        int border = buttonSize.equals(ActionToolbar.NAVBAR_MINIMUM_BUTTON_SIZE) ? 4 : 2;
        actionToolbar.getComponent().setBorder((Border)JBUI.Borders.empty((int)border, (int)0));
        actionToolbar.updateActionsImmediately();
        ActionToolbar actionToolbar2 = actionToolbar;
        if (actionToolbar2 == null) {
            AttachedToolWindow.$$$reportNull$$$0(23);
        }
        return actionToolbar2;
    }

    @Nullable
    private ActionButton findSearchActionButton(@NotNull ToolContent<T> content, @NotNull ActionToolbar actionToolbar) {
        if (content == null) {
            AttachedToolWindow.$$$reportNull$$$0(24);
        }
        if (actionToolbar == null) {
            AttachedToolWindow.$$$reportNull$$$0(25);
        }
        if (!content.supportsFiltering()) {
            return null;
        }
        return ActionToolbarUtil.findActionButton(actionToolbar, (AnAction)actionToolbar.getActions().get(0));
    }

    @Override
    public void updateActions() {
        if (this.myActionToolbar != null) {
            this.myActionToolbar.updateActionsImmediately();
        }
    }

    private void showGearPopup(@NotNull Component component, int x, int y) {
        if (component == null) {
            AttachedToolWindow.$$$reportNull$$$0(26);
        }
        DefaultActionGroup group = new DefaultActionGroup();
        this.addGearPopupActions(group);
        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("ToolwindowPopup", (ActionGroup)group);
        popupMenu.getComponent().show(component, x, y);
    }

    private void addGearPopupActions(@NotNull DefaultActionGroup group) {
        List<AnAction> myExtraGearActions;
        if (group == null) {
            AttachedToolWindow.$$$reportNull$$$0(27);
        }
        if (this.myContent != null && !(myExtraGearActions = this.myContent.getGearActions()).isEmpty()) {
            group.addAll(myExtraGearActions);
            group.addSeparator();
        }
        DefaultActionGroup attachedSide = DefaultActionGroup.createPopupGroup(() -> "Attached Side");
        attachedSide.add((AnAction)new TogglePropertyTypeAction(PropertyType.LEFT, "Left"));
        attachedSide.add((AnAction)new ToggleOppositePropertyTypeAction(PropertyType.LEFT, "Right"));
        attachedSide.add((AnAction)new SwapAction());
        if (this.myDefinition.isFloatingAllowed()) {
            attachedSide.add((AnAction)new TogglePropertyTypeAction(PropertyType.DETACHED, "None"));
        }
        group.add((AnAction)attachedSide);
        ActionManager manager = ActionManager.getInstance();
        if (this.myDefinition.isAutoHideAllowed()) {
            group.add((AnAction)new ToggleOppositePropertyTypeAction(PropertyType.AUTO_HIDE, manager.getAction("ToggleDockMode")));
        }
        if (this.myDefinition.isFloatingAllowed()) {
            group.add((AnAction)new TogglePropertyTypeAction(PropertyType.FLOATING, manager.getAction("ToggleFloatingMode")));
        }
        if (this.myDefinition.isSplitModeChangesAllowed()) {
            group.add((AnAction)new TogglePropertyTypeAction(PropertyType.SPLIT, manager.getAction("ToggleSideMode")));
        }
    }

    @VisibleForTesting
    void fireButtonDragged(@NotNull DragEvent event) {
        if (event == null) {
            AttachedToolWindow.$$$reportNull$$$0(28);
        }
        this.myDragListener.buttonDragged(this, event);
    }

    @VisibleForTesting
    void fireButtonDropped(@NotNull DragEvent event) {
        if (event == null) {
            AttachedToolWindow.$$$reportNull$$$0(29);
        }
        this.myDragListener.buttonDropped(this, event);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 18, 20, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dragListener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workBench";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 18: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/workbench/AttachedToolWindow";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 17: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialSearchString";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionToolbar";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/workbench/AttachedToolWindow";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinimizedButton";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createHeader";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createTitlePanel";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 18: 
            case 20: 
            case 23: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getProperty";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setProperty";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLayoutProperty";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setLayoutProperty";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultProperty";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setPropertyAndUpdate";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createHeader";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createTitlePanel";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "startFiltering";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createToolbar";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findSearchActionButton";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "showGearPopup";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addGearPopupActions";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "fireButtonDragged";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "fireButtonDropped";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 18, 20, 23 -> new IllegalStateException(string);
        };
    }

    static interface ButtonDragListener<T> {
        public void buttonDragged(@NotNull AttachedToolWindow<T> var1, @NotNull DragEvent var2);

        public void buttonDropped(@NotNull AttachedToolWindow<T> var1, @NotNull DragEvent var2);
    }

    private static class MinimizedButton<T>
    extends AnchoredButton {
        private final AttachedToolWindow<T> myToolWindow;
        private final Icon myIcon;
        private JLabel myDragImage;
        private Point myStartDragPosition;

        private MinimizedButton(@NotNull String title, @NotNull Icon icon, @NotNull AttachedToolWindow<T> toolWindow) {
            if (title == null) {
                MinimizedButton.$$$reportNull$$$0(0);
            }
            if (icon == null) {
                MinimizedButton.$$$reportNull$$$0(1);
            }
            if (toolWindow == null) {
                MinimizedButton.$$$reportNull$$$0(2);
            }
            super(title, icon);
            this.myToolWindow = toolWindow;
            this.myIcon = icon;
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
            this.setFocusable(false);
            this.setRolloverEnabled(true);
            this.setOpaque(false);
            this.setBackground(null);
            MouseInputAdapter listener2 = new MouseInputAdapter(){

                @Override
                public void mouseDragged(@NotNull MouseEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.handleDragging(event);
                }

                @Override
                public void mouseReleased(@NotNull MouseEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    this.stopDragging(event);
                }

                @Override
                public void mouseClicked(@NotNull MouseEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if ((event.getModifiersEx() & 0x100) == 0) {
                        this.setSelected(false);
                        myToolWindow.setPropertyAndUpdate(PropertyType.MINIMIZED, !myToolWindow.isMinimized());
                    } else {
                        myToolWindow.showGearPopup((Component)((Object)this), event.getX(), event.getY());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "event";
                    objectArray2[1] = "com/android/tools/adtui/workbench/AttachedToolWindow$MinimizedButton$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "mouseDragged";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "mouseReleased";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "mouseClicked";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            this.addMouseListener(listener2);
            this.addMouseMotionListener(listener2);
            if (ExperimentalUI.isNewUI()) {
                this.addChangeListener(event -> this.setIcon(this.isSelected() ? ColoredIconGenerator.generateWhiteIcon(this.myIcon) : this.myIcon));
            }
            this.setSelected(!toolWindow.isMinimized());
        }

        public void updateUI() {
            this.setUI((ButtonUI)new StripeButtonUi());
            this.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        }

        public void paint(@NotNull Graphics graphics) {
            if (graphics == null) {
                MinimizedButton.$$$reportNull$$$0(3);
            }
            if (this.isDragging()) {
                return;
            }
            if (!this.myToolWindow.isLeft()) {
                super.paint(graphics);
                return;
            }
            Graphics graphics2 = graphics.create();
            try {
                graphics2.translate(JBUIScale.scale((int)1), 0);
                super.paint(graphics2);
            }
            finally {
                graphics2.dispose();
            }
        }

        public int getMnemonic2() {
            return 0;
        }

        public ToolWindowAnchor getAnchor() {
            return this.myToolWindow.isLeft() ? ToolWindowAnchor.LEFT : ToolWindowAnchor.RIGHT;
        }

        private boolean isDragging() {
            return this.myDragImage != null;
        }

        private void handleDragging(@NotNull MouseEvent event) {
            if (event == null) {
                MinimizedButton.$$$reportNull$$$0(4);
            }
            if (!this.isDragging()) {
                this.startDragging(event);
            }
            this.myToolWindow.fireButtonDragged(new DragEvent(event, this.myDragImage, this.myStartDragPosition));
        }

        private void stopDragging(@NotNull MouseEvent event) {
            if (event == null) {
                MinimizedButton.$$$reportNull$$$0(5);
            }
            if (this.isDragging()) {
                this.myToolWindow.fireButtonDropped(new DragEvent(event, this.myDragImage, this.myStartDragPosition));
                this.myDragImage = null;
                this.myStartDragPosition = null;
            }
        }

        private void startDragging(@NotNull MouseEvent event) {
            if (event == null) {
                MinimizedButton.$$$reportNull$$$0(6);
            }
            BufferedImage image = ImageUtil.createImage((int)this.getWidth(), (int)this.getHeight(), (int)2);
            Graphics graphics = image.getGraphics();
            this.paint(graphics);
            graphics.dispose();
            this.myDragImage = new JBLabel((Icon)new JBImageIcon((Image)image));
            this.myStartDragPosition = event.getPoint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWindow";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "graphics";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/adtui/workbench/AttachedToolWindow$MinimizedButton";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleDragging";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "stopDragging";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startDragging";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static enum PropertyType {
        AUTO_HIDE,
        MINIMIZED,
        LEFT,
        SPLIT,
        DETACHED,
        FLOATING;

    }

    private final class FindAction
    extends DumbAwareAction {
        private FindAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                FindAction.$$$reportNull$$$0(0);
            }
            AttachedToolWindow.this.showSearchField(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/AttachedToolWindow$FindAction", "actionPerformed"));
        }
    }

    private class MySearchField
    extends SearchTextField
    implements KeyListener {
        private Component myOldFocusComponent;

        private MySearchField(String propertyName) {
            if (propertyName == null) {
                MySearchField.$$$reportNull$$$0(0);
            }
            super(propertyName);
            this.addKeyboardListener(this);
            this.addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (AttachedToolWindow.this.myContent != null) {
                        AttachedToolWindow.this.myContent.setFilter(MySearchField.this.getText().trim());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/adtui/workbench/AttachedToolWindow$MySearchField$1", "textChanged"));
                }
            });
            this.getTextEditor().addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusGained(@NotNull FocusEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    MySearchField.this.myOldFocusComponent = event.getOppositeComponent();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/AttachedToolWindow$MySearchField$2", "focusGained"));
                }
            });
        }

        public void removeNotify() {
            super.removeNotify();
            this.putClientProperty(AnAction.ACTIONS_KEY, null);
        }

        protected void onFocusLost() {
            Component focusedDescendant = IdeFocusManager.getGlobalInstance().getFocusedDescendantFor((Component)((Object)this));
            if (focusedDescendant == null && this.getText().trim().isEmpty()) {
                AttachedToolWindow.this.showSearchField(false);
            }
            this.myOldFocusComponent = null;
            super.onFocusLost();
        }

        @Override
        public void keyTyped(@NotNull KeyEvent event) {
            if (event == null) {
                MySearchField.$$$reportNull$$$0(1);
            }
            if (AttachedToolWindow.this.myContent != null && AttachedToolWindow.this.myContent.getFilterKeyListener() != null) {
                AttachedToolWindow.this.myContent.getFilterKeyListener().keyTyped(event);
                if (event.isConsumed()) {
                    this.addCurrentTextToHistory();
                }
            }
        }

        @Override
        public void keyPressed(@NotNull KeyEvent event) {
            if (event == null) {
                MySearchField.$$$reportNull$$$0(2);
            }
            if (AttachedToolWindow.this.myContent != null && AttachedToolWindow.this.myContent.getFilterKeyListener() != null) {
                AttachedToolWindow.this.myContent.getFilterKeyListener().keyPressed(event);
                if (event.isConsumed()) {
                    this.addCurrentTextToHistory();
                }
            }
            if (event.getKeyCode() == 27 && this.getText().isEmpty()) {
                AttachedToolWindow.this.showSearchField(false);
                if (this.myOldFocusComponent != null) {
                    this.myOldFocusComponent.requestFocus();
                } else if (AttachedToolWindow.this.myContent != null) {
                    AttachedToolWindow.this.myContent.getFocusedComponent().requestFocus();
                } else if (AttachedToolWindow.this.mySearchActionButton != null) {
                    AttachedToolWindow.this.mySearchActionButton.requestFocus();
                }
            }
        }

        @Override
        public void keyReleased(@NotNull KeyEvent event) {
            if (event == null) {
                MySearchField.$$$reportNull$$$0(3);
            }
            if (AttachedToolWindow.this.myContent != null && AttachedToolWindow.this.myContent.getFilterKeyListener() != null) {
                AttachedToolWindow.this.myContent.getFilterKeyListener().keyReleased(event);
                if (event.isConsumed()) {
                    this.addCurrentTextToHistory();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/adtui/workbench/AttachedToolWindow$MySearchField";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "keyTyped";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "keyPressed";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "keyReleased";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SearchAction
    extends DumbAwareAction {
        private SearchAction() {
            super("Search", null, AllIcons.Actions.Find);
        }

        public void update(@NotNull AnActionEvent event) {
            if (event == null) {
                SearchAction.$$$reportNull$$$0(0);
            }
            Presentation presentation = event.getPresentation();
            presentation.setVisible(!AttachedToolWindow.this.myShowSearchField);
            presentation.setEnabled(AttachedToolWindow.this.myContent != null && AttachedToolWindow.this.myContent.isFilteringActive());
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                SearchAction.$$$reportNull$$$0(1);
            }
            AttachedToolWindow.this.showSearchField(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/android/tools/adtui/workbench/AttachedToolWindow$SearchAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class GearAction
    extends DumbAwareAction {
        private GearAction() {
            super("More Options", null, AllIcons.General.GearPlain);
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                GearAction.$$$reportNull$$$0(0);
            }
            int x = 0;
            int y = 0;
            InputEvent inputEvent = event.getInputEvent();
            if (inputEvent instanceof MouseEvent) {
                x = ((MouseEvent)inputEvent).getX();
                y = ((MouseEvent)inputEvent).getY();
            }
            AttachedToolWindow.this.showGearPopup(inputEvent.getComponent(), x, y);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/AttachedToolWindow$GearAction", "actionPerformed"));
        }
    }

    private class HideAction
    extends DumbAwareAction {
        private HideAction() {
            super(UIBundle.messagePointer((String)"tool.window.hide.action.name", (Object[])new Object[0]), AllIcons.General.HideToolWindow);
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                HideAction.$$$reportNull$$$0(0);
            }
            AttachedToolWindow.this.setPropertyAndUpdate(PropertyType.MINIMIZED, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/AttachedToolWindow$HideAction", "actionPerformed"));
        }
    }

    private class TogglePropertyTypeAction
    extends DumbAwareToggleAction {
        private final PropertyType myProperty;

        private TogglePropertyTypeAction(@NotNull PropertyType property, String text) {
            if (property == null) {
                TogglePropertyTypeAction.$$$reportNull$$$0(0);
            }
            if (text == null) {
                TogglePropertyTypeAction.$$$reportNull$$$0(1);
            }
            super(text);
            this.myProperty = property;
        }

        private TogglePropertyTypeAction(@NotNull PropertyType property, AnAction action) {
            if (property == null) {
                TogglePropertyTypeAction.$$$reportNull$$$0(2);
            }
            if (action == null) {
                TogglePropertyTypeAction.$$$reportNull$$$0(3);
            }
            this.myProperty = property;
            this.copyFrom(action);
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            if (event == null) {
                TogglePropertyTypeAction.$$$reportNull$$$0(4);
            }
            return AttachedToolWindow.this.getProperty(this.myProperty);
        }

        public void setSelected(@NotNull AnActionEvent event, boolean state) {
            if (event == null) {
                TogglePropertyTypeAction.$$$reportNull$$$0(5);
            }
            AttachedToolWindow.this.setPropertyAndUpdate(this.myProperty, state);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "property";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/adtui/workbench/AttachedToolWindow$TogglePropertyTypeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ToggleOppositePropertyTypeAction
    extends TogglePropertyTypeAction {
        private ToggleOppositePropertyTypeAction(@NotNull PropertyType property, String text) {
            if (property == null) {
                ToggleOppositePropertyTypeAction.$$$reportNull$$$0(0);
            }
            if (text == null) {
                ToggleOppositePropertyTypeAction.$$$reportNull$$$0(1);
            }
            super(property, text);
        }

        private ToggleOppositePropertyTypeAction(@NotNull PropertyType property, AnAction action) {
            if (property == null) {
                ToggleOppositePropertyTypeAction.$$$reportNull$$$0(2);
            }
            if (action == null) {
                ToggleOppositePropertyTypeAction.$$$reportNull$$$0(3);
            }
            super(property, action);
        }

        @Override
        public boolean isSelected(@NotNull AnActionEvent event) {
            if (event == null) {
                ToggleOppositePropertyTypeAction.$$$reportNull$$$0(4);
            }
            return !super.isSelected(event);
        }

        @Override
        public void setSelected(@NotNull AnActionEvent event, boolean state) {
            if (event == null) {
                ToggleOppositePropertyTypeAction.$$$reportNull$$$0(5);
            }
            super.setSelected(event, !state);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "property";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/adtui/workbench/AttachedToolWindow$ToggleOppositePropertyTypeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SwapAction
    extends DumbAwareAction {
        private SwapAction() {
            super("Swap");
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                SwapAction.$$$reportNull$$$0(0);
            }
            AttachedToolWindow.this.myModel.swap();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/AttachedToolWindow$SwapAction", "actionPerformed"));
        }
    }

    static class DragEvent {
        private final MouseEvent myMouseEvent;
        private final Component myDragImage;
        private final Point myDragPoint;

        DragEvent(@NotNull MouseEvent mouseEvent, @NotNull Component dragImage, @NotNull Point dragPoint) {
            if (mouseEvent == null) {
                DragEvent.$$$reportNull$$$0(0);
            }
            if (dragImage == null) {
                DragEvent.$$$reportNull$$$0(1);
            }
            if (dragPoint == null) {
                DragEvent.$$$reportNull$$$0(2);
            }
            this.myMouseEvent = mouseEvent;
            this.myDragImage = dragImage;
            this.myDragPoint = dragPoint;
        }

        @NotNull
        public Point getMousePoint() {
            Point point = this.myMouseEvent.getPoint();
            if (point == null) {
                DragEvent.$$$reportNull$$$0(3);
            }
            return point;
        }

        @NotNull
        public Component getDragImage() {
            Component component = this.myDragImage;
            if (component == null) {
                DragEvent.$$$reportNull$$$0(4);
            }
            return component;
        }

        @NotNull
        public Point getDragPoint() {
            Point point = this.myDragPoint;
            if (point == null) {
                DragEvent.$$$reportNull$$$0(5);
            }
            return point;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mouseEvent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dragImage";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dragPoint";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/adtui/workbench/AttachedToolWindow$DragEvent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/adtui/workbench/AttachedToolWindow$DragEvent";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMousePoint";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDragImage";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDragPoint";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

